/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public final class XmlAlter {
    private final Path file;

    public XmlAlter(Path file) {
        this.file = file;
    }

    public void pkgAttr(String tag, String value) throws IOException {
        Path trf = Files.createTempFile("", ".xml", new FileAttribute[0]);
        try (InputStream input = Files.newInputStream(this.file, new OpenOption[0]);
             OutputStream out = Files.newOutputStream(trf, new OpenOption[0]);){
            XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(input);
            XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(out);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(tag)) {
                    writer.add(XmlAlter.alterEvent(event, value));
                    continue;
                }
                writer.add(event);
            }
            reader.close();
            writer.close();
        }
        catch (XMLStreamException err) {
            throw new IOException("Failed to alter file", err);
        }
        Files.move(trf, this.file, StandardCopyOption.REPLACE_EXISTING);
    }

    private static XMLEvent alterEvent(XMLEvent original, String value) {
        XMLEvent res;
        StartElement element = original.asStartElement();
        ArrayList<Attribute> newattrs = new ArrayList<Attribute>(0);
        XMLEventFactory events = XMLEventFactory.newFactory();
        boolean replaced = false;
        Iterator<Attribute> origattrs = element.getAttributes();
        while (origattrs.hasNext()) {
            Attribute attr = origattrs.next();
            if (attr.getName().getLocalPart().equals("packages")) {
                newattrs.add(events.createAttribute(attr.getName(), value));
                replaced = true;
                continue;
            }
            newattrs.add(attr);
        }
        if (replaced) {
            QName name = element.getName();
            res = events.createStartElement(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart(), newattrs.iterator(), element.getNamespaces(), element.getNamespaceContext());
        } else {
            res = original;
        }
        return res;
    }
}

