/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class XmlMetaJoin {
    private static final Pattern HEADER = Pattern.compile("<\\?xml.*?>");
    private static final int MAX = 5;
    private final String tag;

    public XmlMetaJoin(String tag) {
        this.tag = tag;
    }

    public void merge(Path target, Path part) throws IOException {
        Path res = target.getParent().resolve(String.format("%s.merged", target.getFileName().toString()));
        try (BufferedWriter out = Files.newBufferedWriter(res, new OpenOption[0]);){
            this.writeFirstPart(target, out);
            this.writeSecondPart(part, out);
        }
        catch (IOException err) {
            Files.delete(res);
            throw err;
        }
        Files.move(res, target, StandardCopyOption.REPLACE_EXISTING);
    }

    private void writeFirstPart(Path target, BufferedWriter writer) throws IOException {
        try (BufferedReader in = Files.newBufferedReader(target);){
            String line;
            String close = String.format("</%s>", this.tag);
            while ((line = in.readLine()) != null) {
                if (line.contains(close)) {
                    line = line.replace(close, "");
                }
                writer.append(line);
                writer.newLine();
            }
        }
    }

    private void writeSecondPart(Path target, BufferedWriter writer) throws IOException {
        try (BufferedReader in = Files.newBufferedReader(target);){
            String line;
            int cnt = 0;
            boolean found = false;
            Pattern pattern = Pattern.compile(String.format("<%s.*?>", this.tag));
            while ((line = in.readLine()) != null) {
                if (cnt >= 5 && !found) {
                    throw new IOException("Failed to merge xml, header not found in part");
                }
                if (cnt < 5 && !found) {
                    Matcher matcher;
                    Matcher mheader = HEADER.matcher(line);
                    if (mheader.find()) {
                        line = mheader.replaceAll("");
                    }
                    if ((matcher = pattern.matcher(line)).find()) {
                        line = matcher.replaceAll("");
                        found = true;
                    }
                }
                ++cnt;
                writer.append(line);
                writer.newLine();
            }
        }
    }
}

