/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.XmlFile;
import com.artipie.rpm.meta.XmlPackage;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public final class XmlPackagesFile
implements Closeable {
    private static final String PACKAGES_ATTR = "packages";
    private final XmlFile xml;
    private final XmlPackage mtd;

    public XmlPackagesFile(XmlFile xml, XmlPackage mtd) {
        this.xml = xml;
        this.mtd = mtd;
    }

    public void startPackages() throws XMLStreamException {
        this.xml.writeStartDocument(StandardCharsets.UTF_8.displayName(), "1.0");
        this.xml.writeStartElement(this.mtd.tag());
        for (Map.Entry<String, String> namespace : this.mtd.xmlNamespaces().entrySet()) {
            this.xml.writeNamespace(namespace.getKey(), namespace.getValue());
        }
        this.xml.writeAttribute(PACKAGES_ATTR, "-1");
    }

    @Override
    public void close() throws IOException {
        try {
            this.xml.writeEndElement();
            this.xml.writeEndDocument();
            this.xml.close();
        }
        catch (XMLStreamException err) {
            throw new IOException("Failed to close", err);
        }
    }
}

