/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.Digest;
import com.artipie.rpm.FileChecksum;
import com.artipie.rpm.pkg.Checksum;
import com.artipie.rpm.pkg.FilePackageHeader;
import com.artipie.rpm.pkg.InvalidPackageException;
import com.artipie.rpm.pkg.Package;
import com.artipie.rpm.pkg.PackageOutput;
import com.artipie.rpm.pkg.ParsedFilePackage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Header;

public final class FilePackage
implements Package {
    private final Path file;

    public FilePackage(Path path) {
        this.file = path;
    }

    public Path path() {
        return this.file;
    }

    @Override
    public void save(PackageOutput out, Digest digest) throws IOException {
        out.accept(new Headers(new FilePackageHeader(this.file).header(), this.file, digest));
        Files.delete(this.file);
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.file.getFileName());
    }

    public Package parsed() throws InvalidPackageException, IOException {
        return new ParsedFilePackage(new FilePackageHeader(this.file).header(), this.file);
    }

    private static final class EntryHeader
    implements Package.MetaHeader {
        private final Optional<AbstractHeader.Entry<?>> entry;

        EntryHeader(AbstractHeader.Entry<?> entry) {
            this(Optional.ofNullable(entry));
        }

        EntryHeader(Optional<AbstractHeader.Entry<?>> entry) {
            this.entry = entry;
        }

        @Override
        public String asString(String def) {
            return this.entry.map(e -> ((String[])e.getValues())[0]).orElse(def);
        }

        @Override
        public int asInt(int def) {
            return this.entry.map(e -> ((int[])e.getValues())[0]).orElse(def);
        }

        @Override
        public List<String> asStrings() {
            return this.entry.map(e -> Arrays.asList((String[])e.getValues())).orElse(Collections.emptyList());
        }

        @Override
        public int[] asInts() {
            return this.entry.map(e -> (int[])e.getValues()).orElseGet(() -> new int[0]);
        }
    }

    static final class Headers
    implements Package.Meta {
        private final Header hdr;
        private final Path file;
        private final Digest digest;

        Headers(Header hdr, Path file, Digest digest) {
            this.hdr = hdr;
            this.file = file;
            this.digest = digest;
        }

        @Override
        public Package.MetaHeader header(Header.HeaderTag tag) {
            return new EntryHeader(this.hdr.getEntry((AbstractHeader.Tag)tag));
        }

        @Override
        public Checksum checksum() {
            return new FileChecksum(this.file, this.digest);
        }

        @Override
        public long size() throws IOException {
            return Files.size(this.file);
        }

        @Override
        public String href() {
            return this.file.getFileName().toString();
        }

        @Override
        public int[] range() {
            return new int[]{this.hdr.getStartPos(), this.hdr.getEndPos()};
        }
    }
}

