/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.Digest;
import com.artipie.rpm.FileChecksum;
import com.artipie.rpm.meta.XmlAlter;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.meta.XmlRepomd;
import com.artipie.rpm.pkg.Metadata;
import com.artipie.rpm.pkg.Package;
import com.artipie.rpm.pkg.PackageOutput;
import com.artipie.rpm.pkg.Repodata;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLStreamException;

public final class MetadataFile
implements Metadata {
    private final XmlPackage type;
    private final PackageOutput.FileOutput out;
    private final AtomicLong cnt;

    public MetadataFile(XmlPackage type, PackageOutput.FileOutput out) {
        this.type = type;
        this.out = out;
        this.cnt = new AtomicLong();
    }

    @Override
    public void accept(Package.Meta meta) throws IOException {
        Logger.debug((Object)this, (String)"accepting %s", (Object[])new Object[]{this.type});
        this.out.accept(meta);
        this.cnt.incrementAndGet();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        Logger.info((Object)this, (String)"output %s closed", (Object[])new Object[]{this.out});
    }

    @Override
    public void brush(List<String> ids) throws IOException {
        new XmlAlter(this.out.file()).pkgAttr(this.out.tag(), String.valueOf(this.cnt.get()));
    }

    @Override
    public Path save(Repodata repodata, Digest digest, XmlRepomd repomd) throws IOException {
        Path open = this.out.file();
        Path gzip = Files.createTempFile(repodata.temp(), "", ".gz", new FileAttribute[0]);
        MetadataFile.gzip(open, gzip);
        gzip = Files.move(gzip, repodata.metadata(this.type, gzip), new CopyOption[0]);
        Logger.info((Object)this, (String)"gzipped %s to %s", (Object[])new Object[]{open, gzip});
        try (XmlRepomd.Data data = repomd.beginData(this.type.filename());){
            data.gzipChecksum(new FileChecksum(gzip, digest));
            data.openChecksum(new FileChecksum(open, digest));
            data.location(String.format("repodata/%s", gzip.getFileName()));
            data.gzipSize(Files.size(gzip));
            data.openSize(Files.size(open));
        }
        catch (XMLStreamException err) {
            throw new IOException("Failed to update repomd.xml", err);
        }
        Files.delete(open);
        return gzip;
    }

    @Override
    public PackageOutput.FileOutput output() {
        return this.out;
    }

    public String toString() {
        return String.format("MetadataFile: %s", new Object[]{this.type});
    }

    private static void gzip(Path input, Path output) throws IOException {
        try (InputStream fis = Files.newInputStream(input, new OpenOption[0]);
             OutputStream fos = Files.newOutputStream(output, new OpenOption[0]);
             GZIPOutputStream gzos = new GZIPOutputStream(fos);){
            int length;
            byte[] buffer = new byte[8192];
            while ((length = fis.read(buffer)) >= 0) {
                gzos.write(buffer, 0, length);
            }
            gzos.finish();
        }
    }
}

