/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.Digest;
import com.artipie.rpm.meta.PackagesCount;
import com.artipie.rpm.meta.XmlAlter;
import com.artipie.rpm.meta.XmlMetaJoin;
import com.artipie.rpm.meta.XmlRepomd;
import com.artipie.rpm.pkg.Metadata;
import com.artipie.rpm.pkg.Package;
import com.artipie.rpm.pkg.PackageOutput;
import com.artipie.rpm.pkg.PrecedingMetadata;
import com.artipie.rpm.pkg.Repodata;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;

public final class ModifiableMetadata
implements Metadata {
    private final Metadata origin;
    private final PrecedingMetadata preceding;
    private long cnt;

    public ModifiableMetadata(Metadata origin, PrecedingMetadata preceding) {
        this.origin = origin;
        this.preceding = preceding;
        this.cnt = 0L;
    }

    @Override
    public void brush(List<String> pkgs) throws IOException {
        Optional<Path> existed = this.preceding.findAndUnzip();
        if (existed.isPresent()) {
            Path previous = existed.get();
            if (this.cnt > 0L) {
                new XmlMetaJoin(this.origin.output().tag()).merge(this.origin.output().file(), previous);
            } else {
                Files.copy(previous, this.origin.output().file(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.cnt = pkgs.isEmpty() ? (this.cnt += (long)new PackagesCount(previous).value()) : this.origin.output().maid().clean(pkgs);
        }
        new XmlAlter(this.origin.output().file()).pkgAttr(this.origin.output().tag(), String.valueOf(this.cnt));
    }

    @Override
    public Path save(Repodata repodata, Digest digest, XmlRepomd repomd) throws IOException {
        return this.origin.save(repodata, digest, repomd);
    }

    @Override
    public PackageOutput.FileOutput output() {
        return this.origin.output();
    }

    @Override
    public void accept(Package.Meta meta) throws IOException {
        this.origin.accept(meta);
        ++this.cnt;
    }

    @Override
    public void close() throws IOException {
        this.origin.close();
    }

    public String toString() {
        return this.origin.toString();
    }
}

