/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.NamingPolicy;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.meta.XmlRepomd;
import java.io.IOException;
import java.nio.file.Path;

public interface Repodata {
    public XmlRepomd createRepomd() throws IOException;

    public Path temp();

    public Path metadata(XmlPackage var1, Path var2) throws IOException;

    public static final class Temp
    implements Repodata {
        private final NamingPolicy policy;
        private final Path tmp;

        public Temp(NamingPolicy naming, Path tmp) {
            this.policy = naming;
            this.tmp = tmp;
        }

        @Override
        public XmlRepomd createRepomd() throws IOException {
            Path repomd = this.tmp.resolve("repomd.xml");
            repomd.toFile().createNewFile();
            return new XmlRepomd(repomd);
        }

        @Override
        public Path temp() {
            return this.tmp;
        }

        @Override
        public Path metadata(XmlPackage type, Path gzip) throws IOException {
            return this.tmp.resolve(String.format("%s.xml.gz", this.policy.name(type.filename(), gzip)));
        }
    }
}

