/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.vertx;

import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLine;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.vertx.core.Handler;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.core.http.HttpServerRequest;
import io.vertx.reactivex.core.http.HttpServerResponse;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class VertxSliceServer
implements Closeable {
    private final Vertx vertx;
    private final Slice served;
    private final Integer port;
    private HttpServer server;
    private final Object sync;

    public VertxSliceServer(Vertx vertx, Slice served) {
        this(vertx, served, 0);
    }

    public VertxSliceServer(Slice served, Integer port) {
        this(Vertx.vertx(), served, port);
    }

    public VertxSliceServer(Vertx vertx, Slice served, Integer port) {
        this.vertx = vertx;
        this.served = served;
        this.port = port;
        this.sync = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() {
        Object object = this.sync;
        synchronized (object) {
            this.server = this.vertx.createHttpServer();
            this.server.requestHandler(this.proxyHandler());
            this.server.rxListen(this.port.intValue()).blockingGet();
            return this.server.actualPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            this.server.rxClose().blockingAwait();
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    private Handler<HttpServerRequest> proxyHandler() {
        return req -> {
            try {
                this.serve((HttpServerRequest)req).exceptionally(throwable -> {
                    VertxSliceServer.sendError(req.response(), throwable);
                    return null;
                });
            }
            catch (Exception ex) {
                VertxSliceServer.sendError(req.response(), ex);
            }
        };
    }

    private CompletionStage<Void> serve(HttpServerRequest req) {
        return this.served.response(new RequestLine(req.rawMethod(), req.uri(), req.version().toString()).toString(), (Iterable)req.headers(), (Publisher)req.toFlowable().map(buffer -> ByteBuffer.wrap(buffer.getBytes()))).send((status, headers, body) -> {
            int code = Integer.parseInt(status.code());
            HttpServerResponse response = req.response().setStatusCode(code);
            for (Map.Entry header : headers) {
                response.putHeader((String)header.getKey(), (String)header.getValue());
            }
            response.setChunked(true);
            CompletableFuture promise = new CompletableFuture();
            Flowable.fromPublisher((Publisher)body).map(buf -> {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                return Buffer.buffer((byte[])bytes);
            }).doOnComplete(() -> promise.complete(response)).doOnError(promise::completeExceptionally).subscribe((FlowableSubscriber)response.toSubscriber());
            return promise.thenCompose(ignored -> CompletableFuture.allOf(new CompletableFuture[0]));
        });
    }

    private static void sendError(HttpServerResponse response, Throwable throwable) {
        response.setStatusCode(500);
        StringWriter body = new StringWriter();
        body.append(throwable.toString()).append("\n");
        throwable.printStackTrace(new PrintWriter(body));
        response.end(body.toString());
    }
}

