/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.vertx;

import com.artipie.http.Connection;
import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLine;
import com.artipie.vertx.ContinueConnection;
import com.artipie.vertx.VertxConnection;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.core.http.HttpServerRequest;
import io.vertx.reactivex.core.http.HttpServerResponse;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class VertxSliceServer
implements Closeable {
    private final Vertx vertx;
    private final Slice served;
    private final HttpServerOptions options;
    private HttpServer server;
    private final Object sync;

    public VertxSliceServer(Vertx vertx, Slice served) {
        this(vertx, served, new HttpServerOptions().setPort(0));
    }

    public VertxSliceServer(Slice served, Integer port) {
        this(Vertx.vertx(), served, new HttpServerOptions().setPort(port.intValue()));
    }

    public VertxSliceServer(Vertx vertx, Slice served, Integer port) {
        this(vertx, served, new HttpServerOptions().setPort(port.intValue()));
    }

    public VertxSliceServer(Vertx vertx, Slice served, HttpServerOptions options) {
        this.vertx = vertx;
        this.served = served;
        this.options = options;
        this.sync = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() {
        Object object = this.sync;
        synchronized (object) {
            if (this.server != null) {
                throw new IllegalStateException("Server was already started");
            }
            this.server = this.vertx.createHttpServer(this.options);
            this.server.requestHandler(this.proxyHandler());
            this.server.rxListen().blockingGet();
            return this.server.actualPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            this.server.rxClose().blockingAwait();
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    private Handler<HttpServerRequest> proxyHandler() {
        return req -> {
            try {
                this.serve((HttpServerRequest)req).exceptionally(throwable -> {
                    VertxSliceServer.sendError(req.response(), throwable);
                    return null;
                });
            }
            catch (Exception ex) {
                VertxSliceServer.sendError(req.response(), ex);
            }
        };
    }

    private CompletionStage<Void> serve(HttpServerRequest req) {
        HttpServerResponse response = req.response();
        return this.served.response(new RequestLine(req.method().name(), req.uri(), req.version().toString()).toString(), (Iterable)req.headers(), (Publisher)req.toFlowable().map(buffer -> ByteBuffer.wrap(buffer.getBytes()))).send((Connection)new ContinueConnection(response, new VertxConnection(response)));
    }

    private static void sendError(HttpServerResponse response, Throwable throwable) {
        response.setStatusCode(500);
        StringWriter body = new StringWriter();
        body.append(throwable.toString()).append("\n");
        throwable.printStackTrace(new PrintWriter(body));
        response.end(body.toString());
    }
}

