/*
 * Decompiled with CFR 0.152.
 */
package com.artnaseef.logging.logback.marshaller.adapter;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.artnaseef.logging.LogEventMarshaller;
import com.artnaseef.logging.logback.marshaller.model.LogbackWrappedGenericLoggingEvent;
import com.artnaseef.logging.model.GenericLoggingEvent;
import java.util.Optional;

public class LogbackGenericMarshallingAdapter
implements LogEventMarshaller {
    private LogEventMarshaller nestedMarshaller;

    public LogEventMarshaller getNestedMarshaller() {
        return this.nestedMarshaller;
    }

    public void setNestedMarshaller(LogEventMarshaller nestedMarshaller) {
        this.nestedMarshaller = nestedMarshaller;
    }

    public String marshal(Object event) {
        ILoggingEvent iLoggingEvent = (ILoggingEvent)event;
        GenericLoggingEvent genericLoggingEvent = new GenericLoggingEvent();
        genericLoggingEvent.setCallStack(iLoggingEvent.getCallerData());
        genericLoggingEvent.setLevel(this.extractLevelName(iLoggingEvent));
        genericLoggingEvent.setLoggerName(iLoggingEvent.getLoggerName());
        genericLoggingEvent.setMdc(iLoggingEvent.getMDCPropertyMap());
        genericLoggingEvent.setMessage(iLoggingEvent.getFormattedMessage());
        genericLoggingEvent.setThreadName(iLoggingEvent.getThreadName());
        genericLoggingEvent.setTimestamp(iLoggingEvent.getTimeStamp());
        return this.nestedMarshaller.marshal((Object)genericLoggingEvent);
    }

    public Object unmarshal(String marshalled) {
        Object nestedResult = this.nestedMarshaller.unmarshal(marshalled);
        if (nestedResult instanceof GenericLoggingEvent) {
            return new LogbackWrappedGenericLoggingEvent((GenericLoggingEvent)nestedResult);
        }
        return null;
    }

    private String extractLevelName(ILoggingEvent iLoggingEvent) {
        return Optional.of(iLoggingEvent).map(ILoggingEvent::getLevel).map(Object::toString).orElse("null");
    }
}

