/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH$J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H$J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H$R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Llocus/api/objects/Storable;", "", "()V", "asBytes", "", "getAsBytes", "()[B", "copy", "getCopy", "()Llocus/api/objects/Storable;", "getVersion", "", "read", "", "input", "Ljava/io/DataInputStream;", "data", "dr", "Llocus/api/utils/DataReaderBigEndian;", "readObject", "version", "write", "dw", "Llocus/api/utils/DataWriterBigEndian;", "writeObject", "BodyContainer", "Companion", "locus-api-core"})
public abstract class Storable {
    private static final String TAG = "Storable";
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected abstract int getVersion();

    @NotNull
    public final Storable getCopy() throws IOException, InstantiationException, IllegalAccessException {
        return Companion.read(this.getClass(), new DataReaderBigEndian(this.getAsBytes()));
    }

    @Nullable
    public final byte[] getAsBytes() {
        Object object;
        try {
            object = new DataWriterBigEndian();
            boolean bl = false;
            boolean bl2 = false;
            DataWriterBigEndian $this$apply = object;
            boolean bl3 = false;
            this.write($this$apply);
            object = ((DataWriterBigEndian)object).toByteArray();
        }
        catch (IOException e) {
            Logger.INSTANCE.logE(TAG, "asBytes()", e);
            object = null;
        }
        return object;
    }

    public final void read(@NotNull byte[] data) throws IOException {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DataReaderBigEndian dr = new DataReaderBigEndian(data);
        this.read(dr);
    }

    public final void read(@NotNull DataReaderBigEndian dr) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        BodyContainer bc = Storable.Companion.readHeader(dr);
        this.readObject(bc.getVersion$locus_api_core(), new DataReaderBigEndian(bc.getData$locus_api_core()));
    }

    public final void read(@NotNull DataInputStream input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        BodyContainer bc = Storable.Companion.readHeader(input);
        this.readObject(bc.getVersion$locus_api_core(), new DataReaderBigEndian(bc.getData$locus_api_core()));
    }

    protected abstract void readObject(int var1, @NotNull DataReaderBigEndian var2) throws IOException;

    public final void write(@NotNull DataWriterBigEndian dw) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeInt(this.getVersion());
        dw.writeInt(0);
        int startSize = dw.size();
        this.writeObject(dw);
        int totalSize = dw.size() - startSize;
        if (totalSize > 0) {
            dw.storePosition();
            dw.moveTo(startSize - 4);
            dw.writeInt(totalSize);
            dw.restorePosition();
        }
    }

    protected abstract void writeObject(@NotNull DataWriterBigEndian var1) throws IOException;

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Llocus/api/objects/Storable$BodyContainer;", "", "()V", "data", "", "getData$locus_api_core", "()[B", "setData$locus_api_core", "([B)V", "version", "", "getVersion$locus_api_core", "()I", "setVersion$locus_api_core", "(I)V", "locus-api-core"})
    private static final class BodyContainer {
        private int version;
        @Nullable
        private byte[] data;

        public final int getVersion$locus_api_core() {
            return this.version;
        }

        public final void setVersion$locus_api_core(int n) {
            this.version = n;
        }

        @Nullable
        public final byte[] getData$locus_api_core() {
            return this.data;
        }

        public final void setData$locus_api_core(@Nullable byte[] byArray) {
            this.data = byArray;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ+\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u000b0\b\"\b\b\u0000\u0010\u000b*\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u0013\u001a\u00020\u0014J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u000b0\b\"\b\b\u0000\u0010\u000b*\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Llocus/api/objects/Storable$Companion;", "", "()V", "TAG", "", "getAsBytes", "", "data", "", "Llocus/api/objects/Storable;", "read", "E", "claz", "Ljava/lang/Class;", "dr", "Llocus/api/utils/DataReaderBigEndian;", "(Ljava/lang/Class;Llocus/api/utils/DataReaderBigEndian;)Llocus/api/objects/Storable;", "readHeader", "Llocus/api/objects/Storable$BodyContainer;", "dis", "Ljava/io/DataInputStream;", "readList", "readUnknownObject", "", "writeList", "objs", "dos", "Ljava/io/DataOutputStream;", "locus-api-core"})
    public static final class Companion {
        private final BodyContainer readHeader(DataReaderBigEndian dr) throws IOException {
            BodyContainer bc = new BodyContainer();
            bc.setVersion$locus_api_core(dr.readInt());
            int size = dr.readInt();
            if (size < 0 || size > 0x1400000) {
                throw (Throwable)new IOException("item size too big, size:" + size + ", max: 20MB");
            }
            bc.setData$locus_api_core(dr.readBytes(size));
            return bc;
        }

        private final BodyContainer readHeader(DataInputStream dis) throws IOException {
            BodyContainer bc = new BodyContainer();
            bc.setVersion$locus_api_core(dis.readInt());
            int size = dis.readInt();
            if (size < 0 || size > 0xA00000) {
                throw (Throwable)new IOException("item size too big, size:" + size + ", max: 10MB");
            }
            bc.setData$locus_api_core(new byte[size]);
            byte[] byArray = bc.getData$locus_api_core();
            Intrinsics.checkNotNull((Object)byArray);
            dis.read(byArray);
            return bc;
        }

        @NotNull
        public final <E extends Storable> E read(@NotNull Class<E> claz, @NotNull DataReaderBigEndian dr) throws IOException, InstantiationException, IllegalAccessException {
            Intrinsics.checkNotNullParameter(claz, (String)"claz");
            Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
            BodyContainer bc = this.readHeader(dr);
            Storable storable = (Storable)claz.newInstance();
            storable.readObject(bc.getVersion$locus_api_core(), new DataReaderBigEndian(bc.getData$locus_api_core()));
            Storable storable2 = storable;
            Intrinsics.checkNotNullExpressionValue((Object)storable2, (String)"storable");
            return (E)storable2;
        }

        public final void readUnknownObject(@NotNull DataReaderBigEndian dr) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
            this.readHeader(dr);
        }

        @NotNull
        public final <E extends Storable> List<E> readList(@NotNull Class<E> claz, @NotNull byte[] data) throws IOException {
            Intrinsics.checkNotNullParameter(claz, (String)"claz");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            List<E> list = new DataReaderBigEndian(data).readListStorable(claz);
            Intrinsics.checkNotNullExpressionValue(list, (String)"DataReaderBigEndian(data).readListStorable(claz)");
            return list;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <E extends Storable> List<E> readList(@NotNull Class<E> claz, @NotNull DataInputStream dis) throws IOException {
            Intrinsics.checkNotNullParameter(claz, (String)"claz");
            Intrinsics.checkNotNullParameter((Object)dis, (String)"dis");
            ArrayList<Storable> objs = new ArrayList<Storable>();
            int count = dis.readInt();
            if (count == 0) {
                return objs;
            }
            int n = 0;
            int n2 = count;
            while (n < n2) {
                void i;
                try {
                    Storable item = (Storable)claz.newInstance();
                    item.read(dis);
                    objs.add(item);
                }
                catch (InstantiationException e) {
                    Logger.INSTANCE.logE(Storable.TAG, "readList(" + claz + ", " + dis + ')', e);
                }
                catch (IllegalAccessException e) {
                    Logger.INSTANCE.logE(Storable.TAG, "readList(" + claz + ", " + dis + ')', e);
                }
                ++i;
            }
            return objs;
        }

        @Nullable
        public final byte[] getAsBytes(@NotNull List<? extends Storable> data) {
            Object object;
            Intrinsics.checkNotNullParameter(data, (String)"data");
            try {
                object = new DataWriterBigEndian();
                boolean bl = false;
                boolean bl2 = false;
                DataWriterBigEndian $this$apply = object;
                boolean bl3 = false;
                $this$apply.writeListStorable(data);
                object = ((DataWriterBigEndian)object).toByteArray();
            }
            catch (Exception e) {
                Logger.INSTANCE.logE(Storable.TAG, "getAsBytes(" + data + ')', e);
                object = null;
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        public final void writeList(@NotNull List<? extends Storable> objs, @NotNull DataOutputStream dos) throws IOException {
            Intrinsics.checkNotNullParameter(objs, (String)"objs");
            Intrinsics.checkNotNullParameter((Object)dos, (String)"dos");
            int size = objs.size();
            dos.writeInt(size);
            if (size == 0) {
                return;
            }
            int n = 0;
            int n2 = objs.size();
            while (n < n2) {
                void i;
                byte[] byArray = objs.get((int)i).getAsBytes();
                Intrinsics.checkNotNull((Object)byArray);
                dos.write(byArray);
                ++i;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

