/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import locus.api.objects.Storable;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.LocationCompute;
import locus.api.utils.Logger;
import locus.api.utils.Utils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b#\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u007f2\u00020\u0001:\u0005\u007f\u0080\u0001\u0081\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010W\u001a\u00020\u000b2\u0006\u0010X\u001a\u00020\u0000J\b\u0010Y\u001a\u00020ZH\u0002J\b\u0010[\u001a\u00020ZH\u0002J\u000e\u0010\\\u001a\u00020]2\u0006\u0010X\u001a\u00020\u0000J\u000e\u0010^\u001a\u00020\u000b2\u0006\u0010X\u001a\u00020\u0000J\b\u0010_\u001a\u000206H\u0014J\u0006\u0010`\u001a\u00020\u001dJ\u0006\u0010a\u001a\u00020\u001dJ\u0006\u0010b\u001a\u00020\u001dJ\u0006\u0010c\u001a\u00020\u001dJ\u0006\u0010d\u001a\u00020\u001dJ\u0006\u0010e\u001a\u00020\u001dJ\u0006\u0010f\u001a\u00020\u001dJ\u0006\u0010g\u001a\u00020\u001dJ\u0006\u0010h\u001a\u00020\u001dJ\u0006\u0010i\u001a\u00020\u001dJ\u0018\u0010j\u001a\u00020Z2\u0006\u0010k\u001a\u0002062\u0006\u0010l\u001a\u00020mH\u0014J\u0010\u0010n\u001a\u00020Z2\u0006\u0010l\u001a\u00020mH\u0002J\u0006\u0010o\u001a\u00020ZJ\u0006\u0010p\u001a\u00020ZJ\u0006\u0010q\u001a\u00020ZJ\u0006\u0010r\u001a\u00020ZJ\u0006\u0010s\u001a\u00020ZJ\u0006\u0010t\u001a\u00020ZJ\u0006\u0010u\u001a\u00020ZJ\u0006\u0010v\u001a\u00020ZJ\u0006\u0010w\u001a\u00020ZJ\u0006\u0010x\u001a\u00020ZJ\u0006\u0010y\u001a\u00020ZJ\u000e\u0010z\u001a\u00020Z2\u0006\u0010\u0006\u001a\u00020\u0000J\b\u0010{\u001a\u000200H\u0016J\u0010\u0010|\u001a\u00020Z2\u0006\u0010}\u001a\u00020~H\u0014R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u000fR\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010)\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0012\"\u0004\b+\u0010\u0014R$\u0010,\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0012\"\u0004\b.\u0010\u0014R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00107\u001a\u0002062\u0006\u00105\u001a\u0002068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R$\u0010=\u001a\u0002062\u0006\u0010<\u001a\u0002068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b>\u00109\"\u0004\b?\u0010;R$\u0010A\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010\r\"\u0004\bC\u0010\u000fR$\u0010E\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bF\u0010\r\"\u0004\bG\u0010\u000fR$\u0010I\u001a\u0002062\u0006\u0010H\u001a\u0002068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bJ\u00109\"\u0004\bK\u0010;R$\u0010M\u001a\u00020\u000b2\u0006\u0010L\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bN\u0010\r\"\u0004\bO\u0010\u000fR$\u0010D\u001a\u00020\u000b2\u0006\u0010D\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010\r\"\u0004\bQ\u0010\u000fR\u0011\u0010R\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bS\u0010\rR\u001a\u0010T\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010%\"\u0004\bV\u0010'\u00a8\u0006\u0082\u0001"}, d2={"Llocus/api/objects/extra/Location;", "Llocus/api/objects/Storable;", "lat", "", "lon", "(DD)V", "loc", "(Llocus/api/objects/extra/Location;)V", "()V", "_altitude", "accuracy", "", "getAccuracy", "()F", "setAccuracy", "(F)V", "altitude", "getAltitude", "()D", "setAltitude", "(D)V", "bearing", "getBearing", "setBearing", "extraBasic", "Llocus/api/objects/extra/Location$ExtraBasic;", "extraSensor", "Llocus/api/objects/extra/Location$ExtraSensor;", "hasAltitude", "", "getHasAltitude", "()Z", "setHasAltitude", "(Z)V", "id", "", "getId", "()J", "setId", "(J)V", "value", "latitude", "getLatitude", "setLatitude", "longitude", "getLongitude", "setLongitude", "provider", "", "getProvider", "()Ljava/lang/String;", "setProvider", "(Ljava/lang/String;)V", "cadence", "", "sensorCadence", "getSensorCadence", "()I", "setSensorCadence", "(I)V", "heartRate", "sensorHeartRate", "getSensorHeartRate", "setSensorHeartRate", "power", "sensorPower", "getSensorPower", "setSensorPower", "speed", "sensorSpeed", "getSensorSpeed", "setSensorSpeed", "strides", "sensorStrides", "getSensorStrides", "setSensorStrides", "temperature", "sensorTemperature", "getSensorTemperature", "setSensorTemperature", "getSpeed", "setSpeed", "speedOptimal", "getSpeedOptimal", "time", "getTime", "setTime", "bearingTo", "dest", "checkExtraBasic", "", "checkExtraSensor", "distanceAndBearingTo", "", "distanceTo", "getVersion", "hasAccuracy", "hasBearing", "hasSensorCadence", "hasSensorHeartRate", "hasSensorPower", "hasSensorSpeed", "hasSensorStrides", "hasSensorTemperature", "hasSpeed", "hasSpeedOptimal", "readObject", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "readSensorVersion1", "removeAccuracy", "removeAltitude", "removeBearing", "removeSensorAll", "removeSensorCadence", "removeSensorHeartRate", "removeSensorPower", "removeSensorSpeed", "removeSensorStrides", "removeSensorTemperature", "removeSpeed", "set", "toString", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "Companion", "ExtraBasic", "ExtraSensor", "locus-api-core"})
public class Location
extends Storable {
    private long id;
    @NotNull
    private String provider;
    private long time;
    private double latitude;
    private double longitude;
    private boolean hasAltitude;
    private double _altitude;
    private ExtraBasic extraBasic;
    private ExtraSensor extraSensor;
    private static final String TAG = "Location";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final long getId() {
        return this.id;
    }

    public final void setId(long l) {
        this.id = l;
    }

    @NotNull
    public final String getProvider() {
        return this.provider;
    }

    public final void setProvider(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.provider = string;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(double value) {
        double d;
        if (value < -90.0) {
            Logger.INSTANCE.logE(TAG, "setLatitude(" + value + "), invalid latitude");
            d = -90.0;
        } else if (value > 90.0) {
            Logger.INSTANCE.logE(TAG, "setLatitude(" + value + "), invalid latitude");
            d = 90.0;
        } else {
            d = value;
        }
        this.latitude = d;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(double value) {
        double newValue = value;
        if (newValue < -180.0) {
            newValue += 360.0;
        } else if (newValue > 180.0) {
            newValue -= 360.0;
        }
        this.longitude = newValue;
    }

    public final boolean getHasAltitude() {
        return this.hasAltitude;
    }

    public final void setHasAltitude(boolean bl) {
        this.hasAltitude = bl;
    }

    public final double getAltitude() {
        return this.hasAltitude ? this._altitude : 0.0;
    }

    public final void setAltitude(double altitude) {
        this._altitude = altitude;
        this.hasAltitude = true;
    }

    public final void removeAltitude() {
        this._altitude = 0.0;
        this.hasAltitude = false;
    }

    /*
     * Unable to fully structure code
     */
    public final void set(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this.id = loc.id;
        this.provider = loc.provider;
        this.time = loc.time;
        this.setLatitude(loc.latitude);
        this.setLongitude(loc.longitude);
        this.hasAltitude = loc.hasAltitude;
        this._altitude = loc._altitude;
        if (loc.extraBasic == null) ** GOTO lbl-1000
        v0 = loc.extraBasic;
        Intrinsics.checkNotNull((Object)v0);
        if (v0.hasData()) {
            v1 = loc.extraBasic;
            Intrinsics.checkNotNull((Object)v1);
            v2 = this.extraBasic = v1.clone();
            Intrinsics.checkNotNull((Object)v2);
            if (!v2.hasData()) {
                this.extraBasic = null;
            }
        } else lbl-1000:
        // 2 sources

        {
            this.extraBasic = null;
        }
        if (loc.extraSensor == null) ** GOTO lbl-1000
        v3 = loc.extraSensor;
        Intrinsics.checkNotNull((Object)v3);
        if (v3.hasData()) {
            v4 = loc.extraSensor;
            Intrinsics.checkNotNull((Object)v4);
            v5 = this.extraSensor = v4.clone();
            Intrinsics.checkNotNull((Object)v5);
            if (!v5.hasData()) {
                this.extraSensor = null;
            }
        } else lbl-1000:
        // 2 sources

        {
            this.extraSensor = null;
        }
    }

    public final boolean hasSpeed() {
        ExtraBasic extraBasic = this.extraBasic;
        return extraBasic != null && extraBasic.getHasSpeed();
    }

    public final float getSpeed() {
        float f;
        if (this.hasSpeed()) {
            ExtraBasic extraBasic = this.extraBasic;
            Intrinsics.checkNotNull((Object)extraBasic);
            f = extraBasic.getSpeed();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final void setSpeed(float speed) {
        if (this.extraBasic == null) {
            this.extraBasic = new ExtraBasic();
        }
        ExtraBasic extraBasic = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic);
        extraBasic.setSpeed(speed);
        ExtraBasic extraBasic2 = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic2);
        extraBasic2.setHasSpeed(true);
    }

    public final boolean hasSpeedOptimal() {
        return this.hasSpeed() || this.hasSensorSpeed();
    }

    public final float getSpeedOptimal() {
        return this.hasSensorSpeed() ? this.getSensorSpeed() : this.getSpeed();
    }

    public final void removeSpeed() {
        if (this.extraBasic == null) {
            return;
        }
        ExtraBasic extraBasic = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic);
        extraBasic.setSpeed(0.0f);
        ExtraBasic extraBasic2 = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic2);
        extraBasic2.setHasSpeed(false);
        this.checkExtraBasic();
    }

    public final float getBearing() {
        float f;
        if (this.hasBearing()) {
            ExtraBasic extraBasic = this.extraBasic;
            Intrinsics.checkNotNull((Object)extraBasic);
            f = extraBasic.getBearing();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final void setBearing(float bearing) {
        float bearingNew;
        for (bearingNew = bearing; bearingNew < 0.0f; bearingNew += 360.0f) {
        }
        while (bearingNew >= 360.0f) {
            bearingNew -= 360.0f;
        }
        if (this.extraBasic == null) {
            this.extraBasic = new ExtraBasic();
        }
        ExtraBasic extraBasic = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic);
        extraBasic.setBearing(bearingNew);
        ExtraBasic extraBasic2 = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic2);
        extraBasic2.setHasBearing(true);
    }

    public final boolean hasBearing() {
        ExtraBasic extraBasic = this.extraBasic;
        return extraBasic != null && extraBasic.getHasBearing();
    }

    public final void removeBearing() {
        if (this.extraBasic == null) {
            return;
        }
        ExtraBasic extraBasic = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic);
        extraBasic.setBearing(0.0f);
        ExtraBasic extraBasic2 = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic2);
        extraBasic2.setHasBearing(false);
        this.checkExtraBasic();
    }

    public final float getAccuracy() {
        float f;
        if (this.hasAccuracy()) {
            ExtraBasic extraBasic = this.extraBasic;
            Intrinsics.checkNotNull((Object)extraBasic);
            f = extraBasic.getAccuracy();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final void setAccuracy(float accuracy) {
        if (this.extraBasic == null) {
            this.extraBasic = new ExtraBasic();
        }
        ExtraBasic extraBasic = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic);
        extraBasic.setAccuracy(accuracy);
        ExtraBasic extraBasic2 = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic2);
        extraBasic2.setHasAccuracy(true);
    }

    public final boolean hasAccuracy() {
        ExtraBasic extraBasic = this.extraBasic;
        return extraBasic != null && extraBasic.getHasAccuracy();
    }

    public final void removeAccuracy() {
        if (this.extraBasic == null) {
            return;
        }
        ExtraBasic extraBasic = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic);
        extraBasic.setAccuracy(0.0f);
        ExtraBasic extraBasic2 = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic2);
        extraBasic2.setHasAccuracy(false);
        this.checkExtraBasic();
    }

    private final void checkExtraBasic() {
        ExtraBasic extraBasic = this.extraBasic;
        Intrinsics.checkNotNull((Object)extraBasic);
        if (!extraBasic.hasData()) {
            this.extraBasic = null;
        }
    }

    public final int getSensorHeartRate() {
        int n;
        if (this.hasSensorHeartRate()) {
            ExtraSensor extraSensor = this.extraSensor;
            Intrinsics.checkNotNull((Object)extraSensor);
            n = extraSensor.getHr();
        } else {
            n = 0;
        }
        return n;
    }

    public final void setSensorHeartRate(int heartRate) {
        if (this.extraSensor == null) {
            this.extraSensor = new ExtraSensor();
        }
        ExtraSensor extraSensor = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor);
        extraSensor.setHasHr(true);
        ExtraSensor extraSensor2 = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor2);
        extraSensor2.setHr(heartRate);
    }

    public final boolean hasSensorHeartRate() {
        ExtraSensor extraSensor = this.extraSensor;
        return extraSensor != null && extraSensor.getHasHr();
    }

    public final void removeSensorHeartRate() {
        block0: {
            ExtraSensor extraSensor = this.extraSensor;
            if (extraSensor == null) break block0;
            ExtraSensor extraSensor2 = extraSensor;
            boolean bl = false;
            boolean bl2 = false;
            ExtraSensor it = extraSensor2;
            boolean bl3 = false;
            it.setHasHr(false);
            it.setHr(0);
            this.checkExtraSensor();
        }
    }

    public final int getSensorCadence() {
        int n;
        if (this.hasSensorCadence()) {
            ExtraSensor extraSensor = this.extraSensor;
            Intrinsics.checkNotNull((Object)extraSensor);
            n = extraSensor.getCadence();
        } else {
            n = 0;
        }
        return n;
    }

    public final void setSensorCadence(int cadence) {
        if (this.extraSensor == null) {
            this.extraSensor = new ExtraSensor();
        }
        ExtraSensor extraSensor = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor);
        extraSensor.setHasCadence(true);
        ExtraSensor extraSensor2 = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor2);
        extraSensor2.setCadence(cadence);
    }

    public final boolean hasSensorCadence() {
        ExtraSensor extraSensor = this.extraSensor;
        return extraSensor != null && extraSensor.getHasCadence();
    }

    public final void removeSensorCadence() {
        block0: {
            ExtraSensor extraSensor = this.extraSensor;
            if (extraSensor == null) break block0;
            ExtraSensor extraSensor2 = extraSensor;
            boolean bl = false;
            boolean bl2 = false;
            ExtraSensor it = extraSensor2;
            boolean bl3 = false;
            it.setHasCadence(false);
            it.setCadence(0);
            this.checkExtraSensor();
        }
    }

    public final float getSensorSpeed() {
        float f;
        if (this.hasSensorSpeed()) {
            ExtraSensor extraSensor = this.extraSensor;
            Intrinsics.checkNotNull((Object)extraSensor);
            f = extraSensor.getSpeed();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final void setSensorSpeed(float speed) {
        if (this.extraSensor == null) {
            this.extraSensor = new ExtraSensor();
        }
        ExtraSensor extraSensor = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor);
        extraSensor.setHasSpeed(true);
        ExtraSensor extraSensor2 = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor2);
        extraSensor2.setSpeed(speed);
    }

    public final boolean hasSensorSpeed() {
        ExtraSensor extraSensor = this.extraSensor;
        return extraSensor != null && extraSensor.getHasSpeed();
    }

    public final void removeSensorSpeed() {
        block0: {
            ExtraSensor extraSensor = this.extraSensor;
            if (extraSensor == null) break block0;
            ExtraSensor extraSensor2 = extraSensor;
            boolean bl = false;
            boolean bl2 = false;
            ExtraSensor it = extraSensor2;
            boolean bl3 = false;
            it.setHasSpeed(false);
            it.setSpeed(0.0f);
            this.checkExtraSensor();
        }
    }

    public final float getSensorPower() {
        float f;
        if (this.hasSensorPower()) {
            ExtraSensor extraSensor = this.extraSensor;
            Intrinsics.checkNotNull((Object)extraSensor);
            f = extraSensor.getPower();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final void setSensorPower(float power) {
        if (this.extraSensor == null) {
            this.extraSensor = new ExtraSensor();
        }
        ExtraSensor extraSensor = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor);
        extraSensor.setHasPower(true);
        ExtraSensor extraSensor2 = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor2);
        extraSensor2.setPower(power);
    }

    public final boolean hasSensorPower() {
        ExtraSensor extraSensor = this.extraSensor;
        return extraSensor != null && extraSensor.getHasPower();
    }

    public final void removeSensorPower() {
        block0: {
            ExtraSensor extraSensor = this.extraSensor;
            if (extraSensor == null) break block0;
            ExtraSensor extraSensor2 = extraSensor;
            boolean bl = false;
            boolean bl2 = false;
            ExtraSensor it = extraSensor2;
            boolean bl3 = false;
            it.setHasPower(false);
            it.setPower(0.0f);
            this.checkExtraSensor();
        }
    }

    public final int getSensorStrides() {
        int n;
        if (this.hasSensorStrides()) {
            ExtraSensor extraSensor = this.extraSensor;
            Intrinsics.checkNotNull((Object)extraSensor);
            n = extraSensor.getStrides();
        } else {
            n = 0;
        }
        return n;
    }

    public final void setSensorStrides(int strides) {
        if (this.extraSensor == null) {
            this.extraSensor = new ExtraSensor();
        }
        ExtraSensor extraSensor = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor);
        extraSensor.setHasStrides(true);
        ExtraSensor extraSensor2 = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor2);
        extraSensor2.setStrides(strides);
    }

    public final boolean hasSensorStrides() {
        ExtraSensor extraSensor = this.extraSensor;
        return extraSensor != null && extraSensor.getHasStrides();
    }

    public final void removeSensorStrides() {
        block0: {
            ExtraSensor extraSensor = this.extraSensor;
            if (extraSensor == null) break block0;
            ExtraSensor extraSensor2 = extraSensor;
            boolean bl = false;
            boolean bl2 = false;
            ExtraSensor it = extraSensor2;
            boolean bl3 = false;
            it.setHasStrides(false);
            it.setStrides(0);
            this.checkExtraSensor();
        }
    }

    public final float getSensorTemperature() {
        float f;
        if (this.hasSensorTemperature()) {
            ExtraSensor extraSensor = this.extraSensor;
            Intrinsics.checkNotNull((Object)extraSensor);
            f = extraSensor.getTemperature();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final void setSensorTemperature(float temperature) {
        if (this.extraSensor == null) {
            this.extraSensor = new ExtraSensor();
        }
        ExtraSensor extraSensor = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor);
        extraSensor.setHasTemperature(true);
        ExtraSensor extraSensor2 = this.extraSensor;
        Intrinsics.checkNotNull((Object)extraSensor2);
        extraSensor2.setTemperature(temperature);
    }

    public final boolean hasSensorTemperature() {
        ExtraSensor extraSensor = this.extraSensor;
        return extraSensor != null && extraSensor.getHasTemperature();
    }

    public final void removeSensorTemperature() {
        block0: {
            ExtraSensor extraSensor = this.extraSensor;
            if (extraSensor == null) break block0;
            ExtraSensor extraSensor2 = extraSensor;
            boolean bl = false;
            boolean bl2 = false;
            ExtraSensor it = extraSensor2;
            boolean bl3 = false;
            it.setHasTemperature(false);
            it.setTemperature(0.0f);
            this.checkExtraSensor();
        }
    }

    private final void checkExtraSensor() {
        ExtraSensor extraSensor = this.extraSensor;
        if (extraSensor == null || !extraSensor.hasData()) {
            this.extraSensor = null;
        }
    }

    public final void removeSensorAll() {
        this.extraSensor = null;
    }

    @NotNull
    public String toString() {
        return "Location [" + "tag: " + this.provider + ", " + "time: " + this.time + ", " + "lon: " + this.longitude + ", " + "lat: " + this.latitude + ", " + "alt: " + this.getAltitude() + ']';
    }

    public final float distanceTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return com.distanceTo(dest);
    }

    public final float bearingTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return com.bearingTo(dest);
    }

    @NotNull
    public final float[] distanceAndBearingTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return new float[]{com.distanceTo(dest), com.bearingTo(dest)};
    }

    @Override
    protected int getVersion() {
        return 2;
    }

    @Override
    protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        Cloneable it;
        Cloneable $this$apply;
        Location location;
        boolean bl;
        boolean bl2;
        Cloneable cloneable;
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        this.id = dr.readLong();
        String string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.provider = string;
        this.time = dr.readLong();
        this.setLatitude(dr.readDouble());
        this.setLongitude(dr.readDouble());
        this.hasAltitude = dr.readBoolean();
        this._altitude = dr.readDouble();
        if (dr.readBoolean()) {
            cloneable = new ExtraBasic();
            bl2 = false;
            bl = false;
            ExtraBasic extraBasic = cloneable;
            location = this;
            boolean bl3 = false;
            ((ExtraBasic)$this$apply).setHasAccuracy(dr.readBoolean());
            ((ExtraBasic)$this$apply).setAccuracy(dr.readFloat());
            ((ExtraBasic)$this$apply).setHasBearing(dr.readBoolean());
            ((ExtraBasic)$this$apply).setBearing(dr.readFloat());
            ((ExtraBasic)$this$apply).setHasSpeed(dr.readBoolean());
            ((ExtraBasic)$this$apply).setSpeed(dr.readFloat());
            Unit unit = Unit.INSTANCE;
            bl2 = false;
            bl = false;
            $this$apply = cloneable;
            boolean bl4 = false;
            boolean bl5 = ((ExtraBasic)it).hasData();
            Cloneable cloneable2 = location.extraBasic = bl5 ? cloneable : null;
        }
        if (version >= 1 && dr.readBoolean()) {
            if (version == 1) {
                this.readSensorVersion1(dr);
            } else {
                cloneable = new ExtraSensor();
                bl2 = false;
                bl = false;
                it = cloneable;
                location = this;
                boolean bl6 = false;
                ((Storable)((Object)$this$apply)).read(dr);
                Unit unit = Unit.INSTANCE;
                location.extraSensor = cloneable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readSensorVersion1(DataReaderBigEndian dr) {
        void it;
        ExtraSensor $this$apply;
        ExtraSensor extraSensor = new ExtraSensor();
        boolean bl = false;
        boolean bl2 = false;
        ExtraSensor extraSensor2 = extraSensor;
        Location location = this;
        boolean bl3 = false;
        $this$apply.setHasHr(dr.readBoolean());
        $this$apply.setHr(dr.readInt());
        $this$apply.setHasCadence(dr.readBoolean());
        $this$apply.setCadence(dr.readInt());
        $this$apply.setHasSpeed(dr.readBoolean());
        $this$apply.setSpeed(dr.readFloat());
        $this$apply.setHasPower(dr.readBoolean());
        $this$apply.setPower(dr.readFloat());
        Unit unit = Unit.INSTANCE;
        bl = false;
        bl2 = false;
        $this$apply = extraSensor;
        boolean bl4 = false;
        boolean bl5 = it.hasData();
        location.extraSensor = bl5 ? extraSensor : null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeLong(this.id);
        dw.writeString(this.provider);
        dw.writeLong(this.time);
        dw.writeDouble(this.latitude);
        dw.writeDouble(this.longitude);
        dw.writeBoolean(this.hasAltitude);
        dw.writeDouble(this.getAltitude());
        v0 = this.extraBasic;
        if (v0 == null) ** GOTO lbl-1000
        var2_2 /* !! */  = v0;
        var3_3 = false;
        var4_4 = false;
        it = var2_2 /* !! */ ;
        $i$a$-takeIf-Location$writeObject$1 = false;
        v0 = it.hasData() != false ? var2_2 /* !! */  : null;
        if (v0 != null) {
            var2_2 /* !! */  = v0;
            var3_3 = false;
            var4_4 = false;
            it = var2_2 /* !! */ ;
            $i$a$-let-Location$writeObject$2 = false;
            dw.writeBoolean(true);
            dw.writeBoolean(it.getHasAccuracy());
            dw.writeFloat(it.getAccuracy());
            dw.writeBoolean(it.getHasBearing());
            dw.writeFloat(it.getBearing());
            dw.writeBoolean(it.getHasSpeed());
            dw.writeFloat(it.getSpeed());
        } else lbl-1000:
        // 2 sources

        {
            (Unit)((Function0)new Function0<Unit>(dw){
                final /* synthetic */ DataWriterBigEndian $dw;

                public final void invoke() {
                    this.$dw.writeBoolean(false);
                }
                {
                    this.$dw = dataWriterBigEndian;
                    super(0);
                }
            }).invoke();
        }
        if ((v1 /* !! */  = this.extraSensor) == null) ** GOTO lbl-1000
        var2_2 /* !! */  = v1 /* !! */ ;
        var3_3 = false;
        var4_4 = false;
        it = var2_2 /* !! */ ;
        $i$a$-takeIf-Location$writeObject$4 = false;
        v1 /* !! */  = it.hasData() != false ? var2_2 /* !! */  : null;
        if (v1 /* !! */  != null) {
            var2_2 /* !! */  = v1 /* !! */ ;
            var3_3 = false;
            var4_4 = false;
            it = var2_2 /* !! */ ;
            $i$a$-let-Location$writeObject$5 = false;
            dw.writeBoolean(true);
            it.write(dw);
        } else lbl-1000:
        // 2 sources

        {
            (Unit)((Function0)new Function0<Unit>(dw){
                final /* synthetic */ DataWriterBigEndian $dw;

                public final void invoke() {
                    this.$dw.writeBoolean(false);
                }
                {
                    this.$dw = dataWriterBigEndian;
                    super(0);
                }
            }).invoke();
        }
    }

    public Location() {
        this.id = -1L;
        this.provider = "";
    }

    public Location(double lat, double lon) {
        this();
        this.setLatitude(lat);
        this.setLongitude(lon);
    }

    public Location(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this();
        this.set(loc);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\u0006\u0010\u001c\u001a\u00020\rJ\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\b\u00a8\u0006\u001f"}, d2={"Llocus/api/objects/extra/Location$ExtraBasic;", "", "()V", "accuracy", "", "getAccuracy", "()F", "setAccuracy", "(F)V", "bearing", "getBearing", "setBearing", "hasAccuracy", "", "getHasAccuracy", "()Z", "setHasAccuracy", "(Z)V", "hasBearing", "getHasBearing", "setHasBearing", "hasSpeed", "getHasSpeed", "setHasSpeed", "speed", "getSpeed", "setSpeed", "clone", "hasData", "toString", "", "locus-api-core"})
    private static final class ExtraBasic
    implements Cloneable {
        private boolean hasSpeed = false;
        private float speed = 0.0f;
        private boolean hasBearing = false;
        private float bearing = 0.0f;
        private boolean hasAccuracy = false;
        private float accuracy = 0.0f;

        public final boolean getHasSpeed() {
            return this.hasSpeed;
        }

        public final void setHasSpeed(boolean bl) {
            this.hasSpeed = bl;
        }

        public final float getSpeed() {
            return this.speed;
        }

        public final void setSpeed(float f) {
            this.speed = f;
        }

        public final boolean getHasBearing() {
            return this.hasBearing;
        }

        public final void setHasBearing(boolean bl) {
            this.hasBearing = bl;
        }

        public final float getBearing() {
            return this.bearing;
        }

        public final void setBearing(float f) {
            this.bearing = f;
        }

        public final boolean getHasAccuracy() {
            return this.hasAccuracy;
        }

        public final void setHasAccuracy(boolean bl) {
            this.hasAccuracy = bl;
        }

        public final float getAccuracy() {
            return this.accuracy;
        }

        public final void setAccuracy(float f) {
            this.accuracy = f;
        }

        @NotNull
        public ExtraBasic clone() {
            ExtraBasic newExtra = new ExtraBasic();
            newExtra.hasSpeed = this.hasSpeed;
            newExtra.speed = this.speed;
            newExtra.hasBearing = this.hasBearing;
            newExtra.bearing = this.bearing;
            newExtra.hasAccuracy = this.hasAccuracy;
            newExtra.accuracy = this.accuracy;
            return newExtra;
        }

        public final boolean hasData() {
            return this.hasSpeed || this.hasBearing || this.hasAccuracy;
        }

        @NotNull
        public String toString() {
            return Utils.INSTANCE.toString(this, "    ");
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u00101\u001a\u00020\u0000H\u0016J\b\u00102\u001a\u00020\u0005H\u0014J\u0006\u00103\u001a\u00020\u000bJ\u0018\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u000208H\u0014J\b\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u0002052\u0006\u0010<\u001a\u00020=H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001a\u0010\u0019\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u001a\u0010\u001c\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u000fR\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0007\"\u0004\b!\u0010\tR\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001a\u0010+\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0007\"\u0004\b-\u0010\tR\u001a\u0010.\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010%\"\u0004\b0\u0010'\u00a8\u0006>"}, d2={"Llocus/api/objects/extra/Location$ExtraSensor;", "Llocus/api/objects/Storable;", "", "()V", "cadence", "", "getCadence", "()I", "setCadence", "(I)V", "hasCadence", "", "getHasCadence", "()Z", "setHasCadence", "(Z)V", "hasHr", "getHasHr", "setHasHr", "hasPower", "getHasPower", "setHasPower", "hasSpeed", "getHasSpeed", "setHasSpeed", "hasStrides", "getHasStrides", "setHasStrides", "hasTemperature", "getHasTemperature", "setHasTemperature", "hr", "getHr", "setHr", "power", "", "getPower", "()F", "setPower", "(F)V", "speed", "getSpeed", "setSpeed", "strides", "getStrides", "setStrides", "temperature", "getTemperature", "setTemperature", "clone", "getVersion", "hasData", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "toString", "", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "locus-api-core"})
    private static final class ExtraSensor
    extends Storable
    implements Cloneable {
        private boolean hasHr = false;
        private int hr = 0;
        private boolean hasCadence = false;
        private int cadence = 0;
        private boolean hasSpeed = false;
        private float speed = 0.0f;
        private boolean hasPower = false;
        private float power = 0.0f;
        private boolean hasStrides = false;
        private int strides = 0;
        private boolean hasTemperature = false;
        private float temperature = 0.0f;

        public final boolean getHasHr() {
            return this.hasHr;
        }

        public final void setHasHr(boolean bl) {
            this.hasHr = bl;
        }

        public final int getHr() {
            return this.hr;
        }

        public final void setHr(int n) {
            this.hr = n;
        }

        public final boolean getHasCadence() {
            return this.hasCadence;
        }

        public final void setHasCadence(boolean bl) {
            this.hasCadence = bl;
        }

        public final int getCadence() {
            return this.cadence;
        }

        public final void setCadence(int n) {
            this.cadence = n;
        }

        public final boolean getHasSpeed() {
            return this.hasSpeed;
        }

        public final void setHasSpeed(boolean bl) {
            this.hasSpeed = bl;
        }

        public final float getSpeed() {
            return this.speed;
        }

        public final void setSpeed(float f) {
            this.speed = f;
        }

        public final boolean getHasPower() {
            return this.hasPower;
        }

        public final void setHasPower(boolean bl) {
            this.hasPower = bl;
        }

        public final float getPower() {
            return this.power;
        }

        public final void setPower(float f) {
            this.power = f;
        }

        public final boolean getHasStrides() {
            return this.hasStrides;
        }

        public final void setHasStrides(boolean bl) {
            this.hasStrides = bl;
        }

        public final int getStrides() {
            return this.strides;
        }

        public final void setStrides(int n) {
            this.strides = n;
        }

        public final boolean getHasTemperature() {
            return this.hasTemperature;
        }

        public final void setHasTemperature(boolean bl) {
            this.hasTemperature = bl;
        }

        public final float getTemperature() {
            return this.temperature;
        }

        public final void setTemperature(float f) {
            this.temperature = f;
        }

        @NotNull
        public ExtraSensor clone() {
            ExtraSensor newExtra = new ExtraSensor();
            newExtra.hasHr = this.hasHr;
            newExtra.hr = this.hr;
            newExtra.hasCadence = this.hasCadence;
            newExtra.cadence = this.cadence;
            newExtra.hasSpeed = this.hasSpeed;
            newExtra.speed = this.speed;
            newExtra.hasPower = this.hasPower;
            newExtra.power = this.power;
            newExtra.hasStrides = this.hasStrides;
            newExtra.strides = this.strides;
            newExtra.hasTemperature = this.hasTemperature;
            newExtra.temperature = this.temperature;
            return newExtra;
        }

        public final boolean hasData() {
            return this.hasHr || this.hasCadence || this.hasSpeed || this.hasPower || this.hasStrides || this.hasTemperature;
        }

        @Override
        protected int getVersion() {
            return 1;
        }

        @Override
        protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
            this.hasHr = dr.readBoolean();
            this.hr = dr.readInt();
            this.hasCadence = dr.readBoolean();
            this.cadence = dr.readInt();
            this.hasSpeed = dr.readBoolean();
            this.speed = dr.readFloat();
            this.hasPower = dr.readBoolean();
            this.power = dr.readFloat();
            this.hasStrides = dr.readBoolean();
            this.strides = dr.readInt();
            dr.readBoolean();
            dr.readInt();
            if (version >= 1) {
                this.hasTemperature = dr.readBoolean();
                this.temperature = dr.readFloat();
            }
        }

        @Override
        protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
            dw.writeBoolean(this.hasHr);
            dw.writeInt(this.hr);
            dw.writeBoolean(this.hasCadence);
            dw.writeInt(this.cadence);
            dw.writeBoolean(this.hasSpeed);
            dw.writeFloat(this.speed);
            dw.writeBoolean(this.hasPower);
            dw.writeFloat(this.power);
            dw.writeBoolean(this.hasStrides);
            dw.writeInt(this.strides);
            dw.writeBoolean(false);
            dw.writeInt(0);
            dw.writeBoolean(this.hasTemperature);
            dw.writeFloat(this.temperature);
        }

        @NotNull
        public String toString() {
            return Utils.INSTANCE.toString(this, "    ");
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llocus/api/objects/extra/Location$Companion;", "", "()V", "TAG", "", "locus-api-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

