/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.geoData;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import locus.api.objects.extra.Location;
import locus.api.objects.extra.TrackStats;
import locus.api.objects.geoData.GeoData;
import locus.api.objects.geoData.Point;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 @2\u00020\u0001:\u0001@B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u0004J\b\u00106\u001a\u00020\u0004H\u0016J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020;H\u0016J\u000e\u0010%\u001a\u0002082\u0006\u0010<\u001a\u00020\u0010J\u0010\u0010=\u001a\u0002082\u0006\u0010>\u001a\u00020?H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000eR\u0011\u0010\u001f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R \u00100\u001a\b\u0012\u0004\u0012\u0002010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\f\"\u0004\b3\u0010\u000e\u00a8\u0006A"}, d2={"Llocus/api/objects/geoData/Track;", "Llocus/api/objects/geoData/GeoData;", "()V", "activityType", "", "getActivityType", "()I", "setActivityType", "(I)V", "breaks", "", "getBreaks", "()Ljava/util/List;", "setBreaks", "(Ljava/util/List;)V", "value", "", "breaksBinary", "getBreaksBinary", "()[B", "setBreaksBinary", "([B)V", "isUseFolderStyle", "", "()Z", "setUseFolderStyle", "(Z)V", "points", "Llocus/api/objects/extra/Location;", "getPoints", "setPoints", "pointsCount", "getPointsCount", "stats", "Llocus/api/objects/extra/TrackStats;", "getStats", "()Llocus/api/objects/extra/TrackStats;", "setStats", "(Llocus/api/objects/extra/TrackStats;)V", "storeItemId", "", "getStoreItemId", "()J", "setStoreItemId", "(J)V", "storeVersionId", "getStoreVersionId", "setStoreVersionId", "waypoints", "Llocus/api/objects/geoData/Point;", "getWaypoints", "setWaypoints", "getPoint", "index", "getVersion", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "data", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "Companion", "locus-api-core"})
public final class Track
extends GeoData {
    @NotNull
    private List<Location> points;
    @NotNull
    private List<Integer> breaks;
    @NotNull
    private List<Point> waypoints;
    private boolean isUseFolderStyle;
    private int activityType;
    @NotNull
    private TrackStats stats;
    private long storeItemId;
    private long storeVersionId;
    private static final String TAG = "Track";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Location> getPoints() {
        return this.points;
    }

    public final void setPoints(@NotNull List<Location> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.points = list;
    }

    @NotNull
    public final List<Integer> getBreaks() {
        return this.breaks;
    }

    public final void setBreaks(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.breaks = list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] getBreaksBinary() {
        DataWriterBigEndian dataWriterBigEndian = new DataWriterBigEndian();
        boolean bl = false;
        boolean bl2 = false;
        DataWriterBigEndian $this$apply = dataWriterBigEndian;
        boolean bl3 = false;
        int n = 0;
        int n2 = ((Collection)this.breaks).size();
        while (n < n2) {
            void i;
            $this$apply.writeInt(((Number)this.breaks.get((int)i)).intValue());
            ++i;
        }
        byte[] byArray = dataWriterBigEndian.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"DataWriterBigEndian().ap\u2026          }.toByteArray()");
        return byArray;
    }

    public final void setBreaksBinary(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.breaks.clear();
        byte[] byArray = value;
        boolean bl = false;
        if (byArray.length == 0) {
            return;
        }
        try {
            DataReaderBigEndian dr = new DataReaderBigEndian(value);
            while (dr.available() > 0) {
                this.breaks.add(dr.readInt());
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.logE(TAG, "setBreaksFromData(" + value + ')', e);
            this.breaks.clear();
        }
    }

    @NotNull
    public final List<Point> getWaypoints() {
        return this.waypoints;
    }

    public final void setWaypoints(@NotNull List<Point> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.waypoints = list;
    }

    public final boolean isUseFolderStyle() {
        return this.isUseFolderStyle;
    }

    public final void setUseFolderStyle(boolean bl) {
        this.isUseFolderStyle = bl;
    }

    public final int getActivityType() {
        return this.activityType;
    }

    public final void setActivityType(int n) {
        this.activityType = n;
    }

    @NotNull
    public final TrackStats getStats() {
        return this.stats;
    }

    public final void setStats(@NotNull TrackStats trackStats) {
        Intrinsics.checkNotNullParameter((Object)trackStats, (String)"<set-?>");
        this.stats = trackStats;
    }

    public final long getStoreItemId() {
        return this.storeItemId;
    }

    public final void setStoreItemId(long l) {
        this.storeItemId = l;
    }

    public final long getStoreVersionId() {
        return this.storeVersionId;
    }

    public final void setStoreVersionId(long l) {
        this.storeVersionId = l;
    }

    public final int getPointsCount() {
        return this.points.size();
    }

    @NotNull
    public final Location getPoint(int index) {
        return this.points.get(index);
    }

    /*
     * WARNING - void declaration
     */
    public final void setStats(@NotNull byte[] data) {
        Track track;
        TrackStats trackStats;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Track track2 = this;
        try {
            void $this$apply;
            trackStats = new TrackStats();
            boolean bl = false;
            boolean bl2 = false;
            TrackStats trackStats2 = trackStats;
            Track track3 = track2;
            boolean bl3 = false;
            $this$apply.read(data);
            Unit unit = Unit.INSTANCE;
            track = track3;
        }
        catch (Exception exception) {
            void e;
            track = track2;
            StringBuilder stringBuilder = new StringBuilder().append("setStats(");
            byte[] byArray = data;
            boolean bl = false;
            String string = Arrays.toString(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            Logger.INSTANCE.logE(TAG, stringBuilder.append(string).append(")").toString(), (Exception)e);
            trackStats = new TrackStats();
        }
        track.stats = trackStats;
    }

    @Override
    public int getVersion() {
        return 8;
    }

    @Override
    public void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        this.setId(dr.readLong());
        String string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.setName(string);
        List<Location> list = dr.readListStorable(Location.class);
        Intrinsics.checkNotNullExpressionValue(list, (String)"dr.readListStorable(Location::class.java)");
        this.points = list;
        int breaksSize = dr.readInt();
        if (breaksSize > 0) {
            byte[] byArray = dr.readBytes(breaksSize);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"dr.readBytes(breaksSize)");
            this.setBreaksBinary(byArray);
        }
        List<Point> list2 = dr.readListStorable(Point.class);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"dr.readListStorable(Point::class.java)");
        this.waypoints = list2;
        this.readExtraData(dr);
        this.readStyles(dr);
        this.stats = new TrackStats();
        this.stats.setNumOfPoints(dr.readInt());
        this.stats.setStartTime(dr.readLong());
        this.stats.setStopTime(dr.readLong());
        this.stats.setTotalLength(dr.readFloat());
        this.stats.setTotalLengthMove(dr.readFloat());
        this.stats.setTotalTime(dr.readLong());
        this.stats.setTotalTimeMove(dr.readLong());
        this.stats.setSpeedMax(dr.readFloat());
        this.stats.setAltitudeMax(dr.readFloat());
        this.stats.setAltitudeMin(dr.readFloat());
        this.stats.setEleNeutralDistance(dr.readFloat());
        this.stats.setEleNeutralHeight(dr.readFloat());
        this.stats.setElePositiveDistance(dr.readFloat());
        this.stats.setElePositiveHeight(dr.readFloat());
        this.stats.setEleNegativeDistance(dr.readFloat());
        this.stats.setEleNegativeHeight(dr.readFloat());
        dr.readFloat();
        dr.readFloat();
        if (version >= 1) {
            this.isUseFolderStyle = dr.readBoolean();
        }
        if (version >= 2) {
            this.setTimeCreated(dr.readLong());
        }
        if (version >= 3) {
            this.stats = new TrackStats();
            this.stats.read(dr);
        }
        if (version >= 4) {
            this.setProtected(dr.readInt() == 0);
        }
        if (version >= 5) {
            this.activityType = dr.readInt();
        }
        if (version >= 6) {
            this.storeItemId = dr.readLong();
            this.storeVersionId = dr.readLong();
        }
        if (version >= 7) {
            this.setTimeUpdated(dr.readLong());
        }
        if (version >= 8) {
            GeoData.Privacy privacy;
            GeoData.Privacy privacy2;
            GeoData.Privacy privacy3;
            Track track;
            block11: {
                String privacyValue = dr.readString();
                GeoData.Privacy[] privacyArray = GeoData.Privacy.values();
                track = this;
                boolean bl = false;
                GeoData.Privacy[] privacyArray2 = privacyArray;
                boolean bl2 = false;
                GeoData.Privacy[] privacyArray3 = privacyArray2;
                int n = privacyArray3.length;
                for (int i = 0; i < n; ++i) {
                    GeoData.Privacy privacy4;
                    GeoData.Privacy it = privacy4 = privacyArray3[i];
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)privacyValue)) continue;
                    privacy3 = privacy4;
                    break block11;
                }
                privacy3 = null;
            }
            if ((privacy2 = (privacy = privacy3)) == null) {
                privacy2 = this.getPrivacy();
            }
            track.setPrivacy(privacy2);
        }
    }

    @Override
    public void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeLong(this.getId());
        dw.writeString(this.getName());
        dw.writeListStorable(this.points);
        byte[] byArray = this.getBreaksBinary();
        boolean bl = false;
        boolean bl2 = false;
        byte[] it = byArray;
        boolean bl3 = false;
        dw.writeInt(it.length);
        byte[] byArray2 = it;
        boolean bl4 = false;
        byte[] byArray3 = byArray2;
        boolean bl5 = false;
        if (!(byArray3.length == 0)) {
            dw.write(it);
        }
        dw.writeListStorable(this.waypoints);
        this.writeExtraData(dw);
        this.writeStyles(dw);
        dw.writeInt(0);
        dw.writeLong(0L);
        dw.writeLong(0L);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeLong(0L);
        dw.writeLong(0L);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeBoolean(this.isUseFolderStyle);
        dw.writeLong(this.getTimeCreated());
        dw.writeStorable(this.stats);
        dw.writeInt(this.getProtected() ? 0 : 1);
        dw.writeInt(this.activityType);
        dw.writeLong(this.storeItemId);
        dw.writeLong(this.storeVersionId);
        dw.writeLong(this.getTimeUpdated());
        dw.writeString(this.getPrivacy().name());
    }

    public Track() {
        boolean bl = false;
        this.points = new ArrayList();
        bl = false;
        this.breaks = new ArrayList();
        bl = false;
        this.waypoints = new ArrayList();
        this.isUseFolderStyle = true;
        this.stats = new TrackStats();
        this.storeItemId = -1L;
        this.storeVersionId = -1L;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llocus/api/objects/geoData/Track$Companion;", "", "()V", "TAG", "", "locus-api-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

