/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import locus.api.objects.Storable;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.LocationCompute;
import locus.api.utils.Logger;
import locus.api.utils.SparseArrayCompat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b$\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 o2\u00020\u0001:\u0006opqrstB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010[\u001a\u00020\u00182\u0006\u0010\\\u001a\u00020\u0000J\u000e\u0010]\u001a\u00020^2\u0006\u0010\\\u001a\u00020\u0000J\u000e\u0010_\u001a\u00020\u00182\u0006\u0010\\\u001a\u00020\u0000J\b\u0010`\u001a\u00020\u001aH\u0014J\b\u0010a\u001a\u00020bH\u0007J\u0018\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020\u001a2\u0006\u0010f\u001a\u00020gH\u0014J\u0006\u0010h\u001a\u00020dJ\u0006\u0010i\u001a\u00020dJ\u000e\u0010j\u001a\u00020d2\u0006\u0010\u0006\u001a\u00020\u0000J\b\u0010k\u001a\u000209H\u0016J\u0010\u0010l\u001a\u00020d2\u0006\u0010m\u001a\u00020nH\u0014R\u0015\u0010\t\u001a\u00060\nR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\r\u001a\u00060\nR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0015\u0010\u000f\u001a\u00060\u0010R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00060\nR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001b\u001a\u00060\nR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0015\u0010\u001d\u001a\u00060\nR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\fR\u0015\u0010\u001f\u001a\u00060 R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0015\u0010#\u001a\u00060 R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0015\u0010%\u001a\u00060 R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\"R\u0015\u0010'\u001a\u00060\nR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\fR\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u00100\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00105\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00102\"\u0004\b7\u00104R\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001e\u0010>\u001a\u00060 R\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\"\"\u0004\b@\u0010AR\u001e\u0010B\u001a\u00060 R\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\"\"\u0004\bD\u0010AR\u001e\u0010E\u001a\u00060\nR\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010\f\"\u0004\bG\u0010HR\u001e\u0010I\u001a\u00060\nR\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\f\"\u0004\bK\u0010HR\u001e\u0010L\u001a\u00060 R\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\"\"\u0004\bN\u0010AR\u001e\u0010O\u001a\u00060\nR\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\f\"\u0004\bQ\u0010HR\u0015\u0010R\u001a\u00060\nR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\fR\u001a\u0010T\u001a\u00020\u00188FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bU\u0010\b\u001a\u0004\bV\u0010WR\u001a\u0010X\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010,\"\u0004\bZ\u0010.\u00a8\u0006u"}, d2={"Llocus/api/objects/extra/Location;", "Llocus/api/objects/Storable;", "lat", "", "lon", "(DD)V", "loc", "(Llocus/api/objects/extra/Location;)V", "()V", "accuracyHor", "Llocus/api/objects/extra/Location$ValueContainerFloat;", "getAccuracyHor", "()Llocus/api/objects/extra/Location$ValueContainerFloat;", "accuracyVer", "getAccuracyVer", "altitude", "Llocus/api/objects/extra/Location$ValueContainerDouble;", "getAltitude", "()Llocus/api/objects/extra/Location$ValueContainerDouble;", "bearing", "getBearing", "extraDataDouble", "Llocus/api/utils/SparseArrayCompat;", "extraDataFloat", "", "extraDataInt", "", "gnssHdop", "getGnssHdop", "gnssPdop", "getGnssPdop", "gnssSatsUsed", "Llocus/api/objects/extra/Location$ValueContainerInt;", "getGnssSatsUsed", "()Llocus/api/objects/extra/Location$ValueContainerInt;", "gnssSatsVisible", "getGnssSatsVisible", "gnssStatus", "getGnssStatus", "gnssVdop", "getGnssVdop", "id", "", "getId", "()J", "setId", "(J)V", "value", "latitude", "getLatitude", "()D", "setLatitude", "(D)V", "longitude", "getLongitude", "setLongitude", "provider", "", "getProvider", "()Ljava/lang/String;", "setProvider", "(Ljava/lang/String;)V", "sensorCadence", "getSensorCadence", "setSensorCadence", "(Llocus/api/objects/extra/Location$ValueContainerInt;)V", "sensorHeartRate", "getSensorHeartRate", "setSensorHeartRate", "sensorPower", "getSensorPower", "setSensorPower", "(Llocus/api/objects/extra/Location$ValueContainerFloat;)V", "sensorSpeed", "getSensorSpeed", "setSensorSpeed", "sensorStrides", "getSensorStrides", "setSensorStrides", "sensorTemperature", "getSensorTemperature", "setSensorTemperature", "speed", "getSpeed", "speedOptimal", "getSpeedOptimal$annotations", "getSpeedOptimal", "()F", "time", "getTime", "setTime", "bearingTo", "dest", "distanceAndBearingTo", "", "distanceTo", "getVersion", "hasSpeedOptimal", "", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "removeGnssAll", "removeSensorAll", "set", "toString", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "Companion", "ExtraSensor", "ValueContainer", "ValueContainerDouble", "ValueContainerFloat", "ValueContainerInt", "locus-api-core"})
public class Location
extends Storable {
    private long id;
    @NotNull
    private String provider;
    private long time;
    private double latitude;
    private double longitude;
    @NotNull
    private final ValueContainerDouble altitude;
    @NotNull
    private final ValueContainerFloat speed;
    @NotNull
    private final ValueContainerFloat bearing;
    @NotNull
    private final ValueContainerFloat accuracyHor;
    @NotNull
    private final ValueContainerFloat accuracyVer;
    @NotNull
    private ValueContainerInt sensorCadence;
    @NotNull
    private ValueContainerInt sensorHeartRate;
    @NotNull
    private ValueContainerFloat sensorSpeed;
    @NotNull
    private ValueContainerFloat sensorPower;
    @NotNull
    private ValueContainerInt sensorStrides;
    @NotNull
    private ValueContainerFloat sensorTemperature;
    @NotNull
    private final ValueContainerInt gnssStatus;
    @NotNull
    private final ValueContainerFloat gnssHdop;
    @NotNull
    private final ValueContainerFloat gnssVdop;
    @NotNull
    private final ValueContainerFloat gnssPdop;
    @NotNull
    private final ValueContainerInt gnssSatsUsed;
    @NotNull
    private final ValueContainerInt gnssSatsVisible;
    private SparseArrayCompat<Integer> extraDataInt;
    private SparseArrayCompat<Float> extraDataFloat;
    private SparseArrayCompat<Double> extraDataDouble;
    private static final String TAG = "Location";
    private static final int EXTRA_KEY_ALTITUDE = 300;
    private static final int EXTRA_KEY_SPEED = 301;
    private static final int EXTRA_KEY_BEARING = 302;
    private static final int EXTRA_KEY_ACCURACY_HOR = 303;
    private static final int EXTRA_KEY_ACCURACY_VER = 304;
    private static final int EXTRA_KEY_SENSOR_HEART_RATE = 400;
    private static final int EXTRA_KEY_SENSOR_CADENCE = 401;
    private static final int EXTRA_KEY_SENSOR_SPEED = 402;
    private static final int EXTRA_KEY_SENSOR_TEMPERATURE = 403;
    private static final int EXTRA_KEY_SENSOR_POWER = 404;
    private static final int EXTRA_KEY_SENSOR_STRIDES = 405;
    private static final int EXTRA_KEY_GNSS_STATUS = 500;
    private static final int EXTRA_KEY_GNSS_HDOP = 501;
    private static final int EXTRA_KEY_GNSS_VDOP = 502;
    private static final int EXTRA_KEY_GNSS_PDOP = 503;
    private static final int EXTRA_KEY_GNSS_SATS_USED = 504;
    private static final int EXTRA_KEY_GNSS_SATS_VISIBLE = 505;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final long getId() {
        return this.id;
    }

    public final void setId(long l) {
        this.id = l;
    }

    @NotNull
    public final String getProvider() {
        return this.provider;
    }

    public final void setProvider(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.provider = string;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(double value) {
        double d;
        if (value < -90.0) {
            Logger.INSTANCE.logE(TAG, "setLatitude(" + value + "), invalid latitude");
            d = -90.0;
        } else if (value > 90.0) {
            Logger.INSTANCE.logE(TAG, "setLatitude(" + value + "), invalid latitude");
            d = 90.0;
        } else {
            d = value;
        }
        this.latitude = d;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(double value) {
        double newValue = value;
        if (newValue < -180.0) {
            newValue += 360.0;
        } else if (newValue > 180.0) {
            newValue -= 360.0;
        }
        this.longitude = newValue;
    }

    @NotNull
    public final ValueContainerDouble getAltitude() {
        return this.altitude;
    }

    @NotNull
    public final ValueContainerFloat getSpeed() {
        return this.speed;
    }

    @NotNull
    public final ValueContainerFloat getBearing() {
        return this.bearing;
    }

    @NotNull
    public final ValueContainerFloat getAccuracyHor() {
        return this.accuracyHor;
    }

    @NotNull
    public final ValueContainerFloat getAccuracyVer() {
        return this.accuracyVer;
    }

    @NotNull
    public final ValueContainerInt getSensorCadence() {
        return this.sensorCadence;
    }

    public final void setSensorCadence(@NotNull ValueContainerInt valueContainerInt) {
        Intrinsics.checkNotNullParameter((Object)valueContainerInt, (String)"<set-?>");
        this.sensorCadence = valueContainerInt;
    }

    @NotNull
    public final ValueContainerInt getSensorHeartRate() {
        return this.sensorHeartRate;
    }

    public final void setSensorHeartRate(@NotNull ValueContainerInt valueContainerInt) {
        Intrinsics.checkNotNullParameter((Object)valueContainerInt, (String)"<set-?>");
        this.sensorHeartRate = valueContainerInt;
    }

    @NotNull
    public final ValueContainerFloat getSensorSpeed() {
        return this.sensorSpeed;
    }

    public final void setSensorSpeed(@NotNull ValueContainerFloat valueContainerFloat) {
        Intrinsics.checkNotNullParameter((Object)valueContainerFloat, (String)"<set-?>");
        this.sensorSpeed = valueContainerFloat;
    }

    @NotNull
    public final ValueContainerFloat getSensorPower() {
        return this.sensorPower;
    }

    public final void setSensorPower(@NotNull ValueContainerFloat valueContainerFloat) {
        Intrinsics.checkNotNullParameter((Object)valueContainerFloat, (String)"<set-?>");
        this.sensorPower = valueContainerFloat;
    }

    @NotNull
    public final ValueContainerInt getSensorStrides() {
        return this.sensorStrides;
    }

    public final void setSensorStrides(@NotNull ValueContainerInt valueContainerInt) {
        Intrinsics.checkNotNullParameter((Object)valueContainerInt, (String)"<set-?>");
        this.sensorStrides = valueContainerInt;
    }

    @NotNull
    public final ValueContainerFloat getSensorTemperature() {
        return this.sensorTemperature;
    }

    public final void setSensorTemperature(@NotNull ValueContainerFloat valueContainerFloat) {
        Intrinsics.checkNotNullParameter((Object)valueContainerFloat, (String)"<set-?>");
        this.sensorTemperature = valueContainerFloat;
    }

    @NotNull
    public final ValueContainerInt getGnssStatus() {
        return this.gnssStatus;
    }

    @NotNull
    public final ValueContainerFloat getGnssHdop() {
        return this.gnssHdop;
    }

    @NotNull
    public final ValueContainerFloat getGnssVdop() {
        return this.gnssVdop;
    }

    @NotNull
    public final ValueContainerFloat getGnssPdop() {
        return this.gnssPdop;
    }

    @NotNull
    public final ValueContainerInt getGnssSatsUsed() {
        return this.gnssSatsUsed;
    }

    @NotNull
    public final ValueContainerInt getGnssSatsVisible() {
        return this.gnssSatsVisible;
    }

    public final void set(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this.id = loc.id;
        this.provider = loc.provider;
        this.time = loc.time;
        this.setLatitude(loc.latitude);
        this.setLongitude(loc.longitude);
        this.extraDataInt.putAll(loc.extraDataInt);
        this.extraDataFloat.putAll(loc.extraDataFloat);
        this.extraDataDouble.putAll(loc.extraDataDouble);
    }

    @Deprecated(message="Work with speed value directly")
    public static /* synthetic */ void getSpeedOptimal$annotations() {
    }

    public final float getSpeedOptimal() {
        return this.sensorSpeed.getHasData() ? ((Number)this.sensorSpeed.getValue()).floatValue() : ((Number)this.speed.getValue()).floatValue();
    }

    @Deprecated(message="Work with speed value directly")
    public final boolean hasSpeedOptimal() {
        return this.speed.getHasData() || this.sensorSpeed.getHasData();
    }

    public final void removeSensorAll() {
        this.sensorCadence.remove();
        this.sensorHeartRate.remove();
        this.sensorPower.remove();
        this.sensorSpeed.remove();
        this.sensorStrides.remove();
        this.sensorTemperature.remove();
    }

    public final void removeGnssAll() {
        this.gnssStatus.remove();
        this.gnssHdop.remove();
        this.gnssVdop.remove();
        this.gnssPdop.remove();
        this.gnssSatsUsed.remove();
    }

    @NotNull
    public String toString() {
        return "Location [" + "tag: " + this.provider + ", " + "time: " + this.time + ", " + "lon: " + this.longitude + ", " + "lat: " + this.latitude + ", " + "alt: " + this.altitude + ']';
    }

    public final float distanceTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return com.distanceTo(dest);
    }

    public final float bearingTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return com.bearingTo(dest);
    }

    @NotNull
    public final float[] distanceAndBearingTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return new float[]{com.distanceTo(dest), com.bearingTo(dest)};
    }

    @Override
    protected int getVersion() {
        return 3;
    }

    @Override
    protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        this.id = dr.readLong();
        String string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.provider = string;
        this.time = dr.readLong();
        this.setLatitude(dr.readDouble());
        this.setLongitude(dr.readDouble());
        boolean hasAltitude = dr.readBoolean();
        double altitude = dr.readDouble();
        if (hasAltitude) {
            this.altitude.setValue(altitude);
        }
        if (dr.readBoolean()) {
            boolean hasAccuracy = dr.readBoolean();
            float accuracy = dr.readFloat();
            if (hasAccuracy) {
                this.accuracyHor.setValue(Float.valueOf(accuracy));
            }
            boolean hasBearing = dr.readBoolean();
            float bearing2 = dr.readFloat();
            if (hasBearing) {
                this.bearing.setValue(Float.valueOf(bearing2));
            }
            boolean hasSpeed = dr.readBoolean();
            float speed = dr.readFloat();
            if (hasSpeed) {
                this.speed.setValue(Float.valueOf(speed));
            }
        }
        if (version >= 1 && dr.readBoolean()) {
            ExtraSensor extraSensor;
            ExtraSensor extraSensor2;
            ExtraSensor $this$apply;
            boolean bl;
            ExtraSensor accuracy;
            if (version == 1) {
                accuracy = new ExtraSensor();
                n = 0;
                bl = false;
                $this$apply = accuracy;
                boolean bl2 = false;
                $this$apply.setHasHr(dr.readBoolean());
                $this$apply.setHr(dr.readInt());
                $this$apply.setHasCadence(dr.readBoolean());
                $this$apply.setCadence(dr.readInt());
                $this$apply.setHasSpeed(dr.readBoolean());
                $this$apply.setSpeed(dr.readFloat());
                $this$apply.setHasPower(dr.readBoolean());
                $this$apply.setPower(dr.readFloat());
                extraSensor2 = accuracy;
            } else {
                accuracy = new ExtraSensor();
                n = 0;
                bl = false;
                $this$apply = accuracy;
                boolean bl3 = false;
                $this$apply.read(dr);
                extraSensor2 = extraSensor = accuracy;
            }
            if (extraSensor.getHasCadence()) {
                this.sensorCadence.setValue(extraSensor.getCadence());
            }
            if (extraSensor.getHasHr()) {
                this.sensorHeartRate.setValue(extraSensor.getHr());
            }
            if (extraSensor.getHasPower()) {
                this.sensorPower.setValue(Float.valueOf(extraSensor.getPower()));
            }
            if (extraSensor.getHasSpeed()) {
                this.sensorSpeed.setValue(Float.valueOf(extraSensor.getSpeed()));
            }
            if (extraSensor.getHasStrides()) {
                this.sensorStrides.setValue(extraSensor.getStrides());
            }
            if (extraSensor.getHasTemperature()) {
                this.sensorTemperature.setValue(Float.valueOf(extraSensor.getTemperature()));
            }
        }
        if (version >= 3) {
            int i;
            this.extraDataInt.clear();
            int size = dr.readInt();
            int accuracy = 0;
            n = size;
            while (accuracy < n) {
                this.extraDataInt.put(dr.readInt(), dr.readInt());
                ++i;
            }
            this.extraDataFloat.clear();
            size = dr.readInt();
            n = size;
            for (i = 0; i < n; ++i) {
                this.extraDataFloat.put(dr.readInt(), Float.valueOf(dr.readFloat()));
            }
            this.extraDataDouble.clear();
            size = dr.readInt();
            n = size;
            for (i = 0; i < n; ++i) {
                this.extraDataDouble.put(dr.readInt(), dr.readDouble());
            }
        }
    }

    @Override
    protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        int i;
        ExtraSensor extraSensor;
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeLong(this.id);
        dw.writeString(this.provider);
        dw.writeLong(this.time);
        dw.writeDouble(this.latitude);
        dw.writeDouble(this.longitude);
        dw.writeBoolean(this.altitude.getHasData());
        dw.writeDouble(((Number)this.altitude.getValue()).doubleValue());
        if (this.accuracyHor.getHasData() || this.bearing.getHasData() || this.speed.getHasData()) {
            dw.writeBoolean(true);
            dw.writeBoolean(this.accuracyHor.getHasData());
            dw.writeFloat(((Number)this.accuracyHor.getValue()).floatValue());
            dw.writeBoolean(this.bearing.getHasData());
            dw.writeFloat(((Number)this.bearing.getValue()).floatValue());
            dw.writeBoolean(this.speed.getHasData());
            dw.writeFloat(((Number)this.speed.getValue()).floatValue());
        }
        ExtraSensor extraSensor2 = new ExtraSensor();
        int n = 0;
        boolean bl = false;
        ExtraSensor $this$apply = extraSensor2;
        boolean bl2 = false;
        if (this.sensorCadence.getHasData()) {
            $this$apply.setHasCadence(true);
            $this$apply.setCadence(((Number)this.sensorCadence.getValue()).intValue());
        }
        if (this.sensorHeartRate.getHasData()) {
            $this$apply.setHasHr(true);
            $this$apply.setHr(((Number)this.sensorHeartRate.getValue()).intValue());
        }
        if (this.sensorPower.getHasData()) {
            $this$apply.setHasPower(true);
            $this$apply.setPower(((Number)this.sensorPower.getValue()).floatValue());
        }
        if (this.sensorSpeed.getHasData()) {
            $this$apply.setHasSpeed(true);
            $this$apply.setSpeed(((Number)this.sensorSpeed.getValue()).floatValue());
        }
        if (this.sensorStrides.getHasData()) {
            $this$apply.setHasStrides(true);
            $this$apply.setStrides(((Number)this.sensorStrides.getValue()).intValue());
        }
        if (this.sensorTemperature.getHasData()) {
            $this$apply.setHasTemperature(true);
            $this$apply.setTemperature(((Number)this.sensorTemperature.getValue()).floatValue());
        }
        extraSensor2 = extraSensor = extraSensor2;
        n = 0;
        bl = false;
        ExtraSensor it = extraSensor2;
        boolean bl3 = false;
        ExtraSensor extraSensor3 = it.hasData() ? extraSensor2 : null;
        if (extraSensor3 != null) {
            extraSensor2 = extraSensor3;
            n = 0;
            bl = false;
            it = extraSensor2;
            boolean bl4 = false;
            dw.writeBoolean(true);
            it.write(dw);
        } else {
            Unit cfr_ignored_0 = (Unit)((Function0)new Function0<Unit>(dw){
                final /* synthetic */ DataWriterBigEndian $dw;

                public final void invoke() {
                    this.$dw.writeBoolean(false);
                }
                {
                    this.$dw = dataWriterBigEndian;
                    super(0);
                }
            }).invoke();
        }
        dw.writeInt(this.extraDataInt.size());
        int n2 = 0;
        n = this.extraDataInt.size();
        while (n2 < n) {
            dw.writeInt(this.extraDataInt.keyAt(i));
            Integer n3 = this.extraDataInt.valueAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"extraDataInt.valueAt(i)");
            dw.writeInt(((Number)n3).intValue());
            ++i;
        }
        dw.writeInt(this.extraDataFloat.size());
        n = this.extraDataFloat.size();
        for (i = 0; i < n; ++i) {
            dw.writeInt(this.extraDataFloat.keyAt(i));
            Float f = this.extraDataFloat.valueAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.valueAt(i)");
            dw.writeFloat(((Number)f).floatValue());
        }
        dw.writeInt(this.extraDataDouble.size());
        n = this.extraDataDouble.size();
        for (i = 0; i < n; ++i) {
            dw.writeInt(this.extraDataDouble.keyAt(i));
            Double d = this.extraDataDouble.valueAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"extraDataDouble.valueAt(i)");
            dw.writeDouble(((Number)d).doubleValue());
        }
    }

    public Location() {
        this.id = -1L;
        this.provider = "";
        this.altitude = new ValueContainerDouble(300, 0.0);
        this.speed = new ValueContainerFloat(301, 0.0f);
        this.bearing = new ValueContainerFloat(this, 302, 0.0f){
            final /* synthetic */ Location this$0;

            @NotNull
            public Float validateNewValue$locus_api_core(float value) {
                float bearingNew;
                for (bearingNew = value; bearingNew < 0.0f; bearingNew += 360.0f) {
                }
                while (bearingNew >= 360.0f) {
                    bearingNew -= 360.0f;
                }
                return Float.valueOf(bearingNew);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2);
            }
        };
        this.accuracyHor = new ValueContainerFloat(303, 0.0f);
        this.accuracyVer = new ValueContainerFloat(304, 0.0f);
        this.sensorCadence = new ValueContainerInt(401, 0);
        this.sensorHeartRate = new ValueContainerInt(400, 0);
        this.sensorSpeed = new ValueContainerFloat(402, 0.0f);
        this.sensorPower = new ValueContainerFloat(404, 0.0f);
        this.sensorStrides = new ValueContainerInt(405, 0);
        this.sensorTemperature = new ValueContainerFloat(403, 0.0f);
        this.gnssStatus = new ValueContainerInt(500, 0);
        this.gnssHdop = new ValueContainerFloat(501, 0.0f);
        this.gnssVdop = new ValueContainerFloat(502, 0.0f);
        this.gnssPdop = new ValueContainerFloat(503, 0.0f);
        this.gnssSatsUsed = new ValueContainerInt(504, 0);
        this.gnssSatsVisible = new ValueContainerInt(505, 0);
        this.extraDataInt = new SparseArrayCompat(0);
        this.extraDataFloat = new SparseArrayCompat(0);
        this.extraDataDouble = new SparseArrayCompat(0);
    }

    public Location(double lat, double lon) {
        this();
        this.setLatitude(lat);
        this.setLongitude(lon);
    }

    public Location(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this();
        this.set(loc);
    }

    public static final /* synthetic */ void access$setExtraDataInt$p(Location $this, SparseArrayCompat sparseArrayCompat) {
        $this.extraDataInt = sparseArrayCompat;
    }

    public static final /* synthetic */ void access$setExtraDataFloat$p(Location $this, SparseArrayCompat sparseArrayCompat) {
        $this.extraDataFloat = sparseArrayCompat;
    }

    public static final /* synthetic */ void access$setExtraDataDouble$p(Location $this, SparseArrayCompat sparseArrayCompat) {
        $this.extraDataDouble = sparseArrayCompat;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00170\u0019J\u0006\u0010\u001a\u001a\u00020\u0017J\u0017\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Llocus/api/objects/extra/Location$ValueContainer;", "T", "", "dataContainer", "Llocus/api/utils/SparseArrayCompat;", "id", "", "defaultEmpty", "(Llocus/api/utils/SparseArrayCompat;ILjava/lang/Object;)V", "getDefaultEmpty", "()Ljava/lang/Object;", "Ljava/lang/Object;", "hasData", "", "getHasData", "()Z", "getId", "()I", "value", "getValue", "setValue", "(Ljava/lang/Object;)V", "doIfValid", "", "action", "Lkotlin/Function1;", "remove", "validateNewValue", "validateNewValue$locus_api_core", "(Ljava/lang/Object;)Ljava/lang/Object;", "locus-api-core"})
    public static class ValueContainer<T> {
        private final SparseArrayCompat<T> dataContainer;
        private final int id;
        private final T defaultEmpty;

        public final boolean getHasData() {
            return this.dataContainer.containsKey(this.id);
        }

        public final T getValue() {
            return this.dataContainer.get(this.id, this.defaultEmpty);
        }

        public final void setValue(T value) {
            this.dataContainer.put(this.id, value);
        }

        public T validateNewValue$locus_api_core(T value) {
            return value;
        }

        public final void doIfValid(@NotNull Function1<? super T, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            if (this.getHasData()) {
                action.invoke(this.getValue());
            }
        }

        public final void remove() {
            this.dataContainer.remove(this.id);
        }

        public final int getId() {
            return this.id;
        }

        public final T getDefaultEmpty() {
            return this.defaultEmpty;
        }

        public ValueContainer(@NotNull SparseArrayCompat<T> dataContainer, int id, T defaultEmpty) {
            Intrinsics.checkNotNullParameter(dataContainer, (String)"dataContainer");
            this.dataContainer = dataContainer;
            this.id = id;
            this.defaultEmpty = defaultEmpty;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Llocus/api/objects/extra/Location$ValueContainerInt;", "Llocus/api/objects/extra/Location$ValueContainer;", "", "id", "defaultEmpty", "(Llocus/api/objects/extra/Location;II)V", "locus-api-core"})
    public final class ValueContainerInt
    extends ValueContainer<Integer> {
        public ValueContainerInt(int id, int defaultEmpty) {
            super(Location.this.extraDataInt, id, defaultEmpty);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0096\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Llocus/api/objects/extra/Location$ValueContainerFloat;", "Llocus/api/objects/extra/Location$ValueContainer;", "", "id", "", "defaultEmpty", "(Llocus/api/objects/extra/Location;IF)V", "locus-api-core"})
    public class ValueContainerFloat
    extends ValueContainer<Float> {
        public ValueContainerFloat(int id, float defaultEmpty) {
            super(Location.this.extraDataFloat, id, Float.valueOf(defaultEmpty));
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Llocus/api/objects/extra/Location$ValueContainerDouble;", "Llocus/api/objects/extra/Location$ValueContainer;", "", "id", "", "defaultEmpty", "(Llocus/api/objects/extra/Location;ID)V", "locus-api-core"})
    public final class ValueContainerDouble
    extends ValueContainer<Double> {
        public ValueContainerDouble(int id, double defaultEmpty) {
            super(Location.this.extraDataDouble, id, defaultEmpty);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00100\u001a\u00020\u0004H\u0014J\u0006\u00101\u001a\u00020\nJ\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u000206H\u0014J\u0010\u00107\u001a\u0002032\u0006\u00108\u001a\u000209H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u001a\u0010\u001e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\u001a\u0010*\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0006\"\u0004\b,\u0010\bR\u001a\u0010-\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010$\"\u0004\b/\u0010&\u00a8\u0006:"}, d2={"Llocus/api/objects/extra/Location$ExtraSensor;", "Llocus/api/objects/Storable;", "()V", "cadence", "", "getCadence", "()I", "setCadence", "(I)V", "hasCadence", "", "getHasCadence", "()Z", "setHasCadence", "(Z)V", "hasHr", "getHasHr", "setHasHr", "hasPower", "getHasPower", "setHasPower", "hasSpeed", "getHasSpeed", "setHasSpeed", "hasStrides", "getHasStrides", "setHasStrides", "hasTemperature", "getHasTemperature", "setHasTemperature", "hr", "getHr", "setHr", "power", "", "getPower", "()F", "setPower", "(F)V", "speed", "getSpeed", "setSpeed", "strides", "getStrides", "setStrides", "temperature", "getTemperature", "setTemperature", "getVersion", "hasData", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "locus-api-core"})
    private static final class ExtraSensor
    extends Storable {
        private boolean hasHr;
        private int hr;
        private boolean hasCadence;
        private int cadence;
        private boolean hasSpeed;
        private float speed;
        private boolean hasPower;
        private float power;
        private boolean hasStrides;
        private int strides;
        private boolean hasTemperature;
        private float temperature;

        public final boolean getHasHr() {
            return this.hasHr;
        }

        public final void setHasHr(boolean bl) {
            this.hasHr = bl;
        }

        public final int getHr() {
            return this.hr;
        }

        public final void setHr(int n) {
            this.hr = n;
        }

        public final boolean getHasCadence() {
            return this.hasCadence;
        }

        public final void setHasCadence(boolean bl) {
            this.hasCadence = bl;
        }

        public final int getCadence() {
            return this.cadence;
        }

        public final void setCadence(int n) {
            this.cadence = n;
        }

        public final boolean getHasSpeed() {
            return this.hasSpeed;
        }

        public final void setHasSpeed(boolean bl) {
            this.hasSpeed = bl;
        }

        public final float getSpeed() {
            return this.speed;
        }

        public final void setSpeed(float f) {
            this.speed = f;
        }

        public final boolean getHasPower() {
            return this.hasPower;
        }

        public final void setHasPower(boolean bl) {
            this.hasPower = bl;
        }

        public final float getPower() {
            return this.power;
        }

        public final void setPower(float f) {
            this.power = f;
        }

        public final boolean getHasStrides() {
            return this.hasStrides;
        }

        public final void setHasStrides(boolean bl) {
            this.hasStrides = bl;
        }

        public final int getStrides() {
            return this.strides;
        }

        public final void setStrides(int n) {
            this.strides = n;
        }

        public final boolean getHasTemperature() {
            return this.hasTemperature;
        }

        public final void setHasTemperature(boolean bl) {
            this.hasTemperature = bl;
        }

        public final float getTemperature() {
            return this.temperature;
        }

        public final void setTemperature(float f) {
            this.temperature = f;
        }

        public final boolean hasData() {
            return this.hasHr || this.hasCadence || this.hasSpeed || this.hasPower || this.hasStrides || this.hasTemperature;
        }

        @Override
        protected int getVersion() {
            return 1;
        }

        @Override
        protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
            this.hasHr = dr.readBoolean();
            this.hr = dr.readInt();
            this.hasCadence = dr.readBoolean();
            this.cadence = dr.readInt();
            this.hasSpeed = dr.readBoolean();
            this.speed = dr.readFloat();
            this.hasPower = dr.readBoolean();
            this.power = dr.readFloat();
            this.hasStrides = dr.readBoolean();
            this.strides = dr.readInt();
            dr.readBoolean();
            dr.readInt();
            if (version >= 1) {
                this.hasTemperature = dr.readBoolean();
                this.temperature = dr.readFloat();
            }
        }

        @Override
        protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
            dw.writeBoolean(this.hasHr);
            dw.writeInt(this.hr);
            dw.writeBoolean(this.hasCadence);
            dw.writeInt(this.cadence);
            dw.writeBoolean(this.hasSpeed);
            dw.writeFloat(this.speed);
            dw.writeBoolean(this.hasPower);
            dw.writeFloat(this.power);
            dw.writeBoolean(this.hasStrides);
            dw.writeInt(this.strides);
            dw.writeBoolean(false);
            dw.writeInt(0);
            dw.writeBoolean(this.hasTemperature);
            dw.writeFloat(this.temperature);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Llocus/api/objects/extra/Location$Companion;", "", "()V", "EXTRA_KEY_ACCURACY_HOR", "", "EXTRA_KEY_ACCURACY_VER", "EXTRA_KEY_ALTITUDE", "EXTRA_KEY_BEARING", "EXTRA_KEY_GNSS_HDOP", "EXTRA_KEY_GNSS_PDOP", "EXTRA_KEY_GNSS_SATS_USED", "EXTRA_KEY_GNSS_SATS_VISIBLE", "EXTRA_KEY_GNSS_STATUS", "EXTRA_KEY_GNSS_VDOP", "EXTRA_KEY_SENSOR_CADENCE", "EXTRA_KEY_SENSOR_HEART_RATE", "EXTRA_KEY_SENSOR_POWER", "EXTRA_KEY_SENSOR_SPEED", "EXTRA_KEY_SENSOR_STRIDES", "EXTRA_KEY_SENSOR_TEMPERATURE", "EXTRA_KEY_SPEED", "TAG", "", "locus-api-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

