/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import locus.api.objects.Storable;
import locus.api.objects.extra.Location;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.LocationCompute;
import locus.api.utils.Logger;
import locus.api.utils.SparseArrayCompat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 x2\u00020\u0001:\u0007xyz{|}~B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010c\u001a\u00020\u001d2\u0006\u0010d\u001a\u00020\u0000J\u000e\u0010e\u001a\u00020f2\u0006\u0010d\u001a\u00020\u0000J\u000e\u0010g\u001a\u00020\u001d2\u0006\u0010d\u001a\u00020\u0000J\b\u0010h\u001a\u00020\u001fH\u0014J\u0006\u0010i\u001a\u00020jJ\b\u0010k\u001a\u00020jH\u0007J\u0018\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020\u001f2\u0006\u0010o\u001a\u00020pH\u0014J\u0006\u0010q\u001a\u00020mJ\u0006\u0010r\u001a\u00020mJ\u000e\u0010s\u001a\u00020m2\u0006\u0010\u0006\u001a\u00020\u0000J\b\u0010t\u001a\u00020@H\u0016J\u0010\u0010u\u001a\u00020m2\u0006\u0010v\u001a\u00020wH\u0014R\u001f\u0010\t\u001a\u00060\nR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001f\u0010\u000f\u001a\u00060\nR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u001f\u0010\u0012\u001a\u00060\u0013R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0014\u0010\u0015R\u001f\u0010\u0017\u001a\u00060\nR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000e\u001a\u0004\b\u0018\u0010\fR\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\"\u001a\u00060\nR\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\fR\u0015\u0010$\u001a\u00060\nR\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\fR\u0015\u0010&\u001a\u00060'R\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0015\u0010*\u001a\u00060'R\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0015\u0010,\u001a\u00060'R\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b-\u0010)R\u0015\u0010.\u001a\u00060\nR\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\fR\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R$\u00107\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R$\u0010<\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u00109\"\u0004\b>\u0010;R\u001a\u0010?\u001a\u00020@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001f\u0010E\u001a\u00060'R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010\u000e\u001a\u0004\bF\u0010)R\u001f\u0010H\u001a\u00060'R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010\u000e\u001a\u0004\bI\u0010)R\u001f\u0010K\u001a\u00060\nR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bM\u0010\u000e\u001a\u0004\bL\u0010\fR\u001f\u0010N\u001a\u00060\nR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bP\u0010\u000e\u001a\u0004\bO\u0010\fR\u001f\u0010Q\u001a\u00060RR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bU\u0010\u000e\u001a\u0004\bS\u0010TR\u001f\u0010V\u001a\u00060\nR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bX\u0010\u000e\u001a\u0004\bW\u0010\fR\u001f\u0010Y\u001a\u00060\nR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b[\u0010\u000e\u001a\u0004\bZ\u0010\fR\u001a\u0010\\\u001a\u00020\u001d8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b]\u0010\b\u001a\u0004\b^\u0010_R\u001a\u0010`\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u00103\"\u0004\bb\u00105\u00a8\u0006\u007f"}, d2={"Llocus/api/objects/extra/Location;", "Llocus/api/objects/Storable;", "lat", "", "lon", "(DD)V", "loc", "(Llocus/api/objects/extra/Location;)V", "()V", "accuracyHor", "Llocus/api/objects/extra/Location$ValueContainerFloat;", "getAccuracyHor", "()Llocus/api/objects/extra/Location$ValueContainerFloat;", "accuracyHor$delegate", "Lkotlin/Lazy;", "accuracyVer", "getAccuracyVer", "accuracyVer$delegate", "altitude", "Llocus/api/objects/extra/Location$ValueContainerDouble;", "getAltitude", "()Llocus/api/objects/extra/Location$ValueContainerDouble;", "altitude$delegate", "bearing", "getBearing", "bearing$delegate", "extraDataDouble", "Llocus/api/utils/SparseArrayCompat;", "extraDataFloat", "", "extraDataInt", "", "extraDataShort", "", "gnssHdop", "getGnssHdop", "gnssPdop", "getGnssPdop", "gnssQuality", "Llocus/api/objects/extra/Location$ValueContainerShort;", "getGnssQuality", "()Llocus/api/objects/extra/Location$ValueContainerShort;", "gnssSatsUsed", "getGnssSatsUsed", "gnssSatsVisible", "getGnssSatsVisible", "gnssVdop", "getGnssVdop", "id", "", "getId", "()J", "setId", "(J)V", "value", "latitude", "getLatitude", "()D", "setLatitude", "(D)V", "longitude", "getLongitude", "setLongitude", "provider", "", "getProvider", "()Ljava/lang/String;", "setProvider", "(Ljava/lang/String;)V", "sensorCadence", "getSensorCadence", "sensorCadence$delegate", "sensorHeartRate", "getSensorHeartRate", "sensorHeartRate$delegate", "sensorPower", "getSensorPower", "sensorPower$delegate", "sensorSpeed", "getSensorSpeed", "sensorSpeed$delegate", "sensorStrides", "Llocus/api/objects/extra/Location$ValueContainerInt;", "getSensorStrides", "()Llocus/api/objects/extra/Location$ValueContainerInt;", "sensorStrides$delegate", "sensorTemperature", "getSensorTemperature", "sensorTemperature$delegate", "speed", "getSpeed", "speed$delegate", "speedOptimal", "getSpeedOptimal$annotations", "getSpeedOptimal", "()F", "time", "getTime", "setTime", "bearingTo", "dest", "distanceAndBearingTo", "", "distanceTo", "getVersion", "hasAnySensorData", "", "hasSpeedOptimal", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "removeGnssAll", "removeSensorAll", "set", "toString", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "Companion", "ExtraSensor", "ValueContainer", "ValueContainerDouble", "ValueContainerFloat", "ValueContainerInt", "ValueContainerShort", "locus-api-core"})
public class Location
extends Storable {
    private SparseArrayCompat<Short> extraDataShort;
    private SparseArrayCompat<Integer> extraDataInt;
    private SparseArrayCompat<Float> extraDataFloat;
    private SparseArrayCompat<Double> extraDataDouble;
    private long id;
    @NotNull
    private String provider;
    private long time;
    private double latitude;
    private double longitude;
    @NotNull
    private final Lazy altitude$delegate;
    @NotNull
    private final Lazy speed$delegate;
    @NotNull
    private final Lazy bearing$delegate;
    @NotNull
    private final Lazy accuracyHor$delegate;
    @NotNull
    private final Lazy accuracyVer$delegate;
    @NotNull
    private final Lazy sensorCadence$delegate;
    @NotNull
    private final Lazy sensorHeartRate$delegate;
    @NotNull
    private final Lazy sensorSpeed$delegate;
    @NotNull
    private final Lazy sensorPower$delegate;
    @NotNull
    private final Lazy sensorStrides$delegate;
    @NotNull
    private final Lazy sensorTemperature$delegate;
    private static final String TAG = "Location";
    private static final byte EXTRA_KEY_ALTITUDE = 10;
    private static final byte EXTRA_KEY_SPEED = 11;
    private static final byte EXTRA_KEY_BEARING = 12;
    private static final byte EXTRA_KEY_ACCURACY_HOR = 13;
    private static final byte EXTRA_KEY_ACCURACY_VER = 14;
    private static final byte EXTRA_KEY_SENSOR_HEART_RATE = 20;
    private static final byte EXTRA_KEY_SENSOR_CADENCE = 21;
    private static final byte EXTRA_KEY_SENSOR_SPEED = 22;
    private static final byte EXTRA_KEY_SENSOR_TEMPERATURE = 23;
    private static final byte EXTRA_KEY_SENSOR_POWER = 24;
    private static final byte EXTRA_KEY_SENSOR_STRIDES = 25;
    private static final byte EXTRA_KEY_GNSS_STATUS = 51;
    private static final byte EXTRA_KEY_GNSS_HDOP = 52;
    private static final byte EXTRA_KEY_GNSS_VDOP = 53;
    private static final byte EXTRA_KEY_GNSS_PDOP = 54;
    private static final byte EXTRA_KEY_GNSS_SATS_USED = 55;
    private static final byte EXTRA_KEY_GNSS_SATS_VISIBLE = 56;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final long getId() {
        return this.id;
    }

    public final void setId(long l) {
        this.id = l;
    }

    @NotNull
    public final String getProvider() {
        return this.provider;
    }

    public final void setProvider(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.provider = string;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(double value) {
        double d;
        if (value < -90.0) {
            Logger.INSTANCE.logE(TAG, "setLatitude(" + value + "), invalid latitude");
            d = -90.0;
        } else if (value > 90.0) {
            Logger.INSTANCE.logE(TAG, "setLatitude(" + value + "), invalid latitude");
            d = 90.0;
        } else {
            d = value;
        }
        this.latitude = d;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(double value) {
        double newValue = value;
        if (newValue < -180.0) {
            newValue += 360.0;
        } else if (newValue > 180.0) {
            newValue -= 360.0;
        }
        this.longitude = newValue;
    }

    @NotNull
    public final ValueContainerDouble getAltitude() {
        Lazy lazy = this.altitude$delegate;
        Location location = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueContainerDouble)lazy.getValue();
    }

    @NotNull
    public final ValueContainerFloat getSpeed() {
        Lazy lazy = this.speed$delegate;
        Location location = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueContainerFloat)lazy.getValue();
    }

    @NotNull
    public final ValueContainerFloat getBearing() {
        Lazy lazy = this.bearing$delegate;
        Location location = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueContainerFloat)lazy.getValue();
    }

    @NotNull
    public final ValueContainerFloat getAccuracyHor() {
        Lazy lazy = this.accuracyHor$delegate;
        Location location = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueContainerFloat)lazy.getValue();
    }

    @NotNull
    public final ValueContainerFloat getAccuracyVer() {
        Lazy lazy = this.accuracyVer$delegate;
        Location location = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueContainerFloat)lazy.getValue();
    }

    public final boolean hasAnySensorData() {
        return this.extraDataShort.containsKey(21) || this.extraDataShort.containsKey(20) || this.extraDataFloat.containsKey(22) || this.extraDataFloat.containsKey(24) || this.extraDataInt.containsKey(25) || this.extraDataFloat.containsKey(23);
    }

    @NotNull
    public final ValueContainerShort getSensorCadence() {
        Lazy lazy = this.sensorCadence$delegate;
        Location location = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueContainerShort)lazy.getValue();
    }

    @NotNull
    public final ValueContainerShort getSensorHeartRate() {
        Lazy lazy = this.sensorHeartRate$delegate;
        Location location = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueContainerShort)lazy.getValue();
    }

    @NotNull
    public final ValueContainerFloat getSensorSpeed() {
        Lazy lazy = this.sensorSpeed$delegate;
        Location location = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueContainerFloat)lazy.getValue();
    }

    @NotNull
    public final ValueContainerFloat getSensorPower() {
        Lazy lazy = this.sensorPower$delegate;
        Location location = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueContainerFloat)lazy.getValue();
    }

    @NotNull
    public final ValueContainerInt getSensorStrides() {
        Lazy lazy = this.sensorStrides$delegate;
        Location location = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueContainerInt)lazy.getValue();
    }

    @NotNull
    public final ValueContainerFloat getSensorTemperature() {
        Lazy lazy = this.sensorTemperature$delegate;
        Location location = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ValueContainerFloat)lazy.getValue();
    }

    @NotNull
    public final ValueContainerShort getGnssQuality() {
        return new ValueContainerShort(51);
    }

    @NotNull
    public final ValueContainerFloat getGnssHdop() {
        return new ValueContainerFloat(52);
    }

    @NotNull
    public final ValueContainerFloat getGnssVdop() {
        return new ValueContainerFloat(53);
    }

    @NotNull
    public final ValueContainerFloat getGnssPdop() {
        return new ValueContainerFloat(54);
    }

    @NotNull
    public final ValueContainerShort getGnssSatsUsed() {
        return new ValueContainerShort(55);
    }

    @NotNull
    public final ValueContainerShort getGnssSatsVisible() {
        return new ValueContainerShort(56);
    }

    public final void set(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this.id = loc.id;
        this.provider = loc.provider;
        this.time = loc.time;
        this.setLatitude(loc.latitude);
        this.setLongitude(loc.longitude);
        this.extraDataShort.putAll(loc.extraDataShort);
        this.extraDataInt.putAll(loc.extraDataInt);
        this.extraDataFloat.putAll(loc.extraDataFloat);
        this.extraDataDouble.putAll(loc.extraDataDouble);
    }

    @Deprecated(message="Work with speed value directly")
    public static /* synthetic */ void getSpeedOptimal$annotations() {
    }

    public final float getSpeedOptimal() {
        return this.getSensorSpeed().getHasData() ? ((Number)this.getSensorSpeed().getValue()).floatValue() : ((Number)this.getSpeed().getValue()).floatValue();
    }

    @Deprecated(message="Work with speed value directly")
    public final boolean hasSpeedOptimal() {
        return this.getSpeed().getHasData() || this.getSensorSpeed().getHasData();
    }

    public final void removeSensorAll() {
        this.getSensorCadence().remove();
        this.getSensorHeartRate().remove();
        this.getSensorPower().remove();
        this.getSensorSpeed().remove();
        this.getSensorStrides().remove();
        this.getSensorTemperature().remove();
    }

    public final void removeGnssAll() {
        this.getGnssQuality().remove();
        this.getGnssHdop().remove();
        this.getGnssVdop().remove();
        this.getGnssPdop().remove();
        this.getGnssSatsUsed().remove();
    }

    @NotNull
    public String toString() {
        return "Location [" + "tag: " + this.provider + ", " + "time: " + this.time + ", " + "lon: " + this.longitude + ", " + "lat: " + this.latitude + ", " + "alt: " + this.getAltitude() + ']';
    }

    public final float distanceTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return com.distanceTo(dest);
    }

    public final float bearingTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return com.bearingTo(dest);
    }

    @NotNull
    public final float[] distanceAndBearingTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return new float[]{com.distanceTo(dest), com.bearingTo(dest)};
    }

    @Override
    protected int getVersion() {
        return 3;
    }

    @Override
    protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        this.id = dr.readLong();
        String string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.provider = string;
        this.time = dr.readLong();
        this.setLatitude(dr.readDouble());
        this.setLongitude(dr.readDouble());
        boolean hasAltitude = dr.readBoolean();
        double altitude2 = dr.readDouble();
        if (hasAltitude) {
            this.getAltitude().setValue(altitude2);
        }
        if (dr.readBoolean()) {
            boolean hasAccuracy = dr.readBoolean();
            float accuracy = dr.readFloat();
            if (hasAccuracy) {
                this.getAccuracyHor().setValue(Float.valueOf(accuracy));
            }
            boolean hasBearing = dr.readBoolean();
            float bearing2 = dr.readFloat();
            if (hasBearing) {
                this.getBearing().setValue(Float.valueOf(bearing2));
            }
            boolean hasSpeed = dr.readBoolean();
            float speed2 = dr.readFloat();
            if (hasSpeed) {
                this.getSpeed().setValue(Float.valueOf(speed2));
            }
        }
        if (version >= 1 && dr.readBoolean()) {
            ExtraSensor extraSensor;
            ExtraSensor extraSensor2;
            ExtraSensor $this$apply;
            boolean bl;
            ExtraSensor accuracy;
            if (version == 1) {
                accuracy = new ExtraSensor();
                n = 0;
                bl = false;
                $this$apply = accuracy;
                boolean bl2 = false;
                $this$apply.setHasHr(dr.readBoolean());
                $this$apply.setHr(dr.readInt());
                $this$apply.setHasCadence(dr.readBoolean());
                $this$apply.setCadence(dr.readInt());
                $this$apply.setHasSpeed(dr.readBoolean());
                $this$apply.setSpeed(dr.readFloat());
                $this$apply.setHasPower(dr.readBoolean());
                $this$apply.setPower(dr.readFloat());
                extraSensor2 = accuracy;
            } else {
                accuracy = new ExtraSensor();
                n = 0;
                bl = false;
                $this$apply = accuracy;
                boolean bl3 = false;
                $this$apply.read(dr);
                extraSensor2 = extraSensor = accuracy;
            }
            if (extraSensor.getHasCadence()) {
                this.getSensorCadence().setValue((short)extraSensor.getCadence());
            }
            if (extraSensor.getHasHr()) {
                this.getSensorHeartRate().setValue((short)extraSensor.getHr());
            }
            if (extraSensor.getHasPower()) {
                this.getSensorPower().setValue(Float.valueOf(extraSensor.getPower()));
            }
            if (extraSensor.getHasSpeed()) {
                this.getSensorSpeed().setValue(Float.valueOf(extraSensor.getSpeed()));
            }
            if (extraSensor.getHasStrides()) {
                this.getSensorStrides().setValue(extraSensor.getStrides());
            }
            if (extraSensor.getHasTemperature()) {
                this.getSensorTemperature().setValue(Float.valueOf(extraSensor.getTemperature()));
            }
        }
        if (version >= 3) {
            int i;
            this.extraDataShort.clear();
            int size = dr.readByte();
            int accuracy = 0;
            n = size;
            while (accuracy < n) {
                this.extraDataShort.put(dr.readByte(), dr.readShort());
                ++i;
            }
            this.extraDataInt.clear();
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.extraDataInt.put(dr.readByte(), dr.readInt());
            }
            this.extraDataFloat.clear();
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.extraDataFloat.put(dr.readByte(), Float.valueOf(dr.readFloat()));
            }
            this.extraDataDouble.clear();
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.extraDataDouble.put(dr.readByte(), dr.readDouble());
            }
        }
    }

    @Override
    protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        int i;
        ExtraSensor extraSensor;
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeLong(this.id);
        dw.writeString(this.provider);
        dw.writeLong(this.time);
        dw.writeDouble(this.latitude);
        dw.writeDouble(this.longitude);
        dw.writeBoolean(this.getAltitude().getHasData());
        dw.writeDouble(((Number)this.getAltitude().getValue()).doubleValue());
        if (this.getAccuracyHor().getHasData() || this.getBearing().getHasData() || this.getSpeed().getHasData()) {
            dw.writeBoolean(true);
            dw.writeBoolean(this.getAccuracyHor().getHasData());
            dw.writeFloat(((Number)this.getAccuracyHor().getValue()).floatValue());
            dw.writeBoolean(this.getBearing().getHasData());
            dw.writeFloat(((Number)this.getBearing().getValue()).floatValue());
            dw.writeBoolean(this.getSpeed().getHasData());
            dw.writeFloat(((Number)this.getSpeed().getValue()).floatValue());
        } else {
            dw.writeBoolean(false);
        }
        ExtraSensor extraSensor2 = new ExtraSensor();
        int n = 0;
        boolean bl = false;
        ExtraSensor $this$apply = extraSensor2;
        boolean bl2 = false;
        if (this.getSensorCadence().getHasData()) {
            $this$apply.setHasCadence(true);
            $this$apply.setCadence(((Number)this.getSensorCadence().getValue()).shortValue());
        }
        if (this.getSensorHeartRate().getHasData()) {
            $this$apply.setHasHr(true);
            $this$apply.setHr(((Number)this.getSensorHeartRate().getValue()).shortValue());
        }
        if (this.getSensorPower().getHasData()) {
            $this$apply.setHasPower(true);
            $this$apply.setPower(((Number)this.getSensorPower().getValue()).floatValue());
        }
        if (this.getSensorSpeed().getHasData()) {
            $this$apply.setHasSpeed(true);
            $this$apply.setSpeed(((Number)this.getSensorSpeed().getValue()).floatValue());
        }
        if (this.getSensorStrides().getHasData()) {
            $this$apply.setHasStrides(true);
            $this$apply.setStrides(((Number)this.getSensorStrides().getValue()).intValue());
        }
        if (this.getSensorTemperature().getHasData()) {
            $this$apply.setHasTemperature(true);
            $this$apply.setTemperature(((Number)this.getSensorTemperature().getValue()).floatValue());
        }
        extraSensor2 = extraSensor = extraSensor2;
        n = 0;
        bl = false;
        ExtraSensor it = extraSensor2;
        boolean bl3 = false;
        ExtraSensor extraSensor3 = it.hasData() ? extraSensor2 : null;
        if (extraSensor3 != null) {
            extraSensor2 = extraSensor3;
            n = 0;
            bl = false;
            it = extraSensor2;
            boolean bl4 = false;
            dw.writeBoolean(true);
            it.write(dw);
        } else {
            Unit cfr_ignored_0 = (Unit)((Function0)new Function0<Unit>(dw){
                final /* synthetic */ DataWriterBigEndian $dw;

                public final void invoke() {
                    this.$dw.writeBoolean(false);
                }
                {
                    this.$dw = dataWriterBigEndian;
                    super(0);
                }
            }).invoke();
        }
        dw.writeByte((byte)this.extraDataShort.size());
        int n2 = 0;
        n = this.extraDataShort.size();
        while (n2 < n) {
            dw.writeByte((byte)this.extraDataShort.keyAt(i));
            dw.writeShort(((Number)this.extraDataShort.valueAt(i)).shortValue());
            ++i;
        }
        dw.writeByte((byte)this.extraDataInt.size());
        n = this.extraDataInt.size();
        for (i = 0; i < n; ++i) {
            dw.writeByte((byte)this.extraDataInt.keyAt(i));
            Integer n3 = this.extraDataInt.valueAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"extraDataInt.valueAt(i)");
            dw.writeInt(((Number)n3).intValue());
        }
        dw.writeByte((byte)this.extraDataFloat.size());
        n = this.extraDataFloat.size();
        for (i = 0; i < n; ++i) {
            dw.writeByte((byte)this.extraDataFloat.keyAt(i));
            Float f = this.extraDataFloat.valueAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.valueAt(i)");
            dw.writeFloat(((Number)f).floatValue());
        }
        dw.writeByte((byte)this.extraDataDouble.size());
        n = this.extraDataDouble.size();
        for (i = 0; i < n; ++i) {
            dw.writeByte((byte)this.extraDataDouble.keyAt(i));
            Double d = this.extraDataDouble.valueAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"extraDataDouble.valueAt(i)");
            dw.writeDouble(((Number)d).doubleValue());
        }
    }

    public Location() {
        this.extraDataShort = new SparseArrayCompat(0);
        this.extraDataInt = new SparseArrayCompat(0);
        this.extraDataFloat = new SparseArrayCompat(0);
        this.extraDataDouble = new SparseArrayCompat(0);
        this.id = -1L;
        this.provider = "";
        this.altitude$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ValueContainerDouble>(this){
            final /* synthetic */ Location this$0;

            @NotNull
            public final ValueContainerDouble invoke() {
                return this.this$0.new ValueContainerDouble(10);
            }
            {
                this.this$0 = location;
                super(0);
            }
        }));
        this.speed$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ValueContainerFloat>(this){
            final /* synthetic */ Location this$0;

            @NotNull
            public final ValueContainerFloat invoke() {
                return this.this$0.new ValueContainerFloat(11);
            }
            {
                this.this$0 = location;
                super(0);
            }
        }));
        this.bearing$delegate = LazyKt.lazy((Function0)((Function0)new Function0<bearing.1>(this){
            final /* synthetic */ Location this$0;

            @NotNull
            public final bearing.1 invoke() {
                return new ValueContainerFloat(this, 12){
                    final /* synthetic */ bearing.2 this$0;

                    @NotNull
                    public Float validateNewValue$locus_api_core(float value) {
                        float bearingNew;
                        for (bearingNew = value; bearingNew < 0.0f; bearingNew += 360.0f) {
                        }
                        while (bearingNew >= 360.0f) {
                            bearingNew -= 360.0f;
                        }
                        return Float.valueOf(bearingNew);
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1);
                    }
                };
            }
            {
                this.this$0 = location;
                super(0);
            }
        }));
        this.accuracyHor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ValueContainerFloat>(this){
            final /* synthetic */ Location this$0;

            @NotNull
            public final ValueContainerFloat invoke() {
                return this.this$0.new ValueContainerFloat(13);
            }
            {
                this.this$0 = location;
                super(0);
            }
        }));
        this.accuracyVer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ValueContainerFloat>(this){
            final /* synthetic */ Location this$0;

            @NotNull
            public final ValueContainerFloat invoke() {
                return this.this$0.new ValueContainerFloat(14);
            }
            {
                this.this$0 = location;
                super(0);
            }
        }));
        this.sensorCadence$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ValueContainerShort>(this){
            final /* synthetic */ Location this$0;

            @NotNull
            public final ValueContainerShort invoke() {
                return this.this$0.new ValueContainerShort(21);
            }
            {
                this.this$0 = location;
                super(0);
            }
        }));
        this.sensorHeartRate$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ValueContainerShort>(this){
            final /* synthetic */ Location this$0;

            @NotNull
            public final ValueContainerShort invoke() {
                return this.this$0.new ValueContainerShort(20);
            }
            {
                this.this$0 = location;
                super(0);
            }
        }));
        this.sensorSpeed$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ValueContainerFloat>(this){
            final /* synthetic */ Location this$0;

            @NotNull
            public final ValueContainerFloat invoke() {
                return this.this$0.new ValueContainerFloat(22);
            }
            {
                this.this$0 = location;
                super(0);
            }
        }));
        this.sensorPower$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ValueContainerFloat>(this){
            final /* synthetic */ Location this$0;

            @NotNull
            public final ValueContainerFloat invoke() {
                return this.this$0.new ValueContainerFloat(24);
            }
            {
                this.this$0 = location;
                super(0);
            }
        }));
        this.sensorStrides$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ValueContainerInt>(this){
            final /* synthetic */ Location this$0;

            @NotNull
            public final ValueContainerInt invoke() {
                return this.this$0.new ValueContainerInt(25);
            }
            {
                this.this$0 = location;
                super(0);
            }
        }));
        this.sensorTemperature$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ValueContainerFloat>(this){
            final /* synthetic */ Location this$0;

            @NotNull
            public final ValueContainerFloat invoke() {
                return this.this$0.new ValueContainerFloat(23);
            }
            {
                this.this$0 = location;
                super(0);
            }
        }));
    }

    public Location(double lat, double lon) {
        this();
        this.setLatitude(lat);
        this.setLongitude(lon);
    }

    public Location(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this();
        this.set(loc);
    }

    public static final /* synthetic */ void access$setExtraDataShort$p(Location $this, SparseArrayCompat sparseArrayCompat) {
        $this.extraDataShort = sparseArrayCompat;
    }

    public static final /* synthetic */ void access$setExtraDataInt$p(Location $this, SparseArrayCompat sparseArrayCompat) {
        $this.extraDataInt = sparseArrayCompat;
    }

    public static final /* synthetic */ void access$setExtraDataFloat$p(Location $this, SparseArrayCompat sparseArrayCompat) {
        $this.extraDataFloat = sparseArrayCompat;
    }

    public static final /* synthetic */ void access$setExtraDataDouble$p(Location $this, SparseArrayCompat sparseArrayCompat) {
        $this.extraDataDouble = sparseArrayCompat;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0014J\u000f\u0010\u0015\u001a\u00028\u0000H \u00a2\u0006\u0004\b\u0016\u0010\u000eJ\u0006\u0010\u0017\u001a\u00020\u0012J\u0017\u0010\u0018\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0000H\u0010\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Llocus/api/objects/extra/Location$ValueContainer;", "T", "", "dataContainer", "Llocus/api/utils/SparseArrayCompat;", "id", "", "(Llocus/api/utils/SparseArrayCompat;B)V", "hasData", "", "getHasData", "()Z", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "doIfValid", "", "action", "Lkotlin/Function1;", "getDefaultEmpty", "getDefaultEmpty$locus_api_core", "remove", "validateNewValue", "validateNewValue$locus_api_core", "(Ljava/lang/Object;)Ljava/lang/Object;", "locus-api-core"})
    public static abstract class ValueContainer<T> {
        private final SparseArrayCompat<T> dataContainer;
        private final byte id;

        public final boolean getHasData() {
            return this.dataContainer.containsKey(this.id);
        }

        public final T getValue() {
            return this.dataContainer.get(this.id, this.getDefaultEmpty$locus_api_core());
        }

        public final void setValue(T value) {
            T validatedValue = this.validateNewValue$locus_api_core(value);
            this.dataContainer.put(this.id, validatedValue);
        }

        public abstract T getDefaultEmpty$locus_api_core();

        public T validateNewValue$locus_api_core(T value) {
            return value;
        }

        public final void doIfValid(@NotNull Function1<? super T, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            if (this.getHasData()) {
                action.invoke(this.getValue());
            }
        }

        public final void remove() {
            this.dataContainer.remove(this.id);
        }

        public ValueContainer(@NotNull SparseArrayCompat<T> dataContainer, byte id) {
            Intrinsics.checkNotNullParameter(dataContainer, (String)"dataContainer");
            this.dataContainer = dataContainer;
            this.id = id;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Llocus/api/objects/extra/Location$ValueContainerShort;", "Llocus/api/objects/extra/Location$ValueContainer;", "", "id", "", "(Llocus/api/objects/extra/Location;B)V", "getDefaultEmpty", "getDefaultEmpty$locus_api_core", "()Ljava/lang/Short;", "locus-api-core"})
    public final class ValueContainerShort
    extends ValueContainer<Short> {
        @Override
        @NotNull
        public Short getDefaultEmpty$locus_api_core() {
            return (short)0;
        }

        public ValueContainerShort(byte id) {
            super(Location.this.extraDataShort, id);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Llocus/api/objects/extra/Location$ValueContainerInt;", "Llocus/api/objects/extra/Location$ValueContainer;", "", "id", "", "(Llocus/api/objects/extra/Location;B)V", "getDefaultEmpty", "getDefaultEmpty$locus_api_core", "()Ljava/lang/Integer;", "locus-api-core"})
    public final class ValueContainerInt
    extends ValueContainer<Integer> {
        @Override
        @NotNull
        public Integer getDefaultEmpty$locus_api_core() {
            return 0;
        }

        public ValueContainerInt(byte id) {
            super(Location.this.extraDataInt, id);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0096\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Llocus/api/objects/extra/Location$ValueContainerFloat;", "Llocus/api/objects/extra/Location$ValueContainer;", "", "id", "", "(Llocus/api/objects/extra/Location;B)V", "getDefaultEmpty", "getDefaultEmpty$locus_api_core", "()Ljava/lang/Float;", "locus-api-core"})
    public class ValueContainerFloat
    extends ValueContainer<Float> {
        @Override
        @NotNull
        public Float getDefaultEmpty$locus_api_core() {
            return Float.valueOf(0.0f);
        }

        public ValueContainerFloat(byte id) {
            super(Location.this.extraDataFloat, id);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Llocus/api/objects/extra/Location$ValueContainerDouble;", "Llocus/api/objects/extra/Location$ValueContainer;", "", "id", "", "(Llocus/api/objects/extra/Location;B)V", "getDefaultEmpty", "getDefaultEmpty$locus_api_core", "()Ljava/lang/Double;", "locus-api-core"})
    public final class ValueContainerDouble
    extends ValueContainer<Double> {
        @Override
        @NotNull
        public Double getDefaultEmpty$locus_api_core() {
            return 0.0;
        }

        public ValueContainerDouble(byte id) {
            super(Location.this.extraDataDouble, id);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00100\u001a\u00020\u0004H\u0014J\u0006\u00101\u001a\u00020\nJ\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u000206H\u0014J\u0010\u00107\u001a\u0002032\u0006\u00108\u001a\u000209H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u001a\u0010\u001e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\u001a\u0010*\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0006\"\u0004\b,\u0010\bR\u001a\u0010-\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010$\"\u0004\b/\u0010&\u00a8\u0006:"}, d2={"Llocus/api/objects/extra/Location$ExtraSensor;", "Llocus/api/objects/Storable;", "()V", "cadence", "", "getCadence", "()I", "setCadence", "(I)V", "hasCadence", "", "getHasCadence", "()Z", "setHasCadence", "(Z)V", "hasHr", "getHasHr", "setHasHr", "hasPower", "getHasPower", "setHasPower", "hasSpeed", "getHasSpeed", "setHasSpeed", "hasStrides", "getHasStrides", "setHasStrides", "hasTemperature", "getHasTemperature", "setHasTemperature", "hr", "getHr", "setHr", "power", "", "getPower", "()F", "setPower", "(F)V", "speed", "getSpeed", "setSpeed", "strides", "getStrides", "setStrides", "temperature", "getTemperature", "setTemperature", "getVersion", "hasData", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "locus-api-core"})
    private static final class ExtraSensor
    extends Storable {
        private boolean hasHr;
        private int hr;
        private boolean hasCadence;
        private int cadence;
        private boolean hasSpeed;
        private float speed;
        private boolean hasPower;
        private float power;
        private boolean hasStrides;
        private int strides;
        private boolean hasTemperature;
        private float temperature;

        public final boolean getHasHr() {
            return this.hasHr;
        }

        public final void setHasHr(boolean bl) {
            this.hasHr = bl;
        }

        public final int getHr() {
            return this.hr;
        }

        public final void setHr(int n) {
            this.hr = n;
        }

        public final boolean getHasCadence() {
            return this.hasCadence;
        }

        public final void setHasCadence(boolean bl) {
            this.hasCadence = bl;
        }

        public final int getCadence() {
            return this.cadence;
        }

        public final void setCadence(int n) {
            this.cadence = n;
        }

        public final boolean getHasSpeed() {
            return this.hasSpeed;
        }

        public final void setHasSpeed(boolean bl) {
            this.hasSpeed = bl;
        }

        public final float getSpeed() {
            return this.speed;
        }

        public final void setSpeed(float f) {
            this.speed = f;
        }

        public final boolean getHasPower() {
            return this.hasPower;
        }

        public final void setHasPower(boolean bl) {
            this.hasPower = bl;
        }

        public final float getPower() {
            return this.power;
        }

        public final void setPower(float f) {
            this.power = f;
        }

        public final boolean getHasStrides() {
            return this.hasStrides;
        }

        public final void setHasStrides(boolean bl) {
            this.hasStrides = bl;
        }

        public final int getStrides() {
            return this.strides;
        }

        public final void setStrides(int n) {
            this.strides = n;
        }

        public final boolean getHasTemperature() {
            return this.hasTemperature;
        }

        public final void setHasTemperature(boolean bl) {
            this.hasTemperature = bl;
        }

        public final float getTemperature() {
            return this.temperature;
        }

        public final void setTemperature(float f) {
            this.temperature = f;
        }

        public final boolean hasData() {
            return this.hasHr || this.hasCadence || this.hasSpeed || this.hasPower || this.hasStrides || this.hasTemperature;
        }

        @Override
        protected int getVersion() {
            return 1;
        }

        @Override
        protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
            this.hasHr = dr.readBoolean();
            this.hr = dr.readInt();
            this.hasCadence = dr.readBoolean();
            this.cadence = dr.readInt();
            this.hasSpeed = dr.readBoolean();
            this.speed = dr.readFloat();
            this.hasPower = dr.readBoolean();
            this.power = dr.readFloat();
            this.hasStrides = dr.readBoolean();
            this.strides = dr.readInt();
            dr.readBoolean();
            dr.readInt();
            if (version >= 1) {
                this.hasTemperature = dr.readBoolean();
                this.temperature = dr.readFloat();
            }
        }

        @Override
        protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
            dw.writeBoolean(this.hasHr);
            dw.writeInt(this.hr);
            dw.writeBoolean(this.hasCadence);
            dw.writeInt(this.cadence);
            dw.writeBoolean(this.hasSpeed);
            dw.writeFloat(this.speed);
            dw.writeBoolean(this.hasPower);
            dw.writeFloat(this.power);
            dw.writeBoolean(this.hasStrides);
            dw.writeInt(this.strides);
            dw.writeBoolean(false);
            dw.writeInt(0);
            dw.writeBoolean(this.hasTemperature);
            dw.writeFloat(this.temperature);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Llocus/api/objects/extra/Location$Companion;", "", "()V", "EXTRA_KEY_ACCURACY_HOR", "", "EXTRA_KEY_ACCURACY_VER", "EXTRA_KEY_ALTITUDE", "EXTRA_KEY_BEARING", "EXTRA_KEY_GNSS_HDOP", "EXTRA_KEY_GNSS_PDOP", "EXTRA_KEY_GNSS_SATS_USED", "EXTRA_KEY_GNSS_SATS_VISIBLE", "EXTRA_KEY_GNSS_STATUS", "EXTRA_KEY_GNSS_VDOP", "EXTRA_KEY_SENSOR_CADENCE", "EXTRA_KEY_SENSOR_HEART_RATE", "EXTRA_KEY_SENSOR_POWER", "EXTRA_KEY_SENSOR_SPEED", "EXTRA_KEY_SENSOR_STRIDES", "EXTRA_KEY_SENSOR_TEMPERATURE", "EXTRA_KEY_SPEED", "TAG", "", "locus-api-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

