/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import locus.api.objects.Storable;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.LocationCompute;
import locus.api.utils.Logger;
import locus.api.utils.SparseArrayCompat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b#\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b$\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00ad\u00012\u00020\u0001:\n\u00ad\u0001\u00ae\u0001\u00af\u0001\u00b0\u0001\u00b1\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0089\u0001\u001a\u00020\n2\u0007\u0010\u008a\u0001\u001a\u00020\u0000J\u0011\u0010\u008b\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u008a\u0001\u001a\u00020\u0000J\u0010\u0010\u008d\u0001\u001a\u00020\n2\u0007\u0010\u008a\u0001\u001a\u00020\u0000J\t\u0010\u008e\u0001\u001a\u00020\u001fH\u0014J\t\u0010\u008f\u0001\u001a\u000207H\u0007J\u001d\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u0007\u0010\u0092\u0001\u001a\u00020\u001f2\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0014J\b\u0010\u0095\u0001\u001a\u00030\u0091\u0001J\b\u0010\u0096\u0001\u001a\u00030\u0091\u0001J\b\u0010\u0097\u0001\u001a\u00030\u0091\u0001J\b\u0010\u0098\u0001\u001a\u00030\u0091\u0001J\b\u0010\u0099\u0001\u001a\u00030\u0091\u0001J\b\u0010\u009a\u0001\u001a\u00030\u0091\u0001J\b\u0010\u009b\u0001\u001a\u00030\u0091\u0001J\b\u0010\u009c\u0001\u001a\u00030\u0091\u0001J\b\u0010\u009d\u0001\u001a\u00030\u0091\u0001J\b\u0010\u009e\u0001\u001a\u00030\u0091\u0001J\b\u0010\u009f\u0001\u001a\u00030\u0091\u0001J\b\u0010\u00a0\u0001\u001a\u00030\u0091\u0001J\b\u0010\u00a1\u0001\u001a\u00030\u0091\u0001J\b\u0010\u00a2\u0001\u001a\u00030\u0091\u0001J\b\u0010\u00a3\u0001\u001a\u00030\u0091\u0001J\b\u0010\u00a4\u0001\u001a\u00030\u0091\u0001J\b\u0010\u00a5\u0001\u001a\u00030\u0091\u0001J\b\u0010\u00a6\u0001\u001a\u00030\u0091\u0001J\b\u0010\u00a7\u0001\u001a\u00030\u0091\u0001J\u0010\u0010\u00a8\u0001\u001a\u00030\u0091\u00012\u0006\u0010\u0006\u001a\u00020\u0000J\t\u0010\u00a9\u0001\u001a\u00020gH\u0016J\u0014\u0010\u00aa\u0001\u001a\u00030\u0091\u00012\b\u0010\u00ab\u0001\u001a\u00030\u00ac\u0001H\u0014R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR$\u0010\u0013\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\r\"\u0004\b$\u0010\u000fR$\u0010%\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010\u000fR$\u0010(\u001a\u00020!2\u0006\u0010\t\u001a\u00020!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R$\u0010-\u001a\u00020!2\u0006\u0010\t\u001a\u00020!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R$\u00100\u001a\u00020!2\u0006\u0010\t\u001a\u00020!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010*\"\u0004\b2\u0010,R$\u00103\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b4\u0010\r\"\u0004\b5\u0010\u000fR\u0011\u00106\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0011\u0010:\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b;\u00109R\u0011\u0010<\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b=\u00109R\u0011\u0010>\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b?\u00109R\u0011\u0010@\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bA\u00109R\u0011\u0010B\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bC\u00109R\u0011\u0010D\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bE\u00109R\u0011\u0010F\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bG\u00109R\u0011\u0010H\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bI\u00109R\u0011\u0010J\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bK\u00109R\u0011\u0010L\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bM\u00109R\u0011\u0010N\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bO\u00109R\u0011\u0010P\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bQ\u00109R\u0011\u0010R\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bS\u00109R\u0011\u0010T\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bU\u00109R\u0011\u0010V\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bW\u00109R\u0011\u0010X\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\bY\u00109R\u001a\u0010Z\u001a\u00020[X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R$\u0010`\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010\u0015\"\u0004\bb\u0010\u0017R$\u0010c\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010\u0015\"\u0004\be\u0010\u0017R\u001a\u0010f\u001a\u00020gX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR$\u0010l\u001a\u00020!2\u0006\u0010\t\u001a\u00020!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bm\u0010*\"\u0004\bn\u0010,R$\u0010o\u001a\u00020!2\u0006\u0010\t\u001a\u00020!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bp\u0010*\"\u0004\bq\u0010,R$\u0010r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bs\u0010\r\"\u0004\bt\u0010\u000fR$\u0010u\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bv\u0010\r\"\u0004\bw\u0010\u000fR$\u0010x\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\by\u0010z\"\u0004\b{\u0010|R$\u0010}\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b~\u0010\r\"\u0004\b\u007f\u0010\u000fR'\u0010\u0080\u0001\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\u000e\u001a\u0005\b\u0081\u0001\u0010\r\"\u0005\b\u0082\u0001\u0010\u000fR\u001d\u0010\u0083\u0001\u001a\u00020\n8FX\u0087\u0004\u00a2\u0006\u000e\u0012\u0005\b\u0084\u0001\u0010\b\u001a\u0005\b\u0085\u0001\u0010\rR\u001d\u0010\u0086\u0001\u001a\u00020[X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0087\u0001\u0010]\"\u0005\b\u0088\u0001\u0010_\u00a8\u0006\u00b2\u0001"}, d2={"Llocus/api/objects/extra/Location;", "Llocus/api/objects/Storable;", "lat", "", "lon", "(DD)V", "loc", "(Llocus/api/objects/extra/Location;)V", "()V", "value", "", "accuracyHor", "getAccuracyHor", "()F", "setAccuracyHor", "(F)V", "accuracyVer", "getAccuracyVer", "setAccuracyVer", "altitude", "getAltitude", "()D", "setAltitude", "(D)V", "bearing", "getBearing", "setBearing", "extraDataDouble", "Llocus/api/utils/SparseArrayCompat;", "extraDataFloat", "extraDataInt", "", "extraDataShort", "", "gnssHdop", "getGnssHdop", "setGnssHdop", "gnssPdop", "getGnssPdop", "setGnssPdop", "gnssQuality", "getGnssQuality", "()S", "setGnssQuality", "(S)V", "gnssSatsUsed", "getGnssSatsUsed", "setGnssSatsUsed", "gnssSatsVisible", "getGnssSatsVisible", "setGnssSatsVisible", "gnssVdop", "getGnssVdop", "setGnssVdop", "hasAccuracyHor", "", "getHasAccuracyHor", "()Z", "hasAccuracyVer", "getHasAccuracyVer", "hasAltitude", "getHasAltitude", "hasBearing", "getHasBearing", "hasGnssHdop", "getHasGnssHdop", "hasGnssPdop", "getHasGnssPdop", "hasGnssQuality", "getHasGnssQuality", "hasGnssSatsUsed", "getHasGnssSatsUsed", "hasGnssSatsVisible", "getHasGnssSatsVisible", "hasGnssVdop", "getHasGnssVdop", "hasSensorCadence", "getHasSensorCadence", "hasSensorHeartRate", "getHasSensorHeartRate", "hasSensorPower", "getHasSensorPower", "hasSensorSpeed", "getHasSensorSpeed", "hasSensorStrides", "getHasSensorStrides", "hasSensorTemperature", "getHasSensorTemperature", "hasSpeed", "getHasSpeed", "id", "", "getId", "()J", "setId", "(J)V", "latitude", "getLatitude", "setLatitude", "longitude", "getLongitude", "setLongitude", "provider", "", "getProvider", "()Ljava/lang/String;", "setProvider", "(Ljava/lang/String;)V", "sensorCadence", "getSensorCadence", "setSensorCadence", "sensorHeartRate", "getSensorHeartRate", "setSensorHeartRate", "sensorPower", "getSensorPower", "setSensorPower", "sensorSpeed", "getSensorSpeed", "setSensorSpeed", "sensorStrides", "getSensorStrides", "()I", "setSensorStrides", "(I)V", "sensorTemperature", "getSensorTemperature", "setSensorTemperature", "speed", "getSpeed", "setSpeed", "speedOptimal", "getSpeedOptimal$annotations", "getSpeedOptimal", "time", "getTime", "setTime", "bearingTo", "dest", "distanceAndBearingTo", "", "distanceTo", "getVersion", "hasSpeedOptimal", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "removeAccuracyHor", "removeAccuracyVer", "removeAltitude", "removeBearing", "removeGnssAll", "removeGnssHdop", "removeGnssPdop", "removeGnssQuality", "removeGnssSatsUsed", "removeGnssSatsVisible", "removeGnssVdop", "removeSensorAll", "removeSensorCadence", "removeSensorHeartRate", "removeSensorPower", "removeSensorSpeed", "removeSensorStrides", "removeSensorTemperature", "removeSpeed", "set", "toString", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "Companion", "ExtraSensor", "ValueContainer", "ValueContainerInt", "ValueContainerShort", "locus-api-core"})
public class Location
extends Storable {
    private SparseArrayCompat<Short> extraDataShort;
    private SparseArrayCompat<Integer> extraDataInt;
    private SparseArrayCompat<Float> extraDataFloat;
    private SparseArrayCompat<Double> extraDataDouble;
    private long id;
    @NotNull
    private String provider;
    private long time;
    private double latitude;
    private double longitude;
    private static final String TAG = "Location";
    private static final int EXTRA_KEY_ALTITUDE = 10;
    private static final int EXTRA_KEY_SPEED = 11;
    private static final int EXTRA_KEY_BEARING = 12;
    private static final int EXTRA_KEY_ACCURACY_HOR = 13;
    private static final int EXTRA_KEY_ACCURACY_VER = 14;
    private static final int EXTRA_KEY_SENSOR_HEART_RATE = 20;
    private static final int EXTRA_KEY_SENSOR_CADENCE = 21;
    private static final int EXTRA_KEY_SENSOR_SPEED = 22;
    private static final int EXTRA_KEY_SENSOR_TEMPERATURE = 23;
    private static final int EXTRA_KEY_SENSOR_POWER = 24;
    private static final int EXTRA_KEY_SENSOR_STRIDES = 25;
    private static final int EXTRA_KEY_GNSS_QUALITY = 51;
    private static final int EXTRA_KEY_GNSS_HDOP = 52;
    private static final int EXTRA_KEY_GNSS_VDOP = 53;
    private static final int EXTRA_KEY_GNSS_PDOP = 54;
    private static final int EXTRA_KEY_GNSS_SATS_USED = 55;
    private static final int EXTRA_KEY_GNSS_SATS_VISIBLE = 56;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final long getId() {
        return this.id;
    }

    public final void setId(long l) {
        this.id = l;
    }

    @NotNull
    public final String getProvider() {
        return this.provider;
    }

    public final void setProvider(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.provider = string;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(double value) {
        double d;
        if (value < -90.0) {
            Logger.INSTANCE.logE(TAG, "setLatitude(" + value + "), invalid latitude");
            d = -90.0;
        } else if (value > 90.0) {
            Logger.INSTANCE.logE(TAG, "setLatitude(" + value + "), invalid latitude");
            d = 90.0;
        } else {
            d = value;
        }
        this.latitude = d;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(double value) {
        double newValue = value;
        if (newValue < -180.0) {
            newValue += 360.0;
        } else if (newValue > 180.0) {
            newValue -= 360.0;
        }
        this.longitude = newValue;
    }

    public final double getAltitude() {
        Double d = this.extraDataDouble.get(10, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"extraDataDouble.get(EXTRA_KEY_ALTITUDE, 0.0)");
        return ((Number)d).doubleValue();
    }

    public final void setAltitude(double value) {
        this.extraDataDouble.put(10, value);
    }

    public final boolean getHasAltitude() {
        return this.extraDataDouble.containsKey(10);
    }

    public final void removeAltitude() {
        this.extraDataDouble.remove(10);
    }

    public final float getSpeed() {
        Float f = this.extraDataFloat.get(11, Float.valueOf(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.get(EXTRA_KEY_SPEED, 0.0f)");
        return ((Number)f).floatValue();
    }

    public final void setSpeed(float value) {
        this.extraDataFloat.put(11, Float.valueOf(value));
    }

    public final boolean getHasSpeed() {
        return this.extraDataFloat.containsKey(11);
    }

    public final void removeSpeed() {
        this.extraDataFloat.remove(11);
    }

    public final float getBearing() {
        Float f = this.extraDataFloat.get(12, Float.valueOf(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.get(EXTRA_KEY_BEARING, 0.0f)");
        return ((Number)f).floatValue();
    }

    public final void setBearing(float value) {
        float bearingNew;
        for (bearingNew = value; bearingNew < 0.0f; bearingNew += 360.0f) {
        }
        while (bearingNew >= 360.0f) {
            bearingNew -= 360.0f;
        }
        this.extraDataFloat.put(12, Float.valueOf(bearingNew));
    }

    public final boolean getHasBearing() {
        return this.extraDataFloat.containsKey(12);
    }

    public final void removeBearing() {
        this.extraDataFloat.remove(12);
    }

    public final float getAccuracyHor() {
        Float f = this.extraDataFloat.get(13, Float.valueOf(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.get(EXTRA_KEY_ACCURACY_HOR, 0.0f)");
        return ((Number)f).floatValue();
    }

    public final void setAccuracyHor(float value) {
        this.extraDataFloat.put(13, Float.valueOf(value));
    }

    public final boolean getHasAccuracyHor() {
        return this.extraDataFloat.containsKey(13);
    }

    public final void removeAccuracyHor() {
        this.extraDataFloat.remove(13);
    }

    public final float getAccuracyVer() {
        Float f = this.extraDataFloat.get(14, Float.valueOf(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.get(EXTRA_KEY_ACCURACY_VER, 0.0f)");
        return ((Number)f).floatValue();
    }

    public final void setAccuracyVer(float value) {
        this.extraDataFloat.put(14, Float.valueOf(value));
    }

    public final boolean getHasAccuracyVer() {
        return this.extraDataFloat.containsKey(14);
    }

    public final void removeAccuracyVer() {
        this.extraDataFloat.remove(14);
    }

    public final short getSensorCadence() {
        Short s = this.extraDataShort.get(21, (short)0);
        Intrinsics.checkNotNullExpressionValue((Object)s, (String)"extraDataShort.get(EXTRA_KEY_SENSOR_CADENCE, 0)");
        return ((Number)s).shortValue();
    }

    public final void setSensorCadence(short value) {
        this.extraDataShort.put(21, value);
    }

    public final boolean getHasSensorCadence() {
        return this.extraDataShort.containsKey(21);
    }

    public final void removeSensorCadence() {
        this.extraDataShort.remove(21);
    }

    public final short getSensorHeartRate() {
        Short s = this.extraDataShort.get(20, (short)0);
        Intrinsics.checkNotNullExpressionValue((Object)s, (String)"extraDataShort.get(EXTRA_KEY_SENSOR_HEART_RATE, 0)");
        return ((Number)s).shortValue();
    }

    public final void setSensorHeartRate(short value) {
        this.extraDataShort.put(20, value);
    }

    public final boolean getHasSensorHeartRate() {
        return this.extraDataShort.containsKey(20);
    }

    public final void removeSensorHeartRate() {
        this.extraDataShort.remove(20);
    }

    public final float getSensorSpeed() {
        Float f = this.extraDataFloat.get(22, Float.valueOf(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.get(EXTRA_KEY_SENSOR_SPEED, 0.0f)");
        return ((Number)f).floatValue();
    }

    public final void setSensorSpeed(float value) {
        this.extraDataFloat.put(22, Float.valueOf(value));
    }

    public final boolean getHasSensorSpeed() {
        return this.extraDataFloat.containsKey(22);
    }

    public final void removeSensorSpeed() {
        this.extraDataFloat.remove(22);
    }

    public final float getSensorPower() {
        Float f = this.extraDataFloat.get(24, Float.valueOf(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.get(EXTRA_KEY_SENSOR_POWER, 0.0f)");
        return ((Number)f).floatValue();
    }

    public final void setSensorPower(float value) {
        this.extraDataFloat.put(24, Float.valueOf(value));
    }

    public final boolean getHasSensorPower() {
        return this.extraDataFloat.containsKey(24);
    }

    public final void removeSensorPower() {
        this.extraDataFloat.remove(24);
    }

    public final int getSensorStrides() {
        Integer n = this.extraDataInt.get(25, 0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"extraDataInt.get(EXTRA_KEY_SENSOR_STRIDES, 0)");
        return ((Number)n).intValue();
    }

    public final void setSensorStrides(int value) {
        this.extraDataInt.put(25, value);
    }

    public final boolean getHasSensorStrides() {
        return this.extraDataInt.containsKey(25);
    }

    public final void removeSensorStrides() {
        this.extraDataInt.remove(25);
    }

    public final float getSensorTemperature() {
        Float f = this.extraDataFloat.get(23, Float.valueOf(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.get(EXTRA\u2026SENSOR_TEMPERATURE, 0.0f)");
        return ((Number)f).floatValue();
    }

    public final void setSensorTemperature(float value) {
        this.extraDataFloat.put(23, Float.valueOf(value));
    }

    public final boolean getHasSensorTemperature() {
        return this.extraDataFloat.containsKey(23);
    }

    public final void removeSensorTemperature() {
        this.extraDataFloat.remove(23);
    }

    public final short getGnssQuality() {
        Short s = this.extraDataShort.get(51, (short)0);
        Intrinsics.checkNotNullExpressionValue((Object)s, (String)"extraDataShort.get(EXTRA_KEY_GNSS_QUALITY, 0)");
        return ((Number)s).shortValue();
    }

    public final void setGnssQuality(short value) {
        this.extraDataShort.put(51, value);
    }

    public final boolean getHasGnssQuality() {
        return this.extraDataShort.containsKey(51);
    }

    public final void removeGnssQuality() {
        this.extraDataShort.remove(51);
    }

    public final float getGnssHdop() {
        Float f = this.extraDataFloat.get(52, Float.valueOf(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.get(EXTRA_KEY_GNSS_HDOP, 0.0f)");
        return ((Number)f).floatValue();
    }

    public final void setGnssHdop(float value) {
        this.extraDataFloat.put(52, Float.valueOf(value));
    }

    public final boolean getHasGnssHdop() {
        return this.extraDataFloat.containsKey(52);
    }

    public final void removeGnssHdop() {
        this.extraDataFloat.remove(52);
    }

    public final float getGnssVdop() {
        Float f = this.extraDataFloat.get(53, Float.valueOf(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.get(EXTRA_KEY_GNSS_VDOP, 0.0f)");
        return ((Number)f).floatValue();
    }

    public final void setGnssVdop(float value) {
        this.extraDataFloat.put(53, Float.valueOf(value));
    }

    public final boolean getHasGnssVdop() {
        return this.extraDataFloat.containsKey(53);
    }

    public final void removeGnssVdop() {
        this.extraDataFloat.remove(53);
    }

    public final float getGnssPdop() {
        Float f = this.extraDataFloat.get(54, Float.valueOf(0.0f));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.get(EXTRA_KEY_GNSS_PDOP, 0.0f)");
        return ((Number)f).floatValue();
    }

    public final void setGnssPdop(float value) {
        this.extraDataFloat.put(54, Float.valueOf(value));
    }

    public final boolean getHasGnssPdop() {
        return this.extraDataFloat.containsKey(54);
    }

    public final void removeGnssPdop() {
        this.extraDataFloat.remove(54);
    }

    public final short getGnssSatsUsed() {
        Short s = this.extraDataShort.get(55, (short)0);
        Intrinsics.checkNotNullExpressionValue((Object)s, (String)"extraDataShort.get(EXTRA_KEY_GNSS_SATS_USED, 0)");
        return ((Number)s).shortValue();
    }

    public final void setGnssSatsUsed(short value) {
        this.extraDataShort.put(55, value);
    }

    public final boolean getHasGnssSatsUsed() {
        return this.extraDataShort.containsKey(55);
    }

    public final void removeGnssSatsUsed() {
        this.extraDataShort.remove(55);
    }

    public final short getGnssSatsVisible() {
        Short s = this.extraDataShort.get(56, (short)0);
        Intrinsics.checkNotNullExpressionValue((Object)s, (String)"extraDataShort.get(EXTRA_KEY_GNSS_SATS_VISIBLE, 0)");
        return ((Number)s).shortValue();
    }

    public final void setGnssSatsVisible(short value) {
        this.extraDataShort.put(56, value);
    }

    public final boolean getHasGnssSatsVisible() {
        return this.extraDataShort.containsKey(56);
    }

    public final void removeGnssSatsVisible() {
        this.extraDataShort.remove(56);
    }

    public final void set(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this.id = loc.id;
        this.provider = loc.provider;
        this.time = loc.time;
        this.setLatitude(loc.latitude);
        this.setLongitude(loc.longitude);
        this.extraDataShort.putAll(loc.extraDataShort);
        this.extraDataInt.putAll(loc.extraDataInt);
        this.extraDataFloat.putAll(loc.extraDataFloat);
        this.extraDataDouble.putAll(loc.extraDataDouble);
    }

    @Deprecated(message="Work with speed value directly")
    public static /* synthetic */ void getSpeedOptimal$annotations() {
    }

    public final float getSpeedOptimal() {
        return this.getHasSensorSpeed() ? this.getSensorSpeed() : this.getSpeed();
    }

    @Deprecated(message="Work with speed value directly")
    public final boolean hasSpeedOptimal() {
        return this.getHasSpeed() || this.getHasSensorSpeed();
    }

    public final void removeSensorAll() {
        this.removeSensorCadence();
        this.removeSensorHeartRate();
        this.removeSensorPower();
        this.removeSensorSpeed();
        this.removeSensorStrides();
        this.removeSensorTemperature();
    }

    public final void removeGnssAll() {
        this.removeGnssQuality();
        this.removeGnssHdop();
        this.removeGnssVdop();
        this.removeGnssPdop();
        this.removeGnssSatsUsed();
        this.removeGnssSatsVisible();
    }

    @NotNull
    public String toString() {
        return "Location [" + "tag: " + this.provider + ", " + "time: " + this.time + ", " + "lon: " + this.longitude + ", " + "lat: " + this.latitude + ", " + "alt: " + this.getAltitude() + ']';
    }

    public final float distanceTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return com.distanceTo(dest);
    }

    public final float bearingTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return com.bearingTo(dest);
    }

    @NotNull
    public final float[] distanceAndBearingTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return new float[]{com.distanceTo(dest), com.bearingTo(dest)};
    }

    @Override
    protected int getVersion() {
        return 3;
    }

    @Override
    protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        this.id = dr.readLong();
        String string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.provider = string;
        this.time = dr.readLong();
        this.setLatitude(dr.readDouble());
        this.setLongitude(dr.readDouble());
        boolean hasAltitude = dr.readBoolean();
        double altitude = dr.readDouble();
        if (hasAltitude) {
            this.setAltitude(altitude);
        }
        if (dr.readBoolean()) {
            boolean hasAccuracy = dr.readBoolean();
            float accuracy = dr.readFloat();
            if (hasAccuracy) {
                this.setAccuracyHor(accuracy);
            }
            boolean hasBearing = dr.readBoolean();
            float bearing = dr.readFloat();
            if (hasBearing) {
                this.setBearing(bearing);
            }
            boolean hasSpeed = dr.readBoolean();
            float speed = dr.readFloat();
            if (hasSpeed) {
                this.setSpeed(speed);
            }
        }
        if (version >= 1 && dr.readBoolean()) {
            ExtraSensor extraSensor;
            ExtraSensor extraSensor2;
            ExtraSensor $this$apply;
            boolean bl;
            ExtraSensor accuracy;
            if (version == 1) {
                accuracy = new ExtraSensor();
                n = 0;
                bl = false;
                $this$apply = accuracy;
                boolean bl2 = false;
                $this$apply.setHasHr(dr.readBoolean());
                $this$apply.setHr(dr.readInt());
                $this$apply.setHasCadence(dr.readBoolean());
                $this$apply.setCadence(dr.readInt());
                $this$apply.setHasSpeed(dr.readBoolean());
                $this$apply.setSpeed(dr.readFloat());
                $this$apply.setHasPower(dr.readBoolean());
                $this$apply.setPower(dr.readFloat());
                extraSensor2 = accuracy;
            } else {
                accuracy = new ExtraSensor();
                n = 0;
                bl = false;
                $this$apply = accuracy;
                boolean bl3 = false;
                $this$apply.read(dr);
                extraSensor2 = extraSensor = accuracy;
            }
            if (extraSensor.getHasCadence()) {
                this.setSensorCadence((short)extraSensor.getCadence());
            }
            if (extraSensor.getHasHr()) {
                this.setSensorHeartRate((short)extraSensor.getHr());
            }
            if (extraSensor.getHasPower()) {
                this.setSensorPower(extraSensor.getPower());
            }
            if (extraSensor.getHasSpeed()) {
                this.setSensorSpeed(extraSensor.getSpeed());
            }
            if (extraSensor.getHasStrides()) {
                this.setSensorStrides(extraSensor.getStrides());
            }
            if (extraSensor.getHasTemperature()) {
                this.setSensorTemperature(extraSensor.getTemperature());
            }
        }
        if (version >= 3) {
            int i;
            this.extraDataShort.clear();
            int size = dr.readByte();
            int accuracy = 0;
            n = size;
            while (accuracy < n) {
                this.extraDataShort.put(dr.readByte(), dr.readShort());
                ++i;
            }
            this.extraDataInt.clear();
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.extraDataInt.put(dr.readByte(), dr.readInt());
            }
            this.extraDataFloat.clear();
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.extraDataFloat.put(dr.readByte(), Float.valueOf(dr.readFloat()));
            }
            this.extraDataDouble.clear();
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.extraDataDouble.put(dr.readByte(), dr.readDouble());
            }
        }
    }

    @Override
    protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        int i;
        ExtraSensor extraSensor;
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeLong(this.id);
        dw.writeString(this.provider);
        dw.writeLong(this.time);
        dw.writeDouble(this.latitude);
        dw.writeDouble(this.longitude);
        dw.writeBoolean(this.getHasAltitude());
        dw.writeDouble(this.getAltitude());
        if (this.getHasAccuracyHor() || this.getHasBearing() || this.getHasSpeed()) {
            dw.writeBoolean(true);
            dw.writeBoolean(this.getHasAccuracyHor());
            dw.writeFloat(this.getAccuracyHor());
            dw.writeBoolean(this.getHasBearing());
            dw.writeFloat(this.getBearing());
            dw.writeBoolean(this.getHasSpeed());
            dw.writeFloat(this.getSpeed());
        } else {
            dw.writeBoolean(false);
        }
        ExtraSensor extraSensor2 = new ExtraSensor();
        int n = 0;
        boolean bl = false;
        ExtraSensor $this$apply = extraSensor2;
        boolean bl2 = false;
        if (this.getHasSensorCadence()) {
            $this$apply.setHasCadence(true);
            $this$apply.setCadence(this.getSensorCadence());
        }
        if (this.getHasSensorHeartRate()) {
            $this$apply.setHasHr(true);
            $this$apply.setHr(this.getSensorHeartRate());
        }
        if (this.getHasSensorPower()) {
            $this$apply.setHasPower(true);
            $this$apply.setPower(this.getSensorPower());
        }
        if (this.getHasSensorSpeed()) {
            $this$apply.setHasSpeed(true);
            $this$apply.setSpeed(this.getSensorSpeed());
        }
        if (this.getHasSensorStrides()) {
            $this$apply.setHasStrides(true);
            $this$apply.setStrides(this.getSensorStrides());
        }
        if (this.getHasSensorTemperature()) {
            $this$apply.setHasTemperature(true);
            $this$apply.setTemperature(this.getSensorTemperature());
        }
        extraSensor2 = extraSensor = extraSensor2;
        n = 0;
        bl = false;
        ExtraSensor it = extraSensor2;
        boolean bl3 = false;
        ExtraSensor extraSensor3 = it.hasData() ? extraSensor2 : null;
        if (extraSensor3 != null) {
            extraSensor2 = extraSensor3;
            n = 0;
            bl = false;
            it = extraSensor2;
            boolean bl4 = false;
            dw.writeBoolean(true);
            it.write(dw);
        } else {
            Unit cfr_ignored_0 = (Unit)((Function0)new Function0<Unit>(dw){
                final /* synthetic */ DataWriterBigEndian $dw;

                public final void invoke() {
                    this.$dw.writeBoolean(false);
                }
                {
                    this.$dw = dataWriterBigEndian;
                    super(0);
                }
            }).invoke();
        }
        dw.writeByte((byte)this.extraDataShort.size());
        int n2 = 0;
        n = this.extraDataShort.size();
        while (n2 < n) {
            dw.writeByte((byte)this.extraDataShort.keyAt(i));
            dw.writeShort(((Number)this.extraDataShort.valueAt(i)).shortValue());
            ++i;
        }
        dw.writeByte((byte)this.extraDataInt.size());
        n = this.extraDataInt.size();
        for (i = 0; i < n; ++i) {
            dw.writeByte((byte)this.extraDataInt.keyAt(i));
            Integer n3 = this.extraDataInt.valueAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"extraDataInt.valueAt(i)");
            dw.writeInt(((Number)n3).intValue());
        }
        dw.writeByte((byte)this.extraDataFloat.size());
        n = this.extraDataFloat.size();
        for (i = 0; i < n; ++i) {
            dw.writeByte((byte)this.extraDataFloat.keyAt(i));
            Float f = this.extraDataFloat.valueAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"extraDataFloat.valueAt(i)");
            dw.writeFloat(((Number)f).floatValue());
        }
        dw.writeByte((byte)this.extraDataDouble.size());
        n = this.extraDataDouble.size();
        for (i = 0; i < n; ++i) {
            dw.writeByte((byte)this.extraDataDouble.keyAt(i));
            Double d = this.extraDataDouble.valueAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"extraDataDouble.valueAt(i)");
            dw.writeDouble(((Number)d).doubleValue());
        }
    }

    public Location() {
        this.extraDataShort = new SparseArrayCompat(0);
        this.extraDataInt = new SparseArrayCompat(0);
        this.extraDataFloat = new SparseArrayCompat(0);
        this.extraDataDouble = new SparseArrayCompat(0);
        this.id = -1L;
        this.provider = "";
    }

    public Location(double lat, double lon) {
        this();
        this.setLatitude(lat);
        this.setLongitude(lon);
    }

    public Location(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this();
        this.set(loc);
    }

    public static final /* synthetic */ void access$setExtraDataShort$p(Location $this, SparseArrayCompat sparseArrayCompat) {
        $this.extraDataShort = sparseArrayCompat;
    }

    public static final /* synthetic */ void access$setExtraDataInt$p(Location $this, SparseArrayCompat sparseArrayCompat) {
        $this.extraDataInt = sparseArrayCompat;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0014J\u000f\u0010\u0015\u001a\u00028\u0000H \u00a2\u0006\u0004\b\u0016\u0010\u000eJ\u0006\u0010\u0017\u001a\u00020\u0012J\u0017\u0010\u0018\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0000H\u0010\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Llocus/api/objects/extra/Location$ValueContainer;", "T", "", "dataContainer", "Llocus/api/utils/SparseArrayCompat;", "id", "", "(Llocus/api/utils/SparseArrayCompat;B)V", "hasData", "", "getHasData", "()Z", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "doIfValid", "", "action", "Lkotlin/Function1;", "getDefaultEmpty", "getDefaultEmpty$locus_api_core", "remove", "validateNewValue", "validateNewValue$locus_api_core", "(Ljava/lang/Object;)Ljava/lang/Object;", "locus-api-core"})
    public static abstract class ValueContainer<T> {
        private final SparseArrayCompat<T> dataContainer;
        private final byte id;

        public final boolean getHasData() {
            return this.dataContainer.containsKey(this.id);
        }

        public final T getValue() {
            return this.dataContainer.get(this.id, this.getDefaultEmpty$locus_api_core());
        }

        public final void setValue(T value) {
            T validatedValue = this.validateNewValue$locus_api_core(value);
            this.dataContainer.put(this.id, validatedValue);
        }

        public abstract T getDefaultEmpty$locus_api_core();

        public T validateNewValue$locus_api_core(T value) {
            return value;
        }

        public final void doIfValid(@NotNull Function1<? super T, Unit> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            if (this.getHasData()) {
                action.invoke(this.getValue());
            }
        }

        public final void remove() {
            this.dataContainer.remove(this.id);
        }

        public ValueContainer(@NotNull SparseArrayCompat<T> dataContainer, byte id) {
            Intrinsics.checkNotNullParameter(dataContainer, (String)"dataContainer");
            this.dataContainer = dataContainer;
            this.id = id;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Llocus/api/objects/extra/Location$ValueContainerShort;", "Llocus/api/objects/extra/Location$ValueContainer;", "", "id", "", "(Llocus/api/objects/extra/Location;B)V", "getDefaultEmpty", "getDefaultEmpty$locus_api_core", "()Ljava/lang/Short;", "locus-api-core"})
    public final class ValueContainerShort
    extends ValueContainer<Short> {
        @Override
        @NotNull
        public Short getDefaultEmpty$locus_api_core() {
            return (short)0;
        }

        public ValueContainerShort(byte id) {
            super(Location.this.extraDataShort, id);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Llocus/api/objects/extra/Location$ValueContainerInt;", "Llocus/api/objects/extra/Location$ValueContainer;", "", "id", "", "(Llocus/api/objects/extra/Location;B)V", "getDefaultEmpty", "getDefaultEmpty$locus_api_core", "()Ljava/lang/Integer;", "locus-api-core"})
    public final class ValueContainerInt
    extends ValueContainer<Integer> {
        @Override
        @NotNull
        public Integer getDefaultEmpty$locus_api_core() {
            return 0;
        }

        public ValueContainerInt(byte id) {
            super(Location.this.extraDataInt, id);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00100\u001a\u00020\u0004H\u0014J\u0006\u00101\u001a\u00020\nJ\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u000206H\u0014J\u0010\u00107\u001a\u0002032\u0006\u00108\u001a\u000209H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u001a\u0010\u001e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\u001a\u0010*\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0006\"\u0004\b,\u0010\bR\u001a\u0010-\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010$\"\u0004\b/\u0010&\u00a8\u0006:"}, d2={"Llocus/api/objects/extra/Location$ExtraSensor;", "Llocus/api/objects/Storable;", "()V", "cadence", "", "getCadence", "()I", "setCadence", "(I)V", "hasCadence", "", "getHasCadence", "()Z", "setHasCadence", "(Z)V", "hasHr", "getHasHr", "setHasHr", "hasPower", "getHasPower", "setHasPower", "hasSpeed", "getHasSpeed", "setHasSpeed", "hasStrides", "getHasStrides", "setHasStrides", "hasTemperature", "getHasTemperature", "setHasTemperature", "hr", "getHr", "setHr", "power", "", "getPower", "()F", "setPower", "(F)V", "speed", "getSpeed", "setSpeed", "strides", "getStrides", "setStrides", "temperature", "getTemperature", "setTemperature", "getVersion", "hasData", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "locus-api-core"})
    private static final class ExtraSensor
    extends Storable {
        private boolean hasHr;
        private int hr;
        private boolean hasCadence;
        private int cadence;
        private boolean hasSpeed;
        private float speed;
        private boolean hasPower;
        private float power;
        private boolean hasStrides;
        private int strides;
        private boolean hasTemperature;
        private float temperature;

        public final boolean getHasHr() {
            return this.hasHr;
        }

        public final void setHasHr(boolean bl) {
            this.hasHr = bl;
        }

        public final int getHr() {
            return this.hr;
        }

        public final void setHr(int n) {
            this.hr = n;
        }

        public final boolean getHasCadence() {
            return this.hasCadence;
        }

        public final void setHasCadence(boolean bl) {
            this.hasCadence = bl;
        }

        public final int getCadence() {
            return this.cadence;
        }

        public final void setCadence(int n) {
            this.cadence = n;
        }

        public final boolean getHasSpeed() {
            return this.hasSpeed;
        }

        public final void setHasSpeed(boolean bl) {
            this.hasSpeed = bl;
        }

        public final float getSpeed() {
            return this.speed;
        }

        public final void setSpeed(float f) {
            this.speed = f;
        }

        public final boolean getHasPower() {
            return this.hasPower;
        }

        public final void setHasPower(boolean bl) {
            this.hasPower = bl;
        }

        public final float getPower() {
            return this.power;
        }

        public final void setPower(float f) {
            this.power = f;
        }

        public final boolean getHasStrides() {
            return this.hasStrides;
        }

        public final void setHasStrides(boolean bl) {
            this.hasStrides = bl;
        }

        public final int getStrides() {
            return this.strides;
        }

        public final void setStrides(int n) {
            this.strides = n;
        }

        public final boolean getHasTemperature() {
            return this.hasTemperature;
        }

        public final void setHasTemperature(boolean bl) {
            this.hasTemperature = bl;
        }

        public final float getTemperature() {
            return this.temperature;
        }

        public final void setTemperature(float f) {
            this.temperature = f;
        }

        public final boolean hasData() {
            return this.hasHr || this.hasCadence || this.hasSpeed || this.hasPower || this.hasStrides || this.hasTemperature;
        }

        @Override
        protected int getVersion() {
            return 1;
        }

        @Override
        protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
            this.hasHr = dr.readBoolean();
            this.hr = dr.readInt();
            this.hasCadence = dr.readBoolean();
            this.cadence = dr.readInt();
            this.hasSpeed = dr.readBoolean();
            this.speed = dr.readFloat();
            this.hasPower = dr.readBoolean();
            this.power = dr.readFloat();
            this.hasStrides = dr.readBoolean();
            this.strides = dr.readInt();
            dr.readBoolean();
            dr.readInt();
            if (version >= 1) {
                this.hasTemperature = dr.readBoolean();
                this.temperature = dr.readFloat();
            }
        }

        @Override
        protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
            dw.writeBoolean(this.hasHr);
            dw.writeInt(this.hr);
            dw.writeBoolean(this.hasCadence);
            dw.writeInt(this.cadence);
            dw.writeBoolean(this.hasSpeed);
            dw.writeFloat(this.speed);
            dw.writeBoolean(this.hasPower);
            dw.writeFloat(this.power);
            dw.writeBoolean(this.hasStrides);
            dw.writeInt(this.strides);
            dw.writeBoolean(false);
            dw.writeInt(0);
            dw.writeBoolean(this.hasTemperature);
            dw.writeFloat(this.temperature);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Llocus/api/objects/extra/Location$Companion;", "", "()V", "EXTRA_KEY_ACCURACY_HOR", "", "EXTRA_KEY_ACCURACY_VER", "EXTRA_KEY_ALTITUDE", "EXTRA_KEY_BEARING", "EXTRA_KEY_GNSS_HDOP", "EXTRA_KEY_GNSS_PDOP", "EXTRA_KEY_GNSS_QUALITY", "EXTRA_KEY_GNSS_SATS_USED", "EXTRA_KEY_GNSS_SATS_VISIBLE", "EXTRA_KEY_GNSS_VDOP", "EXTRA_KEY_SENSOR_CADENCE", "EXTRA_KEY_SENSOR_HEART_RATE", "EXTRA_KEY_SENSOR_POWER", "EXTRA_KEY_SENSOR_SPEED", "EXTRA_KEY_SENSOR_STRIDES", "EXTRA_KEY_SENSOR_TEMPERATURE", "EXTRA_KEY_SPEED", "TAG", "", "locus-api-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

