/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.styles;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import locus.api.objects.Storable;
import locus.api.objects.extra.KmlVec2;
import locus.api.objects.styles.BalloonStyle;
import locus.api.objects.styles.IconStyle;
import locus.api.objects.styles.LabelStyle;
import locus.api.objects.styles.LineStyle;
import locus.api.objects.styles.ListStyle;
import locus.api.objects.styles.deprecated.LineStyleOld;
import locus.api.objects.styles.deprecated.OldStyleHelper;
import locus.api.objects.styles.deprecated.PolyStyleOld;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 A2\u00020\u0001:\u0001AB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010,\u001a\u00020-H\u0014J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0014J\u0016\u0010\u0010\u001a\u00020/2\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u000205J&\u0010\u0010\u001a\u00020/2\u0006\u00103\u001a\u00020\u00032\u0006\u00106\u001a\u00020-2\u0006\u00107\u001a\u0002052\u0006\u00104\u001a\u000205J\u000e\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020-J\u000e\u00108\u001a\u00020/2\u0006\u0010:\u001a\u00020;J\u0016\u0010\"\u001a\u00020/2\u0006\u00106\u001a\u00020-2\u0006\u0010<\u001a\u000205J\u000e\u0010=\u001a\u00020/2\u0006\u00106\u001a\u00020-J\u0010\u0010>\u001a\u00020/2\u0006\u0010?\u001a\u00020@H\u0014R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0014\"\u0004\b\u0017\u0010\u0004R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0014\"\u0004\b+\u0010\u0004\u00a8\u0006B"}, d2={"Llocus/api/objects/styles/GeoDataStyle;", "Llocus/api/objects/Storable;", "name", "", "(Ljava/lang/String;)V", "()V", "balloonStyle", "Llocus/api/objects/styles/BalloonStyle;", "getBalloonStyle", "()Llocus/api/objects/styles/BalloonStyle;", "setBalloonStyle", "(Llocus/api/objects/styles/BalloonStyle;)V", "iconStyle", "Llocus/api/objects/styles/IconStyle;", "getIconStyle", "()Llocus/api/objects/styles/IconStyle;", "setIconStyle", "(Llocus/api/objects/styles/IconStyle;)V", "iconStyleIconUrl", "getIconStyleIconUrl", "()Ljava/lang/String;", "id", "getId", "setId", "labelStyle", "Llocus/api/objects/styles/LabelStyle;", "getLabelStyle", "()Llocus/api/objects/styles/LabelStyle;", "setLabelStyle", "(Llocus/api/objects/styles/LabelStyle;)V", "lineStyle", "Llocus/api/objects/styles/LineStyle;", "getLineStyle", "()Llocus/api/objects/styles/LineStyle;", "setLineStyle", "(Llocus/api/objects/styles/LineStyle;)V", "listStyle", "Llocus/api/objects/styles/ListStyle;", "getListStyle", "()Llocus/api/objects/styles/ListStyle;", "setListStyle", "(Llocus/api/objects/styles/ListStyle;)V", "getName", "setName", "getVersion", "", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "iconUrl", "scale", "", "color", "heading", "setIconStyleHotSpot", "hotspot", "vec2", "Llocus/api/objects/extra/KmlVec2;", "width", "setPolyStyle", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "Companion", "locus-api-core"})
public final class GeoDataStyle
extends Storable {
    @NotNull
    private String id = "";
    @NotNull
    private String name = "";
    @Nullable
    private BalloonStyle balloonStyle;
    @Nullable
    private IconStyle iconStyle;
    @Nullable
    private LabelStyle labelStyle;
    @Nullable
    private ListStyle listStyle;
    @Nullable
    private LineStyle lineStyle;
    private static final String TAG = "GeoDataStyle";
    public static final int HOTSPOT_BOTTOM_CENTER = 0;
    public static final int HOTSPOT_TOP_LEFT = 1;
    public static final int HOTSPOT_CENTER_CENTER = 2;
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final int COLOR_DEFAULT = -1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void setId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.id = string;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Nullable
    public final BalloonStyle getBalloonStyle() {
        return this.balloonStyle;
    }

    public final void setBalloonStyle(@Nullable BalloonStyle balloonStyle) {
        this.balloonStyle = balloonStyle;
    }

    @Nullable
    public final IconStyle getIconStyle() {
        return this.iconStyle;
    }

    public final void setIconStyle(@Nullable IconStyle iconStyle) {
        this.iconStyle = iconStyle;
    }

    @Nullable
    public final LabelStyle getLabelStyle() {
        return this.labelStyle;
    }

    public final void setLabelStyle(@Nullable LabelStyle labelStyle) {
        this.labelStyle = labelStyle;
    }

    @Nullable
    public final ListStyle getListStyle() {
        return this.listStyle;
    }

    public final void setListStyle(@Nullable ListStyle listStyle) {
        this.listStyle = listStyle;
    }

    @Nullable
    public final LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public final void setLineStyle(@Nullable LineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    @Nullable
    public final String getIconStyleIconUrl() {
        String string;
        if (this.iconStyle == null) {
            string = null;
        } else {
            IconStyle iconStyle = this.iconStyle;
            Intrinsics.checkNotNull((Object)iconStyle);
            string = iconStyle.getIconHref();
        }
        return string;
    }

    public final void setIconStyle(@NotNull String iconUrl, float scale) {
        Intrinsics.checkNotNullParameter((Object)iconUrl, (String)"iconUrl");
        this.setIconStyle(iconUrl, -1, 0.0f, scale);
    }

    /*
     * WARNING - void declaration
     */
    public final void setIconStyle(@NotNull String iconUrl, int color, float heading, float scale) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)iconUrl, (String)"iconUrl");
        IconStyle iconStyle = new IconStyle();
        boolean bl = false;
        boolean bl2 = false;
        IconStyle iconStyle2 = iconStyle;
        GeoDataStyle geoDataStyle = this;
        boolean bl3 = false;
        $this$apply.setIconHref(iconUrl);
        $this$apply.setColor(color);
        $this$apply.setHeading(heading);
        $this$apply.setScale(scale);
        Unit unit = Unit.INSTANCE;
        geoDataStyle.iconStyle = iconStyle;
        this.setIconStyleHotSpot(0);
    }

    public final void setIconStyleHotSpot(int hotspot) {
        KmlVec2 kmlVec2;
        switch (hotspot) {
            case 1: {
                kmlVec2 = new KmlVec2(0.0, KmlVec2.Units.FRACTION, 1.0, KmlVec2.Units.FRACTION);
                break;
            }
            case 2: {
                kmlVec2 = new KmlVec2(0.5, KmlVec2.Units.FRACTION, 0.5, KmlVec2.Units.FRACTION);
                break;
            }
            default: {
                kmlVec2 = Companion.generateDefaultHotSpot();
            }
        }
        this.setIconStyleHotSpot(kmlVec2);
    }

    public final void setIconStyleHotSpot(@NotNull KmlVec2 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"vec2");
        if (this.iconStyle == null) {
            Logger.INSTANCE.logW(TAG, "setIconStyleHotSpot(" + vec2 + "), " + "initialize IconStyle before settings hotSpot or hotSpot is null!");
            return;
        }
        IconStyle iconStyle = this.iconStyle;
        Intrinsics.checkNotNull((Object)iconStyle);
        iconStyle.setHotSpot(vec2);
    }

    public final void setLineStyle(int color, float width) {
        if (this.lineStyle == null) {
            this.lineStyle = new LineStyle();
        }
        LineStyle lineStyle = this.lineStyle;
        Intrinsics.checkNotNull((Object)lineStyle);
        lineStyle.setColorBase(color);
        LineStyle lineStyle2 = this.lineStyle;
        Intrinsics.checkNotNull((Object)lineStyle2);
        lineStyle2.setWidth(width);
    }

    /*
     * WARNING - void declaration
     */
    public final void setPolyStyle(int color) {
        block2: {
            if (this.lineStyle == null) {
                void $this$apply;
                LineStyle lineStyle = new LineStyle();
                boolean bl = false;
                boolean bl2 = false;
                LineStyle lineStyle2 = lineStyle;
                GeoDataStyle geoDataStyle = this;
                boolean bl3 = false;
                $this$apply.setDrawBase(false);
                Unit unit = Unit.INSTANCE;
                geoDataStyle.lineStyle = lineStyle;
            }
            LineStyle lineStyle = this.lineStyle;
            if (lineStyle != null) {
                lineStyle.setDrawFill(true);
            }
            LineStyle lineStyle3 = this.lineStyle;
            if (lineStyle3 == null) break block2;
            lineStyle3.setColorFill(color);
        }
    }

    @Override
    protected int getVersion() {
        return 2;
    }

    @Override
    protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        String string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.id = string;
        String string2 = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dr.readString()");
        this.name = string2;
        if (version == 0) {
            return;
        }
        LineStyleOld lineStyleOld = null;
        PolyStyleOld polyStyleOld = null;
        try {
            if (dr.readBoolean()) {
                this.balloonStyle = Storable.Companion.read(BalloonStyle.class, dr);
            }
            if (dr.readBoolean()) {
                this.iconStyle = Storable.Companion.read(IconStyle.class, dr);
            }
            if (dr.readBoolean()) {
                this.labelStyle = Storable.Companion.read(LabelStyle.class, dr);
            }
            if (dr.readBoolean()) {
                lineStyleOld = Storable.Companion.read(LineStyleOld.class, dr);
            }
            if (dr.readBoolean()) {
                this.listStyle = Storable.Companion.read(ListStyle.class, dr);
            }
            if (dr.readBoolean()) {
                polyStyleOld = Storable.Companion.read(PolyStyleOld.class, dr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lineStyle = OldStyleHelper.INSTANCE.convertToNewLineStyle(lineStyleOld, polyStyleOld);
        if (version >= 2 && dr.readBoolean()) {
            LineStyle lineStyle = this.lineStyle = new LineStyle();
            Intrinsics.checkNotNull((Object)lineStyle);
            lineStyle.read(dr);
        }
    }

    @Override
    protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeString(this.id);
        dw.writeString(this.name);
        if (this.balloonStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            BalloonStyle balloonStyle = this.balloonStyle;
            Intrinsics.checkNotNull((Object)balloonStyle);
            balloonStyle.write(dw);
        }
        if (this.iconStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            IconStyle iconStyle = this.iconStyle;
            Intrinsics.checkNotNull((Object)iconStyle);
            iconStyle.write(dw);
        }
        if (this.labelStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            LabelStyle labelStyle = this.labelStyle;
            Intrinsics.checkNotNull((Object)labelStyle);
            labelStyle.write(dw);
        }
        dw.writeBoolean(false);
        if (this.listStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            ListStyle listStyle = this.listStyle;
            Intrinsics.checkNotNull((Object)listStyle);
            listStyle.write(dw);
        }
        dw.writeBoolean(false);
        if (this.lineStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            LineStyle lineStyle = this.lineStyle;
            Intrinsics.checkNotNull((Object)lineStyle);
            lineStyle.write(dw);
        }
    }

    public GeoDataStyle() {
    }

    public GeoDataStyle(@Nullable String name) {
        this();
        if (name != null) {
            this.name = name;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Llocus/api/objects/styles/GeoDataStyle$Companion;", "", "()V", "BLACK", "", "COLOR_DEFAULT", "HOTSPOT_BOTTOM_CENTER", "HOTSPOT_CENTER_CENTER", "HOTSPOT_TOP_LEFT", "TAG", "", "WHITE", "generateDefaultHotSpot", "Llocus/api/objects/extra/KmlVec2;", "locus-api-core"})
    public static final class Companion {
        @NotNull
        public final KmlVec2 generateDefaultHotSpot() {
            return new KmlVec2(0.5, KmlVec2.Units.FRACTION, 0.0, KmlVec2.Units.FRACTION);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

