/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import locus.api.objects.Storable;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b:\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\r2\u0006\u0010S\u001a\u00020\r2\u0006\u0010T\u001a\u00020\u0016J\u000e\u0010U\u001a\u00020Q2\u0006\u0010V\u001a\u00020\u0004J\u000e\u0010W\u001a\u00020Q2\u0006\u0010V\u001a\u00020\u0004J\u000e\u0010X\u001a\u00020Q2\u0006\u0010V\u001a\u00020\u0004J\u000e\u0010Y\u001a\u00020Q2\u0006\u0010V\u001a\u00020\u0004J\u000e\u0010Z\u001a\u00020Q2\u0006\u0010V\u001a\u00020\u0004J\u000e\u0010[\u001a\u00020Q2\u0006\u0010V\u001a\u00020\u0004J\u000e\u0010\\\u001a\u00020Q2\u0006\u0010)\u001a\u00020\rJ\u001e\u0010]\u001a\u00020Q2\u0006\u0010^\u001a\u00020\r2\u0006\u0010_\u001a\u00020\r2\u0006\u0010T\u001a\u00020\u0016J\u000e\u0010`\u001a\u00020Q2\u0006\u0010V\u001a\u00020\u0004J\u000e\u0010a\u001a\u00020Q2\u0006\u0010V\u001a\u00020\u0004J\u000e\u0010b\u001a\u00020Q2\u0006\u0010V\u001a\u00020\u0016J\u000e\u0010c\u001a\u00020Q2\u0006\u0010V\u001a\u00020\u0016J\u000e\u0010d\u001a\u00020Q2\u0006\u0010e\u001a\u00020\u0000J\u000e\u0010f\u001a\u00020\u00042\u0006\u0010g\u001a\u00020hJ\u000e\u0010i\u001a\u00020\u00042\u0006\u0010g\u001a\u00020hJ\u000e\u0010j\u001a\u00020\u00162\u0006\u0010g\u001a\u00020hJ\b\u0010k\u001a\u00020\rH\u0014J\u0006\u0010l\u001a\u00020hJ\u0018\u0010m\u001a\u00020Q2\u0006\u0010n\u001a\u00020\r2\u0006\u0010o\u001a\u00020pH\u0014J\u0006\u0010q\u001a\u00020QJ\u0006\u0010r\u001a\u00020QJ\u0010\u0010s\u001a\u00020Q2\u0006\u0010t\u001a\u00020uH\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\bR\u001a\u0010\u001a\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0006\"\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0006\"\u0004\b\u001f\u0010\bR\u001a\u0010 \u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0006\"\u0004\b\"\u0010\bR\u001a\u0010#\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0006\"\u0004\b%\u0010\bR\u001a\u0010&\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0006\"\u0004\b(\u0010\bR\u001e\u0010)\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u000fR\u0011\u0010+\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000fR\u000e\u0010-\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010.\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u000fR\u000e\u00100\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u000f\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u000f\"\u0004\b7\u00104R\u001a\u00108\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0006\"\u0004\b:\u0010\bR\u001a\u0010;\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010=\"\u0004\bB\u0010?R\u001a\u0010C\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u0006\"\u0004\bE\u0010\bR\u001a\u0010F\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u0006\"\u0004\bH\u0010\bR$\u0010J\u001a\u00020\u00162\u0006\u0010I\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010=\"\u0004\bL\u0010?R$\u0010M\u001a\u00020\u00162\u0006\u0010I\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010=\"\u0004\bO\u0010?\u00a8\u0006v"}, d2={"Llocus/api/objects/extra/TrackStats;", "Llocus/api/objects/Storable;", "()V", "altitudeMax", "", "getAltitudeMax", "()F", "setAltitudeMax", "(F)V", "altitudeMin", "getAltitudeMin", "setAltitudeMin", "cadenceAverage", "", "getCadenceAverage", "()I", "<set-?>", "cadenceMax", "getCadenceMax", "cadenceNumber", "", "cadenceTime", "", "eleNegativeDistance", "getEleNegativeDistance", "setEleNegativeDistance", "eleNegativeHeight", "getEleNegativeHeight", "setEleNegativeHeight", "eleNeutralDistance", "getEleNeutralDistance", "setEleNeutralDistance", "eleNeutralHeight", "getEleNeutralHeight", "setEleNeutralHeight", "elePositiveDistance", "getElePositiveDistance", "setElePositiveDistance", "elePositiveHeight", "getElePositiveHeight", "setElePositiveHeight", "energy", "getEnergy", "heartRateAverage", "getHeartRateAverage", "heartRateBeats", "heartRateMax", "getHeartRateMax", "heartRateTime", "numOfPoints", "getNumOfPoints", "setNumOfPoints", "(I)V", "numOfStrides", "getNumOfStrides", "setNumOfStrides", "speedMax", "getSpeedMax", "setSpeedMax", "startTime", "getStartTime", "()J", "setStartTime", "(J)V", "stopTime", "getStopTime", "setStopTime", "totalLength", "getTotalLength", "setTotalLength", "totalLengthMove", "getTotalLengthMove", "setTotalLengthMove", "value", "totalTime", "getTotalTime", "setTotalTime", "totalTimeMove", "getTotalTimeMove", "setTotalTimeMove", "addCadenceMeasure", "", "revMeasured", "revAvgSegment", "measureTime", "addEleNegativeDistance", "add", "addEleNegativeHeight", "addEleNeutralDistance", "addEleNeutralHeight", "addElePositiveDistance", "addElePositiveHeight", "addEnergy", "addHeartRateMeasure", "hrmMeasured", "hrmAvgSegment", "addTotalLength", "addTotalLengthMove", "addTotalTime", "addTotalTimeMove", "appendStatistics", "stats", "getLength", "onlyWithMove", "", "getSpeedAverage", "getTime", "getVersion", "hasElevationValues", "readObject", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "resetStatistics", "resetStatisticsAltitude", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "locus-api-core"})
public final class TrackStats
extends Storable {
    private int numOfPoints;
    private long startTime = -1L;
    private long stopTime = -1L;
    private float totalLength;
    private float totalLengthMove;
    private long totalTime;
    private long totalTimeMove;
    private float speedMax;
    private float altitudeMax;
    private float altitudeMin;
    private float eleNeutralDistance;
    private float eleNeutralHeight;
    private float elePositiveDistance;
    private float elePositiveHeight;
    private float eleNegativeDistance;
    private float eleNegativeHeight;
    private double heartRateBeats;
    private long heartRateTime;
    private int heartRateMax;
    private double cadenceNumber;
    private long cadenceTime;
    private int cadenceMax;
    private int energy;
    private int numOfStrides;

    public TrackStats() {
        this.resetStatistics();
    }

    public final int getNumOfPoints() {
        return this.numOfPoints;
    }

    public final void setNumOfPoints(int n) {
        this.numOfPoints = n;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long l) {
        this.startTime = l;
    }

    public final long getStopTime() {
        return this.stopTime;
    }

    public final void setStopTime(long l) {
        this.stopTime = l;
    }

    public final float getTotalLength() {
        return this.totalLength;
    }

    public final void setTotalLength(float f) {
        this.totalLength = f;
    }

    public final void addTotalLength(float add) {
        this.totalLength += add;
    }

    public final float getTotalLengthMove() {
        return this.totalLengthMove;
    }

    public final void setTotalLengthMove(float f) {
        this.totalLengthMove = f;
    }

    public final void addTotalLengthMove(float add) {
        this.totalLengthMove += add;
    }

    public final float getLength(boolean onlyWithMove) {
        return onlyWithMove ? this.totalLengthMove : this.totalLength;
    }

    public final long getTotalTime() {
        return this.totalTime;
    }

    public final void setTotalTime(long value) {
        this.totalTime = Math.abs(value);
    }

    public final void addTotalTime(long add) {
        this.setTotalTime(this.totalTime + Math.abs(add));
    }

    public final long getTotalTimeMove() {
        return this.totalTimeMove;
    }

    public final void setTotalTimeMove(long value) {
        this.totalTimeMove = Math.abs(value);
    }

    public final void addTotalTimeMove(long add) {
        this.setTotalTimeMove(this.totalTimeMove + Math.abs(add));
    }

    public final long getTime(boolean onlyWithMove) {
        return onlyWithMove ? this.totalTimeMove : this.totalTime;
    }

    public final float getSpeedMax() {
        return this.speedMax;
    }

    public final void setSpeedMax(float f) {
        this.speedMax = f;
    }

    public final float getSpeedAverage(boolean onlyWithMove) {
        float time = (float)this.getTime(onlyWithMove) / 1000.0f;
        return time > 0.0f ? this.getLength(onlyWithMove) / time : 0.0f;
    }

    public final float getAltitudeMax() {
        return this.altitudeMax;
    }

    public final void setAltitudeMax(float f) {
        this.altitudeMax = f;
    }

    public final float getAltitudeMin() {
        return this.altitudeMin;
    }

    public final void setAltitudeMin(float f) {
        this.altitudeMin = f;
    }

    public final float getEleNeutralDistance() {
        return this.eleNeutralDistance;
    }

    public final void setEleNeutralDistance(float f) {
        this.eleNeutralDistance = f;
    }

    public final void addEleNeutralDistance(float add) {
        this.eleNeutralDistance += add;
    }

    public final float getEleNeutralHeight() {
        return this.eleNeutralHeight;
    }

    public final void setEleNeutralHeight(float f) {
        this.eleNeutralHeight = f;
    }

    public final void addEleNeutralHeight(float add) {
        this.eleNeutralHeight += add;
    }

    public final float getElePositiveDistance() {
        return this.elePositiveDistance;
    }

    public final void setElePositiveDistance(float f) {
        this.elePositiveDistance = f;
    }

    public final void addElePositiveDistance(float add) {
        this.elePositiveDistance += add;
    }

    public final float getElePositiveHeight() {
        return this.elePositiveHeight;
    }

    public final void setElePositiveHeight(float f) {
        this.elePositiveHeight = f;
    }

    public final void addElePositiveHeight(float add) {
        this.elePositiveHeight += add;
    }

    public final float getEleNegativeDistance() {
        return this.eleNegativeDistance;
    }

    public final void setEleNegativeDistance(float f) {
        this.eleNegativeDistance = f;
    }

    public final void addEleNegativeDistance(float add) {
        this.eleNegativeDistance += add;
    }

    public final float getEleNegativeHeight() {
        return this.eleNegativeHeight;
    }

    public final void setEleNegativeHeight(float f) {
        this.eleNegativeHeight = f;
    }

    public final void addEleNegativeHeight(float add) {
        this.eleNegativeHeight += add;
    }

    public final boolean hasElevationValues() {
        return !(this.altitudeMin == Float.POSITIVE_INFINITY) && !(this.altitudeMin == 0.0f) || !(this.altitudeMax == Float.NEGATIVE_INFINITY) && !(this.altitudeMax == 0.0f);
    }

    public final int getHeartRateAverage() {
        int n;
        if (this.heartRateBeats > 0.0 && this.heartRateTime > 0L) {
            double minutes = (double)this.heartRateTime / 60000.0;
            n = (int)(this.heartRateBeats / minutes);
        } else {
            n = 0;
        }
        return n;
    }

    public final int getHeartRateMax() {
        return this.heartRateMax;
    }

    public final void addHeartRateMeasure(int hrmMeasured, int hrmAvgSegment, long measureTime) {
        double inMinutes = (double)measureTime * 1.0 / (double)60000;
        double numOfBeats = (double)hrmAvgSegment * inMinutes;
        this.heartRateBeats += numOfBeats;
        this.heartRateTime += measureTime;
        this.heartRateMax = Math.max(this.heartRateMax, hrmMeasured);
    }

    public final int getCadenceAverage() {
        int n;
        if (this.cadenceNumber > 0.0 && this.cadenceTime > 0L) {
            double minutes = (double)this.cadenceTime / 60000.0;
            n = (int)(this.cadenceNumber / minutes);
        } else {
            n = 0;
        }
        return n;
    }

    public final int getCadenceMax() {
        return this.cadenceMax;
    }

    public final void addCadenceMeasure(int revMeasured, int revAvgSegment, long measureTime) {
        double inMinutes = (double)measureTime * 1.0 / (double)60000;
        double numOfRevolutions = (double)revAvgSegment * inMinutes;
        this.cadenceNumber += numOfRevolutions;
        this.cadenceTime += measureTime;
        this.cadenceMax = Math.max(this.cadenceMax, revMeasured);
    }

    public final int getEnergy() {
        return this.energy;
    }

    public final void addEnergy(int energy) {
        this.energy += energy;
    }

    public final int getNumOfStrides() {
        return this.numOfStrides;
    }

    public final void setNumOfStrides(int n) {
        this.numOfStrides = n;
    }

    public final void resetStatistics() {
        this.totalLength = 0.0f;
        this.totalLengthMove = 0.0f;
        this.setTotalTime(0L);
        this.setTotalTimeMove(0L);
        this.speedMax = 0.0f;
        this.heartRateBeats = 0.0;
        this.heartRateTime = 0L;
        this.heartRateMax = 0;
        this.cadenceNumber = 0.0;
        this.cadenceTime = 0L;
        this.cadenceMax = 0;
        this.energy = 0;
        this.numOfStrides = 0;
        this.resetStatisticsAltitude();
    }

    public final void resetStatisticsAltitude() {
        this.altitudeMax = Float.NEGATIVE_INFINITY;
        this.altitudeMin = Float.POSITIVE_INFINITY;
        this.eleNeutralDistance = 0.0f;
        this.eleNeutralHeight = 0.0f;
        this.elePositiveDistance = 0.0f;
        this.elePositiveHeight = 0.0f;
        this.eleNegativeDistance = 0.0f;
        this.eleNegativeHeight = 0.0f;
    }

    public final void appendStatistics(@NotNull TrackStats stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        this.numOfPoints += stats.numOfPoints;
        this.startTime = Math.min(this.startTime, stats.startTime);
        this.stopTime = Math.max(this.stopTime, stats.stopTime);
        this.totalLength += stats.totalLength;
        this.totalLengthMove += stats.totalLengthMove;
        this.setTotalTime(this.totalTime + stats.totalTime);
        this.setTotalTimeMove(this.totalTimeMove + stats.totalTimeMove);
        this.speedMax = Math.max(this.speedMax, stats.speedMax);
        this.altitudeMax = Math.max(this.altitudeMax, stats.altitudeMax);
        this.altitudeMin = Math.min(this.altitudeMin, stats.altitudeMin);
        this.eleNeutralDistance += stats.eleNeutralDistance;
        this.eleNeutralHeight += stats.eleNeutralHeight;
        this.elePositiveDistance += stats.elePositiveDistance;
        this.elePositiveHeight += stats.elePositiveHeight;
        this.eleNegativeDistance += stats.eleNegativeDistance;
        this.eleNegativeHeight += stats.eleNegativeHeight;
        this.heartRateBeats += stats.heartRateBeats;
        this.heartRateTime += stats.heartRateTime;
        this.heartRateMax = Math.max(this.heartRateMax, stats.heartRateMax);
        this.cadenceNumber += stats.cadenceNumber;
        this.cadenceTime += stats.cadenceTime;
        this.cadenceMax = Math.max(this.cadenceMax, stats.cadenceMax);
        this.energy += stats.energy;
        this.numOfStrides += stats.numOfStrides;
    }

    @Override
    protected int getVersion() {
        return 3;
    }

    @Override
    protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        this.numOfPoints = dr.readInt();
        this.startTime = dr.readLong();
        this.stopTime = dr.readLong();
        this.totalLength = dr.readFloat();
        this.totalLengthMove = dr.readFloat();
        this.setTotalTime(dr.readLong());
        this.setTotalTimeMove(dr.readLong());
        this.speedMax = dr.readFloat();
        this.altitudeMax = dr.readFloat();
        this.altitudeMin = dr.readFloat();
        this.eleNeutralDistance = dr.readFloat();
        this.eleNeutralHeight = dr.readFloat();
        this.elePositiveDistance = dr.readFloat();
        this.elePositiveHeight = dr.readFloat();
        this.eleNegativeDistance = dr.readFloat();
        this.eleNegativeHeight = dr.readFloat();
        dr.readFloat();
        dr.readFloat();
        if (version >= 1) {
            this.heartRateBeats = dr.readInt();
            this.heartRateTime = dr.readLong();
            this.heartRateMax = dr.readInt();
            this.energy = dr.readInt();
        }
        if (version >= 2) {
            this.heartRateBeats = dr.readDouble();
            this.cadenceNumber = dr.readDouble();
            this.cadenceTime = dr.readLong();
            this.cadenceMax = dr.readInt();
        }
        if (version >= 3) {
            this.numOfStrides = dr.readInt();
        }
    }

    @Override
    protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeInt(this.numOfPoints);
        dw.writeLong(this.startTime);
        dw.writeLong(this.stopTime);
        dw.writeFloat(this.totalLength);
        dw.writeFloat(this.totalLengthMove);
        dw.writeLong(this.totalTime);
        dw.writeLong(this.totalTimeMove);
        dw.writeFloat(this.speedMax);
        dw.writeFloat(this.altitudeMax);
        dw.writeFloat(this.altitudeMin);
        dw.writeFloat(this.eleNeutralDistance);
        dw.writeFloat(this.eleNeutralHeight);
        dw.writeFloat(this.elePositiveDistance);
        dw.writeFloat(this.elePositiveHeight);
        dw.writeFloat(this.eleNegativeDistance);
        dw.writeFloat(this.eleNegativeHeight);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeInt((int)this.heartRateBeats);
        dw.writeLong(this.heartRateTime);
        dw.writeInt(this.heartRateMax);
        dw.writeInt(this.energy);
        dw.writeDouble(this.heartRateBeats);
        dw.writeDouble(this.cadenceNumber);
        dw.writeLong(this.cadenceTime);
        dw.writeInt(this.cadenceMax);
        dw.writeInt(this.numOfStrides);
    }
}

