/*
 * Decompiled with CFR 0.152.
 */
package locus.api.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import locus.api.objects.extra.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Llocus/api/utils/LocationCompute;", "", "loc", "Llocus/api/objects/extra/Location;", "(Llocus/api/objects/extra/Location;)V", "mLat1", "", "mLat2", "mLon1", "mLon2", "results", "", "bearingTo", "", "dest", "distanceTo", "Companion", "locus-api-core"})
public final class LocationCompute {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Location loc;
    private double mLat1;
    private double mLon1;
    private double mLat2;
    private double mLon2;
    @NotNull
    private final float[] results;
    private static final double parWgs84AxisA = 6378137.0;
    private static final double parWgs84AxisB = 6356752.3142;
    private static final double parWgs84Flat = 0.0033528106718309896;
    public static final double AVERAGE_RADIUS_OF_EARTH = 6371000.0;
    @NotNull
    private static final double[] mDistResult = new double[1];

    public LocationCompute(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this.loc = loc;
        this.results = new float[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float distanceTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        float[] fArray = this.results;
        synchronized (fArray) {
            boolean bl = false;
            if (!(this.loc.getLatitude() == this.mLat1 && this.loc.getLongitude() == this.mLon1 && dest.getLatitude() == this.mLat2 && dest.getLongitude() == this.mLon2)) {
                Companion.computeDistanceAndBearing(this.loc.getLatitude(), this.loc.getLongitude(), dest.getLatitude(), dest.getLongitude(), this.results);
                this.mLat1 = this.loc.getLatitude();
                this.mLon1 = this.loc.getLongitude();
                this.mLat2 = dest.getLatitude();
                this.mLon2 = dest.getLongitude();
            }
            float f = this.results[0];
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float bearingTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        float[] fArray = this.results;
        synchronized (fArray) {
            boolean bl = false;
            if (!(this.loc.getLatitude() == this.mLat1 && this.loc.getLongitude() == this.mLon1 && dest.getLatitude() == this.mLat2 && dest.getLongitude() == this.mLon2)) {
                Companion.computeDistanceAndBearing(this.loc.getLatitude(), this.loc.getLongitude(), dest.getLatitude(), dest.getLongitude(), this.results);
                this.mLat1 = this.loc.getLatitude();
                this.mLon1 = this.loc.getLongitude();
                this.mLat2 = dest.getLatitude();
                this.mLon2 = dest.getLongitude();
            }
            float f = this.results[1];
            return f;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J.\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006J&\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0016\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ0\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Llocus/api/utils/LocationCompute$Companion;", "", "()V", "AVERAGE_RADIUS_OF_EARTH", "", "mDistResult", "", "parWgs84AxisA", "parWgs84AxisB", "parWgs84Flat", "computeDistanceAndBearing", "", "latP1", "lonP1", "latP2", "lonP2", "a", "b", "f", "results", "", "lat1", "lon1", "lat2", "lon2", "computeDistanceAndBearingFast", "computeDistanceFast", "loc1", "Llocus/api/objects/extra/Location;", "loc2", "distanceBetween", "startLatitude", "startLongitude", "endLatitude", "endLongitude", "locus-api-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void computeDistanceAndBearing(double lat1, double lon1, double lat2, double lon2, @NotNull float[] results) {
            Intrinsics.checkNotNullParameter((Object)results, (String)"results");
            this.computeDistanceAndBearing(lat1, lon1, lat2, lon2, 6378137.0, 6356752.3142, 0.0033528106718309896, results);
        }

        public final void computeDistanceAndBearing(double latP1, double lonP1, double latP2, double lonP2, double a, double b, double f, @NotNull float[] results) {
            float distance;
            Intrinsics.checkNotNullParameter((Object)results, (String)"results");
            int MAXITERS = 20;
            double lat1 = latP1 * Math.PI / 180.0;
            double lat2 = latP2 * Math.PI / 180.0;
            double lon1 = lonP1 * Math.PI / 180.0;
            double lon2 = lonP2 * Math.PI / 180.0;
            double aSqMinusBSqOverBSq = (a * a - b * b) / (b * b);
            double L = lon2 - lon1;
            double A = 0.0;
            double U1 = Math.atan((1.0 - f) * Math.tan(lat1));
            double U2 = Math.atan((1.0 - f) * Math.tan(lat2));
            double cosU1 = Math.cos(U1);
            double cosU2 = Math.cos(U2);
            double sinU1 = Math.sin(U1);
            double sinU2 = Math.sin(U2);
            double cosU1cosU2 = cosU1 * cosU2;
            double sinU1sinU2 = sinU1 * sinU2;
            double sigma = 0.0;
            double deltaSigma = 0.0;
            double cosSqAlpha = 0.0;
            double cos2SM = 0.0;
            double cosSigma = 0.0;
            double sinSigma = 0.0;
            double cosLambda = 0.0;
            double sinLambda = 0.0;
            double lambda = L;
            int n = 0;
            while (n < MAXITERS) {
                int iter = n++;
                double lambdaOrig = lambda;
                cosLambda = Math.cos(lambda);
                sinLambda = Math.sin(lambda);
                double t1 = cosU2 * sinLambda;
                double t2 = cosU1 * sinU2 - sinU1 * cosU2 * cosLambda;
                double sinSqSigma = t1 * t1 + t2 * t2;
                sinSigma = Math.sqrt(sinSqSigma);
                cosSigma = sinU1sinU2 + cosU1cosU2 * cosLambda;
                sigma = Math.atan2(sinSigma, cosSigma);
                double sinAlpha = sinSigma == 0.0 ? 0.0 : cosU1cosU2 * sinLambda / sinSigma;
                cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
                cos2SM = cosSqAlpha == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1sinU2 / cosSqAlpha;
                double uSquared = cosSqAlpha * aSqMinusBSqOverBSq;
                double A1 = uSquared / 16384.0 * (4096.0 + uSquared * (-768.0 + uSquared * (320.0 - 175.0 * uSquared)));
                A = 1.0 + A1;
                double B = uSquared / 1024.0 * (256.0 + uSquared * (-128.0 + uSquared * (74.0 - 47.0 * uSquared)));
                double C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
                double cos2SMSq = cos2SM * cos2SM;
                deltaSigma = B * sinSigma * (cos2SM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SMSq) - B / 6.0 * cos2SM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SMSq)));
                lambda = L + (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SM + C * cosSigma * (-1.0 + 2.0 * cos2SM * cos2SM)));
                double delta = (lambda - lambdaOrig) / lambda;
                if (!(Math.abs(delta) < 1.0E-12)) continue;
            }
            results[0] = distance = (float)(b * A * (sigma - deltaSigma));
            if (results.length > 1) {
                float initialBearing = (float)Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda);
                results[1] = initialBearing *= 57.29578f;
                if (results.length > 2) {
                    float finalBearing = (float)Math.atan2(cosU1 * sinLambda, -sinU1 * cosU2 + cosU1 * sinU2 * cosLambda);
                    results[2] = finalBearing *= 57.29578f;
                }
            }
        }

        public final void distanceBetween(double startLatitude, double startLongitude, double endLatitude, double endLongitude, @Nullable float[] results) {
            if (results == null || results.length == 0) {
                throw new IllegalArgumentException("results is null or has length < 1");
            }
            this.computeDistanceAndBearing(startLatitude, startLongitude, endLatitude, endLongitude, results);
        }

        public final synchronized double computeDistanceFast(@NotNull Location loc1, @NotNull Location loc2) {
            Intrinsics.checkNotNullParameter((Object)loc1, (String)"loc1");
            Intrinsics.checkNotNullParameter((Object)loc2, (String)"loc2");
            this.computeDistanceAndBearingFast(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude(), mDistResult);
            return mDistResult[0];
        }

        public final synchronized double computeDistanceFast(double lat1, double lon1, double lat2, double lon2) {
            this.computeDistanceAndBearingFast(lat1, lon1, lat2, lon2, mDistResult);
            return mDistResult[0];
        }

        public final void computeDistanceAndBearingFast(double latP1, double lonP1, double latP2, double lonP2, @NotNull double[] results) {
            Intrinsics.checkNotNullParameter((Object)results, (String)"results");
            double lat1 = latP1 * Math.PI / 180.0;
            double lat2 = latP2 * Math.PI / 180.0;
            double lon1 = lonP1 * Math.PI / 180.0;
            double lon2 = lonP2 * Math.PI / 180.0;
            double cosLat1 = Math.cos(lat1);
            double cosLat2 = Math.cos(lat2);
            double sinDLat2 = Math.sin((lat2 - lat1) / 2.0);
            double sinDLon2 = Math.sin((lon2 - lon1) / 2.0);
            double a = sinDLat2 * sinDLat2 + cosLat1 * cosLat2 * sinDLon2 * sinDLon2;
            double d = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
            results[0] = d * 6371000.0;
            if (results.length > 1) {
                double y = Math.sin(lon2 - lon1) * cosLat2;
                double x = cosLat1 * Math.sin(lat2) - Math.sin(lat1) * cosLat2 * Math.cos(lon2 - lon1);
                results[1] = Math.toDegrees(Math.atan2(y, x));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

