/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.geocaching;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import locus.api.objects.Storable;
import locus.api.objects.geocaching.GeocachingAttribute;
import locus.api.objects.geocaching.GeocachingImage;
import locus.api.objects.geocaching.GeocachingLog;
import locus.api.objects.geocaching.GeocachingTrackable;
import locus.api.objects.geocaching.GeocachingWaypoint;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;
import locus.api.utils.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00a3\u00012\u00020\u0001:\u0002\u00a3\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0093\u0001\u001a\u00020P2\u0007\u0010\u0094\u0001\u001a\u00020\u000bJ\t\u0010\u0095\u0001\u001a\u00020\u0017H\u0014J\u001d\u0010\u0096\u0001\u001a\u00030\u0097\u00012\u0007\u0010\u0098\u0001\u001a\u00020\u00172\b\u0010\u0099\u0001\u001a\u00030\u009a\u0001H\u0014J\u000f\u0010\u001a\u001a\u00030\u0097\u00012\u0006\u0010\n\u001a\u00020\u000bJ+\u0010\u009b\u0001\u001a\u00020P2\u0007\u0010\u009c\u0001\u001a\u00020\u000b2\u0007\u0010\u009d\u0001\u001a\u00020P2\u0007\u0010\u009e\u0001\u001a\u00020\u000b2\u0007\u0010\u009f\u0001\u001a\u00020PJ\u0011\u0010\u008e\u0001\u001a\u00030\u0097\u00012\u0007\u0010\u008c\u0001\u001a\u00020\u000bJ\u0014\u0010\u00a0\u0001\u001a\u00030\u0097\u00012\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001H\u0014R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000eR\u001a\u0010\u001e\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000e\"\u0004\b \u0010\u0010R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\u001a\u0010*\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010$\"\u0004\b,\u0010&R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u000e\"\u0004\b;\u0010\u0010R\u001a\u0010<\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0019\"\u0004\b>\u0010\u001bR\u001a\u0010?\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00106\"\u0004\bA\u00108R\u001a\u0010B\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0019\"\u0004\bD\u0010\u001bR\u001a\u0010E\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u00106\"\u0004\bG\u00108R\u001a\u0010H\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010$\"\u0004\bJ\u0010&R \u0010K\u001a\b\u0012\u0004\u0012\u00020L0\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\u0007\"\u0004\bN\u0010\tR\u001a\u0010O\u001a\u00020PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010Q\"\u0004\bR\u0010SR\u001a\u0010T\u001a\u00020PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010Q\"\u0004\bU\u0010SR\u0011\u0010V\u001a\u00020P8F\u00a2\u0006\u0006\u001a\u0004\bV\u0010QR\u001a\u0010W\u001a\u00020PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010Q\"\u0004\bX\u0010SR\u001a\u0010Y\u001a\u00020PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010Q\"\u0004\bZ\u0010SR\u001a\u0010[\u001a\u00020PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010Q\"\u0004\b\\\u0010SR\u001a\u0010]\u001a\u00020^X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010`\"\u0004\ba\u0010bR \u0010c\u001a\b\u0012\u0004\u0012\u00020d0\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010\u0007\"\u0004\bf\u0010\tR\u001a\u0010g\u001a\u00020^X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010`\"\u0004\bi\u0010bR\u001a\u0010j\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010\u000e\"\u0004\bl\u0010\u0010R$\u0010m\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010\u000e\"\u0004\bo\u0010\u0010R\u001e\u0010q\u001a\u00020\"2\u0006\u0010p\u001a\u00020\"@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010$R$\u0010s\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010\u000e\"\u0004\bu\u0010\u0010R\u001e\u0010v\u001a\u00020\"2\u0006\u0010p\u001a\u00020\"@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010$R\u001a\u0010x\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\by\u0010\u000e\"\u0004\bz\u0010\u0010R\u001a\u0010{\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u0010\u000e\"\u0004\b}\u0010\u0010R\u000e\u0010~\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u007f\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0080\u0001\u0010\u0019\"\u0005\b\u0081\u0001\u0010\u001bR\u001d\u0010\u0082\u0001\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0083\u0001\u0010\u000e\"\u0005\b\u0084\u0001\u0010\u0010R\u001d\u0010\u0085\u0001\u001a\u000204X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0086\u0001\u00106\"\u0005\b\u0087\u0001\u00108R$\u0010\u0088\u0001\u001a\t\u0012\u0005\u0012\u00030\u0089\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008a\u0001\u0010\u0007\"\u0005\b\u008b\u0001\u0010\tR\u001d\u0010\u008c\u0001\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008d\u0001\u0010\u0019\"\u0005\b\u008e\u0001\u0010\u001bR$\u0010\u008f\u0001\u001a\t\u0012\u0005\u0012\u00030\u0090\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0091\u0001\u0010\u0007\"\u0005\b\u0092\u0001\u0010\t\u00a8\u0006\u00a4\u0001"}, d2={"Llocus/api/objects/geocaching/GeocachingData;", "Llocus/api/objects/Storable;", "()V", "attributes", "", "Llocus/api/objects/geocaching/GeocachingAttribute;", "getAttributes", "()Ljava/util/List;", "setAttributes", "(Ljava/util/List;)V", "value", "", "cacheID", "getCacheID", "()Ljava/lang/String;", "setCacheID", "(Ljava/lang/String;)V", "cacheUrl", "getCacheUrl", "setCacheUrl", "cacheUrlFull", "getCacheUrlFull", "container", "", "getContainer", "()I", "setContainer", "(I)V", "containerText", "getContainerText", "country", "getCountry", "setCountry", "dateHidden", "", "getDateHidden", "()J", "setDateHidden", "(J)V", "datePublished", "getDatePublished", "setDatePublished", "dateUpdated", "getDateUpdated", "setDateUpdated", "descBytes", "", "descriptions", "", "getDescriptions", "()[Ljava/lang/String;", "difficulty", "", "getDifficulty", "()F", "setDifficulty", "(F)V", "encodedHints", "getEncodedHints", "setEncodedHints", "favoritePoints", "getFavoritePoints", "setFavoritePoints", "gcVoteAverage", "getGcVoteAverage", "setGcVoteAverage", "gcVoteNumOfVotes", "getGcVoteNumOfVotes", "setGcVoteNumOfVotes", "gcVoteUserVote", "getGcVoteUserVote", "setGcVoteUserVote", "id", "getId", "setId", "images", "Llocus/api/objects/geocaching/GeocachingImage;", "getImages", "setImages", "isArchived", "", "()Z", "setArchived", "(Z)V", "isAvailable", "setAvailable", "isCacheValid", "isComputed", "setComputed", "isFound", "setFound", "isPremiumOnly", "setPremiumOnly", "latOriginal", "", "getLatOriginal", "()D", "setLatOriginal", "(D)V", "logs", "Llocus/api/objects/geocaching/GeocachingLog;", "getLogs", "setLogs", "lonOriginal", "getLonOriginal", "setLonOriginal", "name", "getName", "setName", "notesExternal", "getNotesExternal", "setNotesExternal", "<set-?>", "notesExternalUpdatedAt", "getNotesExternalUpdatedAt", "notesLocal", "getNotesLocal", "setNotesLocal", "notesLocalUpdatedAt", "getNotesLocalUpdatedAt", "owner", "getOwner", "setOwner", "placedBy", "getPlacedBy", "setPlacedBy", "shortDescLength", "source", "getSource", "setSource", "state", "getState", "setState", "terrain", "getTerrain", "setTerrain", "trackables", "Llocus/api/objects/geocaching/GeocachingTrackable;", "getTrackables", "setTrackables", "type", "getType", "setType", "waypoints", "Llocus/api/objects/geocaching/GeocachingWaypoint;", "getWaypoints", "setWaypoints", "containsInData", "text", "getVersion", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "setDescriptions", "shortDesc", "shortInHtml", "longDesc", "longInHtml", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "Companion", "locus-api-core"})
public final class GeocachingData
extends Storable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long id;
    @NotNull
    private String cacheID = "";
    private boolean isAvailable = true;
    private boolean isArchived;
    private boolean isPremiumOnly;
    @NotNull
    private String name = "";
    @NotNull
    private String placedBy = "";
    @NotNull
    private String owner = "";
    private long dateHidden;
    private long datePublished;
    private long dateUpdated;
    private int type = -1;
    private int container;
    private float difficulty = -1.0f;
    private float terrain = -1.0f;
    @NotNull
    private String country = "";
    @NotNull
    private String state = "";
    @Nullable
    private byte[] descBytes;
    private int shortDescLength;
    @NotNull
    private String encodedHints = "";
    @NotNull
    private List<GeocachingAttribute> attributes = new ArrayList();
    @NotNull
    private List<GeocachingLog> logs = new ArrayList();
    @NotNull
    private List<GeocachingTrackable> trackables = new ArrayList();
    @NotNull
    private List<GeocachingWaypoint> waypoints = new ArrayList();
    @NotNull
    private String notesLocal = "";
    private long notesLocalUpdatedAt;
    @NotNull
    private String notesExternal = "";
    private long notesExternalUpdatedAt;
    private boolean isComputed;
    private boolean isFound;
    @NotNull
    private String cacheUrl = "";
    private int favoritePoints = -1;
    private int gcVoteNumOfVotes = -1;
    private float gcVoteAverage;
    private float gcVoteUserVote;
    private double lonOriginal;
    private double latOriginal;
    @NotNull
    private List<GeocachingImage> images = new ArrayList();
    private int source;
    @NotNull
    private static final String TAG = "GeocachingData";
    public static final int CACHE_TYPE_TRADITIONAL = 0;
    public static final int CACHE_TYPE_MULTI = 1;
    public static final int CACHE_TYPE_MYSTERY = 2;
    public static final int CACHE_TYPE_VIRTUAL = 3;
    public static final int CACHE_TYPE_EARTH = 4;
    public static final int CACHE_TYPE_PROJECT_APE = 5;
    public static final int CACHE_TYPE_LETTERBOX = 6;
    public static final int CACHE_TYPE_WHERIGO = 7;
    public static final int CACHE_TYPE_EVENT = 8;
    public static final int CACHE_TYPE_MEGA_EVENT = 9;
    public static final int CACHE_TYPE_CACHE_IN_TRASH_OUT = 10;
    public static final int CACHE_TYPE_GPS_ADVENTURE = 11;
    public static final int CACHE_TYPE_WEBCAM = 12;
    public static final int CACHE_TYPE_LOCATIONLESS = 13;
    public static final int CACHE_TYPE_BENCHMARK = 14;
    public static final int CACHE_TYPE_MAZE_EXHIBIT = 15;
    public static final int CACHE_TYPE_WAYMARK = 16;
    public static final int CACHE_TYPE_GROUNDSPEAK = 17;
    public static final int CACHE_TYPE_GC_HQ = 17;
    public static final int CACHE_TYPE_LF_EVENT = 18;
    public static final int CACHE_TYPE_COMMUNITY_CELEBRATION = 18;
    public static final int CACHE_TYPE_LF_CELEBRATION = 19;
    public static final int CACHE_TYPE_GC_HQ_CELEBRATION = 19;
    public static final int CACHE_TYPE_GIGA_EVENT = 20;
    public static final int CACHE_TYPE_LAB_CACHE = 21;
    public static final int CACHE_TYPE_GC_HQ_BLOCK_PARTY = 22;
    public static final int CACHE_TYPE_UNDEFINED = -1;
    public static final int CACHE_SIZE_NOT_CHOSEN = 0;
    public static final int CACHE_SIZE_MICRO = 1;
    public static final int CACHE_SIZE_SMALL = 2;
    public static final int CACHE_SIZE_REGULAR = 3;
    public static final int CACHE_SIZE_LARGE = 4;
    public static final int CACHE_SIZE_HUGE = 5;
    public static final int CACHE_SIZE_OTHER = 6;
    public static final int CACHE_SOURCE_UNDEFINED = 0;
    public static final int CACHE_SOURCE_GEOCACHING_COM = 1;
    public static final int CACHE_SOURCE_GEOCACHING_HU = 2;
    public static final int CACHE_SOURCE_OPENCACHING = 100;
    public static final int CACHE_SOURCE_OPENCACHING_DE = 101;
    public static final int CACHE_SOURCE_OPENCACHING_ES = 102;
    public static final int CACHE_SOURCE_OPENCACHING_FR = 103;
    public static final int CACHE_SOURCE_OPENCACHING_IT = 104;
    public static final int CACHE_SOURCE_OPENCACHING_NL = 105;
    public static final int CACHE_SOURCE_OPENCACHING_PL = 106;
    public static final int CACHE_SOURCE_OPENCACHING_RO = 107;
    public static final int CACHE_SOURCE_OPENCACHING_UK = 108;
    public static final int CACHE_SOURCE_OPENCACHING_US = 109;
    public static final int CACHE_SOURCE_OPENCACHING_CZ = 110;

    public final long getId() {
        return this.id;
    }

    public final void setId(long l) {
        this.id = l;
    }

    @NotNull
    public final String getCacheID() {
        return this.cacheID;
    }

    public final void setCacheID(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (StringsKt.isBlank((CharSequence)value)) {
            return;
        }
        this.cacheID = value;
        String $this$trim$iv = value;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
        String testCode = string2;
        this.source = StringsKt.startsWith$default((String)testCode, (String)"GC", (boolean)false, (int)2, null) ? 1 : (StringsKt.startsWith$default((String)testCode, (String)"OB", (boolean)false, (int)2, null) ? 105 : (StringsKt.startsWith$default((String)testCode, (String)"OK", (boolean)false, (int)2, null) ? 108 : (StringsKt.startsWith$default((String)testCode, (String)"OP", (boolean)false, (int)2, null) ? 106 : (StringsKt.startsWith$default((String)testCode, (String)"OU", (boolean)false, (int)2, null) ? 109 : (StringsKt.startsWith$default((String)testCode, (String)"OZ", (boolean)false, (int)2, null) ? 110 : (StringsKt.startsWith$default((String)testCode, (String)"O", (boolean)false, (int)2, null) ? 100 : 0))))));
    }

    public final boolean isAvailable() {
        return this.isAvailable;
    }

    public final void setAvailable(boolean bl) {
        this.isAvailable = bl;
    }

    public final boolean isArchived() {
        return this.isArchived;
    }

    public final void setArchived(boolean bl) {
        this.isArchived = bl;
    }

    public final boolean isPremiumOnly() {
        return this.isPremiumOnly;
    }

    public final void setPremiumOnly(boolean bl) {
        this.isPremiumOnly = bl;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getPlacedBy() {
        return this.placedBy;
    }

    public final void setPlacedBy(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.placedBy = string;
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    public final void setOwner(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.owner = string;
    }

    public final long getDateHidden() {
        return this.dateHidden;
    }

    public final void setDateHidden(long l) {
        this.dateHidden = l;
    }

    public final long getDatePublished() {
        return this.datePublished;
    }

    public final void setDatePublished(long l) {
        this.datePublished = l;
    }

    public final long getDateUpdated() {
        return this.dateUpdated;
    }

    public final void setDateUpdated(long l) {
        this.dateUpdated = l;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    public final int getContainer() {
        return this.container;
    }

    public final void setContainer(int n) {
        this.container = n;
    }

    public final float getDifficulty() {
        return this.difficulty;
    }

    public final void setDifficulty(float f) {
        this.difficulty = f;
    }

    public final float getTerrain() {
        return this.terrain;
    }

    public final void setTerrain(float f) {
        this.terrain = f;
    }

    @NotNull
    public final String getCountry() {
        return this.country;
    }

    public final void setCountry(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.country = string;
    }

    @NotNull
    public final String getState() {
        return this.state;
    }

    public final void setState(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.state = string;
    }

    @NotNull
    public final String getEncodedHints() {
        return this.encodedHints;
    }

    public final void setEncodedHints(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.encodedHints = string;
    }

    @NotNull
    public final List<GeocachingAttribute> getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(@NotNull List<GeocachingAttribute> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.attributes = list;
    }

    @NotNull
    public final List<GeocachingLog> getLogs() {
        return this.logs;
    }

    public final void setLogs(@NotNull List<GeocachingLog> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.logs = list;
    }

    @NotNull
    public final List<GeocachingTrackable> getTrackables() {
        return this.trackables;
    }

    public final void setTrackables(@NotNull List<GeocachingTrackable> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.trackables = list;
    }

    @NotNull
    public final List<GeocachingWaypoint> getWaypoints() {
        return this.waypoints;
    }

    public final void setWaypoints(@NotNull List<GeocachingWaypoint> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.waypoints = list;
    }

    @NotNull
    public final String getNotesLocal() {
        return this.notesLocal;
    }

    public final void setNotesLocal(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.notesLocal = value;
        this.notesLocalUpdatedAt = System.currentTimeMillis();
    }

    public final long getNotesLocalUpdatedAt() {
        return this.notesLocalUpdatedAt;
    }

    @NotNull
    public final String getNotesExternal() {
        return this.notesExternal;
    }

    public final void setNotesExternal(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.notesExternal = value;
        this.notesExternalUpdatedAt = System.currentTimeMillis();
    }

    public final long getNotesExternalUpdatedAt() {
        return this.notesExternalUpdatedAt;
    }

    public final boolean isComputed() {
        return this.isComputed;
    }

    public final void setComputed(boolean bl) {
        this.isComputed = bl;
    }

    public final boolean isFound() {
        return this.isFound;
    }

    public final void setFound(boolean bl) {
        this.isFound = bl;
    }

    @NotNull
    public final String getCacheUrl() {
        return this.cacheUrl;
    }

    public final void setCacheUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.cacheUrl = string;
    }

    public final int getFavoritePoints() {
        return this.favoritePoints;
    }

    public final void setFavoritePoints(int n) {
        this.favoritePoints = n;
    }

    public final int getGcVoteNumOfVotes() {
        return this.gcVoteNumOfVotes;
    }

    public final void setGcVoteNumOfVotes(int n) {
        this.gcVoteNumOfVotes = n;
    }

    public final float getGcVoteAverage() {
        return this.gcVoteAverage;
    }

    public final void setGcVoteAverage(float f) {
        this.gcVoteAverage = f;
    }

    public final float getGcVoteUserVote() {
        return this.gcVoteUserVote;
    }

    public final void setGcVoteUserVote(float f) {
        this.gcVoteUserVote = f;
    }

    public final double getLonOriginal() {
        return this.lonOriginal;
    }

    public final void setLonOriginal(double d) {
        this.lonOriginal = d;
    }

    public final double getLatOriginal() {
        return this.latOriginal;
    }

    public final void setLatOriginal(double d) {
        this.latOriginal = d;
    }

    @NotNull
    public final List<GeocachingImage> getImages() {
        return this.images;
    }

    public final void setImages(@NotNull List<GeocachingImage> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.images = list;
    }

    public final int getSource() {
        return this.source;
    }

    public final void setSource(int n) {
        this.source = n;
    }

    @NotNull
    public final String getContainerText() {
        switch (this.container) {
            case 1: {
                return "Micro";
            }
            case 2: {
                return "Small";
            }
            case 3: {
                return "Regular";
            }
            case 4: {
                return "Large";
            }
            case 5: {
                return "Huge";
            }
            case 0: {
                return "Not chosen";
            }
            case 6: {
                return "Other";
            }
        }
        return "";
    }

    public final void setContainer(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.container = StringsKt.equals((String)value, (String)"Micro", (boolean)true) ? 1 : (StringsKt.equals((String)value, (String)"Small", (boolean)true) ? 2 : (StringsKt.equals((String)value, (String)"Regular", (boolean)true) ? 3 : (StringsKt.equals((String)value, (String)"Large", (boolean)true) ? 4 : (StringsKt.equals((String)value, (String)"Huge", (boolean)true) ? 5 : (StringsKt.equals((String)value, (String)"Other", (boolean)true) ? 6 : 0)))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String[] getDescriptions() {
        String[] res;
        block11: {
            block10: {
                String[] stringArray = new String[]{"", ""};
                res = stringArray;
                if (this.descBytes == null) break block10;
                Intrinsics.checkNotNull((Object)this.descBytes);
                if (!(this.descBytes.length == 0)) break block11;
            }
            return res;
        }
        GZIPInputStream zis = null;
        try {
            Intrinsics.checkNotNull((Object)this.descBytes);
            zis = new GZIPInputStream((InputStream)new ByteArrayInputStream(this.descBytes), 10240);
            String result = Utils.INSTANCE.doBytesToString(ByteStreamsKt.readBytes((InputStream)zis));
            if (this.shortDescLength > 0) {
                String string = result.substring(0, this.shortDescLength);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                res[0] = string;
            }
            String string = result.substring(this.shortDescLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            res[1] = string;
        }
        catch (IOException e) {
            Logger.INSTANCE.logE(TAG, "", e);
            res[0] = "";
            res[1] = "";
        }
        finally {
            Utils.INSTANCE.closeStream(zis);
        }
        return res;
    }

    public final boolean setDescriptions(@NotNull String shortDesc, boolean shortInHtml, @NotNull String longDesc, boolean longInHtml) {
        Intrinsics.checkNotNullParameter((Object)shortDesc, (String)"shortDesc");
        Intrinsics.checkNotNullParameter((Object)longDesc, (String)"longDesc");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zos = new GZIPOutputStream(baos);
            zos.write(Utils.INSTANCE.doStringToBytes(shortDesc));
            zos.write(Utils.INSTANCE.doStringToBytes(longDesc));
            zos.close();
            this.descBytes = baos.toByteArray();
            this.shortDescLength = shortDesc.length();
            return true;
        }
        catch (IOException e) {
            Logger.INSTANCE.logE(TAG, "setDescription(" + shortDesc + ", " + shortInHtml + ", " + longDesc + ", " + longInHtml + ')', e);
            this.descBytes = null;
            this.shortDescLength = 0;
            return false;
        }
    }

    @NotNull
    public final String getCacheUrlFull() {
        if (this.source == 1) {
            return Intrinsics.stringPlus((String)"https://coord.info/", (Object)this.cacheID);
        }
        return ((CharSequence)this.cacheUrl).length() > 0 ? this.cacheUrl : Intrinsics.stringPlus((String)"https://www.geocaching.com/seek/cache_details.aspx?wp=", (Object)this.cacheID);
    }

    public final boolean isCacheValid() {
        return ((CharSequence)this.cacheID).length() > 0 && ((CharSequence)this.name).length() > 0 && this.type != -1;
    }

    public final void setType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = Companion.getTypeAsInt(type);
    }

    public final boolean containsInData(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.contains((CharSequence)this.owner, (CharSequence)text, (boolean)true)) {
            return true;
        }
        if (StringsKt.contains((CharSequence)this.country, (CharSequence)text, (boolean)true)) {
            return true;
        }
        if (StringsKt.contains((CharSequence)this.state, (CharSequence)text, (boolean)true)) {
            return true;
        }
        String[] desc = this.getDescriptions();
        return StringsKt.contains((CharSequence)desc[0], (CharSequence)text, (boolean)true) || StringsKt.contains((CharSequence)desc[1], (CharSequence)text, (boolean)true);
    }

    @Override
    protected int getVersion() {
        return 4;
    }

    @Override
    protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        this.id = dr.readLong();
        String string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.setCacheID(string);
        this.isAvailable = dr.readBoolean();
        this.isArchived = dr.readBoolean();
        this.isPremiumOnly = dr.readBoolean();
        string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.name = string;
        this.dateUpdated = dr.readLong();
        this.dateHidden = dr.readLong();
        string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.placedBy = string;
        string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.owner = string;
        this.datePublished = dr.readLong();
        this.type = dr.readInt();
        this.container = dr.readInt();
        this.difficulty = dr.readFloat();
        this.terrain = dr.readFloat();
        string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.country = string;
        string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.state = string;
        int size = dr.readInt();
        this.shortDescLength = dr.readInt();
        if (size > 0) {
            this.descBytes = dr.readBytes(size);
        }
        Object object = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dr.readString()");
        this.encodedHints = object;
        object = dr.readListStorable(GeocachingAttribute.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dr.readListStorable(Geoc\u2026ingAttribute::class.java)");
        this.attributes = object;
        object = dr.readListStorable(GeocachingLog.class);
        Intrinsics.checkNotNullExpressionValue(object, (String)"dr.readListStorable(GeocachingLog::class.java)");
        this.logs = object;
        object = dr.readListStorable(GeocachingTrackable.class);
        Intrinsics.checkNotNullExpressionValue(object, (String)"dr.readListStorable(Geoc\u2026ingTrackable::class.java)");
        this.trackables = object;
        object = dr.readListStorable(GeocachingWaypoint.class);
        Intrinsics.checkNotNullExpressionValue(object, (String)"dr.readListStorable(Geoc\u2026hingWaypoint::class.java)");
        this.waypoints = object;
        object = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dr.readString()");
        this.setNotesLocal((String)object);
        this.isComputed = dr.readBoolean();
        this.isFound = dr.readBoolean();
        object = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dr.readString()");
        this.cacheUrl = object;
        this.favoritePoints = dr.readInt();
        if (version >= 1) {
            this.gcVoteNumOfVotes = dr.readInt();
            this.gcVoteAverage = dr.readFloat();
            this.gcVoteUserVote = dr.readFloat();
        }
        if (version >= 2) {
            this.lonOriginal = dr.readDouble();
            this.latOriginal = dr.readDouble();
            object = dr.readListStorable(GeocachingImage.class);
            Intrinsics.checkNotNullExpressionValue(object, (String)"dr.readListStorable(GeocachingImage::class.java)");
            this.images = object;
        }
        if (version >= 3) {
            this.source = dr.readInt();
        }
        if (version >= 4) {
            this.notesLocalUpdatedAt = dr.readLong();
            object = dr.readString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dr.readString()");
            this.setNotesExternal((String)object);
            this.notesExternalUpdatedAt = dr.readLong();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeLong(this.id);
        dw.writeString(this.cacheID);
        dw.writeBoolean(this.isAvailable);
        dw.writeBoolean(this.isArchived);
        dw.writeBoolean(this.isPremiumOnly);
        dw.writeString(this.name);
        dw.writeLong(this.dateUpdated);
        dw.writeLong(this.dateHidden);
        dw.writeString(this.placedBy);
        dw.writeString(this.owner);
        dw.writeLong(this.datePublished);
        dw.writeInt(this.type);
        dw.writeInt(this.container);
        dw.writeFloat(this.difficulty);
        dw.writeFloat(this.terrain);
        dw.writeString(this.country);
        dw.writeString(this.state);
        if (this.descBytes == null) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.descBytes);
        if (this.descBytes.length == 0) lbl-1000:
        // 2 sources

        {
            dw.writeInt(0);
            dw.writeInt(0);
        } else {
            Intrinsics.checkNotNull((Object)this.descBytes);
            dw.writeInt(this.descBytes.length);
            dw.writeInt(this.shortDescLength);
            dw.write(this.descBytes);
        }
        dw.writeString(this.encodedHints);
        dw.writeListStorable(this.attributes);
        dw.writeListStorable(this.logs);
        dw.writeListStorable(this.trackables);
        dw.writeListStorable(this.waypoints);
        dw.writeString(this.notesLocal);
        dw.writeBoolean(this.isComputed);
        dw.writeBoolean(this.isFound);
        dw.writeString(this.cacheUrl);
        dw.writeInt(this.favoritePoints);
        dw.writeInt(this.gcVoteNumOfVotes);
        dw.writeFloat(this.gcVoteAverage);
        dw.writeFloat(this.gcVoteUserVote);
        dw.writeDouble(this.lonOriginal);
        dw.writeDouble(this.latOriginal);
        dw.writeListStorable(this.images);
        dw.writeInt(this.source);
        dw.writeLong(this.notesLocalUpdatedAt);
        dw.writeString(this.notesExternal);
        dw.writeLong(this.notesExternalUpdatedAt);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b3\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u000208J\u000e\u0010;\u001a\u0002082\u0006\u0010:\u001a\u00020\u0004J\u000e\u0010<\u001a\u00020=2\u0006\u0010:\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b$\u0010\u0002R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b(\u0010\u0002R\u0016\u0010)\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b*\u0010\u0002R\u000e\u0010+\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Llocus/api/objects/geocaching/GeocachingData$Companion;", "", "()V", "CACHE_SIZE_HUGE", "", "CACHE_SIZE_LARGE", "CACHE_SIZE_MICRO", "CACHE_SIZE_NOT_CHOSEN", "CACHE_SIZE_OTHER", "CACHE_SIZE_REGULAR", "CACHE_SIZE_SMALL", "CACHE_SOURCE_GEOCACHING_COM", "CACHE_SOURCE_GEOCACHING_HU", "CACHE_SOURCE_OPENCACHING", "CACHE_SOURCE_OPENCACHING_CZ", "CACHE_SOURCE_OPENCACHING_DE", "CACHE_SOURCE_OPENCACHING_ES", "CACHE_SOURCE_OPENCACHING_FR", "CACHE_SOURCE_OPENCACHING_IT", "CACHE_SOURCE_OPENCACHING_NL", "CACHE_SOURCE_OPENCACHING_PL", "CACHE_SOURCE_OPENCACHING_RO", "CACHE_SOURCE_OPENCACHING_UK", "CACHE_SOURCE_OPENCACHING_US", "CACHE_SOURCE_UNDEFINED", "CACHE_TYPE_BENCHMARK", "CACHE_TYPE_CACHE_IN_TRASH_OUT", "CACHE_TYPE_COMMUNITY_CELEBRATION", "CACHE_TYPE_EARTH", "CACHE_TYPE_EVENT", "CACHE_TYPE_GC_HQ", "CACHE_TYPE_GC_HQ_BLOCK_PARTY", "CACHE_TYPE_GC_HQ_CELEBRATION", "CACHE_TYPE_GIGA_EVENT", "CACHE_TYPE_GPS_ADVENTURE", "CACHE_TYPE_GROUNDSPEAK", "getCACHE_TYPE_GROUNDSPEAK$annotations", "CACHE_TYPE_LAB_CACHE", "CACHE_TYPE_LETTERBOX", "CACHE_TYPE_LF_CELEBRATION", "getCACHE_TYPE_LF_CELEBRATION$annotations", "CACHE_TYPE_LF_EVENT", "getCACHE_TYPE_LF_EVENT$annotations", "CACHE_TYPE_LOCATIONLESS", "CACHE_TYPE_MAZE_EXHIBIT", "CACHE_TYPE_MEGA_EVENT", "CACHE_TYPE_MULTI", "CACHE_TYPE_MYSTERY", "CACHE_TYPE_PROJECT_APE", "CACHE_TYPE_TRADITIONAL", "CACHE_TYPE_UNDEFINED", "CACHE_TYPE_VIRTUAL", "CACHE_TYPE_WAYMARK", "CACHE_TYPE_WEBCAM", "CACHE_TYPE_WHERIGO", "TAG", "", "getTypeAsInt", "type", "getTypeAsString", "isEventCache", "", "locus-api-core"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="No longer user cache type/name", replaceWith=@ReplaceWith(expression="CACHE_TYPE_GC_HQ", imports={}))
        public static /* synthetic */ void getCACHE_TYPE_GROUNDSPEAK$annotations() {
        }

        @Deprecated(message="No longer user cache type/name", replaceWith=@ReplaceWith(expression="CACHE_TYPE_COMMUNITY_CELEBRATION", imports={}))
        public static /* synthetic */ void getCACHE_TYPE_LF_EVENT$annotations() {
        }

        @Deprecated(message="No longer user cache type/name", replaceWith=@ReplaceWith(expression="CACHE_TYPE_GC_HQ_CELEBRATION", imports={}))
        public static /* synthetic */ void getCACHE_TYPE_LF_CELEBRATION$annotations() {
        }

        @NotNull
        public final String getTypeAsString(int type) {
            switch (type) {
                case 0: {
                    return "Traditional Cache";
                }
                case 1: {
                    return "Multi-Cache";
                }
                case 2: {
                    return "Unknown Cache";
                }
                case 3: {
                    return "Virtual Cache";
                }
                case 4: {
                    return "EarthCache";
                }
                case 5: {
                    return "Project APE Cache";
                }
                case 6: {
                    return "Letterbox";
                }
                case 7: {
                    return "Wherigo Cache";
                }
                case 8: {
                    return "Event Cache";
                }
                case 9: {
                    return "Mega-Event Cache";
                }
                case 10: {
                    return "Cache In Trash Out Event";
                }
                case 11: {
                    return "GPS Adventure";
                }
                case 12: {
                    return "Webcam Cache";
                }
                case 13: {
                    return "Location-less";
                }
                case 14: {
                    return "Benchmark";
                }
                case 15: {
                    return "Maze Exhibit";
                }
                case 16: {
                    return "Waymark";
                }
                case 18: {
                    return "L&F Event";
                }
                case 17: {
                    return "Groundspeak";
                }
                case 19: {
                    return "L&F Celebration";
                }
                case 20: {
                    return "Giga-Event Cache";
                }
                case 21: {
                    return "Lab Cache";
                }
            }
            return "Geocache";
        }

        public final int getTypeAsInt(@NotNull String type) {
            int n;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            String typeNew = type;
            if (StringsKt.isBlank((CharSequence)typeNew)) {
                return -1;
            }
            if (StringsKt.startsWith$default((String)typeNew, (String)"Geocache|", (boolean)false, (int)2, null)) {
                String string = typeNew.substring("Geocache|".length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                typeNew = string;
            }
            if (StringsKt.equals((String)typeNew, (String)"Traditional Cache", (boolean)true)) {
                n = 0;
            } else if (StringsKt.equals((String)typeNew, (String)"Multi-cache", (boolean)true)) {
                n = 1;
            } else if (StringsKt.equals((String)typeNew, (String)"Mystery Cache", (boolean)true) || StringsKt.equals((String)typeNew, (String)"Unknown Cache", (boolean)true) || StringsKt.equals((String)typeNew, (String)"Mystery/Puzzle Cache", (boolean)true)) {
                n = 2;
            } else if (StringsKt.equals((String)typeNew, (String)"Project APE Cache", (boolean)true) || StringsKt.equals((String)typeNew, (String)"Project A.P.E. Cache", (boolean)true)) {
                n = 5;
            } else if (StringsKt.equals((String)typeNew, (String)"Letterbox Hybrid", (boolean)true) || StringsKt.equals((String)typeNew, (String)"Letterbox", (boolean)true)) {
                n = 6;
            } else if (StringsKt.equals((String)typeNew, (String)"Wherigo", (boolean)true) || StringsKt.equals((String)typeNew, (String)"Wherigo cache", (boolean)true)) {
                n = 7;
            } else if (StringsKt.equals((String)typeNew, (String)"Event Cache", (boolean)true)) {
                n = 8;
            } else if (StringsKt.equals((String)typeNew, (String)"Mega-Event Cache", (boolean)true)) {
                n = 9;
            } else if (StringsKt.equals((String)typeNew, (String)"Cache In Trash Out Event", (boolean)true)) {
                n = 10;
            } else if (StringsKt.equals((String)typeNew, (String)"EarthCache", (boolean)true)) {
                n = 4;
            } else {
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                String string = typeNew.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
                n = StringsKt.startsWith$default((String)string, (String)"gps adventures", (boolean)false, (int)2, null) ? 11 : (StringsKt.equals((String)typeNew, (String)"Virtual Cache", (boolean)true) ? 3 : (StringsKt.equals((String)typeNew, (String)"Webcam Cache", (boolean)true) ? 12 : (StringsKt.equals((String)typeNew, (String)"Locationless Cache", (boolean)true) ? 13 : (StringsKt.equals((String)typeNew, (String)"Benchmark", (boolean)true) ? 14 : (StringsKt.equals((String)typeNew, (String)"Maze Exhibit", (boolean)true) ? 15 : (StringsKt.equals((String)typeNew, (String)"Waymark", (boolean)true) ? 16 : (StringsKt.equals((String)typeNew, (String)"Groundspeak", (boolean)true) ? 17 : (StringsKt.equals((String)typeNew, (String)"L&F Event", (boolean)true) ? 18 : (StringsKt.equals((String)typeNew, (String)"L&F Celebration", (boolean)true) ? 19 : (StringsKt.equals((String)typeNew, (String)"Giga-Event Cache", (boolean)true) ? 20 : (StringsKt.equals((String)typeNew, (String)"Lab Cache", (boolean)true) ? 21 : -1)))))))))));
            }
            return n;
        }

        public final boolean isEventCache(int type) {
            return type == 8 || type == 9 || type == 20 || type == 11 || type == 10;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

