/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import locus.api.objects.Storable;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b6\n\u0002\u0010\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020\r2\u0006\u0010e\u001a\u00020\r2\u0006\u0010f\u001a\u00020\u0016J\u000e\u0010g\u001a\u00020c2\u0006\u0010h\u001a\u00020\u0004J\u000e\u0010i\u001a\u00020c2\u0006\u0010h\u001a\u00020\u0004J\u000e\u0010j\u001a\u00020c2\u0006\u0010h\u001a\u00020\u0004J\u000e\u0010k\u001a\u00020c2\u0006\u0010h\u001a\u00020\u0004J\u000e\u0010l\u001a\u00020c2\u0006\u0010h\u001a\u00020\u0004J\u000e\u0010m\u001a\u00020c2\u0006\u0010h\u001a\u00020\u0004J\u000e\u0010n\u001a\u00020c2\u0006\u0010)\u001a\u00020\rJ\u001e\u0010o\u001a\u00020c2\u0006\u0010p\u001a\u00020\r2\u0006\u0010q\u001a\u00020\r2\u0006\u0010f\u001a\u00020\u0016J\u001e\u0010r\u001a\u00020c2\u0006\u0010s\u001a\u00020\r2\u0006\u0010t\u001a\u00020\r2\u0006\u0010u\u001a\u00020\u0016J\u000e\u0010v\u001a\u00020c2\u0006\u0010w\u001a\u00020\u0004J\u000e\u0010x\u001a\u00020c2\u0006\u0010h\u001a\u00020\u0004J\u000e\u0010y\u001a\u00020c2\u0006\u0010h\u001a\u00020\u0004J\u000e\u0010z\u001a\u00020c2\u0006\u0010h\u001a\u00020\u0016J\u000e\u0010{\u001a\u00020c2\u0006\u0010h\u001a\u00020\u0016J\u000e\u0010|\u001a\u00020c2\u0006\u0010}\u001a\u00020\u0000J\u000e\u0010~\u001a\u00020\u00042\u0006\u0010\u007f\u001a\u00020,J\u000f\u0010\u0080\u0001\u001a\u00020\u00042\u0006\u0010\u007f\u001a\u00020,J\u000f\u0010\u0081\u0001\u001a\u00020\u00162\u0006\u0010\u007f\u001a\u00020,J\t\u0010\u0082\u0001\u001a\u00020\rH\u0014J\u0007\u0010\u0083\u0001\u001a\u00020,J\u001c\u0010\u0084\u0001\u001a\u00020c2\u0007\u0010\u0085\u0001\u001a\u00020\r2\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0014J\u0007\u0010\u0088\u0001\u001a\u00020cJ\u0007\u0010\u0089\u0001\u001a\u00020cJ\u0013\u0010\u008a\u0001\u001a\u00020c2\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\bR\u001a\u0010\u001a\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0006\"\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0006\"\u0004\b\u001f\u0010\bR\u001a\u0010 \u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0006\"\u0004\b\"\u0010\bR\u001a\u0010#\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0006\"\u0004\b%\u0010\bR\u001a\u0010&\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0006\"\u0004\b(\u0010\bR\u001e\u0010)\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u000fR\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0011\u00101\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u000fR\u000e\u00103\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00104\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u000fR\u000e\u00106\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u000f\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u000f\"\u0004\b=\u0010:R\u0011\u0010>\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u000fR\u000e\u0010@\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010A\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u000fR\u000e\u0010C\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010D\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u0006\"\u0004\bF\u0010\bR\u001a\u0010G\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u001a\u0010L\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010I\"\u0004\bN\u0010KR\u001a\u0010O\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u0006\"\u0004\bQ\u0010\bR\u001a\u0010R\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u0006\"\u0004\bT\u0010\bR\u001a\u0010U\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\u0006\"\u0004\bW\u0010\bR\u001a\u0010X\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010\u0006\"\u0004\bZ\u0010\bR$\u0010\\\u001a\u00020\u00162\u0006\u0010[\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010I\"\u0004\b^\u0010KR$\u0010_\u001a\u00020\u00162\u0006\u0010[\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010I\"\u0004\ba\u0010K\u00a8\u0006\u008d\u0001"}, d2={"Llocus/api/objects/extra/TrackStats;", "Llocus/api/objects/Storable;", "()V", "altitudeMax", "", "getAltitudeMax", "()F", "setAltitudeMax", "(F)V", "altitudeMin", "getAltitudeMin", "setAltitudeMin", "cadenceAverage", "", "getCadenceAverage", "()I", "<set-?>", "cadenceMax", "getCadenceMax", "cadenceNumber", "", "cadenceTime", "", "eleNegativeDistance", "getEleNegativeDistance", "setEleNegativeDistance", "eleNegativeHeight", "getEleNegativeHeight", "setEleNegativeHeight", "eleNeutralDistance", "getEleNeutralDistance", "setEleNeutralDistance", "eleNeutralHeight", "getEleNeutralHeight", "setEleNeutralHeight", "elePositiveDistance", "getElePositiveDistance", "setElePositiveDistance", "elePositiveHeight", "getElePositiveHeight", "setElePositiveHeight", "energy", "getEnergy", "hasTemperature", "", "getHasTemperature", "()Z", "setHasTemperature", "(Z)V", "heartRateAverage", "getHeartRateAverage", "heartRateBeats", "heartRateMax", "getHeartRateMax", "heartRateTime", "numOfPoints", "getNumOfPoints", "setNumOfPoints", "(I)V", "numOfStrides", "getNumOfStrides", "setNumOfStrides", "powerAverage", "getPowerAverage", "powerAvgSum", "powerMax", "getPowerMax", "powerTime", "speedMax", "getSpeedMax", "setSpeedMax", "startTime", "getStartTime", "()J", "setStartTime", "(J)V", "stopTime", "getStopTime", "setStopTime", "temperatureMax", "getTemperatureMax", "setTemperatureMax", "temperatureMin", "getTemperatureMin", "setTemperatureMin", "totalLength", "getTotalLength", "setTotalLength", "totalLengthMove", "getTotalLengthMove", "setTotalLengthMove", "value", "totalTime", "getTotalTime", "setTotalTime", "totalTimeMove", "getTotalTimeMove", "setTotalTimeMove", "addCadenceMeasure", "", "revMeasured", "revAvgSegment", "measureTime", "addEleNegativeDistance", "add", "addEleNegativeHeight", "addEleNeutralDistance", "addEleNeutralHeight", "addElePositiveDistance", "addElePositiveHeight", "addEnergy", "addHeartRateMeasure", "hrmMeasured", "hrmAvgSegment", "addPowerMeasure", "powerMeasured", "powerAvgSegment", "timeSegment", "addTemperature", "temp", "addTotalLength", "addTotalLengthMove", "addTotalTime", "addTotalTimeMove", "appendStatistics", "stats", "getLength", "onlyWithMove", "getSpeedAverage", "getTime", "getVersion", "hasElevationValues", "readObject", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "resetStatistics", "resetStatisticsAltitude", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "locus-api-core"})
public final class TrackStats
extends Storable {
    private int numOfPoints;
    private long startTime = -1L;
    private long stopTime = -1L;
    private float totalLength;
    private float totalLengthMove;
    private long totalTime;
    private long totalTimeMove;
    private float speedMax;
    private float altitudeMax;
    private float altitudeMin;
    private float eleNeutralDistance;
    private float eleNeutralHeight;
    private float elePositiveDistance;
    private float elePositiveHeight;
    private float eleNegativeDistance;
    private float eleNegativeHeight;
    private double cadenceNumber;
    private long cadenceTime;
    private int cadenceMax;
    private int energy;
    private double heartRateBeats;
    private long heartRateTime;
    private int heartRateMax;
    private double powerAvgSum;
    private long powerTime;
    private int powerMax;
    private int numOfStrides;
    private boolean hasTemperature;
    private float temperatureMin = Float.POSITIVE_INFINITY;
    private float temperatureMax = Float.NEGATIVE_INFINITY;

    public TrackStats() {
        this.resetStatistics();
    }

    public final int getNumOfPoints() {
        return this.numOfPoints;
    }

    public final void setNumOfPoints(int n) {
        this.numOfPoints = n;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long l) {
        this.startTime = l;
    }

    public final long getStopTime() {
        return this.stopTime;
    }

    public final void setStopTime(long l) {
        this.stopTime = l;
    }

    public final float getTotalLength() {
        return this.totalLength;
    }

    public final void setTotalLength(float f) {
        this.totalLength = f;
    }

    public final void addTotalLength(float add) {
        this.totalLength += add;
    }

    public final float getTotalLengthMove() {
        return this.totalLengthMove;
    }

    public final void setTotalLengthMove(float f) {
        this.totalLengthMove = f;
    }

    public final void addTotalLengthMove(float add) {
        this.totalLengthMove += add;
    }

    public final float getLength(boolean onlyWithMove) {
        return onlyWithMove ? this.totalLengthMove : this.totalLength;
    }

    public final long getTotalTime() {
        return this.totalTime;
    }

    public final void setTotalTime(long value) {
        this.totalTime = Math.abs(value);
    }

    public final void addTotalTime(long add) {
        this.setTotalTime(this.totalTime + Math.abs(add));
    }

    public final long getTotalTimeMove() {
        return this.totalTimeMove;
    }

    public final void setTotalTimeMove(long value) {
        this.totalTimeMove = Math.abs(value);
    }

    public final void addTotalTimeMove(long add) {
        this.setTotalTimeMove(this.totalTimeMove + Math.abs(add));
    }

    public final long getTime(boolean onlyWithMove) {
        return onlyWithMove ? this.totalTimeMove : this.totalTime;
    }

    public final float getSpeedMax() {
        return this.speedMax;
    }

    public final void setSpeedMax(float f) {
        this.speedMax = f;
    }

    public final float getSpeedAverage(boolean onlyWithMove) {
        float time = (float)this.getTime(onlyWithMove) / 1000.0f;
        return time > 0.0f ? this.getLength(onlyWithMove) / time : 0.0f;
    }

    public final float getAltitudeMax() {
        return this.altitudeMax;
    }

    public final void setAltitudeMax(float f) {
        this.altitudeMax = f;
    }

    public final float getAltitudeMin() {
        return this.altitudeMin;
    }

    public final void setAltitudeMin(float f) {
        this.altitudeMin = f;
    }

    public final float getEleNeutralDistance() {
        return this.eleNeutralDistance;
    }

    public final void setEleNeutralDistance(float f) {
        this.eleNeutralDistance = f;
    }

    public final void addEleNeutralDistance(float add) {
        this.eleNeutralDistance += add;
    }

    public final float getEleNeutralHeight() {
        return this.eleNeutralHeight;
    }

    public final void setEleNeutralHeight(float f) {
        this.eleNeutralHeight = f;
    }

    public final void addEleNeutralHeight(float add) {
        this.eleNeutralHeight += add;
    }

    public final float getElePositiveDistance() {
        return this.elePositiveDistance;
    }

    public final void setElePositiveDistance(float f) {
        this.elePositiveDistance = f;
    }

    public final void addElePositiveDistance(float add) {
        this.elePositiveDistance += add;
    }

    public final float getElePositiveHeight() {
        return this.elePositiveHeight;
    }

    public final void setElePositiveHeight(float f) {
        this.elePositiveHeight = f;
    }

    public final void addElePositiveHeight(float add) {
        this.elePositiveHeight += add;
    }

    public final float getEleNegativeDistance() {
        return this.eleNegativeDistance;
    }

    public final void setEleNegativeDistance(float f) {
        this.eleNegativeDistance = f;
    }

    public final void addEleNegativeDistance(float add) {
        this.eleNegativeDistance += add;
    }

    public final float getEleNegativeHeight() {
        return this.eleNegativeHeight;
    }

    public final void setEleNegativeHeight(float f) {
        this.eleNegativeHeight = f;
    }

    public final void addEleNegativeHeight(float add) {
        this.eleNegativeHeight += add;
    }

    public final boolean hasElevationValues() {
        return !(this.altitudeMin == Float.POSITIVE_INFINITY) && !(this.altitudeMin == 0.0f) || !(this.altitudeMax == Float.NEGATIVE_INFINITY) && !(this.altitudeMax == 0.0f);
    }

    public final int getCadenceAverage() {
        int n;
        if (this.cadenceNumber > 0.0 && this.cadenceTime > 0L) {
            double minutes = (double)this.cadenceTime / 60000.0;
            n = (int)(this.cadenceNumber / minutes);
        } else {
            n = 0;
        }
        return n;
    }

    public final int getCadenceMax() {
        return this.cadenceMax;
    }

    public final void addCadenceMeasure(int revMeasured, int revAvgSegment, long measureTime) {
        double inMinutes = (double)measureTime * 1.0 / (double)60000;
        double numOfRevolutions = (double)revAvgSegment * inMinutes;
        this.cadenceNumber += numOfRevolutions;
        this.cadenceTime += measureTime;
        this.cadenceMax = Math.max(this.cadenceMax, revMeasured);
    }

    public final int getEnergy() {
        return this.energy;
    }

    public final void addEnergy(int energy) {
        this.energy += energy;
    }

    public final int getHeartRateAverage() {
        int n;
        if (this.heartRateBeats > 0.0 && this.heartRateTime > 0L) {
            double minutes = (double)this.heartRateTime / 60000.0;
            n = (int)(this.heartRateBeats / minutes);
        } else {
            n = 0;
        }
        return n;
    }

    public final int getHeartRateMax() {
        return this.heartRateMax;
    }

    public final void addHeartRateMeasure(int hrmMeasured, int hrmAvgSegment, long measureTime) {
        double inMinutes = (double)measureTime * 1.0 / (double)60000;
        double numOfBeats = (double)hrmAvgSegment * inMinutes;
        this.heartRateBeats += numOfBeats;
        this.heartRateTime += measureTime;
        this.heartRateMax = Math.max(this.heartRateMax, hrmMeasured);
    }

    public final int getPowerAverage() {
        int n;
        if (this.powerAvgSum > 0.0 && this.powerTime > 0L) {
            double isSeconds = (double)this.powerTime / 1000.0;
            n = (int)(this.powerAvgSum / isSeconds);
        } else {
            n = 0;
        }
        return n;
    }

    public final int getPowerMax() {
        return this.powerMax;
    }

    public final void addPowerMeasure(int powerMeasured, int powerAvgSegment, long timeSegment) {
        double inSeconds = (double)timeSegment / 1000.0;
        this.powerAvgSum += (double)powerAvgSegment * inSeconds;
        this.powerTime += timeSegment;
        this.powerMax = Math.max(this.powerMax, powerMeasured);
    }

    public final int getNumOfStrides() {
        return this.numOfStrides;
    }

    public final void setNumOfStrides(int n) {
        this.numOfStrides = n;
    }

    public final boolean getHasTemperature() {
        return this.hasTemperature;
    }

    public final void setHasTemperature(boolean bl) {
        this.hasTemperature = bl;
    }

    public final float getTemperatureMin() {
        return this.temperatureMin;
    }

    public final void setTemperatureMin(float f) {
        this.temperatureMin = f;
    }

    public final float getTemperatureMax() {
        return this.temperatureMax;
    }

    public final void setTemperatureMax(float f) {
        this.temperatureMax = f;
    }

    public final void addTemperature(float temp) {
        this.hasTemperature = true;
        this.temperatureMin = Math.min(this.temperatureMin, temp);
        this.temperatureMax = Math.max(this.temperatureMax, temp);
    }

    public final void resetStatistics() {
        this.totalLength = 0.0f;
        this.totalLengthMove = 0.0f;
        this.setTotalTime(0L);
        this.setTotalTimeMove(0L);
        this.speedMax = 0.0f;
        this.resetStatisticsAltitude();
        this.cadenceNumber = 0.0;
        this.cadenceTime = 0L;
        this.cadenceMax = 0;
        this.energy = 0;
        this.heartRateBeats = 0.0;
        this.heartRateTime = 0L;
        this.heartRateMax = 0;
        this.numOfStrides = 0;
        this.powerAvgSum = 0.0;
        this.powerTime = 0L;
        this.powerMax = 0;
        this.hasTemperature = false;
        this.temperatureMin = Float.POSITIVE_INFINITY;
        this.temperatureMax = Float.NEGATIVE_INFINITY;
    }

    public final void resetStatisticsAltitude() {
        this.altitudeMax = Float.NEGATIVE_INFINITY;
        this.altitudeMin = Float.POSITIVE_INFINITY;
        this.eleNeutralDistance = 0.0f;
        this.eleNeutralHeight = 0.0f;
        this.elePositiveDistance = 0.0f;
        this.elePositiveHeight = 0.0f;
        this.eleNegativeDistance = 0.0f;
        this.eleNegativeHeight = 0.0f;
    }

    public final void appendStatistics(@NotNull TrackStats stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        this.numOfPoints += stats.numOfPoints;
        this.startTime = Math.min(this.startTime, stats.startTime);
        this.stopTime = Math.max(this.stopTime, stats.stopTime);
        this.totalLength += stats.totalLength;
        this.totalLengthMove += stats.totalLengthMove;
        this.setTotalTime(this.totalTime + stats.totalTime);
        this.setTotalTimeMove(this.totalTimeMove + stats.totalTimeMove);
        this.speedMax = Math.max(this.speedMax, stats.speedMax);
        this.altitudeMax = Math.max(this.altitudeMax, stats.altitudeMax);
        this.altitudeMin = Math.min(this.altitudeMin, stats.altitudeMin);
        this.eleNeutralDistance += stats.eleNeutralDistance;
        this.eleNeutralHeight += stats.eleNeutralHeight;
        this.elePositiveDistance += stats.elePositiveDistance;
        this.elePositiveHeight += stats.elePositiveHeight;
        this.eleNegativeDistance += stats.eleNegativeDistance;
        this.eleNegativeHeight += stats.eleNegativeHeight;
        this.cadenceNumber += stats.cadenceNumber;
        this.cadenceTime += stats.cadenceTime;
        this.cadenceMax = Math.max(this.cadenceMax, stats.cadenceMax);
        this.energy += stats.energy;
        this.heartRateBeats += stats.heartRateBeats;
        this.heartRateTime += stats.heartRateTime;
        this.heartRateMax = Math.max(this.heartRateMax, stats.heartRateMax);
        this.powerAvgSum += stats.powerAvgSum;
        this.powerTime += stats.powerTime;
        this.powerMax = Math.max(this.powerMax, stats.powerMax);
        this.hasTemperature = this.hasTemperature || stats.hasTemperature;
        this.temperatureMin = Math.min(this.temperatureMin, stats.temperatureMin);
        this.temperatureMax = Math.max(this.temperatureMax, stats.temperatureMax);
        this.numOfStrides += stats.numOfStrides;
    }

    @Override
    protected int getVersion() {
        return 4;
    }

    @Override
    protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        this.numOfPoints = dr.readInt();
        this.startTime = dr.readLong();
        this.stopTime = dr.readLong();
        this.totalLength = dr.readFloat();
        this.totalLengthMove = dr.readFloat();
        this.setTotalTime(dr.readLong());
        this.setTotalTimeMove(dr.readLong());
        this.speedMax = dr.readFloat();
        this.altitudeMax = dr.readFloat();
        this.altitudeMin = dr.readFloat();
        this.eleNeutralDistance = dr.readFloat();
        this.eleNeutralHeight = dr.readFloat();
        this.elePositiveDistance = dr.readFloat();
        this.elePositiveHeight = dr.readFloat();
        this.eleNegativeDistance = dr.readFloat();
        this.eleNegativeHeight = dr.readFloat();
        dr.readFloat();
        dr.readFloat();
        if (version >= 1) {
            this.heartRateBeats = dr.readInt();
            this.heartRateTime = dr.readLong();
            this.heartRateMax = dr.readInt();
            this.energy = dr.readInt();
        }
        if (version >= 2) {
            this.heartRateBeats = dr.readDouble();
            this.cadenceNumber = dr.readDouble();
            this.cadenceTime = dr.readLong();
            this.cadenceMax = dr.readInt();
        }
        if (version >= 3) {
            this.numOfStrides = dr.readInt();
        }
        if (version >= 4) {
            this.powerAvgSum = dr.readDouble();
            this.powerTime = dr.readLong();
            this.powerMax = dr.readInt();
            this.hasTemperature = dr.readBoolean();
            this.temperatureMin = dr.readFloat();
            this.temperatureMax = dr.readFloat();
        }
    }

    @Override
    protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeInt(this.numOfPoints);
        dw.writeLong(this.startTime);
        dw.writeLong(this.stopTime);
        dw.writeFloat(this.totalLength);
        dw.writeFloat(this.totalLengthMove);
        dw.writeLong(this.totalTime);
        dw.writeLong(this.totalTimeMove);
        dw.writeFloat(this.speedMax);
        dw.writeFloat(this.altitudeMax);
        dw.writeFloat(this.altitudeMin);
        dw.writeFloat(this.eleNeutralDistance);
        dw.writeFloat(this.eleNeutralHeight);
        dw.writeFloat(this.elePositiveDistance);
        dw.writeFloat(this.elePositiveHeight);
        dw.writeFloat(this.eleNegativeDistance);
        dw.writeFloat(this.eleNegativeHeight);
        dw.writeFloat(0.0f);
        dw.writeFloat(0.0f);
        dw.writeInt((int)this.heartRateBeats);
        dw.writeLong(this.heartRateTime);
        dw.writeInt(this.heartRateMax);
        dw.writeInt(this.energy);
        dw.writeDouble(this.heartRateBeats);
        dw.writeDouble(this.cadenceNumber);
        dw.writeLong(this.cadenceTime);
        dw.writeInt(this.cadenceMax);
        dw.writeInt(this.numOfStrides);
        dw.writeDouble(this.powerAvgSum);
        dw.writeLong(this.powerTime);
        dw.writeInt(this.powerMax);
        dw.writeBoolean(this.hasTemperature);
        dw.writeFloat(this.temperatureMin);
        dw.writeFloat(this.temperatureMax);
    }
}

