/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.styles;

import com.asamm.logger.Logger;
import com.asamm.loggerV2.Log;
import com.asamm.loggerV2.LogCategory;
import com.asamm.loggerV2.LogPriority;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import locus.api.objects.Storable;
import locus.api.objects.extra.KmlVec2;
import locus.api.objects.styles.IconStyle;
import locus.api.objects.styles.LabelStyle;
import locus.api.objects.styles.LineStyle;
import locus.api.objects.styles.deprecated.LineStyleOld;
import locus.api.objects.styles.deprecated.OldStyleHelper;
import locus.api.objects.styles.deprecated.PolyStyleOld;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 52\u00020\u0001:\u00015B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010 \u001a\u00020!H\u0014J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0014J\u0016\u0010\n\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)J&\u0010\n\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020)2\u0006\u0010(\u001a\u00020)J\u000e\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020!J\u000e\u0010,\u001a\u00020#2\u0006\u0010.\u001a\u00020/J\u0016\u0010\u001c\u001a\u00020#2\u0006\u0010*\u001a\u00020!2\u0006\u00100\u001a\u00020)J\u000e\u00101\u001a\u00020#2\u0006\u0010*\u001a\u00020!J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0014R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"\u0004\b\u0011\u0010\u0004R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0004\u00a8\u00066"}, d2={"Llocus/api/objects/styles/GeoDataStyle;", "Llocus/api/objects/Storable;", "name", "", "(Ljava/lang/String;)V", "()V", "iconStyle", "Llocus/api/objects/styles/IconStyle;", "getIconStyle", "()Llocus/api/objects/styles/IconStyle;", "setIconStyle", "(Llocus/api/objects/styles/IconStyle;)V", "iconStyleIconUrl", "getIconStyleIconUrl", "()Ljava/lang/String;", "id", "getId", "setId", "labelStyle", "Llocus/api/objects/styles/LabelStyle;", "getLabelStyle", "()Llocus/api/objects/styles/LabelStyle;", "setLabelStyle", "(Llocus/api/objects/styles/LabelStyle;)V", "lineStyle", "Llocus/api/objects/styles/LineStyle;", "getLineStyle", "()Llocus/api/objects/styles/LineStyle;", "setLineStyle", "(Llocus/api/objects/styles/LineStyle;)V", "getName", "setName", "getVersion", "", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "iconUrl", "scale", "", "color", "heading", "setIconStyleHotSpot", "hotspot", "vec2", "Llocus/api/objects/extra/KmlVec2;", "width", "setPolyStyle", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "Companion", "locus-api-core"})
@SourceDebugExtension(value={"SMAP\nGeoDataStyle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoDataStyle.kt\nlocus/api/objects/styles/GeoDataStyle\n+ 2 Log.kt\ncom/asamm/loggerV2/LogKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,303:1\n69#2,14:304\n1#3:318\n*S KotlinDebug\n*F\n+ 1 GeoDataStyle.kt\nlocus/api/objects/styles/GeoDataStyle\n*L\n129#1:304,14\n*E\n"})
public final class GeoDataStyle
extends Storable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String id = "";
    @NotNull
    private String name = "";
    @Nullable
    private IconStyle iconStyle;
    @Nullable
    private LabelStyle labelStyle;
    @Nullable
    private LineStyle lineStyle;
    @NotNull
    private static final String TAG = "GeoDataStyle";
    public static final int HOTSPOT_BOTTOM_CENTER = 0;
    public static final int HOTSPOT_TOP_LEFT = 1;
    public static final int HOTSPOT_CENTER_CENTER = 2;
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final int COLOR_DEFAULT = -1;

    public GeoDataStyle() {
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void setId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.id = string;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Nullable
    public final IconStyle getIconStyle() {
        return this.iconStyle;
    }

    public final void setIconStyle(@Nullable IconStyle iconStyle) {
        this.iconStyle = iconStyle;
    }

    @Nullable
    public final LabelStyle getLabelStyle() {
        return this.labelStyle;
    }

    public final void setLabelStyle(@Nullable LabelStyle labelStyle) {
        this.labelStyle = labelStyle;
    }

    @Nullable
    public final LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public final void setLineStyle(@Nullable LineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    @Nullable
    public final String getIconStyleIconUrl() {
        String string;
        if (this.iconStyle == null) {
            string = null;
        } else {
            IconStyle iconStyle = this.iconStyle;
            Intrinsics.checkNotNull((Object)iconStyle);
            string = iconStyle.getIconHref();
        }
        return string;
    }

    public GeoDataStyle(@Nullable String name) {
        this();
        if (name != null) {
            this.name = name;
        }
    }

    public final void setIconStyle(@NotNull String iconUrl, float scale) {
        Intrinsics.checkNotNullParameter((Object)iconUrl, (String)"iconUrl");
        this.setIconStyle(iconUrl, -1, 0.0f, scale);
    }

    /*
     * WARNING - void declaration
     */
    public final void setIconStyle(@NotNull String iconUrl, int color, float heading, float scale) {
        void $this$setIconStyle_u24lambda_u240;
        IconStyle iconStyle;
        Intrinsics.checkNotNullParameter((Object)iconUrl, (String)"iconUrl");
        IconStyle iconStyle2 = iconStyle = new IconStyle();
        GeoDataStyle geoDataStyle = this;
        boolean bl = false;
        $this$setIconStyle_u24lambda_u240.setIconHref(iconUrl);
        $this$setIconStyle_u24lambda_u240.setColor(color);
        $this$setIconStyle_u24lambda_u240.setHeading(heading);
        $this$setIconStyle_u24lambda_u240.setScale(scale);
        geoDataStyle.iconStyle = iconStyle;
        this.setIconStyleHotSpot(0);
    }

    public final void setIconStyleHotSpot(int hotspot) {
        KmlVec2 kmlVec2;
        switch (hotspot) {
            case 1: {
                kmlVec2 = new KmlVec2(0.0, KmlVec2.Units.FRACTION, 1.0, KmlVec2.Units.FRACTION);
                break;
            }
            case 2: {
                kmlVec2 = new KmlVec2(0.5, KmlVec2.Units.FRACTION, 0.5, KmlVec2.Units.FRACTION);
                break;
            }
            default: {
                kmlVec2 = Companion.generateDefaultHotSpot();
            }
        }
        this.setIconStyleHotSpot(kmlVec2);
    }

    public final void setIconStyleHotSpot(@NotNull KmlVec2 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"vec2");
        if (this.iconStyle == null) {
            String tag$iv = TAG;
            LogCategory category$iv = LogCategory.Companion.getCORE();
            Throwable ex$iv = null;
            boolean $i$f$logW = false;
            if (category$iv.getMinPriority().getPriority() <= LogPriority.WARN.getPriority()) {
                String string = Log.INSTANCE.getValidTag(category$iv, tag$iv);
                boolean bl = false;
                String string2 = "setIconStyleHotSpot(" + vec2 + "), initialize IconStyle before settings hotSpot or hotSpot is null!";
                Logger.w(ex$iv, (String)string, (String)string2, (Object[])new Object[0]);
            }
            return;
        }
        IconStyle iconStyle = this.iconStyle;
        Intrinsics.checkNotNull((Object)iconStyle);
        iconStyle.setHotSpot(vec2);
    }

    public final void setLineStyle(int color, float width) {
        if (this.lineStyle == null) {
            this.lineStyle = new LineStyle();
        }
        LineStyle lineStyle = this.lineStyle;
        Intrinsics.checkNotNull((Object)lineStyle);
        lineStyle.setColorBase(color);
        LineStyle lineStyle2 = this.lineStyle;
        Intrinsics.checkNotNull((Object)lineStyle2);
        lineStyle2.setWidth(width);
    }

    /*
     * WARNING - void declaration
     */
    public final void setPolyStyle(int color) {
        if (this.lineStyle == null) {
            void $this$setPolyStyle_u24lambda_u242;
            LineStyle lineStyle;
            LineStyle lineStyle2 = lineStyle = new LineStyle();
            GeoDataStyle geoDataStyle = this;
            boolean bl = false;
            $this$setPolyStyle_u24lambda_u242.setDrawBase(false);
            geoDataStyle.lineStyle = lineStyle;
        }
        LineStyle lineStyle = this.lineStyle;
        if (lineStyle != null) {
            lineStyle.setDrawFill(true);
        }
        LineStyle lineStyle3 = this.lineStyle;
        if (lineStyle3 != null) {
            lineStyle3.setColorFill(color);
        }
    }

    @Override
    protected int getVersion() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        String string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.id = string;
        String string2 = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dr.readString()");
        this.name = string2;
        if (version == 0) {
            return;
        }
        LineStyleOld lineStyleOld = null;
        PolyStyleOld polyStyleOld = null;
        try {
            if (dr.readBoolean()) {
                Storable.Companion.readUnknownObject(dr);
            }
            if (dr.readBoolean()) {
                this.iconStyle = Storable.Companion.read(IconStyle.class, dr);
            }
            if (dr.readBoolean()) {
                this.labelStyle = Storable.Companion.read(LabelStyle.class, dr);
            }
            if (dr.readBoolean()) {
                lineStyleOld = Storable.Companion.read(LineStyleOld.class, dr);
            }
            if (dr.readBoolean()) {
                Storable.Companion.readUnknownObject(dr);
            }
            if (dr.readBoolean()) {
                polyStyleOld = Storable.Companion.read(PolyStyleOld.class, dr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lineStyle = OldStyleHelper.INSTANCE.convertToNewLineStyle(lineStyleOld, polyStyleOld);
        if (version >= 2 && dr.readBoolean()) {
            void $this$readObject_u24lambda_u243;
            LineStyle lineStyle;
            LineStyle lineStyle2 = lineStyle = new LineStyle();
            GeoDataStyle geoDataStyle = this;
            boolean bl = false;
            $this$readObject_u24lambda_u243.read(dr);
            geoDataStyle.lineStyle = lineStyle;
        }
    }

    @Override
    protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeString(this.id);
        dw.writeString(this.name);
        dw.writeBoolean(false);
        if (this.iconStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            IconStyle iconStyle = this.iconStyle;
            Intrinsics.checkNotNull((Object)iconStyle);
            iconStyle.write(dw);
        }
        if (this.labelStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            LabelStyle labelStyle = this.labelStyle;
            Intrinsics.checkNotNull((Object)labelStyle);
            labelStyle.write(dw);
        }
        dw.writeBoolean(false);
        dw.writeBoolean(false);
        dw.writeBoolean(false);
        if (this.lineStyle == null) {
            dw.writeBoolean(false);
        } else {
            dw.writeBoolean(true);
            LineStyle lineStyle = this.lineStyle;
            Intrinsics.checkNotNull((Object)lineStyle);
            lineStyle.write(dw);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Llocus/api/objects/styles/GeoDataStyle$Companion;", "", "()V", "BLACK", "", "COLOR_DEFAULT", "HOTSPOT_BOTTOM_CENTER", "HOTSPOT_CENTER_CENTER", "HOTSPOT_TOP_LEFT", "TAG", "", "WHITE", "generateDefaultHotSpot", "Llocus/api/objects/extra/KmlVec2;", "locus-api-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KmlVec2 generateDefaultHotSpot() {
            return new KmlVec2(0.5, KmlVec2.Units.FRACTION, 0.0, KmlVec2.Units.FRACTION);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

