/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u001eH\u0007J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018\u00a8\u0006("}, d2={"Llocus/api/objects/extra/KmlVec2;", "", "()V", "x", "", "xUnits", "Llocus/api/objects/extra/KmlVec2$Units;", "y", "yUnits", "(DLlocus/api/objects/extra/KmlVec2$Units;DLlocus/api/objects/extra/KmlVec2$Units;)V", "asXmlText", "", "getAsXmlText", "()Ljava/lang/String;", "copy", "getCopy", "()Llocus/api/objects/extra/KmlVec2;", "getX", "()D", "setX", "(D)V", "getXUnits", "()Llocus/api/objects/extra/KmlVec2$Units;", "setXUnits", "(Llocus/api/objects/extra/KmlVec2$Units;)V", "getY", "setY", "getYUnits", "setYUnits", "getCoords", "", "sourceWidth", "sourceHeight", "result", "write", "", "dw", "Llocus/api/utils/DataWriterBigEndian;", "Companion", "Units", "locus-api-core"})
public final class KmlVec2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    @NotNull
    private Units xUnits;
    private double y;
    @NotNull
    private Units yUnits;

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    @NotNull
    public final Units getXUnits() {
        return this.xUnits;
    }

    public final void setXUnits(@NotNull Units units) {
        Intrinsics.checkNotNullParameter((Object)((Object)units), (String)"<set-?>");
        this.xUnits = units;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    @NotNull
    public final Units getYUnits() {
        return this.yUnits;
    }

    public final void setYUnits(@NotNull Units units) {
        Intrinsics.checkNotNullParameter((Object)((Object)units), (String)"<set-?>");
        this.yUnits = units;
    }

    @NotNull
    public final String getAsXmlText() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t\t<hotSpot x=\"").append(this.x).append("\" y=\"").append(this.y).append("\"");
        sb.append(" xunits=\"");
        switch (WhenMappings.$EnumSwitchMapping$0[this.xUnits.ordinal()]) {
            case 1: {
                sb.append("fraction");
                break;
            }
            case 2: {
                sb.append("pixels");
                break;
            }
            case 3: {
                sb.append("insetPixels");
            }
        }
        sb.append("\"");
        sb.append(" yunits=\"");
        switch (WhenMappings.$EnumSwitchMapping$0[this.yUnits.ordinal()]) {
            case 1: {
                sb.append("fraction");
                break;
            }
            case 2: {
                sb.append("pixels");
                break;
            }
            case 3: {
                sb.append("insetPixels");
            }
        }
        sb.append("\"");
        sb.append(" />");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final KmlVec2 getCopy() {
        KmlVec2 vec = new KmlVec2();
        vec.x = this.x;
        vec.xUnits = this.xUnits;
        vec.y = this.y;
        vec.yUnits = this.yUnits;
        return vec;
    }

    public KmlVec2() {
        this.x = 0.5;
        this.xUnits = Units.FRACTION;
        this.y = 0.5;
        this.yUnits = Units.FRACTION;
    }

    public KmlVec2(double x, @NotNull Units xUnits, double y, @NotNull Units yUnits) {
        Intrinsics.checkNotNullParameter((Object)((Object)xUnits), (String)"xUnits");
        Intrinsics.checkNotNullParameter((Object)((Object)yUnits), (String)"yUnits");
        this.x = 0.5;
        this.xUnits = Units.FRACTION;
        this.y = 0.5;
        this.yUnits = Units.FRACTION;
        this.x = x;
        this.xUnits = xUnits;
        this.y = y;
        this.yUnits = yUnits;
    }

    @JvmOverloads
    @NotNull
    public final double[] getCoords(double sourceWidth, double sourceHeight, @Nullable double[] result) {
        double[] resultNew = result;
        if (resultNew == null || resultNew.length != 2) {
            resultNew = new double[2];
        }
        if (this.xUnits == Units.FRACTION) {
            resultNew[0] = sourceWidth * this.x;
        } else if (this.xUnits == Units.PIXELS) {
            resultNew[0] = this.x;
        } else if (this.xUnits == Units.INSET_PIXELS) {
            resultNew[0] = sourceWidth - this.x;
        }
        if (this.yUnits == Units.FRACTION) {
            resultNew[1] = sourceHeight * (1.0 - this.y);
        } else if (this.yUnits == Units.PIXELS) {
            resultNew[1] = sourceHeight - this.y;
        } else if (this.yUnits == Units.INSET_PIXELS) {
            resultNew[1] = this.y;
        }
        return resultNew;
    }

    public static /* synthetic */ double[] getCoords$default(KmlVec2 kmlVec2, double d, double d2, double[] dArray, int n, Object object) {
        if ((n & 4) != 0) {
            dArray = new double[2];
        }
        return kmlVec2.getCoords(d, d2, dArray);
    }

    public final void write(@NotNull DataWriterBigEndian dw) {
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeDouble(this.x);
        dw.writeInt(this.xUnits.ordinal());
        dw.writeDouble(this.y);
        dw.writeInt(this.yUnits.ordinal());
    }

    @JvmOverloads
    @NotNull
    public final double[] getCoords(double sourceWidth, double sourceHeight) {
        return KmlVec2.getCoords$default(this, sourceWidth, sourceHeight, null, 4, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Llocus/api/objects/extra/KmlVec2$Companion;", "", "()V", "read", "Llocus/api/objects/extra/KmlVec2;", "dr", "Llocus/api/utils/DataReaderBigEndian;", "locus-api-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KmlVec2 read(@NotNull DataReaderBigEndian dr) {
            Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
            KmlVec2 vec = new KmlVec2();
            vec.setX(dr.readDouble());
            vec.setXUnits(Units.values()[dr.readInt()]);
            vec.setY(dr.readDouble());
            vec.setYUnits(Units.values()[dr.readInt()]);
            return vec;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Llocus/api/objects/extra/KmlVec2$Units;", "", "(Ljava/lang/String;I)V", "FRACTION", "PIXELS", "INSET_PIXELS", "locus-api-core"})
    public static final class Units
    extends Enum<Units> {
        public static final /* enum */ Units FRACTION = new Units();
        public static final /* enum */ Units PIXELS = new Units();
        public static final /* enum */ Units INSET_PIXELS = new Units();
        private static final /* synthetic */ Units[] $VALUES;

        public static Units[] values() {
            return (Units[])$VALUES.clone();
        }

        public static Units valueOf(String value) {
            return Enum.valueOf(Units.class, value);
        }

        static {
            $VALUES = unitsArray = new Units[]{Units.FRACTION, Units.PIXELS, Units.INSET_PIXELS};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Units.values().length];
            try {
                nArray[Units.FRACTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Units.PIXELS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Units.INSET_PIXELS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

