/*
 * Decompiled with CFR 0.152.
 */
package locus.api.utils;

import com.asamm.logger.Logger;
import com.asamm.loggerV2.Log;
import com.asamm.loggerV2.LogCategory;
import com.asamm.loggerV2.LogPriority;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0001J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u0001J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0001J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0001J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u001aH\u0007J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0001J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u0001J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u0004J\u001c\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010!\u001a\u00020\u0004H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Llocus/api/utils/Utils;", "", "()V", "NEW_LINE", "", "kotlin.jvm.PlatformType", "TAG", "closeStream", "", "stream", "Ljava/io/Closeable;", "doBytesToString", "data", "", "doStringToBytes", "text", "isEmpty", "", "str", "", "parseBoolean", "parseDouble", "", "parseFloat", "", "parseInt", "", "defValue", "parseInteger", "parseLong", "", "toString", "obj", "prefix", "locus-api-core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nlocus/api/utils/Utils\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 Log.kt\ncom/asamm/loggerV2/LogKt\n*L\n1#1,197:1\n107#2:198\n79#2,22:199\n107#2:221\n79#2,22:222\n107#2:244\n79#2,22:245\n107#2:267\n79#2,22:268\n107#2:290\n79#2,22:291\n87#3,14:313\n87#3,14:327\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nlocus/api/utils/Utils\n*L\n64#1:198\n64#1:199,22\n76#1:221\n76#1:222,22\n88#1:244\n88#1:245,22\n100#1:267\n100#1:268,22\n113#1:290\n113#1:291,22\n124#1:313,14\n133#1:327,14\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static final String TAG = "Utils";
    private static final String NEW_LINE = System.getProperty("line.separator");

    private Utils() {
    }

    public final boolean parseBoolean(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.parseBoolean(data.toString());
    }

    public final boolean parseBoolean(@NotNull String data) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            String string = data.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"true", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)data, (CharSequence)"1", (boolean)false, (int)2, null);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final int parseInt(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return Utils.parseInt$default(this, data.toString(), 0, 2, null);
    }

    @JvmOverloads
    public final int parseInt(@NotNull String data, int defValue) {
        int n;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            String $this$trim$iv = data;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            n = Integer.parseInt(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        }
        catch (Exception e) {
            n = defValue;
        }
        return n;
    }

    public static /* synthetic */ int parseInt$default(Utils utils, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return utils.parseInt(string, n);
    }

    public final int parseInteger(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.parseInteger(data.toString());
    }

    public final int parseInteger(@NotNull String data) {
        int n;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            String $this$trim$iv = data;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            Integer n2 = Integer.valueOf(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"{\n            Integer.va\u2026 { it <= ' ' })\n        }");
            n = ((Number)n2).intValue();
        }
        catch (Exception e) {
            n = 0;
        }
        return n;
    }

    public final long parseLong(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.parseLong(data.toString());
    }

    public final long parseLong(@NotNull String data) {
        long l;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            String $this$trim$iv = data;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            l = Long.parseLong(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        }
        catch (Exception e) {
            l = 0L;
        }
        return l;
    }

    public final float parseFloat(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.parseFloat(data.toString());
    }

    public final float parseFloat(@NotNull String data) {
        float f;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            String $this$trim$iv = data;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            f = Float.parseFloat(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        }
        catch (Exception e) {
            f = 0.0f;
        }
        return f;
    }

    public final double parseDouble(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.parseDouble(data.toString());
    }

    public final double parseDouble(@NotNull String data) {
        double d;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            String $this$trim$iv = data;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            d = Double.parseDouble(StringsKt.replace$default((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (String)",", (String)".", (boolean)false, (int)4, null));
        }
        catch (Exception e) {
            d = 0.0;
        }
        return d;
    }

    @NotNull
    public final byte[] doStringToBytes(@NotNull String text) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray2 = text.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byArray = byArray2;
        }
        catch (Exception e) {
            String tag$iv = TAG;
            LogCategory category$iv = LogCategory.Companion.getCORE();
            boolean $i$f$logE = false;
            if (category$iv.getMinPriority().getPriority() <= LogPriority.ERROR.getPriority()) {
                String string = Log.INSTANCE.getValidTag(category$iv, tag$iv);
                boolean bl = false;
                String string2 = "doStringToBytes(" + text + ')';
                Logger.e((Throwable)e, (String)string, (String)string2, (Object[])new Object[0]);
            }
            byArray = new byte[]{};
        }
        return byArray;
    }

    @NotNull
    public final String doBytesToString(@NotNull byte[] data) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
            object = charset;
            object = new String(data, (Charset)object);
        }
        catch (Exception e) {
            String tag$iv = TAG;
            LogCategory category$iv = LogCategory.Companion.getCORE();
            boolean $i$f$logE = false;
            if (category$iv.getMinPriority().getPriority() <= LogPriority.ERROR.getPriority()) {
                String string = Log.INSTANCE.getValidTag(category$iv, tag$iv);
                boolean bl = false;
                String string2 = "doBytesToString(" + data + ')';
                Logger.e((Throwable)e, (String)string, (String)string2, (Object[])new Object[0]);
            }
            object = "";
        }
        return object;
    }

    public final void closeStream(@Nullable Closeable stream) {
        try {
            Closeable closeable = stream;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            System.err.println("closeStream(" + stream + "), e:" + e);
            e.printStackTrace();
        }
    }

    public final boolean isEmpty(@Nullable CharSequence str) {
        return str == null || str.length() == 0;
    }

    @JvmOverloads
    @NotNull
    public final String toString(@Nullable Object obj, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        StringBuilder result = new StringBuilder();
        result.append(prefix);
        if (obj == null) {
            result.append(" empty object!");
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
            return string;
        }
        result.append(obj.getClass().getName()).append(" [").append(NEW_LINE);
        Field[] fields = obj.getClass().getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fields, (String)"fields");
        for (Field field : fields) {
            result.append(prefix).append("    ");
            try {
                result.append(field.getName());
                result.append(": ");
                field.setAccessible(true);
                result.append(field.get(obj));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            result.append(NEW_LINE);
        }
        result.append(prefix).append("]");
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    public static /* synthetic */ String toString$default(Utils utils, Object object, String string, int n, Object object2) {
        if ((n & 2) != 0) {
            string = "";
        }
        return utils.toString(object, string);
    }

    @JvmOverloads
    public final int parseInt(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return Utils.parseInt$default(this, data, 0, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String toString(@Nullable Object obj) {
        return Utils.toString$default(this, obj, null, 2, null);
    }
}

