/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import com.asamm.logger.Logger;
import com.asamm.loggerV2.Log;
import com.asamm.loggerV2.LogCategory;
import com.asamm.loggerV2.LogPriority;
import java.io.IOException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import locus.api.objects.Storable;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.LocationCompute;
import locus.api.utils.SparseArrayCompat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b]\n\u0002\u0010\u0014\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00af\u00012\u00020\u0001:\u0004\u00af\u0001\u00b0\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0086\u0001\u001a\u00020\n2\u0007\u0010\u0087\u0001\u001a\u00020\u0000J\u0011\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u0087\u0001\u001a\u00020\u0000J\u0010\u0010\u008a\u0001\u001a\u00020\n2\u0007\u0010\u0087\u0001\u001a\u00020\u0000J\u001a\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u00032\u0007\u0010\u008c\u0001\u001a\u00020%H\u0002\u00a2\u0006\u0003\u0010\u008d\u0001J\u001a\u0010\u008e\u0001\u001a\u0004\u0018\u00010\n2\u0007\u0010\u008c\u0001\u001a\u00020%H\u0002\u00a2\u0006\u0003\u0010\u008f\u0001J\u001a\u0010\u0090\u0001\u001a\u0004\u0018\u00010%2\u0007\u0010\u008c\u0001\u001a\u00020%H\u0002\u00a2\u0006\u0003\u0010\u0091\u0001J\u001a\u0010\u0092\u0001\u001a\u0004\u0018\u00010'2\u0007\u0010\u008c\u0001\u001a\u00020%H\u0002\u00a2\u0006\u0003\u0010\u0093\u0001J\u001a\u0010\u0094\u0001\u001a\u0004\u0018\u00010)2\u0007\u0010\u008c\u0001\u001a\u00020%H\u0002\u00a2\u0006\u0003\u0010\u0095\u0001J\u0014\u0010\u0096\u0001\u001a\u0004\u0018\u00010+2\u0007\u0010\u008c\u0001\u001a\u00020%H\u0002J\t\u0010\u0097\u0001\u001a\u00020%H\u0014J\u001d\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u009a\u0001\u001a\u00020%2\b\u0010\u009b\u0001\u001a\u00030\u009c\u0001H\u0014J\b\u0010\u009d\u0001\u001a\u00030\u0099\u0001J\b\u0010\u009e\u0001\u001a\u00030\u0099\u0001J\u0010\u0010\u009f\u0001\u001a\u00030\u0099\u00012\u0006\u0010\u0006\u001a\u00020\u0000J#\u0010\u00a0\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u008c\u0001\u001a\u00020%2\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0003\u0010\u00a1\u0001J#\u0010\u00a2\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u008c\u0001\u001a\u00020%2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0003\u0010\u00a3\u0001J#\u0010\u00a4\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u008c\u0001\u001a\u00020%2\b\u0010\t\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0003\u0010\u00a5\u0001J#\u0010\u00a6\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u008c\u0001\u001a\u00020%2\b\u0010\t\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0003\u0010\u00a7\u0001J#\u0010\u00a8\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u008c\u0001\u001a\u00020%2\b\u0010\t\u001a\u0004\u0018\u00010)H\u0002\u00a2\u0006\u0003\u0010\u00a9\u0001J\u001d\u0010\u00aa\u0001\u001a\u00030\u0099\u00012\u0007\u0010\u008c\u0001\u001a\u00020%2\b\u0010\t\u001a\u0004\u0018\u00010+H\u0002J\t\u0010\u00ab\u0001\u001a\u00020+H\u0016J\u0014\u0010\u00ac\u0001\u001a\u00030\u0099\u00012\b\u0010\u00ad\u0001\u001a\u00030\u00ae\u0001H\u0014R(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR(\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R(\u0010\u001b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\r\"\u0004\b\u001d\u0010\u000fR(\u0010\u001e\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\r\"\u0004\b \u0010\u000fR\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010,\u001a\u0004\u0018\u00010%2\b\u0010\t\u001a\u0004\u0018\u00010%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R(\u00101\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010\r\"\u0004\b3\u0010\u000fR(\u00104\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\r\"\u0004\b6\u0010\u000fR(\u00107\u001a\u0004\u0018\u00010+2\b\u0010\t\u001a\u0004\u0018\u00010+8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R(\u0010<\u001a\u0004\u0018\u00010'2\b\u0010\t\u001a\u0004\u0018\u00010'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R(\u0010A\u001a\u0004\u0018\u00010'2\b\u0010\t\u001a\u0004\u0018\u00010'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010>\"\u0004\bC\u0010@R(\u0010D\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010\r\"\u0004\bF\u0010\u000fR(\u0010G\u001a\u0004\u0018\u00010)2\b\u0010\t\u001a\u0004\u0018\u00010)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR(\u0010L\u001a\u0004\u0018\u00010)2\b\u0010\t\u001a\u0004\u0018\u00010)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010I\"\u0004\bN\u0010KR(\u0010O\u001a\u0004\u0018\u00010)2\b\u0010\t\u001a\u0004\u0018\u00010)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010I\"\u0004\bQ\u0010KR(\u0010R\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bS\u0010\r\"\u0004\bT\u0010\u000fR\u001a\u0010U\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR$\u0010Z\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R(\u0010_\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b`\u0010\u0015\"\u0004\ba\u0010\u0017R$\u0010b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010\\\"\u0004\bd\u0010^R(\u0010e\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bf\u0010\u0015\"\u0004\bg\u0010\u0017R\u001c\u0010h\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u00109\"\u0004\bj\u0010;R(\u0010k\u001a\u0004\u0018\u00010)2\b\u0010\t\u001a\u0004\u0018\u00010)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bl\u0010I\"\u0004\bm\u0010KR(\u0010n\u001a\u0004\u0018\u00010)2\b\u0010\t\u001a\u0004\u0018\u00010)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bo\u0010I\"\u0004\bp\u0010KR(\u0010q\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\br\u0010\r\"\u0004\bs\u0010\u000fR(\u0010t\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bu\u0010\r\"\u0004\bv\u0010\u000fR(\u0010w\u001a\u0004\u0018\u00010%2\b\u0010\t\u001a\u0004\u0018\u00010%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bx\u0010.\"\u0004\by\u00100R(\u0010z\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b{\u0010\r\"\u0004\b|\u0010\u000fR(\u0010}\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b~\u0010\r\"\u0004\b\u007f\u0010\u000fR\u001f\u0010\u0080\u0001\u001a\u0004\u0018\u00010\n8FX\u0087\u0004\u00a2\u0006\u000e\u0012\u0005\b\u0081\u0001\u0010\b\u001a\u0005\b\u0082\u0001\u0010\rR\u001d\u0010\u0083\u0001\u001a\u00020'X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0084\u0001\u0010W\"\u0005\b\u0085\u0001\u0010Y\u00a8\u0006\u00b1\u0001"}, d2={"Llocus/api/objects/extra/Location;", "Llocus/api/objects/Storable;", "lat", "", "lon", "(DD)V", "loc", "(Llocus/api/objects/extra/Location;)V", "()V", "value", "", "accuracyHor", "getAccuracyHor", "()Ljava/lang/Float;", "setAccuracyHor", "(Ljava/lang/Float;)V", "accuracyVer", "getAccuracyVer", "setAccuracyVer", "altitude", "getAltitude", "()Ljava/lang/Double;", "setAltitude", "(Ljava/lang/Double;)V", "altitudeOriginal", "getAltitudeOriginal", "setAltitudeOriginal", "bearing", "getBearing", "setBearing", "extraAntennaPhaseCenterOffset", "getExtraAntennaPhaseCenterOffset", "setExtraAntennaPhaseCenterOffset", "extraDataDouble", "Llocus/api/utils/SparseArrayCompat;", "extraDataFloat", "extraDataInt", "", "extraDataLong", "", "extraDataShort", "", "extraDataString", "", "extraGsmSignalStrength", "getExtraGsmSignalStrength", "()Ljava/lang/Integer;", "setExtraGsmSignalStrength", "(Ljava/lang/Integer;)V", "extraPoleHeight", "getExtraPoleHeight", "setExtraPoleHeight", "gnssHdop", "getGnssHdop", "setGnssHdop", "gnssNtripMountPoint", "getGnssNtripMountPoint", "()Ljava/lang/String;", "setGnssNtripMountPoint", "(Ljava/lang/String;)V", "gnssObservationTimeEnd", "getGnssObservationTimeEnd", "()Ljava/lang/Long;", "setGnssObservationTimeEnd", "(Ljava/lang/Long;)V", "gnssObservationTimeStart", "getGnssObservationTimeStart", "setGnssObservationTimeStart", "gnssPdop", "getGnssPdop", "setGnssPdop", "gnssQuality", "getGnssQuality", "()Ljava/lang/Short;", "setGnssQuality", "(Ljava/lang/Short;)V", "gnssSatsUsed", "getGnssSatsUsed", "setGnssSatsUsed", "gnssSatsVisible", "getGnssSatsVisible", "setGnssSatsVisible", "gnssVdop", "getGnssVdop", "setGnssVdop", "id", "getId", "()J", "setId", "(J)V", "latitude", "getLatitude", "()D", "setLatitude", "(D)V", "latitudeOriginal", "getLatitudeOriginal", "setLatitudeOriginal", "longitude", "getLongitude", "setLongitude", "longitudeOriginal", "getLongitudeOriginal", "setLongitudeOriginal", "provider", "getProvider", "setProvider", "sensorCadence", "getSensorCadence", "setSensorCadence", "sensorHeartRate", "getSensorHeartRate", "setSensorHeartRate", "sensorPower", "getSensorPower", "setSensorPower", "sensorSpeed", "getSensorSpeed", "setSensorSpeed", "sensorStrides", "getSensorStrides", "setSensorStrides", "sensorTemperature", "getSensorTemperature", "setSensorTemperature", "speed", "getSpeed", "setSpeed", "speedOptimal", "getSpeedOptimal$annotations", "getSpeedOptimal", "time", "getTime", "setTime", "bearingTo", "dest", "distanceAndBearingTo", "", "distanceTo", "getDataDouble", "key", "(I)Ljava/lang/Double;", "getDataFloat", "(I)Ljava/lang/Float;", "getDataInt", "(I)Ljava/lang/Integer;", "getDataLong", "(I)Ljava/lang/Long;", "getDataShort", "(I)Ljava/lang/Short;", "getDataString", "getVersion", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "removeSensorAll", "saveCurrentToOriginal", "set", "setDataDouble", "(ILjava/lang/Double;)V", "setDataFloat", "(ILjava/lang/Float;)V", "setDataInt", "(ILjava/lang/Integer;)V", "setDataLong", "(ILjava/lang/Long;)V", "setDataShort", "(ILjava/lang/Short;)V", "setDataString", "toString", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "Companion", "ExtraSensor", "locus-api-core"})
@SourceDebugExtension(value={"SMAP\nLocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Location.kt\nlocus/api/objects/extra/Location\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Log.kt\ncom/asamm/loggerV2/LogKt\n*L\n1#1,1036:1\n1#2:1037\n87#3,14:1038\n87#3,14:1052\n*S KotlinDebug\n*F\n+ 1 Location.kt\nlocus/api/objects/extra/Location\n*L\n261#1:1038,14\n265#1:1052,14\n*E\n"})
public final class Location
extends Storable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SparseArrayCompat<Short> extraDataShort;
    @Nullable
    private SparseArrayCompat<Integer> extraDataInt;
    @Nullable
    private SparseArrayCompat<Long> extraDataLong;
    @Nullable
    private SparseArrayCompat<Float> extraDataFloat;
    @Nullable
    private SparseArrayCompat<Double> extraDataDouble;
    @Nullable
    private SparseArrayCompat<String> extraDataString;
    private long id;
    @Nullable
    private String provider;
    private long time;
    private double latitude;
    private double longitude;
    @NotNull
    private static final String TAG = "Location";
    private static final int EXTRA_KEY_ALTITUDE = 10;
    private static final int EXTRA_KEY_SPEED = 11;
    private static final int EXTRA_KEY_BEARING = 12;
    private static final int EXTRA_KEY_ACCURACY_HOR = 13;
    private static final int EXTRA_KEY_ACCURACY_VER = 14;
    private static final int EXTRA_KEY_ORIG_LATITUDE = 15;
    private static final int EXTRA_KEY_ORIG_LONGITUDE = 16;
    private static final int EXTRA_KEY_ORIG_ALTITUDE = 17;
    private static final int EXTRA_KEY_SENSOR_HEART_RATE = 20;
    private static final int EXTRA_KEY_SENSOR_CADENCE = 21;
    private static final int EXTRA_KEY_SENSOR_SPEED = 22;
    private static final int EXTRA_KEY_SENSOR_TEMPERATURE = 23;
    private static final int EXTRA_KEY_SENSOR_POWER = 24;
    private static final int EXTRA_KEY_SENSOR_STRIDES = 25;
    private static final int EXTRA_KEY_GNSS_QUALITY = 51;
    private static final int EXTRA_KEY_GNSS_HDOP = 52;
    private static final int EXTRA_KEY_GNSS_VDOP = 53;
    private static final int EXTRA_KEY_GNSS_PDOP = 54;
    private static final int EXTRA_KEY_GNSS_SATS_USED = 55;
    private static final int EXTRA_KEY_GNSS_SATS_VISIBLE = 56;
    private static final int EXTRA_KEY_GNSS_NTRIP_MOUNTPOINT = 57;
    private static final int EXTRA_KEY_GNSS_OBSERVATION_TIME_START = 58;
    private static final int EXTRA_KEY_GNSS_OBSERVATION_TIME_END = 59;
    private static final int EXTRA_KEY_EXTRA_ANTENNA_PHASE_CENTER_OFFSET = 70;
    private static final int EXTRA_KEY_EXTRA_POLE_HEIGHT = 71;
    private static final int EXTRA_KEY_EXTRA_GSM_SIGNAL_STRENGTH = 72;

    public Location() {
        this.id = -1L;
    }

    private final Short getDataShort(int key) {
        SparseArrayCompat<Short> sparseArrayCompat = this.extraDataShort;
        return sparseArrayCompat != null ? sparseArrayCompat.get(key) : null;
    }

    private final void setDataShort(int key, Short value) {
        block2: {
            block1: {
                if (value != null) break block1;
                SparseArrayCompat<Short> sparseArrayCompat = this.extraDataShort;
                if (sparseArrayCompat == null) break block2;
                sparseArrayCompat.remove(key);
                break block2;
            }
            if (this.extraDataShort == null) {
                this.extraDataShort = new SparseArrayCompat(0);
            }
            SparseArrayCompat<Short> sparseArrayCompat = this.extraDataShort;
            if (sparseArrayCompat == null) break block2;
            sparseArrayCompat.put(key, value);
        }
    }

    private final Integer getDataInt(int key) {
        SparseArrayCompat<Integer> sparseArrayCompat = this.extraDataInt;
        return sparseArrayCompat != null ? sparseArrayCompat.get(key) : null;
    }

    private final void setDataInt(int key, Integer value) {
        block2: {
            block1: {
                if (value != null) break block1;
                SparseArrayCompat<Integer> sparseArrayCompat = this.extraDataInt;
                if (sparseArrayCompat == null) break block2;
                sparseArrayCompat.remove(key);
                break block2;
            }
            if (this.extraDataInt == null) {
                this.extraDataInt = new SparseArrayCompat(0);
            }
            SparseArrayCompat<Integer> sparseArrayCompat = this.extraDataInt;
            if (sparseArrayCompat == null) break block2;
            sparseArrayCompat.put(key, value);
        }
    }

    private final Long getDataLong(int key) {
        SparseArrayCompat<Long> sparseArrayCompat = this.extraDataLong;
        return sparseArrayCompat != null ? sparseArrayCompat.get(key) : null;
    }

    private final void setDataLong(int key, Long value) {
        block2: {
            block1: {
                if (value != null) break block1;
                SparseArrayCompat<Long> sparseArrayCompat = this.extraDataLong;
                if (sparseArrayCompat == null) break block2;
                sparseArrayCompat.remove(key);
                break block2;
            }
            if (this.extraDataLong == null) {
                this.extraDataLong = new SparseArrayCompat(0);
            }
            SparseArrayCompat<Long> sparseArrayCompat = this.extraDataLong;
            if (sparseArrayCompat == null) break block2;
            sparseArrayCompat.put(key, value);
        }
    }

    private final Float getDataFloat(int key) {
        SparseArrayCompat<Float> sparseArrayCompat = this.extraDataFloat;
        return sparseArrayCompat != null ? sparseArrayCompat.get(key) : null;
    }

    private final void setDataFloat(int key, Float value) {
        block2: {
            block1: {
                if (value != null) break block1;
                SparseArrayCompat<Float> sparseArrayCompat = this.extraDataFloat;
                if (sparseArrayCompat == null) break block2;
                sparseArrayCompat.remove(key);
                break block2;
            }
            if (this.extraDataFloat == null) {
                this.extraDataFloat = new SparseArrayCompat(0);
            }
            SparseArrayCompat<Float> sparseArrayCompat = this.extraDataFloat;
            if (sparseArrayCompat == null) break block2;
            sparseArrayCompat.put(key, value);
        }
    }

    private final Double getDataDouble(int key) {
        SparseArrayCompat<Double> sparseArrayCompat = this.extraDataDouble;
        return sparseArrayCompat != null ? sparseArrayCompat.get(key) : null;
    }

    private final void setDataDouble(int key, Double value) {
        block2: {
            block1: {
                if (value != null) break block1;
                SparseArrayCompat<Double> sparseArrayCompat = this.extraDataDouble;
                if (sparseArrayCompat == null) break block2;
                sparseArrayCompat.remove(key);
                break block2;
            }
            if (this.extraDataDouble == null) {
                this.extraDataDouble = new SparseArrayCompat(0);
            }
            SparseArrayCompat<Double> sparseArrayCompat = this.extraDataDouble;
            if (sparseArrayCompat == null) break block2;
            sparseArrayCompat.put(key, value);
        }
    }

    private final String getDataString(int key) {
        SparseArrayCompat<String> sparseArrayCompat = this.extraDataString;
        return sparseArrayCompat != null ? sparseArrayCompat.get(key) : null;
    }

    private final void setDataString(int key, String value) {
        block2: {
            block1: {
                if (value != null) break block1;
                SparseArrayCompat<String> sparseArrayCompat = this.extraDataString;
                if (sparseArrayCompat == null) break block2;
                sparseArrayCompat.remove(key);
                break block2;
            }
            if (this.extraDataString == null) {
                this.extraDataString = new SparseArrayCompat(0);
            }
            SparseArrayCompat<String> sparseArrayCompat = this.extraDataString;
            if (sparseArrayCompat == null) break block2;
            sparseArrayCompat.put(key, value);
        }
    }

    public Location(double lat, double lon) {
        this();
        this.setLatitude(lat);
        this.setLongitude(lon);
    }

    public Location(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this();
        this.set(loc);
    }

    public final void set(@NotNull Location loc) {
        int i;
        int n;
        SparseArrayCompat<Short> sparseArrayCompat;
        SparseArrayCompat<Short> it;
        SparseArrayCompat<Short> sparseArrayCompat2;
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this.id = loc.id;
        this.provider = loc.provider;
        this.time = loc.time;
        this.setLatitude(loc.latitude);
        this.setLongitude(loc.longitude);
        SparseArrayCompat<Short> sparseArrayCompat3 = this.extraDataShort;
        if (sparseArrayCompat3 != null) {
            sparseArrayCompat3.clear();
        }
        SparseArrayCompat<Object> sparseArrayCompat4 = loc.extraDataShort;
        if (sparseArrayCompat4 != null) {
            it = sparseArrayCompat2 = sparseArrayCompat4;
            boolean bl = false;
            SparseArrayCompat<Short> sparseArrayCompat5 = sparseArrayCompat = !it.isEmpty() ? sparseArrayCompat2 : null;
            if (sparseArrayCompat != null) {
                it = sparseArrayCompat;
                boolean bl2 = false;
                n = it.size();
                for (i = 0; i < n; ++i) {
                    this.setDataShort(it.keyAt(i), it.valueAt(i));
                }
            }
        }
        SparseArrayCompat<Integer> sparseArrayCompat6 = this.extraDataInt;
        if (sparseArrayCompat6 != null) {
            sparseArrayCompat6.clear();
        }
        sparseArrayCompat4 = loc.extraDataInt;
        if (sparseArrayCompat4 != null) {
            it = sparseArrayCompat2 = sparseArrayCompat4;
            boolean bl = false;
            SparseArrayCompat<Short> sparseArrayCompat7 = sparseArrayCompat = !it.isEmpty() ? sparseArrayCompat2 : null;
            if (sparseArrayCompat != null) {
                it = sparseArrayCompat;
                boolean bl3 = false;
                n = it.size();
                for (i = 0; i < n; ++i) {
                    this.setDataInt(it.keyAt(i), (Integer)((Object)it.valueAt(i)));
                }
            }
        }
        SparseArrayCompat<Long> sparseArrayCompat8 = this.extraDataLong;
        if (sparseArrayCompat8 != null) {
            sparseArrayCompat8.clear();
        }
        sparseArrayCompat4 = loc.extraDataLong;
        if (sparseArrayCompat4 != null) {
            it = sparseArrayCompat2 = sparseArrayCompat4;
            boolean bl = false;
            SparseArrayCompat<Short> sparseArrayCompat9 = sparseArrayCompat = !it.isEmpty() ? sparseArrayCompat2 : null;
            if (sparseArrayCompat != null) {
                it = sparseArrayCompat;
                boolean bl4 = false;
                n = it.size();
                for (i = 0; i < n; ++i) {
                    this.setDataLong(it.keyAt(i), (Long)((Object)it.valueAt(i)));
                }
            }
        }
        SparseArrayCompat<Float> sparseArrayCompat10 = this.extraDataFloat;
        if (sparseArrayCompat10 != null) {
            sparseArrayCompat10.clear();
        }
        sparseArrayCompat4 = loc.extraDataFloat;
        if (sparseArrayCompat4 != null) {
            it = sparseArrayCompat2 = sparseArrayCompat4;
            boolean bl = false;
            SparseArrayCompat<Short> sparseArrayCompat11 = sparseArrayCompat = !it.isEmpty() ? sparseArrayCompat2 : null;
            if (sparseArrayCompat != null) {
                it = sparseArrayCompat;
                boolean bl5 = false;
                n = it.size();
                for (i = 0; i < n; ++i) {
                    this.setDataFloat(it.keyAt(i), (Float)((Object)it.valueAt(i)));
                }
            }
        }
        SparseArrayCompat<Double> sparseArrayCompat12 = this.extraDataDouble;
        if (sparseArrayCompat12 != null) {
            sparseArrayCompat12.clear();
        }
        sparseArrayCompat4 = loc.extraDataDouble;
        if (sparseArrayCompat4 != null) {
            it = sparseArrayCompat2 = sparseArrayCompat4;
            boolean bl = false;
            SparseArrayCompat<Short> sparseArrayCompat13 = sparseArrayCompat = !it.isEmpty() ? sparseArrayCompat2 : null;
            if (sparseArrayCompat != null) {
                it = sparseArrayCompat;
                boolean bl6 = false;
                n = it.size();
                for (i = 0; i < n; ++i) {
                    this.setDataDouble(it.keyAt(i), (Double)((Object)it.valueAt(i)));
                }
            }
        }
        SparseArrayCompat<String> sparseArrayCompat14 = this.extraDataString;
        if (sparseArrayCompat14 != null) {
            sparseArrayCompat14.clear();
        }
        sparseArrayCompat4 = loc.extraDataString;
        if (sparseArrayCompat4 != null) {
            it = sparseArrayCompat2 = sparseArrayCompat4;
            boolean bl = false;
            SparseArrayCompat<Short> sparseArrayCompat15 = sparseArrayCompat = !it.isEmpty() ? sparseArrayCompat2 : null;
            if (sparseArrayCompat != null) {
                it = sparseArrayCompat;
                boolean bl7 = false;
                n = it.size();
                for (i = 0; i < n; ++i) {
                    this.setDataString(it.keyAt(i), (String)((Object)it.valueAt(i)));
                }
            }
        }
    }

    public final long getId() {
        return this.id;
    }

    public final void setId(long l) {
        this.id = l;
    }

    @Nullable
    public final String getProvider() {
        return this.provider;
    }

    public final void setProvider(@Nullable String string) {
        this.provider = string;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(double value) {
        double d;
        Location location = this;
        if (value < -90.0) {
            String tag$iv = TAG;
            LogCategory category$iv = LogCategory.Companion.getCORE();
            Throwable ex$iv = null;
            boolean $i$f$logE = false;
            if (category$iv.getMinPriority().getPriority() <= LogPriority.ERROR.getPriority()) {
                String string = Log.INSTANCE.getValidTag(category$iv, tag$iv);
                Location location2 = location;
                boolean bl = false;
                location = location2;
                String string2 = "setLatitude(" + value + "), invalid latitude";
                Logger.e(ex$iv, (String)string, (String)string2, (Object[])new Object[0]);
            }
            d = -90.0;
        } else if (value > 90.0) {
            String tag$iv = TAG;
            LogCategory category$iv = LogCategory.Companion.getCORE();
            Throwable ex$iv = null;
            boolean $i$f$logE = false;
            if (category$iv.getMinPriority().getPriority() <= LogPriority.ERROR.getPriority()) {
                String string = Log.INSTANCE.getValidTag(category$iv, tag$iv);
                Location location3 = location;
                boolean bl = false;
                location = location3;
                String string3 = "setLatitude(" + value + "), invalid latitude";
                Logger.e(ex$iv, (String)string, (String)string3, (Object[])new Object[0]);
            }
            d = 90.0;
        } else {
            d = value;
        }
        location.latitude = d;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(double value) {
        double newValue = value;
        if (newValue < -180.0) {
            newValue += 360.0;
        } else if (newValue > 180.0) {
            newValue -= 360.0;
        }
        this.longitude = newValue;
    }

    @Nullable
    public final Double getAltitude() {
        return this.getDataDouble(10);
    }

    public final void setAltitude(@Nullable Double value) {
        this.setDataDouble(10, value);
    }

    @Nullable
    public final Float getSpeed() {
        return this.getDataFloat(11);
    }

    public final void setSpeed(@Nullable Float value) {
        this.setDataFloat(11, value);
    }

    @Nullable
    public final Float getBearing() {
        return this.getDataFloat(12);
    }

    public final void setBearing(@Nullable Float value) {
        Float bearingNew = value;
        if (bearingNew != null) {
            while (bearingNew.floatValue() < 0.0f) {
                bearingNew = Float.valueOf(bearingNew.floatValue() + 360.0f);
            }
            while (bearingNew.floatValue() >= 360.0f) {
                bearingNew = Float.valueOf(bearingNew.floatValue() - 360.0f);
            }
        }
        this.setDataFloat(12, bearingNew);
    }

    @Nullable
    public final Float getAccuracyHor() {
        return this.getDataFloat(13);
    }

    public final void setAccuracyHor(@Nullable Float value) {
        this.setDataFloat(13, value);
    }

    @Nullable
    public final Float getAccuracyVer() {
        return this.getDataFloat(14);
    }

    public final void setAccuracyVer(@Nullable Float value) {
        this.setDataFloat(14, value);
    }

    @Nullable
    public final Double getLatitudeOriginal() {
        return this.getDataDouble(15);
    }

    public final void setLatitudeOriginal(@Nullable Double value) {
        this.setDataDouble(15, value);
    }

    @Nullable
    public final Double getLongitudeOriginal() {
        return this.getDataDouble(16);
    }

    public final void setLongitudeOriginal(@Nullable Double value) {
        this.setDataDouble(16, value);
    }

    @Nullable
    public final Double getAltitudeOriginal() {
        return this.getDataDouble(17);
    }

    public final void setAltitudeOriginal(@Nullable Double value) {
        this.setDataDouble(17, value);
    }

    @Nullable
    public final Short getSensorCadence() {
        return this.getDataShort(21);
    }

    public final void setSensorCadence(@Nullable Short value) {
        this.setDataShort(21, value);
    }

    @Nullable
    public final Short getSensorHeartRate() {
        return this.getDataShort(20);
    }

    public final void setSensorHeartRate(@Nullable Short value) {
        this.setDataShort(20, value);
    }

    @Nullable
    public final Float getSensorSpeed() {
        return this.getDataFloat(22);
    }

    public final void setSensorSpeed(@Nullable Float value) {
        this.setDataFloat(22, value);
    }

    @Nullable
    public final Float getSensorPower() {
        return this.getDataFloat(24);
    }

    public final void setSensorPower(@Nullable Float value) {
        this.setDataFloat(24, value);
    }

    @Nullable
    public final Integer getSensorStrides() {
        return this.getDataInt(25);
    }

    public final void setSensorStrides(@Nullable Integer value) {
        this.setDataInt(25, value);
    }

    @Nullable
    public final Float getSensorTemperature() {
        return this.getDataFloat(23);
    }

    public final void setSensorTemperature(@Nullable Float value) {
        this.setDataFloat(23, value);
    }

    @Nullable
    public final Short getGnssQuality() {
        return this.getDataShort(51);
    }

    public final void setGnssQuality(@Nullable Short value) {
        this.setDataShort(51, value);
    }

    @Nullable
    public final Float getGnssHdop() {
        return this.getDataFloat(52);
    }

    public final void setGnssHdop(@Nullable Float value) {
        this.setDataFloat(52, value);
    }

    @Nullable
    public final Float getGnssVdop() {
        return this.getDataFloat(53);
    }

    public final void setGnssVdop(@Nullable Float value) {
        this.setDataFloat(53, value);
    }

    @Nullable
    public final Float getGnssPdop() {
        return this.getDataFloat(54);
    }

    public final void setGnssPdop(@Nullable Float value) {
        this.setDataFloat(54, value);
    }

    @Nullable
    public final Short getGnssSatsUsed() {
        return this.getDataShort(55);
    }

    public final void setGnssSatsUsed(@Nullable Short value) {
        this.setDataShort(55, value);
    }

    @Nullable
    public final Short getGnssSatsVisible() {
        return this.getDataShort(56);
    }

    public final void setGnssSatsVisible(@Nullable Short value) {
        this.setDataShort(56, value);
    }

    @Nullable
    public final String getGnssNtripMountPoint() {
        return this.getDataString(57);
    }

    public final void setGnssNtripMountPoint(@Nullable String value) {
        this.setDataString(57, value);
    }

    @Nullable
    public final Long getGnssObservationTimeStart() {
        return this.getDataLong(58);
    }

    public final void setGnssObservationTimeStart(@Nullable Long value) {
        this.setDataLong(58, value);
    }

    @Nullable
    public final Long getGnssObservationTimeEnd() {
        return this.getDataLong(59);
    }

    public final void setGnssObservationTimeEnd(@Nullable Long value) {
        this.setDataLong(59, value);
    }

    @Nullable
    public final Float getExtraAntennaPhaseCenterOffset() {
        return this.getDataFloat(70);
    }

    public final void setExtraAntennaPhaseCenterOffset(@Nullable Float value) {
        this.setDataFloat(70, value);
    }

    @Nullable
    public final Float getExtraPoleHeight() {
        return this.getDataFloat(71);
    }

    public final void setExtraPoleHeight(@Nullable Float value) {
        this.setDataFloat(71, value);
    }

    @Nullable
    public final Integer getExtraGsmSignalStrength() {
        return this.getDataInt(72);
    }

    public final void setExtraGsmSignalStrength(@Nullable Integer value) {
        this.setDataInt(72, value);
    }

    @Nullable
    public final Float getSpeedOptimal() {
        Float f = this.getSensorSpeed();
        if (f == null) {
            f = this.getSpeed();
        }
        return f;
    }

    @Deprecated(message="Work with speed value directly")
    public static /* synthetic */ void getSpeedOptimal$annotations() {
    }

    public final void removeSensorAll() {
        this.setSensorCadence(null);
        this.setSensorHeartRate(null);
        this.setSensorPower(null);
        this.getSensorSpeed();
        this.setSensorStrides(null);
        this.getSensorTemperature();
    }

    public final void saveCurrentToOriginal() {
        this.setLatitudeOriginal(this.latitude);
        this.setLongitudeOriginal(this.longitude);
        this.setAltitudeOriginal(this.getAltitude());
    }

    @NotNull
    public String toString() {
        return "Location [tag: " + this.provider + ", time: " + this.time + ", lon: " + this.longitude + ", lat: " + this.latitude + ", alt: " + this.getAltitude() + ']';
    }

    public final float distanceTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return com.distanceTo(dest);
    }

    public final float bearingTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        return com.bearingTo(dest);
    }

    @NotNull
    public final float[] distanceAndBearingTo(@NotNull Location dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        LocationCompute com = new LocationCompute(this);
        float[] fArray = new float[]{com.distanceTo(dest), com.bearingTo(dest)};
        return fArray;
    }

    @Override
    protected int getVersion() {
        return 4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        int n;
        void it;
        String string;
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        this.id = dr.readLong();
        String string2 = string = dr.readString();
        Location location = this;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
        location.provider = bl2 ? string : null;
        this.time = dr.readLong();
        this.setLatitude(dr.readDouble());
        this.setLongitude(dr.readDouble());
        boolean hasAltitude = dr.readBoolean();
        double altitude = dr.readDouble();
        if (hasAltitude) {
            this.setAltitude(altitude);
        }
        if (dr.readBoolean()) {
            boolean hasAccuracy = dr.readBoolean();
            float accuracy = dr.readFloat();
            if (hasAccuracy) {
                this.setAccuracyHor(Float.valueOf(accuracy));
            }
            boolean hasBearing = dr.readBoolean();
            float bearing = dr.readFloat();
            if (hasBearing) {
                this.setBearing(Float.valueOf(bearing));
            }
            boolean hasSpeed = dr.readBoolean();
            float speed = dr.readFloat();
            if (hasSpeed) {
                this.setSpeed(Float.valueOf(speed));
            }
        }
        if (version >= 1 && dr.readBoolean()) {
            ExtraSensor extraSensor;
            ExtraSensor extraSensor2;
            ExtraSensor accuracy;
            if (version == 1) {
                ExtraSensor $this$readObject_u24lambda_u2415 = accuracy = new ExtraSensor();
                boolean bl3 = false;
                $this$readObject_u24lambda_u2415.setHasHr(dr.readBoolean());
                $this$readObject_u24lambda_u2415.setHr(dr.readInt());
                $this$readObject_u24lambda_u2415.setHasCadence(dr.readBoolean());
                $this$readObject_u24lambda_u2415.setCadence(dr.readInt());
                $this$readObject_u24lambda_u2415.setHasSpeed(dr.readBoolean());
                $this$readObject_u24lambda_u2415.setSpeed(dr.readFloat());
                $this$readObject_u24lambda_u2415.setHasPower(dr.readBoolean());
                $this$readObject_u24lambda_u2415.setPower(dr.readFloat());
                extraSensor2 = accuracy;
            } else {
                ExtraSensor $this$readObject_u24lambda_u2416 = accuracy = new ExtraSensor();
                boolean bl4 = false;
                $this$readObject_u24lambda_u2416.read(dr);
                extraSensor2 = extraSensor = accuracy;
            }
            if (extraSensor.getHasCadence()) {
                this.setSensorCadence((short)extraSensor.getCadence());
            }
            if (extraSensor.getHasHr()) {
                this.setSensorHeartRate((short)extraSensor.getHr());
            }
            if (extraSensor.getHasPower()) {
                this.setSensorPower(Float.valueOf(extraSensor.getPower()));
            }
            if (extraSensor.getHasSpeed()) {
                this.setSensorSpeed(Float.valueOf(extraSensor.getSpeed()));
            }
            if (extraSensor.getHasStrides()) {
                this.setSensorStrides(extraSensor.getStrides());
            }
            if (extraSensor.getHasTemperature()) {
                this.setSensorTemperature(Float.valueOf(extraSensor.getTemperature()));
            }
        }
        int size = 0;
        if (version >= 3) {
            int i;
            SparseArrayCompat<Short> sparseArrayCompat = this.extraDataShort;
            if (sparseArrayCompat != null) {
                sparseArrayCompat.clear();
            }
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.setDataShort(dr.readByte(), dr.readShort());
            }
            SparseArrayCompat<Integer> sparseArrayCompat2 = this.extraDataInt;
            if (sparseArrayCompat2 != null) {
                sparseArrayCompat2.clear();
            }
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.setDataInt(dr.readByte(), dr.readInt());
            }
            SparseArrayCompat<Float> sparseArrayCompat3 = this.extraDataFloat;
            if (sparseArrayCompat3 != null) {
                sparseArrayCompat3.clear();
            }
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.setDataFloat(dr.readByte(), Float.valueOf(dr.readFloat()));
            }
            SparseArrayCompat<Double> sparseArrayCompat4 = this.extraDataDouble;
            if (sparseArrayCompat4 != null) {
                sparseArrayCompat4.clear();
            }
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.setDataDouble(dr.readByte(), dr.readDouble());
            }
        }
        if (version >= 4) {
            int i;
            SparseArrayCompat<Long> sparseArrayCompat = this.extraDataLong;
            if (sparseArrayCompat != null) {
                sparseArrayCompat.clear();
            }
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.setDataLong(dr.readByte(), dr.readLong());
            }
            SparseArrayCompat<String> sparseArrayCompat5 = this.extraDataString;
            if (sparseArrayCompat5 != null) {
                sparseArrayCompat5.clear();
            }
            size = dr.readByte();
            n = size;
            for (i = 0; i < n; ++i) {
                this.setDataString(dr.readByte(), dr.readString());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        block34: {
            Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
            dw.writeLong(this.id);
            dw.writeString(this.provider);
            dw.writeLong(this.time);
            dw.writeDouble(this.latitude);
            dw.writeDouble(this.longitude);
            dw.writeBoolean(this.getAltitude() != null);
            v0 = this.getAltitude();
            dw.writeDouble(v0 != null ? v0 : 0.0);
            if (this.getAccuracyHor() != null || this.getBearing() != null || this.getSpeed() != null) {
                dw.writeBoolean(true);
                dw.writeBoolean(this.getAccuracyHor() != null);
                v1 = this.getAccuracyHor();
                dw.writeFloat(v1 != null ? v1.floatValue() : 0.0f);
                dw.writeBoolean(this.getBearing() != null);
                v2 = this.getBearing();
                dw.writeFloat(v2 != null ? v2.floatValue() : 0.0f);
                dw.writeBoolean(this.getSpeed() != null);
                v3 = this.getSpeed();
                dw.writeFloat(v3 != null ? v3.floatValue() : 0.0f);
            } else {
                dw.writeBoolean(false);
            }
            $this$writeObject_u24lambda_u2418 = var3_2 = new ExtraSensor();
            $i$a$-apply-Location$writeObject$extraSensor$1 = false;
            if (this.getSensorCadence() != null) {
                $this$writeObject_u24lambda_u2418.setHasCadence(true);
                v4 = this.getSensorCadence();
                $this$writeObject_u24lambda_u2418.setCadence(v4 != null ? v4 : 0);
            }
            if (this.getSensorHeartRate() != null) {
                $this$writeObject_u24lambda_u2418.setHasHr(true);
                v5 = this.getSensorHeartRate();
                $this$writeObject_u24lambda_u2418.setHr(v5 != null ? v5 : 0);
            }
            if (this.getSensorPower() != null) {
                $this$writeObject_u24lambda_u2418.setHasPower(true);
                v6 = this.getSensorPower();
                $this$writeObject_u24lambda_u2418.setPower(v6 != null ? v6.floatValue() : 0.0f);
            }
            if (this.getSensorSpeed() != null) {
                $this$writeObject_u24lambda_u2418.setHasSpeed(true);
                v7 = this.getSensorSpeed();
                $this$writeObject_u24lambda_u2418.setSpeed(v7 != null ? v7.floatValue() : 0.0f);
            }
            v8 = this.getSensorStrides();
            if (v8 != null) {
                it = ((Number)v8).intValue();
                $i$a$-let-Location$writeObject$extraSensor$1$1 = false;
                $this$writeObject_u24lambda_u2418.setHasStrides(true);
                $this$writeObject_u24lambda_u2418.setStrides(it);
            }
            if (this.getSensorTemperature() != null) {
                $this$writeObject_u24lambda_u2418.setHasTemperature(true);
                v9 = this.getSensorTemperature();
                $this$writeObject_u24lambda_u2418.setTemperature(v9 != null ? v9.floatValue() : 0.0f);
            }
            it = $i$a$-apply-Location$writeObject$extraSensor$1 = (extraSensor = var3_2);
            $i$a$-takeIf-Location$writeObject$1 = false;
            v10 = var4_3 = it.hasData() != false ? $i$a$-apply-Location$writeObject$extraSensor$1 : null;
            if (var4_3 != null) {
                it = var4_3;
                $i$a$-let-Location$writeObject$2 = false;
                dw.writeBoolean(true);
                it.write(dw);
                v11 = Unit.INSTANCE;
            } else {
                v11 = null;
            }
            if (v11 == null) {
                $this$writeObject_u24lambda_u2421 = this;
                $i$a$-run-Location$writeObject$3 = false;
                dw.writeBoolean(false);
            }
            var4_3 = this.extraDataShort;
            if (var4_3 == null) ** GOTO lbl-1000
            $i$a$-run-Location$writeObject$3 = var4_3;
            it = $i$a$-run-Location$writeObject$3;
            $i$a$-takeIf-Location$writeObject$4 = false;
            v12 = $this$writeObject_u24lambda_u2421 = it.isEmpty() == false != false ? $i$a$-run-Location$writeObject$3 : null;
            if ($this$writeObject_u24lambda_u2421 != null) {
                it = $this$writeObject_u24lambda_u2421;
                $i$a$-let-Location$writeObject$5 = false;
                dw.writeByte((byte)it.size());
                var10_31 = it.size();
                for (i = 0; i < var10_31; ++i) {
                    dw.writeByte((byte)it.keyAt(i));
                    dw.writeShort(((Number)it.valueAt(i)).shortValue());
                }
                v13 = Unit.INSTANCE;
            } else lbl-1000:
            // 2 sources

            {
                v13 = null;
            }
            if (v13 == null) {
                $this$writeObject_u24lambda_u2424 = this;
                $i$a$-run-Location$writeObject$6 = false;
                dw.writeByte((byte)0);
            }
            var4_3 = this.extraDataInt;
            if (var4_3 == null) ** GOTO lbl-1000
            $i$a$-run-Location$writeObject$6 = var4_3;
            it = $i$a$-run-Location$writeObject$6;
            $i$a$-takeIf-Location$writeObject$7 = false;
            v14 = $this$writeObject_u24lambda_u2424 = it.isEmpty() == false != false ? $i$a$-run-Location$writeObject$6 : null;
            if ($this$writeObject_u24lambda_u2424 != null) {
                it = $this$writeObject_u24lambda_u2424;
                $i$a$-let-Location$writeObject$8 = false;
                dw.writeByte((byte)it.size());
                var10_31 = it.size();
                for (i = 0; i < var10_31; ++i) {
                    dw.writeByte((byte)it.keyAt(i));
                    v15 = it.valueAt(i);
                    Intrinsics.checkNotNullExpressionValue(v15, (String)"it.valueAt(i)");
                    dw.writeInt(((Number)v15).intValue());
                }
                v16 = Unit.INSTANCE;
            } else lbl-1000:
            // 2 sources

            {
                v16 = null;
            }
            if (v16 == null) {
                $this$writeObject_u24lambda_u2427 = this;
                $i$a$-run-Location$writeObject$9 = false;
                dw.writeByte((byte)0);
            }
            var4_3 = this.extraDataFloat;
            if (var4_3 == null) ** GOTO lbl-1000
            $i$a$-run-Location$writeObject$9 = var4_3;
            it = $i$a$-run-Location$writeObject$9;
            $i$a$-takeIf-Location$writeObject$10 = false;
            v17 = $this$writeObject_u24lambda_u2427 = it.isEmpty() == false != false ? $i$a$-run-Location$writeObject$9 : null;
            if ($this$writeObject_u24lambda_u2427 != null) {
                it = $this$writeObject_u24lambda_u2427;
                $i$a$-let-Location$writeObject$11 = false;
                dw.writeByte((byte)it.size());
                var10_31 = it.size();
                for (i = 0; i < var10_31; ++i) {
                    dw.writeByte((byte)it.keyAt(i));
                    v18 = it.valueAt(i);
                    Intrinsics.checkNotNullExpressionValue(v18, (String)"it.valueAt(i)");
                    dw.writeFloat(((Number)v18).floatValue());
                }
                v19 = Unit.INSTANCE;
            } else lbl-1000:
            // 2 sources

            {
                v19 = null;
            }
            if (v19 == null) {
                $this$writeObject_u24lambda_u2430 = this;
                $i$a$-run-Location$writeObject$12 = false;
                dw.writeByte((byte)0);
            }
            var4_3 = this.extraDataDouble;
            if (var4_3 == null) ** GOTO lbl-1000
            $i$a$-run-Location$writeObject$12 = var4_3;
            it = $i$a$-run-Location$writeObject$12;
            $i$a$-takeIf-Location$writeObject$13 = false;
            v20 = $this$writeObject_u24lambda_u2430 = it.isEmpty() == false != false ? $i$a$-run-Location$writeObject$12 : null;
            if ($this$writeObject_u24lambda_u2430 != null) {
                it = $this$writeObject_u24lambda_u2430;
                $i$a$-let-Location$writeObject$14 = false;
                dw.writeByte((byte)it.size());
                var10_31 = it.size();
                for (i = 0; i < var10_31; ++i) {
                    dw.writeByte((byte)it.keyAt(i));
                    v21 = it.valueAt(i);
                    Intrinsics.checkNotNullExpressionValue(v21, (String)"it.valueAt(i)");
                    dw.writeDouble(((Number)v21).doubleValue());
                }
                v22 = Unit.INSTANCE;
            } else lbl-1000:
            // 2 sources

            {
                v22 = null;
            }
            if (v22 == null) {
                $this$writeObject_u24lambda_u2433 = this;
                $i$a$-run-Location$writeObject$15 = false;
                dw.writeByte((byte)0);
            }
            var4_3 = this.extraDataLong;
            if (var4_3 == null) ** GOTO lbl-1000
            $i$a$-run-Location$writeObject$15 = var4_3;
            it = $i$a$-run-Location$writeObject$15;
            $i$a$-takeIf-Location$writeObject$16 = false;
            v23 = $this$writeObject_u24lambda_u2433 = it.isEmpty() == false != false ? $i$a$-run-Location$writeObject$15 : null;
            if ($this$writeObject_u24lambda_u2433 != null) {
                it = $this$writeObject_u24lambda_u2433;
                $i$a$-let-Location$writeObject$17 = false;
                dw.writeByte((byte)it.size());
                var10_31 = it.size();
                for (i = 0; i < var10_31; ++i) {
                    dw.writeByte((byte)it.keyAt(i));
                    v24 = it.valueAt(i);
                    Intrinsics.checkNotNullExpressionValue(v24, (String)"it.valueAt(i)");
                    dw.writeLong(((Number)v24).longValue());
                }
                v25 = Unit.INSTANCE;
            } else lbl-1000:
            // 2 sources

            {
                v25 = null;
            }
            if (v25 == null) {
                $this$writeObject_u24lambda_u2436 = this;
                $i$a$-run-Location$writeObject$18 = false;
                dw.writeByte((byte)0);
            }
            var4_3 = this.extraDataString;
            if (var4_3 == null) ** GOTO lbl-1000
            $i$a$-run-Location$writeObject$18 = var4_3;
            it = $i$a$-run-Location$writeObject$18;
            $i$a$-takeIf-Location$writeObject$19 = false;
            v26 = $this$writeObject_u24lambda_u2436 = it.isEmpty() == false != false ? $i$a$-run-Location$writeObject$18 : null;
            if ($this$writeObject_u24lambda_u2436 != null) {
                it = $this$writeObject_u24lambda_u2436;
                $i$a$-let-Location$writeObject$20 = false;
                dw.writeByte((byte)it.size());
                var10_31 = it.size();
                for (i = 0; i < var10_31; ++i) {
                    dw.writeByte((byte)it.keyAt(i));
                    dw.writeString((String)it.valueAt(i));
                }
                v27 = Unit.INSTANCE;
            } else lbl-1000:
            // 2 sources

            {
                v27 = null;
            }
            if (v27 != null) break block34;
            $this$writeObject_u24lambda_u2439 = this;
            $i$a$-run-Location$writeObject$21 = false;
            dw.writeByte((byte)0);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Llocus/api/objects/extra/Location$Companion;", "", "()V", "EXTRA_KEY_ACCURACY_HOR", "", "EXTRA_KEY_ACCURACY_VER", "EXTRA_KEY_ALTITUDE", "EXTRA_KEY_BEARING", "EXTRA_KEY_EXTRA_ANTENNA_PHASE_CENTER_OFFSET", "EXTRA_KEY_EXTRA_GSM_SIGNAL_STRENGTH", "EXTRA_KEY_EXTRA_POLE_HEIGHT", "EXTRA_KEY_GNSS_HDOP", "EXTRA_KEY_GNSS_NTRIP_MOUNTPOINT", "EXTRA_KEY_GNSS_OBSERVATION_TIME_END", "EXTRA_KEY_GNSS_OBSERVATION_TIME_START", "EXTRA_KEY_GNSS_PDOP", "EXTRA_KEY_GNSS_QUALITY", "EXTRA_KEY_GNSS_SATS_USED", "EXTRA_KEY_GNSS_SATS_VISIBLE", "EXTRA_KEY_GNSS_VDOP", "EXTRA_KEY_ORIG_ALTITUDE", "EXTRA_KEY_ORIG_LATITUDE", "EXTRA_KEY_ORIG_LONGITUDE", "EXTRA_KEY_SENSOR_CADENCE", "EXTRA_KEY_SENSOR_HEART_RATE", "EXTRA_KEY_SENSOR_POWER", "EXTRA_KEY_SENSOR_SPEED", "EXTRA_KEY_SENSOR_STRIDES", "EXTRA_KEY_SENSOR_TEMPERATURE", "EXTRA_KEY_SPEED", "TAG", "", "validateIds", "", "id", "locus-api-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void validateIds(int id) {
            switch (id) {
                default: 
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00100\u001a\u00020\u0004H\u0014J\u0006\u00101\u001a\u00020\nJ\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u000206H\u0014J\u0010\u00107\u001a\u0002032\u0006\u00108\u001a\u000209H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u001a\u0010\u001e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\u001a\u0010*\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0006\"\u0004\b,\u0010\bR\u001a\u0010-\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010$\"\u0004\b/\u0010&\u00a8\u0006:"}, d2={"Llocus/api/objects/extra/Location$ExtraSensor;", "Llocus/api/objects/Storable;", "()V", "cadence", "", "getCadence", "()I", "setCadence", "(I)V", "hasCadence", "", "getHasCadence", "()Z", "setHasCadence", "(Z)V", "hasHr", "getHasHr", "setHasHr", "hasPower", "getHasPower", "setHasPower", "hasSpeed", "getHasSpeed", "setHasSpeed", "hasStrides", "getHasStrides", "setHasStrides", "hasTemperature", "getHasTemperature", "setHasTemperature", "hr", "getHr", "setHr", "power", "", "getPower", "()F", "setPower", "(F)V", "speed", "getSpeed", "setSpeed", "strides", "getStrides", "setStrides", "temperature", "getTemperature", "setTemperature", "getVersion", "hasData", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "locus-api-core"})
    private static final class ExtraSensor
    extends Storable {
        private boolean hasHr;
        private int hr;
        private boolean hasCadence;
        private int cadence;
        private boolean hasSpeed;
        private float speed;
        private boolean hasPower;
        private float power;
        private boolean hasStrides;
        private int strides;
        private boolean hasTemperature;
        private float temperature;

        public final boolean getHasHr() {
            return this.hasHr;
        }

        public final void setHasHr(boolean bl) {
            this.hasHr = bl;
        }

        public final int getHr() {
            return this.hr;
        }

        public final void setHr(int n) {
            this.hr = n;
        }

        public final boolean getHasCadence() {
            return this.hasCadence;
        }

        public final void setHasCadence(boolean bl) {
            this.hasCadence = bl;
        }

        public final int getCadence() {
            return this.cadence;
        }

        public final void setCadence(int n) {
            this.cadence = n;
        }

        public final boolean getHasSpeed() {
            return this.hasSpeed;
        }

        public final void setHasSpeed(boolean bl) {
            this.hasSpeed = bl;
        }

        public final float getSpeed() {
            return this.speed;
        }

        public final void setSpeed(float f) {
            this.speed = f;
        }

        public final boolean getHasPower() {
            return this.hasPower;
        }

        public final void setHasPower(boolean bl) {
            this.hasPower = bl;
        }

        public final float getPower() {
            return this.power;
        }

        public final void setPower(float f) {
            this.power = f;
        }

        public final boolean getHasStrides() {
            return this.hasStrides;
        }

        public final void setHasStrides(boolean bl) {
            this.hasStrides = bl;
        }

        public final int getStrides() {
            return this.strides;
        }

        public final void setStrides(int n) {
            this.strides = n;
        }

        public final boolean getHasTemperature() {
            return this.hasTemperature;
        }

        public final void setHasTemperature(boolean bl) {
            this.hasTemperature = bl;
        }

        public final float getTemperature() {
            return this.temperature;
        }

        public final void setTemperature(float f) {
            this.temperature = f;
        }

        public final boolean hasData() {
            return this.hasHr || this.hasCadence || this.hasSpeed || this.hasPower || this.hasStrides || this.hasTemperature;
        }

        @Override
        protected int getVersion() {
            return 1;
        }

        @Override
        protected void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
            this.hasHr = dr.readBoolean();
            this.hr = dr.readInt();
            this.hasCadence = dr.readBoolean();
            this.cadence = dr.readInt();
            this.hasSpeed = dr.readBoolean();
            this.speed = dr.readFloat();
            this.hasPower = dr.readBoolean();
            this.power = dr.readFloat();
            this.hasStrides = dr.readBoolean();
            this.strides = dr.readInt();
            dr.readBoolean();
            dr.readInt();
            if (version >= 1) {
                this.hasTemperature = dr.readBoolean();
                this.temperature = dr.readFloat();
            }
        }

        @Override
        protected void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
            dw.writeBoolean(this.hasHr);
            dw.writeInt(this.hr);
            dw.writeBoolean(this.hasCadence);
            dw.writeInt(this.cadence);
            dw.writeBoolean(this.hasSpeed);
            dw.writeFloat(this.speed);
            dw.writeBoolean(this.hasPower);
            dw.writeFloat(this.power);
            dw.writeBoolean(this.hasStrides);
            dw.writeInt(this.strides);
            dw.writeBoolean(false);
            dw.writeInt(0);
            dw.writeBoolean(this.hasTemperature);
            dw.writeFloat(this.temperature);
        }
    }
}

