/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.geoData;

import com.asamm.logger.Logger;
import com.asamm.loggerV2.Log;
import com.asamm.loggerV2.LogCategory;
import com.asamm.loggerV2.LogPriority;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import locus.api.objects.extra.Location;
import locus.api.objects.extra.TrackStats;
import locus.api.objects.geoData.GeoData;
import locus.api.objects.geoData.Point;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 D2\u00020\u0001:\u0001DB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u0004J\b\u0010:\u001a\u00020\u0004H\u0016J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020?H\u0016J\u000e\u0010&\u001a\u00020<2\u0006\u0010@\u001a\u00020\u0010J\u0010\u0010A\u001a\u00020<2\u0006\u0010B\u001a\u00020CH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R*\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00168F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0017\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\f\"\u0004\b\u001f\u0010\u000eR\u0011\u0010 \u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0006R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u001a\u00101\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0019\"\u0004\b3\u0010\u001bR \u00104\u001a\b\u0012\u0004\u0012\u0002050\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\f\"\u0004\b7\u0010\u000e\u00a8\u0006E"}, d2={"Llocus/api/objects/geoData/Track;", "Llocus/api/objects/geoData/GeoData;", "()V", "activityType", "", "getActivityType", "()I", "setActivityType", "(I)V", "breaks", "", "getBreaks", "()Ljava/util/List;", "setBreaks", "(Ljava/util/List;)V", "value", "", "breaksBinary", "getBreaksBinary", "()[B", "setBreaksBinary", "([B)V", "", "isUseFolderStyle", "isUseFolderStyle$annotations", "()Z", "setUseFolderStyle", "(Z)V", "points", "Llocus/api/objects/extra/Location;", "getPoints", "setPoints", "pointsCount", "getPointsCount", "stats", "Llocus/api/objects/extra/TrackStats;", "getStats", "()Llocus/api/objects/extra/TrackStats;", "setStats", "(Llocus/api/objects/extra/TrackStats;)V", "storeItemId", "", "getStoreItemId", "()J", "setStoreItemId", "(J)V", "storeVersionId", "getStoreVersionId", "setStoreVersionId", "useParentLineStyle", "getUseParentLineStyle", "setUseParentLineStyle", "waypoints", "Llocus/api/objects/geoData/Point;", "getWaypoints", "setWaypoints", "getPoint", "index", "getVersion", "readObject", "", "version", "dr", "Llocus/api/utils/DataReaderBigEndian;", "data", "writeObject", "dw", "Llocus/api/utils/DataWriterBigEndian;", "Companion", "locus-api-core"})
@SourceDebugExtension(value={"SMAP\nTrack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Track.kt\nlocus/api/objects/geoData/Track\n+ 2 Log.kt\ncom/asamm/loggerV2/LogKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,283:1\n87#2,14:284\n87#2,14:299\n1#3:298\n*S KotlinDebug\n*F\n+ 1 Track.kt\nlocus/api/objects/geoData/Track\n*L\n67#1:284,14\n139#1:299,14\n*E\n"})
public final class Track
extends GeoData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<Location> points = new ArrayList();
    @NotNull
    private List<Integer> breaks = new ArrayList();
    @NotNull
    private List<Point> waypoints = new ArrayList();
    private boolean useParentLineStyle = true;
    private int activityType;
    @NotNull
    private TrackStats stats = new TrackStats();
    private long storeItemId = -1L;
    private long storeVersionId = -1L;
    @NotNull
    private static final String TAG = "Track";

    @NotNull
    public final List<Location> getPoints() {
        return this.points;
    }

    public final void setPoints(@NotNull List<Location> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.points = list;
    }

    @NotNull
    public final List<Integer> getBreaks() {
        return this.breaks;
    }

    public final void setBreaks(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.breaks = list;
    }

    @NotNull
    public final byte[] getBreaksBinary() {
        DataWriterBigEndian dataWriterBigEndian;
        DataWriterBigEndian $this$_get_breaksBinary__u24lambda_u240 = dataWriterBigEndian = new DataWriterBigEndian();
        boolean bl = false;
        int n = this.breaks.size();
        for (int i = 0; i < n; ++i) {
            $this$_get_breaksBinary__u24lambda_u240.writeInt(((Number)this.breaks.get(i)).intValue());
        }
        byte[] byArray = dataWriterBigEndian.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"DataWriterBigEndian().ap\u2026          }.toByteArray()");
        return byArray;
    }

    public final void setBreaksBinary(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.breaks.clear();
        if (value.length == 0) {
            return;
        }
        try {
            DataReaderBigEndian dr = new DataReaderBigEndian(value);
            while (dr.available() > 0) {
                this.breaks.add(dr.readInt());
            }
        }
        catch (Exception e) {
            String tag$iv = TAG;
            LogCategory category$iv = LogCategory.Companion.getCORE();
            boolean $i$f$logE = false;
            if (category$iv.getMinPriority().getPriority() <= LogPriority.ERROR.getPriority()) {
                String string = Log.INSTANCE.getValidTag(category$iv, tag$iv);
                boolean bl = false;
                String string2 = "setBreaksFromData(" + value + ")";
                Logger.e((Throwable)e, (String)string, (String)string2, (Object[])new Object[0]);
            }
            this.breaks.clear();
        }
    }

    @NotNull
    public final List<Point> getWaypoints() {
        return this.waypoints;
    }

    public final void setWaypoints(@NotNull List<Point> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.waypoints = list;
    }

    public final boolean isUseFolderStyle() {
        return this.useParentLineStyle;
    }

    public final void setUseFolderStyle(boolean value) {
        this.useParentLineStyle = value;
    }

    @Deprecated(message="Use renamed parameter", replaceWith=@ReplaceWith(expression="useParentLineStyle", imports={}))
    public static /* synthetic */ void isUseFolderStyle$annotations() {
    }

    public final boolean getUseParentLineStyle() {
        return this.useParentLineStyle;
    }

    public final void setUseParentLineStyle(boolean bl) {
        this.useParentLineStyle = bl;
    }

    public final int getActivityType() {
        return this.activityType;
    }

    public final void setActivityType(int n) {
        this.activityType = n;
    }

    @NotNull
    public final TrackStats getStats() {
        return this.stats;
    }

    public final void setStats(@NotNull TrackStats trackStats) {
        Intrinsics.checkNotNullParameter((Object)trackStats, (String)"<set-?>");
        this.stats = trackStats;
    }

    public final long getStoreItemId() {
        return this.storeItemId;
    }

    public final void setStoreItemId(long l) {
        this.storeItemId = l;
    }

    public final long getStoreVersionId() {
        return this.storeVersionId;
    }

    public final void setStoreVersionId(long l) {
        this.storeVersionId = l;
    }

    public final int getPointsCount() {
        return this.points.size();
    }

    @NotNull
    public final Location getPoint(int index) {
        return this.points.get(index);
    }

    /*
     * WARNING - void declaration
     */
    public final void setStats(@NotNull byte[] data) {
        Track track;
        TrackStats trackStats;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Track track2 = this;
        try {
            void $this$setStats_u24lambda_u242;
            TrackStats trackStats2 = trackStats = new TrackStats();
            Track track3 = track2;
            boolean bl = false;
            $this$setStats_u24lambda_u242.read(data);
            track = track3;
        }
        catch (Exception $this$setStats_u24lambda_u242) {
            track = track2;
            String tag$iv = TAG;
            LogCategory category$iv = LogCategory.Companion.getCORE();
            boolean $i$f$logE = false;
            if (category$iv.getMinPriority().getPriority() <= LogPriority.ERROR.getPriority()) {
                void e;
                String string = Log.INSTANCE.getValidTag(category$iv, tag$iv);
                track2 = track;
                boolean bl = false;
                String string2 = Arrays.toString(data);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
                track = track2;
                String string3 = "setStats(" + string2 + ")";
                Logger.e((Throwable)((Throwable)e), (String)string, (String)string3, (Object[])new Object[0]);
            }
            trackStats = new TrackStats();
        }
        track.stats = trackStats;
    }

    @Override
    public int getVersion() {
        return 8;
    }

    @Override
    public void readObject(int version, @NotNull DataReaderBigEndian dr) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dr, (String)"dr");
        this.stats = new TrackStats();
        this.setId(dr.readLong());
        String string = dr.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dr.readString()");
        this.setName(string);
        List<Location> list = dr.readListStorable(Location.class);
        Intrinsics.checkNotNullExpressionValue(list, (String)"dr.readListStorable(Location::class.java)");
        this.points = list;
        int breaksSize = dr.readInt();
        if (breaksSize > 0) {
            byte[] byArray = dr.readBytes(breaksSize);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"dr.readBytes(breaksSize)");
            this.setBreaksBinary(byArray);
        }
        List<Point> list2 = dr.readListStorable(Point.class);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"dr.readListStorable(Point::class.java)");
        this.waypoints = list2;
        this.readExtraData(dr);
        this.readStyles(dr);
        dr.readBytes(88);
        if (version >= 1) {
            this.useParentLineStyle = dr.readBoolean();
        }
        if (version >= 2) {
            this.setTimeCreated(dr.readLong());
        }
        if (version >= 3) {
            this.stats = new TrackStats();
            this.stats.read(dr);
        }
        if (version >= 4) {
            this.setProtected(dr.readInt() == 0);
        }
        if (version >= 5) {
            this.activityType = dr.readInt();
        }
        if (version >= 6) {
            this.storeItemId = dr.readLong();
            this.storeVersionId = dr.readLong();
        }
        if (version >= 7) {
            this.setTimeUpdated(dr.readLong());
        }
        if (version >= 8) {
            GeoData.Privacy privacy;
            GeoData.Privacy privacy2;
            Track track;
            block11: {
                String privacyValue = dr.readString();
                GeoData.Privacy[] privacyArray = GeoData.Privacy.values();
                track = this;
                GeoData.Privacy[] privacyArray2 = privacyArray;
                int n = privacyArray2.length;
                for (int i = 0; i < n; ++i) {
                    GeoData.Privacy privacy3;
                    GeoData.Privacy it = privacy3 = privacyArray2[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)privacyValue)) continue;
                    privacy2 = privacy3;
                    break block11;
                }
                privacy2 = privacy = null;
            }
            if (privacy2 == null) {
                privacy = this.getPrivacy();
            }
            track.setPrivacy(privacy);
        }
    }

    @Override
    public void writeObject(@NotNull DataWriterBigEndian dw) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dw, (String)"dw");
        dw.writeLong(this.getId());
        dw.writeString(this.getName());
        dw.writeListStorable(this.points);
        byte[] it = this.getBreaksBinary();
        boolean bl = false;
        dw.writeInt(it.length);
        if (!(it.length == 0)) {
            dw.write(it);
        }
        dw.writeListStorable(this.waypoints);
        this.writeExtraData(dw);
        this.writeStyles(dw);
        int n = 0;
        byte[] byArray = new byte[88];
        DataWriterBigEndian dataWriterBigEndian = dw;
        while (n < 88) {
            int n2 = n++;
            byArray[n2] = 0;
        }
        dataWriterBigEndian.write(byArray);
        dw.writeBoolean(this.useParentLineStyle);
        dw.writeLong(this.getTimeCreated());
        dw.writeStorable(this.stats);
        dw.writeInt(this.getProtected() ? 0 : 1);
        dw.writeInt(this.activityType);
        dw.writeLong(this.storeItemId);
        dw.writeLong(this.storeVersionId);
        dw.writeLong(this.getTimeUpdated());
        dw.writeString(this.getPrivacy().name());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llocus/api/objects/geoData/Track$Companion;", "", "()V", "TAG", "", "locus-api-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

