/*
 * Decompiled with CFR 0.152.
 */
package com.ashampoo.xmp;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0010J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0010H\u0007J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0007J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0007J\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!2\u0006\u0010\"\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/ashampoo/xmp/Utils;", "", "()V", "HEX_RADIX", "", "UUID_LENGTH", "UUID_SEGMENT_COUNT", "XML_NAME_LENGTH", "controlCharRegex", "Lkotlin/text/Regex;", "xmlNameChars", "", "xmlNameStartChars", "checkUUIDFormat", "", "uuid", "", "escapeXML", "value", "forAttribute", "escapeWhitespaces", "initCharTables", "", "isNameChar", "char", "", "isNameStartChar", "isXMLName", "name", "isXMLNameNS", "normalizeLangValue", "replaceControlCharsWithSpace", "splitNameAndValue", "", "selector", "(Ljava/lang/String;)[Ljava/lang/String;", "xmpcore"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    public static final int UUID_SEGMENT_COUNT = 4;
    public static final int UUID_LENGTH = 36;
    public static final int HEX_RADIX = 16;
    private static final int XML_NAME_LENGTH = 256;
    @NotNull
    private static final boolean[] xmlNameStartChars = new boolean[256];
    @NotNull
    private static final boolean[] xmlNameChars = new boolean[256];
    @NotNull
    private static final Regex controlCharRegex = new Regex("[\\p{Cntrl}]");

    private Utils() {
    }

    @JvmStatic
    @NotNull
    public static final String normalizeLangValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)"x-default", (Object)value)) {
            return value;
        }
        int subTag = 1;
        StringBuilder buffer = new StringBuilder();
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            if (c == '-' ? true : c == '_') {
                buffer.append('-');
                ++subTag;
                continue;
            }
            if (c == ' ') continue;
            if (subTag != 2) {
                buffer.append(Character.toLowerCase(value.charAt(i)));
                continue;
            }
            buffer.append(Character.toUpperCase(value.charAt(i)));
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String[] splitNameAndValue(@NotNull String selector) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        int eq = StringsKt.indexOf$default((CharSequence)selector, (char)'=', (int)0, (boolean)false, (int)6, null);
        int pos = 1;
        if (selector.charAt(pos) == '?') {
            ++pos;
        }
        String string = selector.substring(pos, eq);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String name = string;
        pos = eq + 1;
        char quote = selector.charAt(pos);
        ++pos;
        int end = selector.length() - 2;
        StringBuilder value = new StringBuilder(end - eq);
        while (pos < end) {
            value.append(selector.charAt(pos));
            if (selector.charAt(++pos) != quote) continue;
            ++pos;
        }
        String[] stringArray = new String[2];
        stringArray[0] = name;
        Intrinsics.checkNotNullExpressionValue((Object)value.toString(), (String)"toString(...)");
        return stringArray;
    }

    @JvmStatic
    public static final boolean checkUUIDFormat(@Nullable String uuid) {
        int delimPos;
        boolean result = true;
        int delimCnt = 0;
        if (uuid == null) {
            return false;
        }
        for (delimPos = 0; delimPos < uuid.length(); ++delimPos) {
            if (uuid.charAt(delimPos) != '-') continue;
            ++delimCnt;
            result = result && (delimPos == 8 || delimPos == 13 || delimPos == 18 || delimPos == 23);
        }
        return result && 4 == delimCnt && 36 == delimPos;
    }

    public final boolean isXMLName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (((CharSequence)name).length() > 0 && !this.isNameStartChar(name.charAt(0))) {
            return false;
        }
        int n = name.length();
        for (int i = 1; i < n; ++i) {
            if (this.isNameChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final boolean isXMLNameNS(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (((CharSequence)name).length() > 0 && (!INSTANCE.isNameStartChar(name.charAt(0)) || name.charAt(0) == ':')) {
            return false;
        }
        int n = name.length();
        for (int index = 1; index < n; ++index) {
            if (INSTANCE.isNameChar(name.charAt(index)) && name.charAt(index) != ':') continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    @NotNull
    public static final String escapeXML(@NotNull String value, boolean forAttribute, boolean escapeWhitespaces) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean needsEscaping = false;
        int n = value.length();
        for (int index = 0; index < n; ++index) {
            boolean isControlChar;
            char c = value.charAt(index);
            boolean bl = isControlChar = c == '\t' || c == '\n' || c == '\r';
            if (c != '<' && c != '>' && c != '&' && (!escapeWhitespaces || !isControlChar) && (!forAttribute || c != '\"')) continue;
            needsEscaping = true;
            break;
        }
        if (!needsEscaping) {
            return value;
        }
        StringBuilder buffer = new StringBuilder(value.length() * 4 / 3);
        int n2 = value.length();
        for (n = 0; n < n2; ++n) {
            boolean isControlChar;
            char c = value.charAt(n);
            boolean bl = isControlChar = c == '\t' || c == '\n' || c == '\r';
            if (!escapeWhitespaces || !isControlChar) {
                char c2 = c;
                if (c2 == '<') {
                    buffer.append("&lt;");
                    continue;
                }
                if (c2 == '>') {
                    buffer.append("&gt;");
                    continue;
                }
                if (c2 == '&') {
                    buffer.append("&amp;");
                    continue;
                }
                if (c2 == '\"') {
                    buffer.append(forAttribute ? "&quot;" : "\"");
                    continue;
                }
                buffer.append(c);
                continue;
            }
            buffer.append("&#x");
            String string = Integer.toString(c, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            buffer.append(string2);
            buffer.append(';');
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String replaceControlCharsWithSpace(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence charSequence = value;
        Regex regex = controlCharRegex;
        String string = " ";
        return regex.replace(charSequence, string);
    }

    private final boolean isNameStartChar(char c) {
        return c <= '\u00ff' && xmlNameStartChars[c] || c >= '\u0100' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd' || c >= '\u10000' && c <= '\ueffff';
    }

    private final boolean isNameChar(char c) {
        return c <= '\u00ff' && xmlNameChars[c] || this.isNameStartChar(c) || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040';
    }

    private final void initCharTables() {
        int n = 0;
        while (Intrinsics.compare((int)n, (int)((char)xmlNameChars.length)) < 0) {
            Utils.xmlNameStartChars[n] = n == 58 || Intrinsics.compare((int)65, (int)n) <= 0 && Intrinsics.compare((int)n, (int)90) <= 0 || n == 95 || Intrinsics.compare((int)97, (int)n) <= 0 && Intrinsics.compare((int)n, (int)122) <= 0 || 192 <= n && n <= 214 || 216 <= n && n <= 246 || 248 <= n && n <= 255;
            Utils.xmlNameChars[n] = xmlNameStartChars[n] || n == 45 || n == 46 || Intrinsics.compare((int)48, (int)n) <= 0 && Intrinsics.compare((int)n, (int)57) <= 0 || n == 183;
            int n2 = n;
            n = (char)(n2 + 1);
        }
    }

    static {
        INSTANCE.initCharTables();
    }
}

