/*
 * Decompiled with CFR 0.152.
 */
package com.ashampoo.xmp;

import com.ashampoo.xmp.DomParser;
import com.ashampoo.xmp.XMPMeta;
import com.ashampoo.xmp.XMPNormalizer;
import com.ashampoo.xmp.XMPRDFParser;
import com.ashampoo.xmp.options.ParseOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/ashampoo/xmp/XMPMetaParser;", "", "()V", "XMP_RDF", "findRootNode", "", "root", "Lorg/w3c/dom/Node;", "Lnl/adaptivity/xmlutil/dom/Node;", "xmpmetaRequired", "", "result", "(Lorg/w3c/dom/Node;Z[Ljava/lang/Object;)[Ljava/lang/Object;", "parse", "Lcom/ashampoo/xmp/XMPMeta;", "input", "", "options", "Lcom/ashampoo/xmp/options/ParseOptions;", "xmpcore"})
public final class XMPMetaParser {
    @NotNull
    public static final XMPMetaParser INSTANCE = new XMPMetaParser();
    @NotNull
    private static final Object XMP_RDF = new Object();

    private XMPMetaParser() {
    }

    @NotNull
    public final XMPMeta parse(@NotNull String input, @Nullable ParseOptions options) {
        XMPMeta xMPMeta;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ParseOptions parseOptions = options;
        if (parseOptions == null) {
            parseOptions = new ParseOptions();
        }
        ParseOptions actualOptions = parseOptions;
        Document document = DomParser.INSTANCE.parseDocumentFromString(input);
        boolean xmpmetaRequired = actualOptions.getRequireXMPMeta();
        Object[] result = new Object[3];
        if ((result = this.findRootNode(document, xmpmetaRequired, result)) != null && result[1] == XMP_RDF) {
            Object object = result[0];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.Node{ nl.adaptivity.xmlutil.dom.DomaliassesKt.Node }");
            XMPMeta xmp = XMPRDFParser.parse((Node)object, actualOptions);
            Object object2 = result[2];
            xmp.setPacketHeader(object2 instanceof String ? (String)object2 : null);
            xMPMeta = !actualOptions.getOmitNormalization() ? XMPNormalizer.normalize(xmp, actualOptions) : xmp;
        } else {
            xMPMeta = new XMPMeta();
        }
        return xMPMeta;
    }

    private final Object[] findRootNode(Node root, boolean xmpmetaRequired, Object[] result) {
        int n = root.getChildNodes().getLength();
        for (int index = 0; index < n; ++index) {
            Object[] newResult;
            Node child = root.getChildNodes().item(index);
            if (child == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            if (child instanceof ProcessingInstruction && Intrinsics.areEqual((Object)"xpacket", (Object)((ProcessingInstruction)child).getTarget())) {
                if (result == null) continue;
                result[2] = ((ProcessingInstruction)child).getData();
                continue;
            }
            if (child instanceof Text || child instanceof ProcessingInstruction) continue;
            Element childElement = (Element)child;
            String rootNS = childElement.getNamespaceURI();
            String rootLocal = childElement.getLocalName();
            if ((Intrinsics.areEqual((Object)"xmpmeta", (Object)rootLocal) || Intrinsics.areEqual((Object)"xapmeta", (Object)rootLocal)) && Intrinsics.areEqual((Object)"adobe:ns:meta/", (Object)rootNS)) {
                return this.findRootNode(child, false, result);
            }
            if (!xmpmetaRequired && Intrinsics.areEqual((Object)"RDF", (Object)rootLocal) && Intrinsics.areEqual((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)rootNS)) {
                if (result != null) {
                    result[0] = child;
                    result[1] = XMP_RDF;
                }
                return result;
            }
            if (newResult == null) continue;
            newResult = this.findRootNode(child, xmpmetaRequired, result);
            return newResult;
        }
        return null;
    }
}

