/*
 * Decompiled with CFR 0.152.
 */
package com.ashampoo.xmp;

import com.ashampoo.xmp.Utils;
import com.ashampoo.xmp.XMPException;
import com.ashampoo.xmp.XMPNode;
import com.ashampoo.xmp.XMPSchemaRegistry;
import com.ashampoo.xmp.XMPUtils;
import com.ashampoo.xmp.options.PropertyOptions;
import com.ashampoo.xmp.xpath.XMPPath;
import com.ashampoo.xmp.xpath.XMPPathSegment;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0007J/\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00122\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\rH\u0007J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J.\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010$\u001a\u0004\u0018\u00010%H\u0007J$\u0010&\u001a\u0004\u0018\u00010\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010(\u001a\u0004\u0018\u00010\r2\u0006\u0010)\u001a\u00020\r2\b\u0010*\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J,\u0010(\u001a\u0004\u0018\u00010\r2\u0006\u0010)\u001a\u00020\r2\b\u0010*\u001a\u0004\u0018\u00010\u000f2\b\u0010+\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\"\u0010,\u001a\u0004\u0018\u00010\r2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u00100\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000fH\u0002J\u0018\u00103\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u00104\u001a\u00020\u000fJ(\u00105\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u0004H\u0002J\u000e\u00108\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u00109\u001a\u0004\u0018\u00010\u000f2\b\u0010:\u001a\u0004\u0018\u00010\u0001J\u001a\u0010;\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\r2\b\u0010:\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020%2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/ashampoo/xmp/XMPNodeUtils;", "", "()V", "CLT_FIRST_ITEM", "", "CLT_MULTIPLE_GENERIC", "CLT_NO_VALUES", "CLT_SINGLE_GENERIC", "CLT_SPECIFIC_MATCH", "CLT_XDEFAULT", "appendLangItem", "", "arrayNode", "Lcom/ashampoo/xmp/XMPNode;", "itemLang", "", "itemValue", "chooseLocalizedText", "", "genericLang", "specificLang", "(Lcom/ashampoo/xmp/XMPNode;Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/Object;", "deleteNode", "node", "detectAltText", "findChildNode", "parent", "childName", "createNodes", "", "findIndexedItem", "segment", "findNode", "xmpTree", "xpath", "Lcom/ashampoo/xmp/xpath/XMPPath;", "leafOptions", "Lcom/ashampoo/xmp/options/PropertyOptions;", "findQualifierNode", "qualName", "findSchemaNode", "tree", "namespaceURI", "suggestedPrefix", "followXPathStep", "parentNode", "nextStep", "Lcom/ashampoo/xmp/xpath/XMPPathSegment;", "lookupFieldSelector", "fieldName", "fieldValue", "lookupLanguageItem", "language", "lookupQualSelector", "qualValue", "aliasForm", "normalizeLangArray", "serializeNodeValue", "value", "setNodeValue", "verifySetOptions", "options", "xmpcore"})
public final class XMPNodeUtils {
    @NotNull
    public static final XMPNodeUtils INSTANCE = new XMPNodeUtils();
    public static final int CLT_NO_VALUES = 0;
    public static final int CLT_SPECIFIC_MATCH = 1;
    public static final int CLT_SINGLE_GENERIC = 2;
    public static final int CLT_MULTIPLE_GENERIC = 3;
    public static final int CLT_XDEFAULT = 4;
    public static final int CLT_FIRST_ITEM = 5;

    private XMPNodeUtils() {
    }

    @JvmStatic
    @Nullable
    public static final XMPNode findSchemaNode(@NotNull XMPNode tree, @Nullable String namespaceURI, boolean createNodes) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        return INSTANCE.findSchemaNode(tree, namespaceURI, null, createNodes);
    }

    @Nullable
    public final XMPNode findSchemaNode(@NotNull XMPNode tree, @Nullable String namespaceURI, @Nullable String suggestedPrefix, boolean createNodes) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        if (!(tree.getParent() == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        XMPNode schemaNode = tree.findChildByName(namespaceURI);
        if (schemaNode == null && createNodes) {
            schemaNode = new XMPNode(namespaceURI, null, new PropertyOptions().setSchemaNode(true));
            schemaNode.setImplicit(true);
            String string = namespaceURI;
            Intrinsics.checkNotNull((Object)string);
            String prefix = XMPSchemaRegistry.INSTANCE.getNamespacePrefix(string);
            if (prefix == null) {
                CharSequence charSequence = suggestedPrefix;
                if (charSequence == null || charSequence.length() == 0) {
                    throw new XMPException("Unregistered schema namespace URI", 101, null, 4, null);
                }
                prefix = XMPSchemaRegistry.INSTANCE.registerNamespace(namespaceURI, suggestedPrefix);
            }
            schemaNode.setValue(prefix);
            tree.addChild(schemaNode);
        }
        return schemaNode;
    }

    @Nullable
    public final XMPNode findChildNode(@NotNull XMPNode parent, @Nullable String childName, boolean createNodes) {
        XMPNode childNode;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!parent.getOptions().isSchemaNode() && !parent.getOptions().isStruct()) {
            if (!parent.isImplicit()) {
                throw new XMPException("Named children only allowed for schemas and structs", 102, null, 4, null);
            }
            if (parent.getOptions().isArray()) {
                throw new XMPException("Named children not allowed for arrays", 102, null, 4, null);
            }
            if (createNodes) {
                parent.getOptions().setStruct(true);
            }
        }
        if ((childNode = parent.findChildByName(childName)) == null && createNodes) {
            childNode = new XMPNode(childName, null, null, 4, null);
            childNode.setImplicit(true);
            parent.addChild(childNode);
        }
        if (!(childNode != null || !createNodes)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return childNode;
    }

    @JvmStatic
    @Nullable
    public static final XMPNode findNode(@NotNull XMPNode xmpTree, @Nullable XMPPath xpath, boolean createNodes, @Nullable PropertyOptions leafOptions) {
        Intrinsics.checkNotNullParameter((Object)xmpTree, (String)"xmpTree");
        if (xpath == null || xpath.size() == 0) {
            throw new XMPException("Empty XMPPath", 102, null, 4, null);
        }
        XMPNode rootImplicitNode = null;
        XMPNode currNode = XMPNodeUtils.findSchemaNode(xmpTree, xpath.getSegment(0).getName(), createNodes);
        if (currNode == null) {
            return null;
        }
        if (currNode.isImplicit()) {
            currNode.setImplicit(false);
            rootImplicitNode = currNode;
        }
        try {
            int n = xpath.size();
            for (int index = 1; index < n; ++index) {
                if ((currNode = INSTANCE.followXPathStep(currNode, xpath.getSegment(index), createNodes)) == null) {
                    if (createNodes) {
                        XMPNode xMPNode = rootImplicitNode;
                        Intrinsics.checkNotNull((Object)xMPNode);
                        XMPNodeUtils.deleteNode(xMPNode);
                    }
                    return null;
                }
                if (!currNode.isImplicit()) continue;
                currNode.setImplicit(false);
                if (index == 1 && xpath.getSegment(index).isAlias() && xpath.getSegment(index).getAliasForm() != 0) {
                    currNode.getOptions().setOption(xpath.getSegment(index).getAliasForm(), true);
                } else if (index < xpath.size() - 1 && xpath.getSegment(index).getKind() == 1 && !currNode.getOptions().isCompositeProperty()) {
                    currNode.getOptions().setStruct(true);
                }
                if (rootImplicitNode != null) continue;
                rootImplicitNode = currNode;
            }
        }
        catch (XMPException ex) {
            if (rootImplicitNode != null) {
                XMPNodeUtils.deleteNode(rootImplicitNode);
            }
            throw ex;
        }
        if (rootImplicitNode != null) {
            if (leafOptions != null) {
                currNode.getOptions().mergeWith(leafOptions);
            }
            currNode.setOptions(currNode.getOptions());
        }
        return currNode;
    }

    @JvmStatic
    public static final void deleteNode(@NotNull XMPNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        XMPNode parent = node.getParent();
        if (node.getOptions().isQualifier()) {
            XMPNode xMPNode = parent;
            Intrinsics.checkNotNull((Object)xMPNode);
            xMPNode.removeQualifier(node);
        } else {
            XMPNode xMPNode = parent;
            Intrinsics.checkNotNull((Object)xMPNode);
            xMPNode.removeChild(node);
        }
        if (!parent.hasChildren() && parent.getOptions().isSchemaNode()) {
            XMPNode xMPNode = parent.getParent();
            Intrinsics.checkNotNull((Object)xMPNode);
            xMPNode.removeChild(parent);
        }
    }

    @JvmStatic
    public static final void setNodeValue(@NotNull XMPNode node, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String strValue = INSTANCE.serializeNodeValue(value);
        if (!node.getOptions().isQualifier() || !Intrinsics.areEqual((Object)"xml:lang", (Object)node.getName())) {
            node.setValue(strValue);
        } else {
            String string = strValue;
            Intrinsics.checkNotNull((Object)string);
            node.setValue(Utils.normalizeLangValue(string));
        }
    }

    @JvmStatic
    @NotNull
    public static final PropertyOptions verifySetOptions(@NotNull PropertyOptions options, @Nullable Object itemValue) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (options.isArrayAltText()) {
            options.setArrayAlternate(true);
        }
        if (options.isArrayAlternate()) {
            options.setArrayOrdered(true);
        }
        if (options.isArrayOrdered()) {
            options.setArray(true);
        }
        if (options.isCompositeProperty() && itemValue != null && ((CharSequence)itemValue.toString()).length() > 0) {
            throw new XMPException("Structs and arrays can't have values", 103, null, 4, null);
        }
        options.assertConsistency(options.getOptions());
        return options;
    }

    @Nullable
    public final String serializeNodeValue(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        Object object = value;
        String strValue = object instanceof Boolean ? (((Boolean)value).booleanValue() ? "True" : "False") : (object instanceof Integer ? String.valueOf(((Number)value).intValue()) : (object instanceof Long ? String.valueOf(((Number)value).longValue()) : (object instanceof Double ? String.valueOf(((Number)value).doubleValue()) : (object instanceof byte[] ? XMPUtils.encodeBase64((byte[])value) : value.toString()))));
        return Utils.replaceControlCharsWithSpace(strValue);
    }

    private final XMPNode followXPathStep(XMPNode parentNode, XMPPathSegment nextStep, boolean createNodes) {
        XMPNode nextNode = null;
        int stepKind = nextStep.getKind();
        switch (stepKind) {
            case 1: {
                nextNode = this.findChildNode(parentNode, nextStep.getName(), createNodes);
                break;
            }
            case 2: {
                String string = nextStep.getName();
                Intrinsics.checkNotNull((Object)string);
                String string2 = string.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                nextNode = this.findQualifierNode(parentNode, string2, createNodes);
                break;
            }
            default: {
                if (!parentNode.getOptions().isArray()) {
                    throw new XMPException("Indexing applied to non-array", 102, null, 4, null);
                }
                int index = switch (stepKind) {
                    case 3 -> {
                        String v2 = nextStep.getName();
                        Intrinsics.checkNotNull((Object)v2);
                        yield this.findIndexedItem(parentNode, v2, createNodes);
                    }
                    case 4 -> parentNode.getChildrenLength();
                    case 6 -> {
                        String v4 = nextStep.getName();
                        Intrinsics.checkNotNull((Object)v4);
                        String[] result = Utils.splitNameAndValue(v4);
                        String fieldName = result[0];
                        String fieldValue = result[1];
                        yield this.lookupFieldSelector(parentNode, fieldName, fieldValue);
                    }
                    case 5 -> {
                        String v5 = nextStep.getName();
                        Intrinsics.checkNotNull((Object)v5);
                        String[] result = Utils.splitNameAndValue(v5);
                        String qualName = result[0];
                        String qualValue = result[1];
                        yield this.lookupQualSelector(parentNode, qualName, qualValue, nextStep.getAliasForm());
                    }
                    default -> throw new XMPException("Unknown array indexing step in FollowXPathStep", 9, null, 4, null);
                };
                if (1 > index || index > parentNode.getChildrenLength()) break;
                nextNode = parentNode.getChild(index);
            }
        }
        return nextNode;
    }

    private final XMPNode findQualifierNode(XMPNode parent, String qualName, boolean createNodes) {
        if (!(!StringsKt.startsWith$default((String)qualName, (String)"?", (boolean)false, (int)2, null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        XMPNode xMPNode = parent;
        Intrinsics.checkNotNull((Object)xMPNode);
        XMPNode qualNode = xMPNode.findQualifierByName(qualName);
        if (qualNode == null && createNodes) {
            qualNode = new XMPNode(qualName, null, null, 4, null);
            qualNode.setImplicit(true);
            parent.addQualifier(qualNode);
        }
        return qualNode;
    }

    private final int findIndexedItem(XMPNode arrayNode, String segment, boolean createNodes) {
        int index = 0;
        try {
            String string = segment.substring(1, segment.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String innerSegment = string;
            index = Integer.parseInt(innerSegment);
            if (index < 1) {
                throw new XMPException("Array index must be larger than zero", 102, null, 4, null);
            }
        }
        catch (NumberFormatException ex) {
            throw new XMPException("Array index not digits.", 102, ex);
        }
        if (createNodes && index == arrayNode.getChildrenLength() + 1) {
            XMPNode newItem = new XMPNode("[]", null, null, 4, null);
            newItem.setImplicit(true);
            arrayNode.addChild(newItem);
        }
        return index;
    }

    private final int lookupFieldSelector(XMPNode arrayNode, String fieldName, String fieldValue) {
        int result = -1;
        int index = 1;
        while (true) {
            XMPNode xMPNode = arrayNode;
            Intrinsics.checkNotNull((Object)xMPNode);
            if (index > xMPNode.getChildrenLength() || result >= 0) break;
            XMPNode currItem = arrayNode.getChild(index);
            if (!currItem.getOptions().isStruct()) {
                throw new XMPException("Field selector must be used on array of struct", 102, null, 4, null);
            }
            int childIndex = 1;
            int n = currItem.getChildrenLength();
            if (childIndex <= n) {
                while (true) {
                    XMPNode currField;
                    if (Intrinsics.areEqual((Object)fieldName, (Object)(currField = currItem.getChild(childIndex)).getName()) && Intrinsics.areEqual((Object)fieldValue, (Object)currField.getValue())) {
                        result = index;
                        break;
                    }
                    if (childIndex == n) break;
                    ++childIndex;
                }
            }
            ++index;
        }
        return result;
    }

    private final int lookupQualSelector(XMPNode arrayNode, String qualName, String qualValue, int aliasForm) {
        int n;
        if (Intrinsics.areEqual((Object)"xml:lang", (Object)qualName)) {
            String normalizedQualValue = Utils.normalizeLangValue(qualValue);
            int index = this.lookupLanguageItem(arrayNode, normalizedQualValue);
            if (index < 0 && (aliasForm & 0x1000) > 0) {
                XMPNode langNode = new XMPNode("[]", null, null, 4, null);
                XMPNode xdefault = new XMPNode("xml:lang", "x-default", null, 4, null);
                langNode.addQualifier(xdefault);
                arrayNode.addChild(1, langNode);
                n = 1;
            } else {
                n = index;
            }
        } else {
            int n2 = arrayNode.getChildrenLength();
            for (int index = 1; index < n2; ++index) {
                XMPNode currItem = arrayNode.getChild(index);
                for (XMPNode qualifier : currItem.getQualifier()) {
                    if (!Intrinsics.areEqual((Object)qualName, (Object)qualifier.getName()) || !Intrinsics.areEqual((Object)qualValue, (Object)qualifier.getValue())) continue;
                    return index;
                }
            }
            n = -1;
        }
        return n;
    }

    public final void normalizeLangArray(@NotNull XMPNode arrayNode) {
        Intrinsics.checkNotNullParameter((Object)arrayNode, (String)"arrayNode");
        if (!arrayNode.getOptions().isArrayAltText()) {
            return;
        }
        int index = 2;
        int n = arrayNode.getChildrenLength();
        if (index <= n) {
            while (true) {
                XMPNode child;
                if ((child = arrayNode.getChild(index)).hasQualifier() && Intrinsics.areEqual((Object)"x-default", (Object)child.getQualifier(1).getValue())) {
                    arrayNode.removeChild(index);
                    arrayNode.addChild(1, child);
                    if (index != 2) break;
                    arrayNode.getChild(2).setValue(child.getValue());
                    break;
                }
                if (index == n) break;
                ++index;
            }
        }
    }

    public final void detectAltText(@NotNull XMPNode arrayNode) {
        Intrinsics.checkNotNullParameter((Object)arrayNode, (String)"arrayNode");
        if (arrayNode.getOptions().isArrayAlternate() && arrayNode.hasChildren()) {
            boolean isAltText = false;
            for (XMPNode child : arrayNode.getChildren()) {
                if (!child.getOptions().hasLanguage()) continue;
                isAltText = true;
                break;
            }
            if (isAltText) {
                arrayNode.getOptions().setArrayAltText(true);
                this.normalizeLangArray(arrayNode);
            }
        }
    }

    @JvmStatic
    public static final void appendLangItem(@NotNull XMPNode arrayNode, @Nullable String itemLang, @Nullable String itemValue) {
        Intrinsics.checkNotNullParameter((Object)arrayNode, (String)"arrayNode");
        XMPNode newItem = new XMPNode("[]", itemValue, null, 4, null);
        XMPNode langQual = new XMPNode("xml:lang", itemLang, null, 4, null);
        newItem.addQualifier(langQual);
        if (!Intrinsics.areEqual((Object)"x-default", (Object)langQual.getValue())) {
            arrayNode.addChild(newItem);
        } else {
            arrayNode.addChild(1, newItem);
        }
    }

    @JvmStatic
    @NotNull
    public static final Object[] chooseLocalizedText(@NotNull XMPNode arrayNode, @Nullable String genericLang, @NotNull String specificLang) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)arrayNode, (String)"arrayNode");
        Intrinsics.checkNotNullParameter((Object)specificLang, (String)"specificLang");
        if (!arrayNode.getOptions().isArrayAltText()) {
            throw new XMPException("Localized text array is not alt-text", 102, null, 4, null);
        }
        if (!arrayNode.hasChildren()) {
            Object[] objectArray2 = new Object[]{0, null};
            return objectArray2;
        }
        int foundGenericMatches = 0;
        XMPNode resultNode = null;
        XMPNode xDefault = null;
        Iterator<XMPNode> it = arrayNode.iterateChildren();
        while (it.hasNext()) {
            XMPNode currItem = it.next();
            if (currItem.getOptions().isCompositeProperty()) {
                throw new XMPException("Alt-text array item is not simple", 102, null, 4, null);
            }
            if (!currItem.hasQualifier() || !Intrinsics.areEqual((Object)"xml:lang", (Object)currItem.getQualifier(1).getName())) {
                throw new XMPException("Alt-text array item has no language qualifier", 102, null, 4, null);
            }
            String currLang = currItem.getQualifier(1).getValue();
            if (Intrinsics.areEqual((Object)specificLang, (Object)currLang)) {
                Object[] objectArray3 = new Object[]{1, currItem};
                return objectArray3;
            }
            if (genericLang != null) {
                String string = currLang;
                Intrinsics.checkNotNull((Object)string);
                if (StringsKt.startsWith$default((String)string, (String)genericLang, (boolean)false, (int)2, null)) {
                    if (resultNode == null) {
                        resultNode = currItem;
                    }
                    ++foundGenericMatches;
                    continue;
                }
            }
            if (!Intrinsics.areEqual((Object)"x-default", (Object)currLang)) continue;
            xDefault = currItem;
        }
        if (foundGenericMatches == 1) {
            var7_8 = new Object[]{2, resultNode};
            objectArray = var7_8;
        } else if (foundGenericMatches > 1) {
            var7_8 = new Object[]{3, resultNode};
            objectArray = var7_8;
        } else if (xDefault != null) {
            var7_8 = new Object[]{4, xDefault};
            objectArray = var7_8;
        } else {
            var7_8 = new Object[]{5, arrayNode.getChild(1)};
            objectArray = var7_8;
        }
        return objectArray;
    }

    public final int lookupLanguageItem(@Nullable XMPNode arrayNode, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        XMPNode xMPNode = arrayNode;
        Intrinsics.checkNotNull((Object)xMPNode);
        if (!xMPNode.getOptions().isArray()) {
            throw new XMPException("Language item must be used on array", 102, null, 4, null);
        }
        int index = 1;
        int n = arrayNode.getChildrenLength();
        if (index <= n) {
            while (true) {
                XMPNode child;
                if ((child = arrayNode.getChild(index)).hasQualifier() && Intrinsics.areEqual((Object)"xml:lang", (Object)child.getQualifier(1).getName()) && Intrinsics.areEqual((Object)language, (Object)child.getQualifier(1).getValue())) {
                    return index;
                }
                if (index == n) break;
                ++index;
            }
        }
        return -1;
    }
}

