/*
 * Decompiled with CFR 0.152.
 */
package com.ashampoo.xmp;

import com.ashampoo.xmp.Utils;
import com.ashampoo.xmp.XMPException;
import com.ashampoo.xmp.XMPMeta;
import com.ashampoo.xmp.XMPNode;
import com.ashampoo.xmp.XMPNodeUtils;
import com.ashampoo.xmp.XMPSchemaRegistry;
import com.ashampoo.xmp.options.ParseOptions;
import com.ashampoo.xmp.options.PropertyOptions;
import com.ashampoo.xmp.properties.XMPAliasInfo;
import com.ashampoo.xmp.xpath.XMPPath;
import com.ashampoo.xmp.xpath.XMPPathParser;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010)\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0012\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J&\u0010\u001c\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/ashampoo/xmp/XMPNormalizer;", "", "()V", "dcArrayForms", "", "", "Lcom/ashampoo/xmp/options/PropertyOptions;", "compareAliasedSubtrees", "", "aliasNode", "Lcom/ashampoo/xmp/XMPNode;", "baseNode", "outerCall", "", "createDCArrays", "deleteEmptySchemas", "tree", "moveExplicitAliases", "options", "Lcom/ashampoo/xmp/options/ParseOptions;", "normalize", "Lcom/ashampoo/xmp/XMPMeta;", "xmp", "normalizeDCArrays", "dcSchema", "repairAltText", "arrayNode", "touchUpDataModel", "transplantArrayItemAlias", "propertyIt", "", "childNode", "baseArray", "tweakOldXMP", "xmpcore"})
@SourceDebugExtension(value={"SMAP\nXMPNormalizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XMPNormalizer.kt\ncom/ashampoo/xmp/XMPNormalizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,491:1\n1#2:492\n*E\n"})
public final class XMPNormalizer {
    @NotNull
    public static final XMPNormalizer INSTANCE = new XMPNormalizer();
    @NotNull
    private static final Map<String, PropertyOptions> dcArrayForms = INSTANCE.createDCArrays();

    private XMPNormalizer() {
    }

    @JvmStatic
    @NotNull
    public static final XMPMeta normalize(@NotNull XMPMeta xmp, @NotNull ParseOptions options) {
        Intrinsics.checkNotNullParameter((Object)xmp, (String)"xmp");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        XMPNode tree = xmp.getRoot();
        INSTANCE.touchUpDataModel(xmp);
        INSTANCE.moveExplicitAliases(tree, options);
        INSTANCE.tweakOldXMP(tree);
        INSTANCE.deleteEmptySchemas(tree);
        return xmp;
    }

    private final void tweakOldXMP(XMPNode tree) {
        if (tree.getName() != null) {
            String string = tree.getName();
            Intrinsics.checkNotNull((Object)string);
            if (string.length() >= 36) {
                String string2 = tree.getName();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                String nameStr = string3;
                if (StringsKt.startsWith$default((String)nameStr, (String)"uuid:", (boolean)false, (int)2, null)) {
                    String string4 = nameStr.substring(5);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    nameStr = string4;
                }
                if (Utils.checkUUIDFormat(nameStr)) {
                    XMPPath path = XMPPathParser.expandXPath("http://ns.adobe.com/xap/1.0/mm/", "InstanceID");
                    XMPNode idNode = XMPNodeUtils.findNode(tree, path, true, null);
                    if (idNode == null) {
                        throw new XMPException("Failure creating xmpMM:InstanceID", 9, null, 4, null);
                    }
                    idNode.setOptions(new PropertyOptions());
                    idNode.setValue("uuid:" + nameStr);
                    idNode.removeChildren();
                    idNode.removeQualifiers();
                    tree.setName(null);
                }
            }
        }
    }

    private final void touchUpDataModel(XMPMeta xmp) {
        XMPNodeUtils.findSchemaNode(xmp.getRoot(), "http://purl.org/dc/elements/1.1/", true);
        Iterator<XMPNode> it = xmp.getRoot().iterateChildren();
        while (it.hasNext()) {
            XMPNode xMPNode;
            XMPNode currSchema = it.next();
            if (Intrinsics.areEqual((Object)"http://purl.org/dc/elements/1.1/", (Object)currSchema.getName())) {
                this.normalizeDCArrays(currSchema);
                continue;
            }
            if (Intrinsics.areEqual((Object)"http://ns.adobe.com/exif/1.0/", (Object)currSchema.getName())) {
                xMPNode = XMPNodeUtils.INSTANCE.findChildNode(currSchema, "exif:UserComment", false);
                if (xMPNode == null) continue;
                XMPNode userComment = xMPNode;
                boolean bl = false;
                INSTANCE.repairAltText(userComment);
                continue;
            }
            if (!Intrinsics.areEqual((Object)"http://ns.adobe.com/xap/1.0/rights/", (Object)currSchema.getName()) || (xMPNode = XMPNodeUtils.INSTANCE.findChildNode(currSchema, "xmpRights:UsageTerms", false)) == null) continue;
            XMPNode usageTerms = xMPNode;
            boolean bl = false;
            INSTANCE.repairAltText(usageTerms);
        }
    }

    private final void normalizeDCArrays(XMPNode dcSchema) {
        int index = 1;
        int n = dcSchema.getChildrenLength();
        if (index <= n) {
            while (true) {
                XMPNode currProp;
                PropertyOptions arrayForm;
                if ((arrayForm = dcArrayForms.get((currProp = dcSchema.getChild(index)).getName())) != null) {
                    if (currProp.getOptions().isSimple()) {
                        XMPNode newArray = new XMPNode(currProp.getName(), null, arrayForm);
                        currProp.setName("[]");
                        newArray.addChild(currProp);
                        dcSchema.replaceChild(index, newArray);
                        if (arrayForm.isArrayAltText() && !currProp.getOptions().hasLanguage()) {
                            XMPNode newLang = new XMPNode("xml:lang", "x-default", null, 4, null);
                            currProp.addQualifier(newLang);
                        }
                    } else {
                        currProp.getOptions().setOption(7680, false);
                        currProp.getOptions().mergeWith(arrayForm);
                        if (arrayForm.isArrayAltText()) {
                            this.repairAltText(currProp);
                        }
                    }
                }
                if (index == n) break;
                ++index;
            }
        }
    }

    private final void repairAltText(XMPNode arrayNode) {
        if (arrayNode == null || !arrayNode.getOptions().isArray()) {
            return;
        }
        arrayNode.getOptions().setArrayOrdered(true).setArrayAlternate(true).setArrayAltText(true);
        Iterator<XMPNode> it = arrayNode.iterateChildrenMutable();
        while (it.hasNext()) {
            XMPNode currChild = it.next();
            if (currChild.getOptions().isCompositeProperty()) {
                it.remove();
                continue;
            }
            if (currChild.getOptions().hasLanguage()) continue;
            String childValue = currChild.getValue();
            CharSequence charSequence = childValue;
            if (charSequence == null || charSequence.length() == 0) {
                it.remove();
                continue;
            }
            XMPNode repairLang = new XMPNode("xml:lang", "x-repair", null, 4, null);
            currChild.addQualifier(repairLang);
        }
    }

    private final void moveExplicitAliases(XMPNode tree, ParseOptions options) {
        if (!tree.getHasAliases()) {
            return;
        }
        tree.setHasAliases(false);
        boolean strictAliasing = options.getStrictAliasing();
        Iterator<XMPNode> schemaIt = tree.iterateChildren();
        while (schemaIt.hasNext()) {
            XMPNode currSchema = schemaIt.next();
            if (!currSchema.getHasAliases()) continue;
            Iterator<XMPNode> propertyIt = currSchema.iterateChildrenMutable();
            while (propertyIt.hasNext()) {
                XMPNode currProp = propertyIt.next();
                if (!currProp.isAlias()) continue;
                currProp.setAlias(false);
                String string = currProp.getName();
                Intrinsics.checkNotNull((Object)string);
                XMPAliasInfo info = XMPSchemaRegistry.INSTANCE.findAlias(string);
                if (info == null) continue;
                XMPNode baseSchema = XMPNodeUtils.INSTANCE.findSchemaNode(tree, info.getNamespace(), null, true);
                if (baseSchema == null) {
                    boolean $i$a$-checkNotNull-XMPNormalizer$moveExplicitAliases$22 = false;
                    String $i$a$-checkNotNull-XMPNormalizer$moveExplicitAliases$22 = "SchemaNode should have been created.";
                    throw new IllegalStateException($i$a$-checkNotNull-XMPNormalizer$moveExplicitAliases$22.toString());
                }
                baseSchema.setImplicit(false);
                XMPNode baseNode = XMPNodeUtils.INSTANCE.findChildNode(baseSchema, info.getPrefix() + info.getPropName(), false);
                if (baseNode == null) {
                    if (info.getAliasForm().isSimple()) {
                        String qname = info.getPrefix() + info.getPropName();
                        currProp.setName(qname);
                        baseSchema.addChild(currProp);
                        propertyIt.remove();
                        continue;
                    }
                    baseNode = new XMPNode(info.getPrefix() + info.getPropName(), null, info.getAliasForm().toPropertyOptions());
                    baseSchema.addChild(baseNode);
                    this.transplantArrayItemAlias(propertyIt, currProp, baseNode);
                    continue;
                }
                if (info.getAliasForm().isSimple()) {
                    if (strictAliasing) {
                        this.compareAliasedSubtrees(currProp, baseNode, true);
                    }
                    propertyIt.remove();
                    continue;
                }
                XMPNode itemNode = null;
                if (info.getAliasForm().isArrayAltText()) {
                    int xdIndex = XMPNodeUtils.INSTANCE.lookupLanguageItem(baseNode, "x-default");
                    if (xdIndex != -1) {
                        itemNode = baseNode.getChild(xdIndex);
                    }
                } else if (baseNode.hasChildren()) {
                    itemNode = baseNode.getChild(1);
                }
                if (itemNode == null) {
                    this.transplantArrayItemAlias(propertyIt, currProp, baseNode);
                    continue;
                }
                if (strictAliasing) {
                    this.compareAliasedSubtrees(currProp, itemNode, true);
                }
                propertyIt.remove();
            }
            currSchema.setHasAliases(false);
        }
    }

    private final void transplantArrayItemAlias(Iterator<XMPNode> propertyIt, XMPNode childNode, XMPNode baseArray) {
        if (baseArray.getOptions().isArrayAltText()) {
            if (childNode.getOptions().hasLanguage()) {
                throw new XMPException("Alias to x-default already has a language qualifier", 203, null, 4, null);
            }
            XMPNode langQual = new XMPNode("xml:lang", "x-default", null, 4, null);
            childNode.addQualifier(langQual);
        }
        propertyIt.remove();
        childNode.setName("[]");
        baseArray.addChild(childNode);
    }

    private final void deleteEmptySchemas(XMPNode tree) {
        Iterator<XMPNode> it = tree.iterateChildrenMutable();
        while (it.hasNext()) {
            XMPNode schema = it.next();
            if (schema.hasChildren()) continue;
            it.remove();
        }
    }

    private final void compareAliasedSubtrees(XMPNode aliasNode, XMPNode baseNode, boolean outerCall) {
        if (!Intrinsics.areEqual((Object)aliasNode.getValue(), (Object)baseNode.getValue()) || aliasNode.getChildrenLength() != baseNode.getChildrenLength()) {
            throw new XMPException("Mismatch between alias and base nodes", 203, null, 4, null);
        }
        if (!(outerCall || Intrinsics.areEqual((Object)aliasNode.getName(), (Object)baseNode.getName()) && Intrinsics.areEqual((Object)aliasNode.getOptions(), (Object)baseNode.getOptions()) && aliasNode.getQualifierLength() == baseNode.getQualifierLength())) {
            throw new XMPException("Mismatch between alias and base nodes", 203, null, 4, null);
        }
        XMPNormalizer $this$compareAliasedSubtrees_u24lambda_u243 = this;
        boolean bl = false;
        Iterator<XMPNode> an = aliasNode.iterateChildren();
        Iterator<XMPNode> bn = baseNode.iterateChildren();
        while (an.hasNext() && bn.hasNext()) {
            XMPNode aliasChild = an.next();
            XMPNode baseChild = bn.next();
            $this$compareAliasedSubtrees_u24lambda_u243.compareAliasedSubtrees(aliasChild, baseChild, false);
        }
        Iterator<XMPNode> an2 = aliasNode.iterateQualifier();
        Iterator<XMPNode> bn2 = baseNode.iterateQualifier();
        while (an2.hasNext() && bn2.hasNext()) {
            XMPNode aliasQual = an2.next();
            XMPNode baseQual = bn2.next();
            this.compareAliasedSubtrees(aliasQual, baseQual, false);
        }
    }

    private final Map<String, PropertyOptions> createDCArrays() {
        Map dcArrayForms = new LinkedHashMap();
        PropertyOptions bagForm = new PropertyOptions();
        bagForm.setArray(true);
        dcArrayForms.put("dc:contributor", bagForm);
        dcArrayForms.put("dc:language", bagForm);
        dcArrayForms.put("dc:publisher", bagForm);
        dcArrayForms.put("dc:relation", bagForm);
        dcArrayForms.put("dc:subject", bagForm);
        dcArrayForms.put("dc:type", bagForm);
        PropertyOptions seqForm = new PropertyOptions();
        seqForm.setArray(true);
        seqForm.setArrayOrdered(true);
        dcArrayForms.put("dc:creator", seqForm);
        dcArrayForms.put("dc:date", seqForm);
        PropertyOptions altTextForm = new PropertyOptions();
        altTextForm.setArray(true);
        altTextForm.setArrayOrdered(true);
        altTextForm.setArrayAlternate(true);
        altTextForm.setArrayAltText(true);
        dcArrayForms.put("dc:description", altTextForm);
        dcArrayForms.put("dc:rights", altTextForm);
        dcArrayForms.put("dc:title", altTextForm);
        return dcArrayForms;
    }
}

