/*
 * Decompiled with CFR 0.152.
 */
package com.ashampoo.xmp;

import com.ashampoo.xmp.Utils;
import com.ashampoo.xmp.XMPException;
import com.ashampoo.xmp.xpath.XMPPath;
import com.ashampoo.xmp.xpath.XMPPathParser;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J*\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/ashampoo/xmp/XMPPathFactory;", "", "()V", "composeArrayItemPath", "", "arrayName", "itemIndex", "", "composeFieldSelector", "fieldNS", "fieldName", "fieldValue", "composeLangSelector", "langName", "composeQualifierPath", "qualNS", "qualName", "composeStructFieldPath", "xmpcore"})
public final class XMPPathFactory {
    @NotNull
    public static final XMPPathFactory INSTANCE = new XMPPathFactory();

    private XMPPathFactory() {
    }

    @JvmStatic
    @NotNull
    public static final String composeArrayItemPath(@NotNull String arrayName, int itemIndex) {
        Intrinsics.checkNotNullParameter((Object)arrayName, (String)"arrayName");
        if (itemIndex > 0) {
            return arrayName + "[" + itemIndex + "]";
        }
        if (itemIndex == -1) {
            return arrayName + "[last()]";
        }
        throw new XMPException("Array index must be larger than zero", 104, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final String composeStructFieldPath(@NotNull String fieldNS, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldNS, (String)"fieldNS");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        if (((CharSequence)fieldNS).length() == 0) {
            throw new XMPException("Empty field namespace URI", 101, null, 4, null);
        }
        if (((CharSequence)fieldName).length() == 0) {
            throw new XMPException("Empty field name", 102, null, 4, null);
        }
        XMPPath fieldPath = XMPPathParser.expandXPath(fieldNS, fieldName);
        if (fieldPath.size() != 2) {
            throw new XMPException("The field name must be simple", 102, null, 4, null);
        }
        return "/" + fieldPath.getSegment(1).getName();
    }

    @JvmStatic
    @NotNull
    public static final String composeQualifierPath(@NotNull String qualNS, @NotNull String qualName) {
        Intrinsics.checkNotNullParameter((Object)qualNS, (String)"qualNS");
        Intrinsics.checkNotNullParameter((Object)qualName, (String)"qualName");
        if (((CharSequence)qualNS).length() == 0) {
            throw new XMPException("Empty qualifier namespace URI", 101, null, 4, null);
        }
        if (((CharSequence)qualName).length() == 0) {
            throw new XMPException("Empty qualifier name", 102, null, 4, null);
        }
        XMPPath qualPath = XMPPathParser.expandXPath(qualNS, qualName);
        if (qualPath.size() != 2) {
            throw new XMPException("The qualifier name must be simple", 102, null, 4, null);
        }
        return "/?" + qualPath.getSegment(1).getName();
    }

    @NotNull
    public final String composeLangSelector(@NotNull String arrayName, @NotNull String langName) {
        Intrinsics.checkNotNullParameter((Object)arrayName, (String)"arrayName");
        Intrinsics.checkNotNullParameter((Object)langName, (String)"langName");
        return arrayName + "[?xml:lang=\"" + Utils.normalizeLangValue(langName) + "\"]";
    }

    @NotNull
    public final String composeFieldSelector(@NotNull String arrayName, @Nullable String fieldNS, @Nullable String fieldName, @NotNull String fieldValue) {
        Intrinsics.checkNotNullParameter((Object)arrayName, (String)"arrayName");
        Intrinsics.checkNotNullParameter((Object)fieldValue, (String)"fieldValue");
        XMPPath fieldPath = XMPPathParser.expandXPath(fieldNS, fieldName);
        if (fieldPath.size() != 2) {
            throw new XMPException("The fieldName name must be simple", 102, null, 4, null);
        }
        return arrayName + "[" + fieldPath.getSegment(1).getName() + "=\"" + fieldValue + "\"]";
    }
}

