/*
 * Decompiled with CFR 0.152.
 */
package com.ashampoo.xmp;

import com.ashampoo.xmp.Utils;
import com.ashampoo.xmp.XMPException;
import com.ashampoo.xmp.XMPMeta;
import com.ashampoo.xmp.XMPNode;
import com.ashampoo.xmp.XMPNodeUtils;
import com.ashampoo.xmp.XMPSchemaRegistry;
import com.ashampoo.xmp.options.ParseOptions;
import com.ashampoo.xmp.options.PropertyOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001e\u001a\u00060\u001fj\u0002` 2\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0014\u0010(\u001a\u00020\u00062\n\u0010)\u001a\u00060\u001fj\u0002` H\u0002J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0006H\u0002J\u0010\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u0004H\u0002J\u0010\u0010.\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0006H\u0002J\u0010\u0010/\u001a\u00020#2\u0006\u0010+\u001a\u00020\u0006H\u0002J\u0014\u00100\u001a\u00020#2\n\u0010)\u001a\u00060\u001fj\u0002` H\u0002J\u001c\u00101\u001a\u00020\u001c2\n\u00102\u001a\u00060\u001fj\u0002` 2\u0006\u00103\u001a\u000204H\u0007J,\u00105\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001e\u001a\u000606j\u0002`72\u0006\u0010\"\u001a\u00020#H\u0002J,\u00108\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001e\u001a\u000606j\u0002`72\u0006\u0010\"\u001a\u00020#H\u0002J4\u00109\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001e\u001a\u000606j\u0002`72\u0006\u0010\"\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0002J,\u0010:\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001e\u001a\u000606j\u0002`72\u0006\u0010\"\u001a\u00020#H\u0002J4\u0010;\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001e\u001a\u000606j\u0002`72\u0006\u0010\"\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0002J8\u0010<\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u000e\u0010=\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` 2\u0006\u0010\"\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0002J4\u0010>\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001e\u001a\u000606j\u0002`72\u0006\u0010\"\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0002J\"\u0010?\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010@\u001a\u00060\u001fj\u0002` 2\u0006\u00103\u001a\u000204J4\u0010A\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001e\u001a\u000606j\u0002`72\u0006\u0010\"\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/ashampoo/xmp/XMPRDFParser;", "", "()V", "DEFAULT_PREFIX", "", "RDFTERM_ABOUT", "", "RDFTERM_ABOUT_EACH", "RDFTERM_ABOUT_EACH_PREFIX", "RDFTERM_BAG_ID", "RDFTERM_DATATYPE", "RDFTERM_DESCRIPTION", "RDFTERM_FIRST_CORE", "RDFTERM_FIRST_OLD", "RDFTERM_FIRST_SYNTAX", "RDFTERM_ID", "RDFTERM_LAST_CORE", "RDFTERM_LAST_OLD", "RDFTERM_LAST_SYNTAX", "RDFTERM_LI", "RDFTERM_NODE_ID", "RDFTERM_OTHER", "RDFTERM_PARSE_TYPE", "RDFTERM_RDF", "RDFTERM_RESOURCE", "addChildNode", "Lcom/ashampoo/xmp/XMPNode;", "xmp", "Lcom/ashampoo/xmp/XMPMeta;", "xmpParent", "xmlNode", "Lorg/w3c/dom/Node;", "Lnl/adaptivity/xmlutil/dom/Node;", "value", "isTopLevel", "", "addQualifierNode", "name", "fixupQualifiedNode", "", "getRDFTermKind", "node", "isCoreSyntaxTerm", "term", "isNumberedArrayItemName", "nodeName", "isOldTerm", "isPropertyElementName", "isWhitespaceNode", "parse", "xmlRoot", "options", "Lcom/ashampoo/xmp/options/ParseOptions;", "parseEmptyPropertyElement", "Lorg/w3c/dom/Element;", "Lnl/adaptivity/xmlutil/dom/Element;", "parseRdfLiteralPropertyElement", "parseRdfNodeElement", "parseRdfNodeElementAttrs", "parseRdfPropertyElement", "parseRdfPropertyElementList", "xmlParent", "parseRdfResourcePropertyElement", "parseRdfRoot", "rdfRdfNode", "parseTypeResourcePropertyElement", "xmpcore"})
@SourceDebugExtension(value={"SMAP\nXMPRDFParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XMPRDFParser.kt\ncom/ashampoo/xmp/XMPRDFParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1187:1\n1#2:1188\n*E\n"})
public final class XMPRDFParser {
    @NotNull
    public static final XMPRDFParser INSTANCE = new XMPRDFParser();
    public static final int RDFTERM_OTHER = 0;
    public static final int RDFTERM_RDF = 1;
    public static final int RDFTERM_ID = 2;
    public static final int RDFTERM_ABOUT = 3;
    public static final int RDFTERM_PARSE_TYPE = 4;
    public static final int RDFTERM_RESOURCE = 5;
    public static final int RDFTERM_NODE_ID = 6;
    public static final int RDFTERM_DATATYPE = 7;
    public static final int RDFTERM_DESCRIPTION = 8;
    public static final int RDFTERM_LI = 9;
    public static final int RDFTERM_ABOUT_EACH = 10;
    public static final int RDFTERM_ABOUT_EACH_PREFIX = 11;
    public static final int RDFTERM_BAG_ID = 12;
    public static final int RDFTERM_FIRST_CORE = 1;
    public static final int RDFTERM_LAST_CORE = 7;
    public static final int RDFTERM_FIRST_SYNTAX = 1;
    public static final int RDFTERM_LAST_SYNTAX = 9;
    public static final int RDFTERM_FIRST_OLD = 10;
    public static final int RDFTERM_LAST_OLD = 12;
    @NotNull
    public static final String DEFAULT_PREFIX = "_dflt";

    private XMPRDFParser() {
    }

    @JvmStatic
    @NotNull
    public static final XMPMeta parse(@NotNull Node xmlRoot, @NotNull ParseOptions options) {
        Intrinsics.checkNotNullParameter((Object)xmlRoot, (String)"xmlRoot");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        XMPMeta xmp = new XMPMeta();
        INSTANCE.parseRdfRoot(xmp, xmlRoot, options);
        return xmp;
    }

    public final void parseRdfRoot(@NotNull XMPMeta xmp, @NotNull Node rdfRdfNode, @NotNull ParseOptions options) {
        Intrinsics.checkNotNullParameter((Object)xmp, (String)"xmp");
        Intrinsics.checkNotNullParameter((Object)rdfRdfNode, (String)"rdfRdfNode");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!Intrinsics.areEqual((Object)rdfRdfNode.getNodeName(), (Object)"rdf:RDF")) {
            throw new XMPException("Root node should be of type rdf:RDF", 202, null, 4, null);
        }
        if (!(rdfRdfNode instanceof Element)) {
            throw new XMPException("Root node must be of element type.", 202, null, 4, null);
        }
        if (((Element)rdfRdfNode).getAttributes().getLength() == 0) {
            throw new XMPException("Illegal: rdf:RDF node has no attributes", 202, null, 4, null);
        }
        int n = ((Element)rdfRdfNode).getChildNodes().getLength();
        for (int index = 0; index < n; ++index) {
            Node child;
            Intrinsics.checkNotNull((Object)((Element)rdfRdfNode).getChildNodes().item(index));
            if (this.isWhitespaceNode(child)) continue;
            this.parseRdfNodeElement(xmp, xmp.getRoot(), (Element)child, true, options);
        }
    }

    private final void parseRdfNodeElement(XMPMeta xmp, XMPNode xmpParent, Element xmlNode, boolean isTopLevel, ParseOptions options) {
        int nodeTerm = this.getRDFTermKind(xmlNode);
        if (nodeTerm != 8 && nodeTerm != 0) {
            throw new XMPException("Node element must be rdf:Description or typed node", 202, null, 4, null);
        }
        if (isTopLevel && nodeTerm == 0) {
            throw new XMPException("Top level typed node not allowed", 203, null, 4, null);
        }
        this.parseRdfNodeElementAttrs(xmp, xmpParent, xmlNode, isTopLevel);
        this.parseRdfPropertyElementList(xmp, xmpParent, xmlNode, isTopLevel, options);
    }

    private final void parseRdfNodeElementAttrs(XMPMeta xmp, XMPNode xmpParent, Element xmlNode, boolean isTopLevel) {
        int exclusiveAttrs = 0;
        int n = xmlNode.getAttributes().getLength();
        block4: for (int index = 0; index < n; ++index) {
            Node node = xmlNode.getAttributes().item(index);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr{ nl.adaptivity.xmlutil.dom.DomaliassesKt.Attr }");
            Attr attribute = (Attr)node;
            if (Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getPrefix()) || attribute.getPrefix() == null && Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getNodeName())) continue;
            int attrTerm = this.getRDFTermKind(attribute);
            switch (attrTerm) {
                case 2: 
                case 3: 
                case 6: {
                    if (exclusiveAttrs > 0) {
                        throw new XMPException("Mutally exclusive about, ID, nodeID attributes", 202, null, 4, null);
                    }
                    ++exclusiveAttrs;
                    if (!isTopLevel || attrTerm != 3) continue block4;
                    if (xmpParent.getName() != null) {
                        String string = xmpParent.getName();
                        Intrinsics.checkNotNull((Object)string);
                        if (((CharSequence)string).length() > 0) {
                            if (Intrinsics.areEqual((Object)xmpParent.getName(), (Object)attribute.getValue())) continue block4;
                            throw new XMPException("Mismatched top level rdf:about values", 203, null, 4, null);
                        }
                    }
                    xmpParent.setName(attribute.getValue());
                    continue block4;
                }
                case 0: {
                    this.addChildNode(xmp, xmpParent, attribute, attribute.getValue(), isTopLevel);
                    continue block4;
                }
                default: {
                    throw new XMPException("Invalid nodeElement attribute", 202, null, 4, null);
                }
            }
        }
    }

    private final void parseRdfPropertyElementList(XMPMeta xmp, XMPNode xmpParent, Node xmlParent, boolean isTopLevel, ParseOptions options) {
        Node node = xmlParent;
        Intrinsics.checkNotNull((Object)node);
        int n = node.getChildNodes().getLength();
        for (int index = 0; index < n; ++index) {
            Node currChild;
            Intrinsics.checkNotNull((Object)xmlParent.getChildNodes().item(index));
            if (this.isWhitespaceNode(currChild)) continue;
            if (!(currChild instanceof Element)) {
                throw new XMPException("Expected property element node not found", 202, null, 4, null);
            }
            this.parseRdfPropertyElement(xmp, xmpParent, (Element)currChild, isTopLevel, options);
        }
    }

    private final void parseRdfPropertyElement(XMPMeta xmp, XMPNode xmpParent, Element xmlNode, boolean isTopLevel, ParseOptions options) {
        Attr attribute;
        int index;
        int nodeTerm = this.getRDFTermKind(xmlNode);
        if (!this.isPropertyElementName(nodeTerm)) {
            throw new XMPException("Invalid property element name", 202, null, 4, null);
        }
        NamedNodeMap attributes = xmlNode.getAttributes();
        List nsAttrs = null;
        int n = attributes.getLength();
        for (index = 0; index < n; ++index) {
            Node node = attributes.item(index);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr{ nl.adaptivity.xmlutil.dom.DomaliassesKt.Attr }");
            attribute = (Attr)node;
            if (!Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getPrefix()) && (attribute.getPrefix() != null || !Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getNodeName()))) continue;
            if (nsAttrs == null) {
                nsAttrs = new ArrayList();
            }
            String string = attribute.getNodeName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNodeName(...)");
            nsAttrs.add(string);
        }
        if (nsAttrs != null) {
            Iterator it = nsAttrs.iterator();
            while (it.hasNext()) {
                attributes.removeNamedItem((String)it.next());
            }
        }
        if (attributes.getLength() > 3) {
            this.parseEmptyPropertyElement(xmp, xmpParent, xmlNode, isTopLevel);
        } else {
            n = attributes.getLength();
            for (index = 0; index < n; ++index) {
                boolean condition;
                Node node = attributes.item(index);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr{ nl.adaptivity.xmlutil.dom.DomaliassesKt.Attr }");
                attribute = (Attr)node;
                String attrValue = attribute.getValue();
                boolean bl = condition = Intrinsics.areEqual((Object)"xml:lang", (Object)attribute.getNodeName()) && (!Intrinsics.areEqual((Object)"ID", (Object)attribute.getLocalName()) || !Intrinsics.areEqual((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)attribute.getNamespaceURI()));
                if (condition) continue;
                if (Intrinsics.areEqual((Object)"datatype", (Object)attribute.getLocalName()) && Intrinsics.areEqual((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)attribute.getNamespaceURI())) {
                    this.parseRdfLiteralPropertyElement(xmp, xmpParent, xmlNode, isTopLevel);
                } else if (!Intrinsics.areEqual((Object)"parseType", (Object)attribute.getLocalName()) || !Intrinsics.areEqual((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)attribute.getNamespaceURI())) {
                    this.parseEmptyPropertyElement(xmp, xmpParent, xmlNode, isTopLevel);
                } else {
                    if (Intrinsics.areEqual((Object)"Literal", (Object)attrValue)) {
                        throw new XMPException("Literal property element not allowed", 203, null, 4, null);
                    }
                    if (Intrinsics.areEqual((Object)"Resource", (Object)attrValue)) {
                        this.parseTypeResourcePropertyElement(xmp, xmpParent, xmlNode, isTopLevel, options);
                    } else {
                        if (Intrinsics.areEqual((Object)"Collection", (Object)attrValue)) {
                            throw new XMPException("Collection property element forbidden", 203, null, 4, null);
                        }
                        throw new XMPException("Other property element not allowed", 203, null, 4, null);
                    }
                }
                return;
            }
            if (xmlNode.getChildNodes().getLength() > 0) {
                n = xmlNode.getChildNodes().getLength();
                for (index = 0; index < n; ++index) {
                    Node currentChild = xmlNode.getChildNodes().item(index);
                    if (currentChild instanceof Text) continue;
                    this.parseRdfResourcePropertyElement(xmp, xmpParent, xmlNode, isTopLevel, options);
                    return;
                }
                this.parseRdfLiteralPropertyElement(xmp, xmpParent, xmlNode, isTopLevel);
            } else {
                this.parseEmptyPropertyElement(xmp, xmpParent, xmlNode, isTopLevel);
            }
        }
    }

    private final void parseRdfResourcePropertyElement(XMPMeta xmp, XMPNode xmpParent, Element xmlNode, boolean isTopLevel, ParseOptions options) {
        if (isTopLevel && Intrinsics.areEqual((Object)"iX:changes", (Object)xmlNode.getNodeName())) {
            return;
        }
        XMPNode newCompound = this.addChildNode(xmp, xmpParent, xmlNode, "", isTopLevel);
        int n = xmlNode.getAttributes().getLength();
        for (int index = 0; index < n; ++index) {
            Node node = xmlNode.getAttributes().item(index);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr{ nl.adaptivity.xmlutil.dom.DomaliassesKt.Attr }");
            Attr attribute = (Attr)node;
            if (Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getPrefix()) || attribute.getPrefix() == null && Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getNodeName())) continue;
            if (Intrinsics.areEqual((Object)"xml:lang", (Object)attribute.getNodeName())) {
                String string = attribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                this.addQualifierNode(newCompound, "xml:lang", string);
                continue;
            }
            if (Intrinsics.areEqual((Object)"ID", (Object)attribute.getLocalName()) && Intrinsics.areEqual((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)attribute.getNamespaceURI())) continue;
            throw new XMPException("Invalid attribute for resource property element", 202, null, 4, null);
        }
        boolean found = false;
        int n2 = xmlNode.getChildNodes().getLength();
        for (int index = 0; index < n2; ++index) {
            Node currentChild;
            Intrinsics.checkNotNull((Object)xmlNode.getChildNodes().item(index));
            if (this.isWhitespaceNode(currentChild)) continue;
            if (currentChild instanceof Element && !found) {
                boolean isRDF = Intrinsics.areEqual((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)((Element)currentChild).getNamespaceURI());
                String localName = ((Element)currentChild).getLocalName();
                if (isRDF && Intrinsics.areEqual((Object)"Bag", (Object)localName)) {
                    newCompound.getOptions().setArray(true);
                } else if (isRDF && Intrinsics.areEqual((Object)"Seq", (Object)localName)) {
                    newCompound.getOptions().setArray(true).setArrayOrdered(true);
                } else if (isRDF && Intrinsics.areEqual((Object)"Alt", (Object)localName)) {
                    newCompound.getOptions().setArray(true).setArrayOrdered(true).setArrayAlternate(true);
                } else {
                    newCompound.getOptions().setStruct(true);
                    if (!isRDF && !Intrinsics.areEqual((Object)"Description", (Object)localName)) {
                        String string = ((Element)currentChild).getNamespaceURI();
                        if (string == null) {
                            throw new XMPException("All XML elements must be in a namespace", 203, null, 4, null);
                        }
                        Object typeName = string;
                        typeName = (String)typeName + ":" + localName;
                        this.addQualifierNode(newCompound, "rdf:type", (String)typeName);
                    }
                }
                this.parseRdfNodeElement(xmp, newCompound, (Element)currentChild, false, options);
                if (newCompound.getHasValueChild()) {
                    this.fixupQualifiedNode(newCompound);
                } else if (newCompound.getOptions().isArrayAlternate()) {
                    XMPNodeUtils.INSTANCE.detectAltText(newCompound);
                }
                found = true;
                continue;
            }
            if (found) {
                throw new XMPException("Invalid child of resource property element", 202, null, 4, null);
            }
            throw new XMPException("Children of resource property element must be XML elements", 202, null, 4, null);
        }
        if (!found) {
            throw new XMPException("Missing child of resource property element", 202, null, 4, null);
        }
    }

    private final void parseRdfLiteralPropertyElement(XMPMeta xmp, XMPNode xmpParent, Element xmlNode, boolean isTopLevel) {
        XMPNode newChild = this.addChildNode(xmp, xmpParent, xmlNode, null, isTopLevel);
        int n = xmlNode.getAttributes().getLength();
        for (int index = 0; index < n; ++index) {
            Node node = xmlNode.getAttributes().item(index);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr{ nl.adaptivity.xmlutil.dom.DomaliassesKt.Attr }");
            Attr attribute = (Attr)node;
            if (Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getPrefix()) || attribute.getPrefix() == null && Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getNodeName())) continue;
            if (Intrinsics.areEqual((Object)"xml:lang", (Object)attribute.getNodeName())) {
                String string = attribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                this.addQualifierNode(newChild, "xml:lang", string);
                continue;
            }
            if (Intrinsics.areEqual((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)attribute.getNamespaceURI()) && (Intrinsics.areEqual((Object)"ID", (Object)attribute.getLocalName()) || Intrinsics.areEqual((Object)"datatype", (Object)attribute.getLocalName()))) continue;
            throw new XMPException("Invalid attribute for literal property element", 202, null, 4, null);
        }
        Object textValue = "";
        int n2 = xmlNode.getChildNodes().getLength();
        for (int index = 0; index < n2; ++index) {
            Node child = xmlNode.getChildNodes().item(index);
            if (!(child instanceof Text)) {
                throw new XMPException("Invalid child of literal property element", 202, null, 4, null);
            }
            textValue = (String)textValue + ((Text)child).getData();
        }
        newChild.setValue((String)textValue);
    }

    private final void parseTypeResourcePropertyElement(XMPMeta xmp, XMPNode xmpParent, Element xmlNode, boolean isTopLevel, ParseOptions options) {
        XMPNode newStruct = this.addChildNode(xmp, xmpParent, xmlNode, "", isTopLevel);
        newStruct.getOptions().setStruct(true);
        int n = xmlNode.getAttributes().getLength();
        for (int index = 0; index < n; ++index) {
            Node node = xmlNode.getAttributes().item(index);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr{ nl.adaptivity.xmlutil.dom.DomaliassesKt.Attr }");
            Attr attribute = (Attr)node;
            if (Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getPrefix()) || attribute.getPrefix() == null && Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getNodeName())) continue;
            if (Intrinsics.areEqual((Object)"xml:lang", (Object)attribute.getNodeName())) {
                String string = attribute.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                this.addQualifierNode(newStruct, "xml:lang", string);
                continue;
            }
            if (Intrinsics.areEqual((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)attribute.getNamespaceURI()) && (Intrinsics.areEqual((Object)"ID", (Object)attribute.getLocalName()) || Intrinsics.areEqual((Object)"parseType", (Object)attribute.getLocalName()))) continue;
            throw new XMPException("Invalid attribute for ParseTypeResource property element", 202, null, 4, null);
        }
        this.parseRdfPropertyElementList(xmp, newStruct, xmlNode, false, options);
        if (newStruct.getHasValueChild()) {
            this.fixupQualifiedNode(newStruct);
        }
    }

    private final void parseEmptyPropertyElement(XMPMeta xmp, XMPNode xmpParent, Element xmlNode, boolean isTopLevel) {
        boolean hasPropertyAttrs = false;
        boolean hasResourceAttr = false;
        boolean hasNodeIDAttr = false;
        boolean hasValueAttr = false;
        Node valueNode = null;
        if (xmlNode.getChildNodes().getLength() > 0) {
            throw new XMPException("Nested content not allowed with rdf:resource or property attributes", 202, null, 4, null);
        }
        int n = xmlNode.getAttributes().getLength();
        block11: for (int index = 0; index < n; ++index) {
            Node node = xmlNode.getAttributes().item(index);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr{ nl.adaptivity.xmlutil.dom.DomaliassesKt.Attr }");
            Attr attribute = (Attr)node;
            if (Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getPrefix()) || attribute.getPrefix() == null && Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getNodeName())) continue;
            int attrTerm = this.getRDFTermKind(attribute);
            switch (attrTerm) {
                case 2: {
                    continue block11;
                }
                case 5: {
                    if (hasNodeIDAttr) {
                        throw new XMPException("Empty property element can't have both rdf:resource and rdf:nodeID", 202, null, 4, null);
                    }
                    if (hasValueAttr) {
                        throw new XMPException("Empty property element can't have both rdf:value and rdf:resource", 203, null, 4, null);
                    }
                    hasResourceAttr = true;
                    if (hasValueAttr) continue block11;
                    valueNode = attribute;
                    continue block11;
                }
                case 6: {
                    if (hasResourceAttr) {
                        throw new XMPException("Empty property element can't have both rdf:resource and rdf:nodeID", 202, null, 4, null);
                    }
                    hasNodeIDAttr = true;
                    continue block11;
                }
                case 0: {
                    if (Intrinsics.areEqual((Object)attribute.getLocalName(), (Object)"value") && Intrinsics.areEqual((Object)attribute.getNamespaceURI(), (Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                        if (hasResourceAttr) {
                            throw new XMPException("Empty property element can't have both rdf:value and rdf:resource", 203, null, 4, null);
                        }
                        hasValueAttr = true;
                        valueNode = attribute;
                        continue block11;
                    }
                    if (Intrinsics.areEqual((Object)"xml:lang", (Object)attribute.getNodeName())) continue block11;
                    hasPropertyAttrs = true;
                    continue block11;
                }
                default: {
                    throw new XMPException("Unrecognized attribute of empty property element", 202, null, 4, null);
                }
            }
        }
        XMPNode childNode = this.addChildNode(xmp, xmpParent, xmlNode, "", isTopLevel);
        boolean childIsStruct = false;
        if (hasValueAttr || hasResourceAttr) {
            String valueNodeValue;
            String string;
            String string2;
            Node node = valueNode;
            if (node == null) {
                string2 = null;
            } else if (node instanceof Attr) {
                string2 = ((Attr)valueNode).getValue();
            } else {
                throw new XMPException("Unknown Node " + xmlNode.getNodeType(), 203, null, 4, null);
            }
            if ((string = (valueNodeValue = string2)) == null) {
                string = "";
            }
            childNode.setValue(string);
            if (!hasValueAttr) {
                childNode.getOptions().setURI(true);
            }
        } else if (hasPropertyAttrs) {
            childNode.getOptions().setStruct(true);
            childIsStruct = true;
        }
        int n2 = xmlNode.getAttributes().getLength();
        block12: for (int index = 0; index < n2; ++index) {
            Node node = xmlNode.getAttributes().item(index);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr{ nl.adaptivity.xmlutil.dom.DomaliassesKt.Attr }");
            Attr attribute = (Attr)node;
            if (attribute == valueNode || Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getPrefix()) || attribute.getPrefix() == null && Intrinsics.areEqual((Object)"xmlns", (Object)attribute.getNodeName())) continue;
            int attrTerm = this.getRDFTermKind(attribute);
            switch (attrTerm) {
                case 2: 
                case 6: {
                    continue block12;
                }
                case 5: {
                    String string = attribute.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                    this.addQualifierNode(childNode, "rdf:resource", string);
                    continue block12;
                }
                case 0: {
                    if (!childIsStruct) {
                        String string = attribute.getNodeName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNodeName(...)");
                        String string3 = attribute.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
                        this.addQualifierNode(childNode, string, string3);
                        continue block12;
                    }
                    if (Intrinsics.areEqual((Object)"xml:lang", (Object)attribute.getNodeName())) {
                        String string = attribute.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                        this.addQualifierNode(childNode, "xml:lang", string);
                        continue block12;
                    }
                    this.addChildNode(xmp, childNode, attribute, attribute.getValue(), false);
                    continue block12;
                }
                default: {
                    throw new XMPException("Unrecognized attribute of empty property element", 202, null, 4, null);
                }
            }
        }
    }

    private final XMPNode addChildNode(XMPMeta xmp, XMPNode xmpParent, Node xmlNode, String value, boolean isTopLevel) {
        String string;
        Object object;
        String string2;
        Object object2 = xmlNode;
        if (object2 instanceof Element) {
            string2 = ((Element)xmlNode).getNamespaceURI();
        } else if (object2 instanceof Attr) {
            string2 = ((Attr)xmlNode).getNamespaceURI();
        } else {
            throw new XMPException("Unknown Node " + xmlNode.getNodeType(), 203, null, 4, null);
        }
        String namespace = string2;
        object2 = namespace;
        if (object2 == null || object2.length() == 0) {
            throw new XMPException("XML namespace required for all elements and attributes: " + xmlNode, 202, null, 4, null);
        }
        if (Intrinsics.areEqual((Object)"http://purl.org/dc/1.1/", (Object)namespace)) {
            namespace = "http://purl.org/dc/elements/1.1/";
        }
        String string3 = namespace;
        Intrinsics.checkNotNull((Object)string3);
        String prefix = XMPSchemaRegistry.INSTANCE.getNamespacePrefix(string3);
        if (prefix == null) {
            String string4;
            object = xmlNode;
            if (object instanceof Element) {
                string4 = ((Element)xmlNode).getPrefix();
            } else if (object instanceof Attr) {
                string4 = ((Attr)xmlNode).getPrefix();
            } else {
                throw new XMPException("Unknown Node " + xmlNode.getNodeType(), 203, null, 4, null);
            }
            String xmlNodePrefix = string4;
            prefix = xmlNodePrefix != null ? xmlNodePrefix : DEFAULT_PREFIX;
            object = namespace;
            Intrinsics.checkNotNull((Object)object);
            prefix = XMPSchemaRegistry.INSTANCE.registerNamespace((String)object, prefix);
        }
        if ((object = xmlNode) instanceof Element) {
            string = ((Element)xmlNode).getLocalName();
        } else if (object instanceof Attr) {
            string = ((Attr)xmlNode).getLocalName();
        } else {
            throw new XMPException("Unknown Node " + xmlNode.getNodeType(), 203, null, 4, null);
        }
        String xmlNodeLocalName = string;
        String childName = prefix + xmlNodeLocalName;
        PropertyOptions childOptions = new PropertyOptions();
        boolean isAlias = false;
        XMPNode actualXmpParent = xmpParent;
        if (isTopLevel) {
            XMPNode schemaNode = XMPNodeUtils.INSTANCE.findSchemaNode(xmp.getRoot(), namespace, DEFAULT_PREFIX, true);
            if (schemaNode == null) {
                boolean $i$a$-checkNotNull-XMPRDFParser$addChildNode$22 = false;
                String $i$a$-checkNotNull-XMPRDFParser$addChildNode$22 = "SchemaNode should have been created.";
                throw new IllegalStateException($i$a$-checkNotNull-XMPRDFParser$addChildNode$22.toString());
            }
            schemaNode.setImplicit(false);
            actualXmpParent = schemaNode;
            if (XMPSchemaRegistry.INSTANCE.findAlias(childName) != null) {
                isAlias = true;
                xmp.getRoot().setHasAliases(true);
                schemaNode.setHasAliases(true);
            }
        }
        boolean isArrayItem = this.isNumberedArrayItemName(childName);
        boolean isValueNode = Intrinsics.areEqual((Object)"rdf:value", (Object)childName);
        XMPNode newChild = new XMPNode(childName, value, childOptions);
        newChild.setAlias(isAlias);
        if (!isValueNode) {
            actualXmpParent.addChild(newChild);
        } else {
            actualXmpParent.addChild(1, newChild);
        }
        if (isValueNode) {
            if (isTopLevel || !actualXmpParent.getOptions().isStruct()) {
                throw new XMPException("Misplaced rdf:value element", 202, null, 4, null);
            }
            actualXmpParent.setHasValueChild(true);
        }
        boolean isParentArray = actualXmpParent.getOptions().isArray();
        if (isParentArray && isArrayItem) {
            newChild.setName("[]");
        } else {
            if (!isParentArray && isArrayItem) {
                throw new XMPException("Misplaced rdf:li element", 202, null, 4, null);
            }
            if (isParentArray && !isArrayItem) {
                throw new XMPException("Arrays cannot have arbitrary child names", 202, null, 4, null);
            }
        }
        return newChild;
    }

    private final XMPNode addQualifierNode(XMPNode xmpParent, String name, String value) {
        boolean isLang = Intrinsics.areEqual((Object)"xml:lang", (Object)name);
        String normalizedValue = isLang ? Utils.normalizeLangValue(value) : value;
        XMPNode newQualifier = new XMPNode(name, normalizedValue, null, 4, null);
        xmpParent.addQualifier(newQualifier);
        return newQualifier;
    }

    private final void fixupQualifiedNode(XMPNode xmpParent) {
        XMPNode qualifier;
        int n;
        int index;
        if (!(xmpParent.getOptions().isStruct() && xmpParent.hasChildren())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        XMPNode valueNode = xmpParent.getChild(1);
        if (!Intrinsics.areEqual((Object)"rdf:value", (Object)valueNode.getName())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (valueNode.getOptions().hasLanguage()) {
            if (xmpParent.getOptions().hasLanguage()) {
                throw new XMPException("Redundant xml:lang for rdf:value element", 203, null, 4, null);
            }
            XMPNode langQual = valueNode.getQualifier(1);
            valueNode.removeQualifier(langQual);
            xmpParent.addQualifier(langQual);
        }
        if ((index = 1) <= (n = valueNode.getQualifierLength())) {
            while (true) {
                qualifier = valueNode.getQualifier(index);
                xmpParent.addQualifier(qualifier);
                if (index == n) break;
                ++index;
            }
        }
        if ((index = 2) <= (n = xmpParent.getChildrenLength())) {
            while (true) {
                qualifier = xmpParent.getChild(index);
                xmpParent.addQualifier(qualifier);
                if (index == n) break;
                ++index;
            }
        }
        if (!(xmpParent.getOptions().isStruct() || xmpParent.getHasValueChild())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        xmpParent.setHasValueChild(false);
        xmpParent.getOptions().setStruct(false);
        xmpParent.getOptions().mergeWith(valueNode.getOptions());
        xmpParent.setValue(valueNode.getValue());
        xmpParent.removeChildren();
        for (XMPNode child : valueNode.getChildren()) {
            xmpParent.addChild(child);
        }
    }

    private final boolean isWhitespaceNode(Node node) {
        if (!(node instanceof Text)) {
            return false;
        }
        String value = ((Text)node).getData();
        int n = value.length();
        for (int index = 0; index < n; ++index) {
            if (CharsKt.isWhitespace((char)value.charAt(index))) continue;
            return false;
        }
        return true;
    }

    private final boolean isPropertyElementName(int term) {
        if (term == 8 || this.isOldTerm(term)) {
            return false;
        }
        return !this.isCoreSyntaxTerm(term);
    }

    private final boolean isOldTerm(int term) {
        return 10 <= term && term <= 12;
    }

    private final boolean isCoreSyntaxTerm(int term) {
        return 1 <= term && term <= 7;
    }

    /*
     * Unable to fully structure code
     */
    private final int getRDFTermKind(Node node) {
        block50: {
            var3_2 = node;
            if (var3_2 instanceof Element) {
                v0 = ((Element)node).getNamespaceURI();
            } else if (var3_2 instanceof Attr) {
                v0 = ((Attr)node).getNamespaceURI();
            } else {
                throw new XMPException("Unknown Node " + node.getNodeType(), 203, null, 4, null);
            }
            namespace = v0;
            var4_5 = namespace;
            if (!(var4_5 == null || var4_5.length() == 0) || !Intrinsics.areEqual((Object)"about", (Object)node.getNodeName()) && !Intrinsics.areEqual((Object)"ID", (Object)node.getNodeName()) || !(node instanceof Attr)) ** GOTO lbl-1000
            v1 = ((Attr)node).getOwnerElement();
            if (Intrinsics.areEqual((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (Object)(v1 != null ? v1.getNamespaceURI() : null))) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = mustBeRdfNamespace = false;
            }
            if (!mustBeRdfNamespace && !Intrinsics.areEqual((Object)namespace, (Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#") || (var4_5 = node.getNodeName()) == null) break block50;
            tmp = -1;
            switch (var4_5.hashCode()) {
                case -341064690: {
                    if (var4_5.equals("resource")) {
                        tmp = 1;
                    }
                    break;
                }
                case 92611469: {
                    if (var4_5.equals("about")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1055127630: {
                    if (var4_5.equals("rdf:RDF")) {
                        tmp = 3;
                    }
                    break;
                }
                case 380160263: {
                    if (var4_5.equals("rdf:about")) {
                        tmp = 2;
                    }
                    break;
                }
                case -1833071475: {
                    if (var4_5.equals("parseType")) {
                        tmp = 4;
                    }
                    break;
                }
                case -1340118226: {
                    if (var4_5.equals("aboutEach")) {
                        tmp = 5;
                    }
                    break;
                }
                case 93496099: {
                    if (var4_5.equals("bagID")) {
                        tmp = 6;
                    }
                    break;
                }
                case 1790024164: {
                    if (var4_5.equals("datatype")) {
                        tmp = 7;
                    }
                    break;
                }
                case -935795231: {
                    if (var4_5.equals("rdf:ID")) {
                        tmp = 8;
                    }
                    break;
                }
                case -935794109: {
                    if (var4_5.equals("rdf:li")) {
                        tmp = 9;
                    }
                    break;
                }
                case 2331: {
                    if (var4_5.equals("ID")) {
                        tmp = 8;
                    }
                    break;
                }
                case 670789472: {
                    if (var4_5.equals("aboutEachPrefix")) {
                        tmp = 10;
                    }
                    break;
                }
                case 23809494: {
                    if (var4_5.equals("rdf:Description")) {
                        tmp = 11;
                    }
                    break;
                }
                case -1040171363: {
                    if (var4_5.equals("nodeID")) {
                        tmp = 12;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 9: {
                    return 9;
                }
                case 4: {
                    return 4;
                }
                case 11: {
                    return 8;
                }
                case 2: {
                    return 3;
                }
                case 1: {
                    return 5;
                }
                case 3: {
                    return 1;
                }
                case 8: {
                    return 2;
                }
                case 12: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 5: {
                    return 10;
                }
                case 10: {
                    return 11;
                }
                case 6: {
                    return 12;
                }
            }
        }
        return 0;
    }

    private final boolean isNumberedArrayItemName(String nodeName) {
        boolean result = Intrinsics.areEqual((Object)"rdf:li", (Object)nodeName);
        if (StringsKt.startsWith$default((String)nodeName, (String)"rdf:_", (boolean)false, (int)2, null)) {
            result = true;
            int n = nodeName.length();
            for (int i = 5; i < n; ++i) {
                result = result && Intrinsics.compare((int)nodeName.charAt(i), (int)48) >= 0 && Intrinsics.compare((int)nodeName.charAt(i), (int)57) <= 0;
            }
        }
        return result;
    }
}

