/*
 * Decompiled with CFR 0.152.
 */
package com.ashampoo.xmp;

import com.ashampoo.xmp.Utils;
import com.ashampoo.xmp.XMPException;
import com.ashampoo.xmp.XMPNodeUtils;
import com.ashampoo.xmp.options.AliasOptions;
import com.ashampoo.xmp.properties.XMPAliasInfo;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0005J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0005J\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0014J\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0014J0\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0016\u0010 \u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J\b\u0010\"\u001a\u00020\fH\u0002J\b\u0010#\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/ashampoo/xmp/XMPSchemaRegistry;", "", "()V", "aliasMap", "", "", "Lcom/ashampoo/xmp/properties/XMPAliasInfo;", "namespaceToPrefixMap", "prefixToNamespaceMap", "simpleProperyPattern", "Lkotlin/text/Regex;", "deleteNamespace", "", "namespaceURI", "findAlias", "qname", "findAliases", "", "aliasNS", "getAliases", "", "getNamespacePrefix", "getNamespaceURI", "namespacePrefix", "getNamespaces", "getPrefixes", "registerAlias", "aliasProp", "actualNS", "actualProp", "aliasForm", "Lcom/ashampoo/xmp/options/AliasOptions;", "registerNamespace", "suggestedPrefix", "registerStandardAliases", "registerStandardNamespaces", "resolveAlias", "xmpcore"})
public final class XMPSchemaRegistry {
    @NotNull
    public static final XMPSchemaRegistry INSTANCE = new XMPSchemaRegistry();
    @NotNull
    private static final Map<String, String> namespaceToPrefixMap = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> prefixToNamespaceMap = new LinkedHashMap();
    @NotNull
    private static final Map<String, XMPAliasInfo> aliasMap = new LinkedHashMap();
    @NotNull
    private static final Regex simpleProperyPattern = new Regex("[/*?\\[\\]]");

    private XMPSchemaRegistry() {
    }

    @NotNull
    public final String registerNamespace(@NotNull String namespaceURI, @NotNull String suggestedPrefix) {
        Intrinsics.checkNotNullParameter((Object)namespaceURI, (String)"namespaceURI");
        Intrinsics.checkNotNullParameter((Object)suggestedPrefix, (String)"suggestedPrefix");
        Object actualSuggestedPrefix = suggestedPrefix;
        if (((CharSequence)namespaceURI).length() == 0) {
            throw new XMPException("Empty schema namespace URI", 4, null, 4, null);
        }
        if (((CharSequence)actualSuggestedPrefix).length() == 0) {
            throw new XMPException("Empty prefix", 4, null, 4, null);
        }
        if (((String)actualSuggestedPrefix).charAt(((String)actualSuggestedPrefix).length() - 1) != ':') {
            actualSuggestedPrefix = (String)actualSuggestedPrefix + ":";
        }
        String string = ((String)actualSuggestedPrefix).substring(0, ((String)actualSuggestedPrefix).length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (!Utils.isXMLNameNS(string)) {
            throw new XMPException("The prefix is a bad XML name", 201, null, 4, null);
        }
        String registeredPrefix = namespaceToPrefixMap.get(namespaceURI);
        String registeredNS = prefixToNamespaceMap.get(actualSuggestedPrefix);
        if (registeredPrefix != null) {
            return registeredPrefix;
        }
        if (registeredNS != null) {
            Object generatedPrefix = actualSuggestedPrefix;
            int i = 1;
            while (prefixToNamespaceMap.containsKey(generatedPrefix)) {
                String string2 = ((String)actualSuggestedPrefix).substring(0, ((String)actualSuggestedPrefix).length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                generatedPrefix = string2 + "_" + i + "_:";
                ++i;
            }
            actualSuggestedPrefix = generatedPrefix;
        }
        prefixToNamespaceMap.put((String)actualSuggestedPrefix, namespaceURI);
        namespaceToPrefixMap.put(namespaceURI, (String)actualSuggestedPrefix);
        return actualSuggestedPrefix;
    }

    @Nullable
    public final String getNamespacePrefix(@NotNull String namespaceURI) {
        Intrinsics.checkNotNullParameter((Object)namespaceURI, (String)"namespaceURI");
        return namespaceToPrefixMap.get(namespaceURI);
    }

    @Nullable
    public final String getNamespaceURI(@NotNull String namespacePrefix) {
        Intrinsics.checkNotNullParameter((Object)namespacePrefix, (String)"namespacePrefix");
        Object actualNamespacePrefix = namespacePrefix;
        if (!StringsKt.endsWith$default((String)actualNamespacePrefix, (String)":", (boolean)false, (int)2, null)) {
            actualNamespacePrefix = (String)actualNamespacePrefix + ":";
        }
        return prefixToNamespaceMap.get(actualNamespacePrefix);
    }

    @NotNull
    public final Map<String, String> getNamespaces() {
        return namespaceToPrefixMap;
    }

    public final void deleteNamespace(@NotNull String namespaceURI) {
        Intrinsics.checkNotNullParameter((Object)namespaceURI, (String)"namespaceURI");
        String string = this.getNamespacePrefix(namespaceURI);
        if (string == null) {
            return;
        }
        String prefixToDelete = string;
        namespaceToPrefixMap.remove(namespaceURI);
        prefixToNamespaceMap.remove(prefixToDelete);
    }

    @NotNull
    public final Map<String, String> getPrefixes() {
        return prefixToNamespaceMap;
    }

    private final void registerStandardNamespaces() {
        this.registerNamespace("http://www.w3.org/XML/1998/namespace", "xml");
        this.registerNamespace("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.registerNamespace("http://purl.org/dc/elements/1.1/", "dc");
        this.registerNamespace("http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/", "Iptc4xmpCore");
        this.registerNamespace("http://iptc.org/std/Iptc4xmpExt/2008-02-29/", "Iptc4xmpExt");
        this.registerNamespace("http://ns.adobe.com/DICOM/", "DICOM");
        this.registerNamespace("http://ns.useplus.org/ldf/xmp/1.0/", "plus");
        this.registerNamespace("http://www.metadataworkinggroup.com/schemas/regions/", "mwg-rs");
        this.registerNamespace("http://ns.acdsee.com/iptc/1.0/", "acdsee");
        this.registerNamespace("adobe:ns:meta/", "x");
        this.registerNamespace("http://ns.adobe.com/iX/1.0/", "iX");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/", "xmp");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/rights/", "xmpRights");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/mm/", "xmpMM");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/bj/", "xmpBJ");
        this.registerNamespace("http://ns.adobe.com/xmp/note/", "xmpNote");
        this.registerNamespace("http://ns.adobe.com/pdf/1.3/", "pdf");
        this.registerNamespace("http://ns.adobe.com/pdfx/1.3/", "pdfx");
        this.registerNamespace("http://www.npes.org/pdfx/ns/id/", "pdfxid");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/schema#", "pdfaSchema");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/property#", "pdfaProperty");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/type#", "pdfaType");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/field#", "pdfaField");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/id/", "pdfaid");
        this.registerNamespace("http://www.aiim.org/pdfa/ns/extension/", "pdfaExtension");
        this.registerNamespace("http://ns.adobe.com/photoshop/1.0/", "photoshop");
        this.registerNamespace("http://ns.adobe.com/album/1.0/", "album");
        this.registerNamespace("http://ns.adobe.com/exif/1.0/", "exif");
        this.registerNamespace("http://cipa.jp/exif/1.0/", "exifEX");
        this.registerNamespace("http://ns.adobe.com/exif/1.0/aux/", "aux");
        this.registerNamespace("http://ns.adobe.com/tiff/1.0/", "tiff");
        this.registerNamespace("http://ns.adobe.com/png/1.0/", "png");
        this.registerNamespace("http://ns.adobe.com/jpeg/1.0/", "jpeg");
        this.registerNamespace("http://ns.adobe.com/jp2k/1.0/", "jp2k");
        this.registerNamespace("http://ns.adobe.com/camera-raw-settings/1.0/", "crs");
        this.registerNamespace("http://ns.adobe.com/StockPhoto/1.0/", "bmsp");
        this.registerNamespace("http://ns.adobe.com/creatorAtom/1.0/", "creatorAtom");
        this.registerNamespace("http://ns.adobe.com/asf/1.0/", "asf");
        this.registerNamespace("http://ns.adobe.com/xmp/wav/1.0/", "wav");
        this.registerNamespace("http://ns.adobe.com/bwf/bext/1.0/", "bext");
        this.registerNamespace("http://ns.adobe.com/riff/info/", "riffinfo");
        this.registerNamespace("http://ns.adobe.com/xmp/1.0/Script/", "xmpScript");
        this.registerNamespace("http://ns.adobe.com/TransformXMP/", "txmp");
        this.registerNamespace("http://ns.adobe.com/swf/1.0/", "swf");
        this.registerNamespace("http://ns.adobe.com/xmp/1.0/DynamicMedia/", "xmpDM");
        this.registerNamespace("http://ns.adobe.com/xmp/transient/1.0/", "xmpx");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/t/", "xmpT");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/t/pg/", "xmpTPg");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/g/", "xmpG");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/g/img/", "xmpGImg");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/Font#", "stFnt");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/Dimensions#", "stDim");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/ResourceEvent#", "stEvt");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/ResourceRef#", "stRef");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/Version#", "stVer");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/Job#", "stJob");
        this.registerNamespace("http://ns.adobe.com/xap/1.0/sType/ManifestItem#", "stMfs");
        this.registerNamespace("http://ns.adobe.com/xmp/Identifier/qual/1.0/", "xmpidq");
    }

    @Nullable
    public final XMPAliasInfo resolveAlias(@NotNull String aliasNS, @NotNull String aliasProp) {
        Intrinsics.checkNotNullParameter((Object)aliasNS, (String)"aliasNS");
        Intrinsics.checkNotNullParameter((Object)aliasProp, (String)"aliasProp");
        String string = this.getNamespacePrefix(aliasNS);
        if (string == null) {
            return null;
        }
        String aliasPrefix = string;
        return aliasMap.get(aliasPrefix + aliasProp);
    }

    @Nullable
    public final XMPAliasInfo findAlias(@NotNull String qname) {
        Intrinsics.checkNotNullParameter((Object)qname, (String)"qname");
        return aliasMap.get(qname);
    }

    @NotNull
    public final Set<XMPAliasInfo> findAliases(@NotNull String aliasNS) {
        Intrinsics.checkNotNullParameter((Object)aliasNS, (String)"aliasNS");
        String prefix = this.getNamespacePrefix(aliasNS);
        if (prefix == null) {
            return SetsKt.emptySet();
        }
        Set result = new LinkedHashSet();
        for (String qname : aliasMap.keySet()) {
            XMPAliasInfo alias;
            if (!StringsKt.startsWith$default((String)qname, (String)prefix, (boolean)false, (int)2, null) || this.findAlias(qname) == null) continue;
            result.add(alias);
        }
        return result;
    }

    public final void registerAlias(@NotNull String aliasNS, @NotNull String aliasProp, @NotNull String actualNS, @NotNull String actualProp, @Nullable AliasOptions aliasForm) {
        AliasOptions aliasOpts;
        Intrinsics.checkNotNullParameter((Object)aliasNS, (String)"aliasNS");
        Intrinsics.checkNotNullParameter((Object)aliasProp, (String)"aliasProp");
        Intrinsics.checkNotNullParameter((Object)actualNS, (String)"actualNS");
        Intrinsics.checkNotNullParameter((Object)actualProp, (String)"actualProp");
        if (((CharSequence)aliasNS).length() == 0) {
            throw new XMPException("Empty schema namespace URI", 4, null, 4, null);
        }
        if (((CharSequence)aliasProp).length() == 0) {
            throw new XMPException("Empty property name", 4, null, 4, null);
        }
        if (((CharSequence)actualNS).length() == 0) {
            throw new XMPException("Empty schema namespace URI", 4, null, 4, null);
        }
        if (((CharSequence)actualProp).length() == 0) {
            throw new XMPException("Empty property name", 4, null, 4, null);
        }
        AliasOptions aliasOptions = aliasOpts = aliasForm != null ? new AliasOptions(XMPNodeUtils.verifySetOptions(aliasForm.toPropertyOptions(), null).getOptions()) : new AliasOptions();
        if (simpleProperyPattern.matches((CharSequence)aliasProp) || simpleProperyPattern.matches((CharSequence)actualProp)) {
            throw new XMPException("Alias and actual property names must be simple", 102, null, 4, null);
        }
        String aliasPrefix = this.getNamespacePrefix(aliasNS);
        String actualPrefix = this.getNamespacePrefix(actualNS);
        if (aliasPrefix == null) {
            throw new XMPException("Alias namespace is not registered", 101, null, 4, null);
        }
        if (actualPrefix == null) {
            throw new XMPException("Actual namespace is not registered", 101, null, 4, null);
        }
        String key = aliasPrefix + aliasProp;
        if (aliasMap.containsKey(key)) {
            throw new XMPException("Alias is already existing", 4, null, 4, null);
        }
        if (aliasMap.containsKey(actualPrefix + actualProp)) {
            throw new XMPException("Actual property is already an alias, use the base property", 4, null, 4, null);
        }
        XMPAliasInfo aliasInfo2 = new XMPAliasInfo(actualNS, actualPrefix, actualProp, aliasOpts){
            final /* synthetic */ String $actualNS;
            final /* synthetic */ String $actualPrefix;
            final /* synthetic */ String $actualProp;
            final /* synthetic */ AliasOptions $aliasOpts;
            {
                this.$actualNS = $actualNS;
                this.$actualPrefix = $actualPrefix;
                this.$actualProp = $actualProp;
                this.$aliasOpts = $aliasOpts;
            }

            @NotNull
            public String getNamespace() {
                return this.$actualNS;
            }

            @NotNull
            public String getPrefix() {
                return this.$actualPrefix;
            }

            @NotNull
            public String getPropName() {
                return this.$actualProp;
            }

            @NotNull
            public AliasOptions getAliasForm() {
                return this.$aliasOpts;
            }

            @NotNull
            public String toString() {
                return this.$actualPrefix + this.$actualProp + " NS(" + this.$actualNS + "), FORM (" + this.getAliasForm() + ")";
            }
        };
        aliasMap.put(key, aliasInfo2);
    }

    @NotNull
    public final Map<String, XMPAliasInfo> getAliases() {
        return aliasMap;
    }

    private final void registerStandardAliases() {
        AliasOptions aliasToArrayOrdered = new AliasOptions().setArrayOrdered(true);
        AliasOptions aliasToArrayAltText = new AliasOptions().setArrayAltText(true);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Author", "http://purl.org/dc/elements/1.1/", "creator", aliasToArrayOrdered);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Authors", "http://purl.org/dc/elements/1.1/", "creator", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Description", "http://purl.org/dc/elements/1.1/", "description", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Format", "http://purl.org/dc/elements/1.1/", "format", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Keywords", "http://purl.org/dc/elements/1.1/", "subject", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Locale", "http://purl.org/dc/elements/1.1/", "language", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/", "Title", "http://purl.org/dc/elements/1.1/", "title", null);
        this.registerAlias("http://ns.adobe.com/xap/1.0/rights/", "Copyright", "http://purl.org/dc/elements/1.1/", "rights", null);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "Author", "http://purl.org/dc/elements/1.1/", "creator", aliasToArrayOrdered);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "BaseURL", "http://ns.adobe.com/xap/1.0/", "BaseURL", null);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "CreationDate", "http://ns.adobe.com/xap/1.0/", "CreateDate", null);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "Creator", "http://ns.adobe.com/xap/1.0/", "CreatorTool", null);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "ModDate", "http://ns.adobe.com/xap/1.0/", "ModifyDate", null);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "Subject", "http://purl.org/dc/elements/1.1/", "description", aliasToArrayAltText);
        this.registerAlias("http://ns.adobe.com/pdf/1.3/", "Title", "http://purl.org/dc/elements/1.1/", "title", aliasToArrayAltText);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Author", "http://purl.org/dc/elements/1.1/", "creator", aliasToArrayOrdered);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Caption", "http://purl.org/dc/elements/1.1/", "description", aliasToArrayAltText);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Copyright", "http://purl.org/dc/elements/1.1/", "rights", aliasToArrayAltText);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Keywords", "http://purl.org/dc/elements/1.1/", "subject", null);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Marked", "http://ns.adobe.com/xap/1.0/rights/", "Marked", null);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "Title", "http://purl.org/dc/elements/1.1/", "title", aliasToArrayAltText);
        this.registerAlias("http://ns.adobe.com/photoshop/1.0/", "WebStatement", "http://ns.adobe.com/xap/1.0/rights/", "WebStatement", null);
        this.registerAlias("http://ns.adobe.com/tiff/1.0/", "Artist", "http://purl.org/dc/elements/1.1/", "creator", aliasToArrayOrdered);
        this.registerAlias("http://ns.adobe.com/tiff/1.0/", "Copyright", "http://purl.org/dc/elements/1.1/", "rights", null);
        this.registerAlias("http://ns.adobe.com/tiff/1.0/", "DateTime", "http://ns.adobe.com/xap/1.0/", "ModifyDate", null);
        this.registerAlias("http://ns.adobe.com/exif/1.0/", "DateTimeDigitized", "http://ns.adobe.com/xap/1.0/", "CreateDate", null);
        this.registerAlias("http://ns.adobe.com/tiff/1.0/", "ImageDescription", "http://purl.org/dc/elements/1.1/", "description", null);
        this.registerAlias("http://ns.adobe.com/tiff/1.0/", "Software", "http://ns.adobe.com/xap/1.0/", "CreatorTool", null);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "Author", "http://purl.org/dc/elements/1.1/", "creator", aliasToArrayOrdered);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "Copyright", "http://purl.org/dc/elements/1.1/", "rights", aliasToArrayAltText);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "CreationTime", "http://ns.adobe.com/xap/1.0/", "CreateDate", null);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "Description", "http://purl.org/dc/elements/1.1/", "description", aliasToArrayAltText);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "ModificationTime", "http://ns.adobe.com/xap/1.0/", "ModifyDate", null);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "Software", "http://ns.adobe.com/xap/1.0/", "CreatorTool", null);
        this.registerAlias("http://ns.adobe.com/png/1.0/", "Title", "http://purl.org/dc/elements/1.1/", "title", aliasToArrayAltText);
    }

    static {
        try {
            INSTANCE.registerStandardNamespaces();
            INSTANCE.registerStandardAliases();
        }
        catch (XMPException ex) {
            throw new IllegalStateException("The XMPSchemaRegistry cannot be initialized!", ex);
        }
    }
}

