/*
 * Decompiled with CFR 0.152.
 */
package com.ashampoo.xmp;

import com.ashampoo.xmp.XMPException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.encoding.Base64;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000fH\u0007\u00a8\u0006\u0013"}, d2={"Lcom/ashampoo/xmp/XMPUtils;", "", "()V", "convertToBoolean", "", "value", "", "convertToDouble", "", "rawValue", "convertToInteger", "", "convertToLong", "", "decodeBase64", "", "base64String", "encodeBase64", "buffer", "xmpcore"})
public final class XMPUtils {
    @NotNull
    public static final XMPUtils INSTANCE = new XMPUtils();

    private XMPUtils() {
    }

    @JvmStatic
    public static final boolean convertToBoolean(@Nullable String value) {
        CharSequence charSequence = value;
        if (charSequence == null || charSequence.length() == 0) {
            throw new XMPException("Empty convert-string", 5, null, 4, null);
        }
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String valueLowercase = string;
        try {
            return Integer.parseInt(valueLowercase) != 0;
        }
        catch (NumberFormatException ex) {
            return Intrinsics.areEqual((Object)"true", (Object)valueLowercase) || Intrinsics.areEqual((Object)"t", (Object)valueLowercase) || Intrinsics.areEqual((Object)"on", (Object)valueLowercase) || Intrinsics.areEqual((Object)"yes", (Object)valueLowercase);
        }
    }

    @JvmStatic
    public static final int convertToInteger(@Nullable String rawValue) {
        try {
            int n;
            CharSequence charSequence = rawValue;
            if (charSequence == null || charSequence.length() == 0) {
                throw new XMPException("Empty convert-string", 5, null, 4, null);
            }
            if (StringsKt.startsWith$default((String)rawValue, (String)"0x", (boolean)false, (int)2, null)) {
                String string = rawValue.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                n = Integer.parseInt(string, CharsKt.checkRadix((int)16));
            } else {
                n = Integer.parseInt(rawValue);
            }
            return n;
        }
        catch (NumberFormatException ex) {
            throw new XMPException("Invalid integer string", 5, ex);
        }
    }

    @JvmStatic
    public static final long convertToLong(@Nullable String rawValue) {
        try {
            long l;
            CharSequence charSequence = rawValue;
            if (charSequence == null || charSequence.length() == 0) {
                throw new XMPException("Empty convert-string", 5, null, 4, null);
            }
            if (StringsKt.startsWith$default((String)rawValue, (String)"0x", (boolean)false, (int)2, null)) {
                String string = rawValue.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                l = Long.parseLong(string, CharsKt.checkRadix((int)16));
            } else {
                l = Long.parseLong(rawValue);
            }
            return l;
        }
        catch (NumberFormatException ex) {
            throw new XMPException("Invalid long string", 5, ex);
        }
    }

    @JvmStatic
    public static final double convertToDouble(@Nullable String rawValue) {
        try {
            CharSequence charSequence = rawValue;
            if (charSequence == null || charSequence.length() == 0) {
                throw new XMPException("Empty convert-string", 5, null, 4, null);
            }
            return Double.parseDouble(rawValue);
        }
        catch (NumberFormatException ex) {
            throw new XMPException("Invalid double string", 5, ex);
        }
    }

    @JvmStatic
    @NotNull
    public static final String encodeBase64(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])buffer, (int)0, (int)0, (int)6, null);
    }

    @JvmStatic
    @NotNull
    public static final byte[] decodeBase64(@NotNull String base64String) {
        Intrinsics.checkNotNullParameter((Object)base64String, (String)"base64String");
        try {
            return Base64.decode$default((Base64)((Base64)Base64.Default), (byte[])StringsKt.encodeToByteArray((String)base64String), (int)0, (int)0, (int)6, null);
        }
        catch (Throwable ex) {
            throw new XMPException("Invalid base64 string", 5, ex);
        }
    }
}

