/*
 * Decompiled with CFR 0.152.
 */
package com.ashampoo.xmp.xpath;

import com.ashampoo.xmp.Utils;
import com.ashampoo.xmp.XMPException;
import com.ashampoo.xmp.XMPMetaFactory;
import com.ashampoo.xmp.properties.XMPAliasInfo;
import com.ashampoo.xmp.xpath.PathPosition;
import com.ashampoo.xmp.xpath.XMPPath;
import com.ashampoo.xmp.xpath.XMPPathSegment;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u001a\u0010\u0015\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/ashampoo/xmp/xpath/XMPPathParser;", "", "()V", "expandXPath", "Lcom/ashampoo/xmp/xpath/XMPPath;", "schemaNS", "", "path", "parseIndexSegment", "Lcom/ashampoo/xmp/xpath/XMPPathSegment;", "pos", "Lcom/ashampoo/xmp/xpath/PathPosition;", "parseRootNode", "", "expandedXPath", "parseStructSegment", "skipPathDelimiter", "verifyQualName", "qualName", "verifySimpleXMLName", "name", "verifyXPathRoot", "rootProp", "xmpcore"})
public final class XMPPathParser {
    @NotNull
    public static final XMPPathParser INSTANCE = new XMPPathParser();

    private XMPPathParser() {
    }

    @JvmStatic
    @NotNull
    public static final XMPPath expandXPath(@Nullable String schemaNS, @Nullable String path) {
        if (schemaNS == null || path == null) {
            throw new XMPException("Parameter must not be null", 4, null, 4, null);
        }
        XMPPath expandedXPath = new XMPPath();
        PathPosition pos = new PathPosition();
        pos.setPath(path);
        INSTANCE.parseRootNode(schemaNS, pos, expandedXPath);
        while (pos.getStepEnd() < path.length()) {
            pos.setStepBegin(pos.getStepEnd());
            INSTANCE.skipPathDelimiter(path, pos);
            pos.setStepEnd(pos.getStepBegin());
            XMPPathSegment segment = null;
            XMPPathSegment xMPPathSegment = segment = path.charAt(pos.getStepBegin()) != '[' ? INSTANCE.parseStructSegment(pos) : INSTANCE.parseIndexSegment(pos);
            if (segment.getKind() == 1) {
                String string = segment.getName();
                Intrinsics.checkNotNull((Object)string);
                if (string.charAt(0) == '@') {
                    String string2 = segment.getName();
                    Intrinsics.checkNotNull((Object)string2);
                    String string3 = string2.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    segment.setName("?" + string3);
                    if (!Intrinsics.areEqual((Object)"?xml:lang", (Object)segment.getName())) {
                        throw new XMPException("Only xml:lang allowed with '@'", 102, null, 4, null);
                    }
                }
                String string4 = segment.getName();
                Intrinsics.checkNotNull((Object)string4);
                if (string4.charAt(0) == '?') {
                    var5_5 = pos.getNameStart();
                    pos.setNameStart(var5_5 + 1);
                    segment.setKind(2);
                }
                String string5 = pos.getPath();
                Intrinsics.checkNotNull((Object)string5);
                String string6 = string5.substring(pos.getNameStart(), pos.getNameEnd());
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                INSTANCE.verifyQualName(string6);
            } else if (segment.getKind() == 6) {
                String string = segment.getName();
                Intrinsics.checkNotNull((Object)string);
                if (string.charAt(1) == '@') {
                    String string7 = segment.getName();
                    Intrinsics.checkNotNull((Object)string7);
                    String string8 = string7.substring(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                    segment.setName("[?" + string8);
                    String string9 = segment.getName();
                    Intrinsics.checkNotNull((Object)string9);
                    if (!StringsKt.startsWith$default((String)string9, (String)"[?xml:lang=", (boolean)false, (int)2, null)) {
                        throw new XMPException("Only xml:lang allowed with '@'", 102, null, 4, null);
                    }
                }
                String string10 = segment.getName();
                Intrinsics.checkNotNull((Object)string10);
                if (string10.charAt(1) == '?') {
                    var5_5 = pos.getNameStart();
                    pos.setNameStart(var5_5 + 1);
                    segment.setKind(5);
                    String string11 = pos.getPath();
                    Intrinsics.checkNotNull((Object)string11);
                    String string12 = string11.substring(pos.getNameStart(), pos.getNameEnd());
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"substring(...)");
                    INSTANCE.verifyQualName(string12);
                }
            }
            expandedXPath.add(segment);
        }
        return expandedXPath;
    }

    private final void skipPathDelimiter(String path, PathPosition pos) {
        int n;
        if (path.charAt(pos.getStepBegin()) == '/') {
            n = pos.getStepBegin();
            pos.setStepBegin(n + 1);
            if (pos.getStepBegin() >= path.length()) {
                throw new XMPException("Empty XMPPath segment", 102, null, 4, null);
            }
        }
        if (path.charAt(pos.getStepBegin()) == '*') {
            n = pos.getStepBegin();
            pos.setStepBegin(n + 1);
            if (pos.getStepBegin() >= path.length() || path.charAt(pos.getStepBegin()) != '[') {
                throw new XMPException("Missing '[' after '*'", 102, null, 4, null);
            }
        }
    }

    private final XMPPathSegment parseStructSegment(PathPosition pos) {
        pos.setNameStart(pos.getStepBegin());
        while (true) {
            int n = pos.getStepEnd();
            String string = pos.getPath();
            Intrinsics.checkNotNull((Object)string);
            if (n >= string.length()) break;
            CharSequence charSequence = "/[*";
            String string2 = pos.getPath();
            Intrinsics.checkNotNull((Object)string2);
            if (StringsKt.indexOf$default((CharSequence)charSequence, (char)string2.charAt(pos.getStepEnd()), (int)0, (boolean)false, (int)6, null) >= 0) break;
            int n2 = pos.getStepEnd();
            pos.setStepEnd(n2 + 1);
        }
        pos.setNameEnd(pos.getStepEnd());
        if (pos.getStepEnd() == pos.getStepBegin()) {
            throw new XMPException("Empty XMPPath segment", 102, null, 4, null);
        }
        String string = pos.getPath();
        Intrinsics.checkNotNull((Object)string);
        String string3 = string.substring(pos.getStepBegin(), pos.getStepEnd());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return new XMPPathSegment(string3, 1);
    }

    private final XMPPathSegment parseIndexSegment(PathPosition pos) {
        int n;
        XMPPathSegment segment;
        block16: {
            block15: {
                segment = null;
                n = pos.getStepEnd();
                pos.setStepEnd(n + 1);
                String string = pos.getPath();
                Intrinsics.checkNotNull((Object)string);
                n = string.charAt(pos.getStepEnd());
                boolean bl = 48 <= n ? n < 58 : false;
                if (bl) {
                    while (true) {
                        int n2 = pos.getStepEnd();
                        String string2 = pos.getPath();
                        Intrinsics.checkNotNull((Object)string2);
                        if (n2 >= string2.length()) break;
                        String string3 = pos.getPath();
                        Intrinsics.checkNotNull((Object)string3);
                        if (Intrinsics.compare((int)48, (int)string3.charAt(pos.getStepEnd())) > 0) break;
                        String string4 = pos.getPath();
                        Intrinsics.checkNotNull((Object)string4);
                        if (Intrinsics.compare((int)string4.charAt(pos.getStepEnd()), (int)57) > 0) break;
                        n = pos.getStepEnd();
                        pos.setStepEnd(n + 1);
                    }
                    segment = new XMPPathSegment(null, 3);
                } else {
                    while (true) {
                        int n3 = pos.getStepEnd();
                        String string5 = pos.getPath();
                        Intrinsics.checkNotNull((Object)string5);
                        if (n3 >= string5.length()) break;
                        String string6 = pos.getPath();
                        Intrinsics.checkNotNull((Object)string6);
                        if (string6.charAt(pos.getStepEnd()) == ']') break;
                        String string7 = pos.getPath();
                        Intrinsics.checkNotNull((Object)string7);
                        if (string7.charAt(pos.getStepEnd()) == '=') break;
                        n = pos.getStepEnd();
                        pos.setStepEnd(n + 1);
                    }
                    int n4 = pos.getStepEnd();
                    String string8 = pos.getPath();
                    Intrinsics.checkNotNull((Object)string8);
                    if (n4 >= string8.length()) {
                        throw new XMPException("Missing ']' or '=' for array index", 102, null, 4, null);
                    }
                    String string9 = pos.getPath();
                    Intrinsics.checkNotNull((Object)string9);
                    if (string9.charAt(pos.getStepEnd()) == ']') {
                        String string10 = pos.getPath();
                        Intrinsics.checkNotNull((Object)string10);
                        String string11 = string10.substring(pos.getStepBegin(), pos.getStepEnd());
                        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"substring(...)");
                        if (!Intrinsics.areEqual((Object)"[last()", (Object)string11)) {
                            throw new XMPException("Invalid non-numeric array index", 102, null, 4, null);
                        }
                        segment = new XMPPathSegment(null, 4);
                    } else {
                        pos.setNameStart(pos.getStepBegin() + 1);
                        pos.setNameEnd(pos.getStepEnd());
                        n = pos.getStepEnd();
                        pos.setStepEnd(n + 1);
                        String string12 = pos.getPath();
                        Intrinsics.checkNotNull((Object)string12);
                        char quote = string12.charAt(pos.getStepEnd());
                        if (quote != '\'' && quote != '\"') {
                            throw new XMPException("Invalid quote in array selector", 102, null, 4, null);
                        }
                        int n5 = pos.getStepEnd();
                        pos.setStepEnd(n5 + 1);
                        while (true) {
                            int n6 = pos.getStepEnd();
                            String string13 = pos.getPath();
                            Intrinsics.checkNotNull((Object)string13);
                            if (n6 >= string13.length()) break;
                            String string14 = pos.getPath();
                            Intrinsics.checkNotNull((Object)string14);
                            if (string14.charAt(pos.getStepEnd()) == quote) {
                                int n7 = pos.getStepEnd() + 1;
                                String string15 = pos.getPath();
                                Intrinsics.checkNotNull((Object)string15);
                                if (n7 >= string15.length()) break;
                                String string16 = pos.getPath();
                                Intrinsics.checkNotNull((Object)string16);
                                if (string16.charAt(pos.getStepEnd() + 1) != quote) break;
                                n5 = pos.getStepEnd();
                                pos.setStepEnd(n5 + 1);
                            }
                            n5 = pos.getStepEnd();
                            pos.setStepEnd(n5 + 1);
                        }
                        int n8 = pos.getStepEnd();
                        String string17 = pos.getPath();
                        Intrinsics.checkNotNull((Object)string17);
                        if (n8 >= string17.length()) {
                            throw new XMPException("No terminating quote for array selector", 102, null, 4, null);
                        }
                        n5 = pos.getStepEnd();
                        pos.setStepEnd(n5 + 1);
                        segment = new XMPPathSegment(null, 6);
                    }
                }
                int n9 = pos.getStepEnd();
                String string18 = pos.getPath();
                Intrinsics.checkNotNull((Object)string18);
                if (n9 >= string18.length()) break block15;
                String string19 = pos.getPath();
                Intrinsics.checkNotNull((Object)string19);
                if (string19.charAt(pos.getStepEnd()) == ']') break block16;
            }
            throw new XMPException("Missing ']' for array index", 102, null, 4, null);
        }
        n = pos.getStepEnd();
        pos.setStepEnd(n + 1);
        String string = pos.getPath();
        Intrinsics.checkNotNull((Object)string);
        String string20 = string.substring(pos.getStepBegin(), pos.getStepEnd());
        Intrinsics.checkNotNullExpressionValue((Object)string20, (String)"substring(...)");
        segment.setName(string20);
        return segment;
    }

    private final void parseRootNode(String schemaNS, PathPosition pos, XMPPath expandedXPath) {
        while (true) {
            int n = pos.getStepEnd();
            String string = pos.getPath();
            Intrinsics.checkNotNull((Object)string);
            if (n >= string.length()) break;
            CharSequence charSequence = "/[*";
            String string2 = pos.getPath();
            Intrinsics.checkNotNull((Object)string2);
            if (StringsKt.indexOf$default((CharSequence)charSequence, (char)string2.charAt(pos.getStepEnd()), (int)0, (boolean)false, (int)6, null) >= 0) break;
            int n2 = pos.getStepEnd();
            pos.setStepEnd(n2 + 1);
        }
        if (pos.getStepEnd() == pos.getStepBegin()) {
            throw new XMPException("Empty initial XMPPath step", 102, null, 4, null);
        }
        String string = pos.getPath();
        Intrinsics.checkNotNull((Object)string);
        String string3 = string.substring(pos.getStepBegin(), pos.getStepEnd());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String rootProp = this.verifyXPathRoot(schemaNS, string3);
        XMPAliasInfo aliasInfo2 = XMPMetaFactory.getSchemaRegistry().findAlias(rootProp);
        if (aliasInfo2 == null) {
            expandedXPath.add(new XMPPathSegment(schemaNS, Integer.MIN_VALUE));
            XMPPathSegment rootStep = new XMPPathSegment(rootProp, 1);
            expandedXPath.add(rootStep);
        } else {
            expandedXPath.add(new XMPPathSegment(aliasInfo2.getNamespace(), Integer.MIN_VALUE));
            XMPPathSegment rootStep = new XMPPathSegment(this.verifyXPathRoot(aliasInfo2.getNamespace(), aliasInfo2.getPropName()), 1);
            rootStep.setAlias(true);
            rootStep.setAliasForm(aliasInfo2.getAliasForm().getOptions());
            expandedXPath.add(rootStep);
            if (aliasInfo2.getAliasForm().isArrayAltText()) {
                XMPPathSegment qualSelectorStep = new XMPPathSegment("[?xml:lang='x-default']", 5);
                qualSelectorStep.setAlias(true);
                qualSelectorStep.setAliasForm(aliasInfo2.getAliasForm().getOptions());
                expandedXPath.add(qualSelectorStep);
            } else if (aliasInfo2.getAliasForm().isArray()) {
                XMPPathSegment indexStep = new XMPPathSegment("[1]", 3);
                indexStep.setAlias(true);
                indexStep.setAliasForm(aliasInfo2.getAliasForm().getOptions());
                expandedXPath.add(indexStep);
            }
        }
    }

    private final void verifyQualName(String qualName) {
        int colonPos = StringsKt.indexOf$default((CharSequence)qualName, (char)':', (int)0, (boolean)false, (int)6, null);
        if (colonPos > 0) {
            String string = qualName.substring(0, colonPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String prefix = string;
            if (Utils.isXMLNameNS(prefix)) {
                String regURI = XMPMetaFactory.getSchemaRegistry().getNamespaceURI(prefix);
                if (regURI != null) {
                    return;
                }
                throw new XMPException("Unknown namespace prefix for qualified name", 102, null, 4, null);
            }
        }
        throw new XMPException("Ill-formed qualified name", 102, null, 4, null);
    }

    private final void verifySimpleXMLName(String name) {
        if (!Utils.INSTANCE.isXMLName(name)) {
            throw new XMPException("Bad XML name", 102, null, 4, null);
        }
    }

    private final String verifyXPathRoot(String schemaNS, String rootProp) {
        Object object;
        CharSequence charSequence = schemaNS;
        if (charSequence == null || charSequence.length() == 0) {
            throw new XMPException("Schema namespace URI is required", 101, null, 4, null);
        }
        if (rootProp.charAt(0) == '?' || rootProp.charAt(0) == '@') {
            throw new XMPException("Top level name must not be a qualifier", 102, null, 4, null);
        }
        if (StringsKt.indexOf$default((CharSequence)rootProp, (char)'/', (int)0, (boolean)false, (int)6, null) >= 0 || StringsKt.indexOf$default((CharSequence)rootProp, (char)'[', (int)0, (boolean)false, (int)6, null) >= 0) {
            throw new XMPException("Top level name must be simple", 102, null, 4, null);
        }
        String string = XMPMetaFactory.getSchemaRegistry().getNamespacePrefix(schemaNS);
        if (string == null) {
            throw new XMPException("Unregistered schema namespace URI", 101, null, 4, null);
        }
        String prefix = string;
        int colonPos = StringsKt.indexOf$default((CharSequence)rootProp, (char)':', (int)0, (boolean)false, (int)6, null);
        if (colonPos < 0) {
            this.verifySimpleXMLName(rootProp);
            object = prefix + rootProp;
        } else {
            String string2 = rootProp.substring(0, colonPos);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            this.verifySimpleXMLName(string2);
            String string3 = rootProp.substring(colonPos);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            this.verifySimpleXMLName(string3);
            String string4 = rootProp.substring(0, colonPos + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            prefix = string4;
            String string5 = XMPMetaFactory.getSchemaRegistry().getNamespacePrefix(schemaNS);
            if (string5 == null) {
                throw new XMPException("Unknown schema namespace prefix", 101, null, 4, null);
            }
            String regPrefix = string5;
            if (!Intrinsics.areEqual((Object)prefix, (Object)regPrefix)) {
                throw new XMPException("Schema namespace URI and prefix mismatch", 101, null, 4, null);
            }
            object = rootProp;
        }
        return object;
    }
}

