/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.bottomnavigation;

import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.ashokvarma.bottomnavigation.BadgeTextView;
import com.ashokvarma.bottomnavigation.BottomNavigationTab;
import java.lang.ref.WeakReference;

abstract class BadgeItem<T extends BadgeItem<T>> {
    private int mGravity = 8388661;
    private boolean mHideOnSelect;
    private WeakReference<BadgeTextView> mTextViewRef;
    private boolean mIsHidden = false;
    private int mAnimationDuration = 200;

    BadgeItem() {
    }

    abstract T getSubInstance();

    abstract void bindToBottomTabInternal(BottomNavigationTab var1);

    public T setGravity(int gravity) {
        this.mGravity = gravity;
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.mTextViewRef.get();
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)textView.getLayoutParams();
            layoutParams.gravity = gravity;
            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        return this.getSubInstance();
    }

    public T setHideOnSelect(boolean hideOnSelect) {
        this.mHideOnSelect = hideOnSelect;
        return this.getSubInstance();
    }

    public T setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
        return this.getSubInstance();
    }

    void bindToBottomTab(BottomNavigationTab bottomNavigationTab) {
        bottomNavigationTab.badgeView.clearPrevious();
        if (bottomNavigationTab.badgeItem != null) {
            bottomNavigationTab.badgeItem.setTextView(null);
        }
        bottomNavigationTab.setBadgeItem(this);
        this.setTextView(bottomNavigationTab.badgeView);
        this.bindToBottomTabInternal(bottomNavigationTab);
        bottomNavigationTab.badgeView.setVisibility(0);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)bottomNavigationTab.badgeView.getLayoutParams();
        layoutParams.gravity = this.getGravity();
        bottomNavigationTab.badgeView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.isHidden()) {
            this.hide();
        }
    }

    private T setTextView(BadgeTextView mTextView) {
        this.mTextViewRef = new WeakReference<BadgeTextView>(mTextView);
        return this.getSubInstance();
    }

    int getGravity() {
        return this.mGravity;
    }

    boolean isHideOnSelect() {
        return this.mHideOnSelect;
    }

    WeakReference<BadgeTextView> getTextView() {
        return this.mTextViewRef;
    }

    boolean isWeakReferenceValid() {
        return this.mTextViewRef != null && this.mTextViewRef.get() != null;
    }

    void select() {
        if (this.mHideOnSelect) {
            this.hide(true);
        }
    }

    void unSelect() {
        if (this.mHideOnSelect) {
            this.show(true);
        }
    }

    public T toggle() {
        return this.toggle(true);
    }

    public T toggle(boolean animate) {
        if (this.mIsHidden) {
            return this.show(animate);
        }
        return this.hide(animate);
    }

    public T show() {
        return this.show(true);
    }

    public T show(boolean animate) {
        this.mIsHidden = false;
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.mTextViewRef.get();
            if (animate) {
                textView.setScaleX(0.0f);
                textView.setScaleY(0.0f);
                textView.setVisibility(0);
                ViewPropertyAnimatorCompat animatorCompat = ViewCompat.animate((View)textView);
                animatorCompat.cancel();
                animatorCompat.setDuration((long)this.mAnimationDuration);
                animatorCompat.scaleX(1.0f).scaleY(1.0f);
                animatorCompat.setListener(null);
                animatorCompat.start();
            } else {
                textView.setScaleX(1.0f);
                textView.setScaleY(1.0f);
                textView.setVisibility(0);
            }
        }
        return this.getSubInstance();
    }

    public T hide() {
        return this.hide(true);
    }

    public T hide(boolean animate) {
        this.mIsHidden = true;
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.mTextViewRef.get();
            if (animate) {
                ViewPropertyAnimatorCompat animatorCompat = ViewCompat.animate((View)textView);
                animatorCompat.cancel();
                animatorCompat.setDuration((long)this.mAnimationDuration);
                animatorCompat.scaleX(0.0f).scaleY(0.0f);
                animatorCompat.setListener(new ViewPropertyAnimatorListener(){

                    public void onAnimationStart(View view) {
                    }

                    public void onAnimationEnd(View view) {
                        view.setVisibility(8);
                    }

                    public void onAnimationCancel(View view) {
                        view.setVisibility(8);
                    }
                });
                animatorCompat.start();
            } else {
                textView.setVisibility(8);
            }
        }
        return this.getSubInstance();
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }
}

