/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.bottomnavigation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import com.ashokvarma.bottomnavigation.ShapeBadgeItem;

@SuppressLint(value={"Instantiatable"})
class BadgeTextView
extends AppCompatTextView {
    private ShapeBadgeItem mShapeBadgeItem;
    private boolean mAreDimensOverridden;
    private int mDesiredWidth = 100;
    private int mDesiredHeight = 100;

    public BadgeTextView(Context context) {
        this(context, null);
    }

    public BadgeTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BadgeTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
    }

    void clearPrevious() {
        this.mAreDimensOverridden = false;
        this.mShapeBadgeItem = null;
    }

    void setShapeBadgeItem(ShapeBadgeItem shapeBadgeItem) {
        this.mShapeBadgeItem = shapeBadgeItem;
    }

    void setDimens(int width, int height) {
        this.mAreDimensOverridden = true;
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
        this.requestLayout();
    }

    void recallOnDraw() {
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mShapeBadgeItem != null) {
            this.mShapeBadgeItem.draw(canvas);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mAreDimensOverridden) {
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(this.mDesiredWidth, widthSize) : this.mDesiredWidth);
            int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(this.mDesiredHeight, heightSize) : this.mDesiredHeight);
            this.setMeasuredDimension(width, height);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

