/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.bottomnavigation;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.ViewGroup;
import com.ashokvarma.bottomnavigation.BadgeItem;
import com.ashokvarma.bottomnavigation.BadgeTextView;
import com.ashokvarma.bottomnavigation.BottomNavigationTab;
import com.ashokvarma.bottomnavigation.utils.Utils;

public class ShapeBadgeItem
extends BadgeItem<ShapeBadgeItem> {
    public static final int SHAPE_OVAL = 0;
    public static final int SHAPE_RECTANGLE = 1;
    public static final int SHAPE_HEART = 2;
    public static final int SHAPE_STAR_3_VERTICES = 3;
    public static final int SHAPE_STAR_4_VERTICES = 4;
    public static final int SHAPE_STAR_5_VERTICES = 5;
    public static final int SHAPE_STAR_6_VERTICES = 6;
    private int mShape = 5;
    private String mShapeColorCode;
    private int mShapeColorResource;
    private int mShapeColor = -65536;
    private int mHeightInPixels;
    private int mWidthInPixels;
    private int mEdgeMarginInPx;
    private RectF mCanvasRect = new RectF();
    private Paint mCanvasPaint;
    private Path mPath = new Path();

    public ShapeBadgeItem() {
        this.mCanvasPaint = new Paint();
        this.mCanvasPaint.setColor(this.mShapeColor);
        this.mCanvasPaint.setAntiAlias(true);
        this.mCanvasPaint.setStyle(Paint.Style.FILL);
    }

    public ShapeBadgeItem setShape(int shape) {
        this.mShape = shape;
        this.refreshDraw();
        return this;
    }

    public ShapeBadgeItem setShapeColorResource(@ColorRes int colorResource) {
        this.mShapeColorResource = colorResource;
        this.refreshColor();
        return this;
    }

    public ShapeBadgeItem setShapeColor(@Nullable String colorCode) {
        this.mShapeColorCode = colorCode;
        this.refreshColor();
        return this;
    }

    public ShapeBadgeItem setShapeColor(int color) {
        this.mShapeColor = color;
        this.refreshColor();
        return this;
    }

    public ShapeBadgeItem setSizeInDp(Context context, int heightInDp, int widthInDp) {
        this.mHeightInPixels = Utils.dp2px(context, heightInDp);
        this.mWidthInPixels = Utils.dp2px(context, widthInDp);
        if (this.isWeakReferenceValid()) {
            ((BadgeTextView)((Object)this.getTextView().get())).setDimens(this.mWidthInPixels, this.mHeightInPixels);
        }
        return this;
    }

    public ShapeBadgeItem setSizeInPixels(int heightInPx, int widthInPx) {
        this.mHeightInPixels = heightInPx;
        this.mWidthInPixels = widthInPx;
        if (this.isWeakReferenceValid()) {
            ((BadgeTextView)((Object)this.getTextView().get())).setDimens(this.mWidthInPixels, this.mHeightInPixels);
        }
        return this;
    }

    public ShapeBadgeItem setEdgeMarginInDp(Context context, int edgeMarginInDp) {
        this.mEdgeMarginInPx = Utils.dp2px(context, edgeMarginInDp);
        this.refreshMargin();
        return this;
    }

    public ShapeBadgeItem setEdgeMarginInPixels(int edgeMarginInPx) {
        this.mEdgeMarginInPx = edgeMarginInPx;
        this.refreshMargin();
        return this;
    }

    void draw(Canvas canvas) {
        this.mCanvasRect.set(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
        if (this.mShape == 1) {
            canvas.drawRect(this.mCanvasRect, this.mCanvasPaint);
        } else if (this.mShape == 0) {
            canvas.drawOval(this.mCanvasRect, this.mCanvasPaint);
        } else if (this.mShape == 3 || this.mShape == 4 || this.mShape == 5 || this.mShape == 6) {
            this.drawStar(canvas, this.mShape);
        } else if (this.mShape == 2) {
            this.drawHeart(canvas);
        }
    }

    @Override
    ShapeBadgeItem getSubInstance() {
        return this;
    }

    @Override
    void bindToBottomTabInternal(BottomNavigationTab bottomNavigationTab) {
        if (this.mHeightInPixels == 0) {
            this.mHeightInPixels = Utils.dp2px(bottomNavigationTab.getContext(), 12.0f);
        }
        if (this.mWidthInPixels == 0) {
            this.mWidthInPixels = Utils.dp2px(bottomNavigationTab.getContext(), 12.0f);
        }
        if (this.mEdgeMarginInPx == 0) {
            this.mEdgeMarginInPx = Utils.dp2px(bottomNavigationTab.getContext(), 4.0f);
        }
        this.refreshMargin();
        this.refreshColor();
        bottomNavigationTab.badgeView.setShapeBadgeItem(this);
        bottomNavigationTab.badgeView.setDimens(this.mWidthInPixels, this.mHeightInPixels);
    }

    private int getShapeColor(Context context) {
        if (this.mShapeColorResource != 0) {
            return ContextCompat.getColor((Context)context, (int)this.mShapeColorResource);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mShapeColorCode)) {
            return Color.parseColor((String)this.mShapeColorCode);
        }
        return this.mShapeColor;
    }

    private void refreshColor() {
        if (this.isWeakReferenceValid()) {
            this.mCanvasPaint.setColor(this.getShapeColor(((BadgeTextView)((Object)this.getTextView().get())).getContext()));
        }
        this.refreshDraw();
    }

    private void refreshDraw() {
        if (this.isWeakReferenceValid()) {
            ((BadgeTextView)((Object)this.getTextView().get())).recallOnDraw();
        }
    }

    private void refreshMargin() {
        if (this.isWeakReferenceValid()) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)((BadgeTextView)((Object)this.getTextView().get())).getLayoutParams();
            layoutParams.bottomMargin = this.mEdgeMarginInPx;
            layoutParams.topMargin = this.mEdgeMarginInPx;
            layoutParams.rightMargin = this.mEdgeMarginInPx;
            layoutParams.leftMargin = this.mEdgeMarginInPx;
            ((BadgeTextView)((Object)this.getTextView().get())).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void drawStar(Canvas canvas, int numOfPt) {
        float innerRadius;
        float radius;
        double section = Math.PI * 2 / (double)numOfPt;
        double halfSection = section / 2.0;
        double antiClockRotation = this.getStarAntiClockRotationOffset(numOfPt);
        float x = (float)canvas.getWidth() / 2.0f;
        float y = (float)canvas.getHeight() / 2.0f;
        if (canvas.getWidth() > canvas.getHeight()) {
            radius = (float)canvas.getHeight() * 0.5f;
            innerRadius = (float)canvas.getHeight() * 0.25f;
        } else {
            radius = (float)canvas.getWidth() * 0.5f;
            innerRadius = (float)canvas.getWidth() * 0.25f;
        }
        this.mPath.reset();
        this.mPath.moveTo((float)((double)x + (double)radius * Math.cos(0.0 - antiClockRotation)), (float)((double)y + (double)radius * Math.sin(0.0 - antiClockRotation)));
        this.mPath.lineTo((float)((double)x + (double)innerRadius * Math.cos(0.0 + halfSection - antiClockRotation)), (float)((double)y + (double)innerRadius * Math.sin(0.0 + halfSection - antiClockRotation)));
        for (int i = 1; i < numOfPt; ++i) {
            this.mPath.lineTo((float)((double)x + (double)radius * Math.cos(section * (double)i - antiClockRotation)), (float)((double)y + (double)radius * Math.sin(section * (double)i - antiClockRotation)));
            this.mPath.lineTo((float)((double)x + (double)innerRadius * Math.cos(section * (double)i + halfSection - antiClockRotation)), (float)((double)y + (double)innerRadius * Math.sin(section * (double)i + halfSection - antiClockRotation)));
        }
        this.mPath.close();
        canvas.drawPath(this.mPath, this.mCanvasPaint);
    }

    private double getStarAntiClockRotationOffset(int numOfPt) {
        if (numOfPt == 5) {
            return 0.3141592653589793;
        }
        if (numOfPt == 6) {
            return 0.5235987755982988;
        }
        return 0.0;
    }

    private void drawHeart(Canvas canvas) {
        float curveLength = canvas.getHeight() / 3;
        this.mPath.reset();
        this.mPath.moveTo((float)(canvas.getWidth() / 2), (float)canvas.getHeight());
        this.mPath.lineTo(curveLength / 3.0f, 7.0f * curveLength / 4.0f);
        this.mPath.arcTo(new RectF(0.0f, 0.0f, (float)(canvas.getWidth() / 2), 2.0f * curveLength), -225.0f, 225.0f);
        this.mPath.arcTo(new RectF((float)(canvas.getWidth() / 2), 0.0f, (float)canvas.getWidth(), 2.0f * curveLength), -180.0f, 225.0f);
        this.mPath.close();
        canvas.drawPath(this.mPath, this.mCanvasPaint);
    }
}

