/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.bottomnavigation;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.widget.TextView;
import com.ashokvarma.bottomnavigation.BadgeItem;
import com.ashokvarma.bottomnavigation.BottomNavigationTab;
import com.ashokvarma.bottomnavigation.R;

public class TextBadgeItem
extends BadgeItem<TextBadgeItem> {
    private int mBackgroundColorResource;
    private String mBackgroundColorCode;
    private int mBackgroundColor = -65536;
    private int mTextColorResource;
    private String mTextColorCode;
    private int mTextColor = -1;
    private CharSequence mText;
    private int mBorderColorResource;
    private String mBorderColorCode;
    private int mBorderColor = -1;
    private int mBorderWidthInPixels = 0;

    public TextBadgeItem setBackgroundColorResource(@ColorRes int colorResource) {
        this.mBackgroundColorResource = colorResource;
        this.refreshDrawable();
        return this;
    }

    public TextBadgeItem setBackgroundColor(@Nullable String colorCode) {
        this.mBackgroundColorCode = colorCode;
        this.refreshDrawable();
        return this;
    }

    public TextBadgeItem setBackgroundColor(int color) {
        this.mBackgroundColor = color;
        this.refreshDrawable();
        return this;
    }

    public TextBadgeItem setTextColorResource(@ColorRes int colorResource) {
        this.mTextColorResource = colorResource;
        this.setTextColor();
        return this;
    }

    public TextBadgeItem setTextColor(@Nullable String colorCode) {
        this.mTextColorCode = colorCode;
        this.setTextColor();
        return this;
    }

    public TextBadgeItem setTextColor(int color) {
        this.mTextColor = color;
        this.setTextColor();
        return this;
    }

    public TextBadgeItem setText(@Nullable CharSequence text) {
        this.mText = text;
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.getTextView().get();
            if (!TextUtils.isEmpty((CharSequence)text)) {
                textView.setText(text);
            }
        }
        return this;
    }

    public TextBadgeItem setBorderColorResource(@ColorRes int colorResource) {
        this.mBorderColorResource = colorResource;
        this.refreshDrawable();
        return this;
    }

    public TextBadgeItem setBorderColor(@Nullable String colorCode) {
        this.mBorderColorCode = colorCode;
        this.refreshDrawable();
        return this;
    }

    public TextBadgeItem setBorderColor(int color) {
        this.mBorderColor = color;
        this.refreshDrawable();
        return this;
    }

    public TextBadgeItem setBorderWidth(int borderWidthInPixels) {
        this.mBorderWidthInPixels = borderWidthInPixels;
        this.refreshDrawable();
        return this;
    }

    @Override
    TextBadgeItem getSubInstance() {
        return this;
    }

    @Override
    void bindToBottomTabInternal(BottomNavigationTab bottomNavigationTab) {
        Context context = bottomNavigationTab.getContext();
        GradientDrawable shape = this.getBadgeDrawable(context);
        bottomNavigationTab.badgeView.setBackgroundDrawable((Drawable)shape);
        bottomNavigationTab.badgeView.setTextColor(this.getTextColor(context));
        bottomNavigationTab.badgeView.setText(this.getText());
    }

    private int getBackgroundColor(Context context) {
        if (this.mBackgroundColorResource != 0) {
            return ContextCompat.getColor((Context)context, (int)this.mBackgroundColorResource);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mBackgroundColorCode)) {
            return Color.parseColor((String)this.mBackgroundColorCode);
        }
        return this.mBackgroundColor;
    }

    private int getTextColor(Context context) {
        if (this.mTextColorResource != 0) {
            return ContextCompat.getColor((Context)context, (int)this.mTextColorResource);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTextColorCode)) {
            return Color.parseColor((String)this.mTextColorCode);
        }
        return this.mTextColor;
    }

    private CharSequence getText() {
        return this.mText;
    }

    private int getBorderColor(Context context) {
        if (this.mBorderColorResource != 0) {
            return ContextCompat.getColor((Context)context, (int)this.mBorderColorResource);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mBorderColorCode)) {
            return Color.parseColor((String)this.mBorderColorCode);
        }
        return this.mBorderColor;
    }

    private int getBorderWidth() {
        return this.mBorderWidthInPixels;
    }

    private void refreshDrawable() {
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.getTextView().get();
            textView.setBackgroundDrawable((Drawable)this.getBadgeDrawable(textView.getContext()));
        }
    }

    private void setTextColor() {
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.getTextView().get();
            textView.setTextColor(this.getTextColor(textView.getContext()));
        }
    }

    private GradientDrawable getBadgeDrawable(Context context) {
        GradientDrawable shape = new GradientDrawable();
        shape.setShape(0);
        shape.setCornerRadius((float)context.getResources().getDimensionPixelSize(R.dimen.badge_corner_radius));
        shape.setColor(this.getBackgroundColor(context));
        shape.setStroke(this.getBorderWidth(), this.getBorderColor(context));
        return shape;
    }
}

