/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.bottomnavigation.behaviour;

import android.content.Context;
import android.support.design.widget.CoordinatorLayout;
import android.util.AttributeSet;
import android.view.View;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class VerticalScrollingBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    private int mTotalDyUnconsumed = -1;
    private int mTotalDyConsumed = -1;
    private int mTotalDy = -1;
    private int mScrollDirection = 0;
    private int mPreScrollDirection = 0;
    private int mConsumedScrollDirection = 0;

    public VerticalScrollingBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VerticalScrollingBehavior() {
    }

    public int getScrollDirection() {
        return this.mScrollDirection;
    }

    public int getConsumedScrollDirection() {
        return this.mConsumedScrollDirection;
    }

    public int getPreScrollDirection() {
        return this.mPreScrollDirection;
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V child, View directTargetChild, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        super.onNestedScroll(coordinatorLayout, child, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
        if (dyUnconsumed > 0 && this.mTotalDyUnconsumed < 0) {
            this.mTotalDyUnconsumed = 0;
            this.mScrollDirection = 1;
            this.onNestedVerticalScrollUnconsumed(coordinatorLayout, child, this.mScrollDirection, dyConsumed, this.mTotalDyUnconsumed);
        } else if (dyUnconsumed < 0 && this.mTotalDyUnconsumed > 0) {
            this.mTotalDyUnconsumed = 0;
            this.mScrollDirection = -1;
            this.onNestedVerticalScrollUnconsumed(coordinatorLayout, child, this.mScrollDirection, dyConsumed, this.mTotalDyUnconsumed);
        }
        this.mTotalDyUnconsumed += dyUnconsumed;
        if (dyConsumed > 0 && this.mTotalDyConsumed < 0) {
            this.mTotalDyConsumed = 0;
            this.mConsumedScrollDirection = 1;
            this.onNestedVerticalScrollConsumed(coordinatorLayout, child, this.mConsumedScrollDirection, dyConsumed, this.mTotalDyConsumed);
        } else if (dyConsumed < 0 && this.mTotalDyConsumed > 0) {
            this.mTotalDyConsumed = 0;
            this.mConsumedScrollDirection = -1;
            this.onNestedVerticalScrollConsumed(coordinatorLayout, child, this.mConsumedScrollDirection, dyConsumed, this.mTotalDyConsumed);
        }
        this.mTotalDyConsumed += dyConsumed;
    }

    public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dx, int dy, int[] consumed) {
        super.onNestedPreScroll(coordinatorLayout, child, target, dx, dy, consumed);
        if (dy > 0 && this.mTotalDy < 0) {
            this.mTotalDy = 0;
            this.mPreScrollDirection = 1;
            this.onNestedVerticalPreScroll(coordinatorLayout, child, target, dx, dy, consumed, this.mPreScrollDirection);
        } else if (dy < 0 && this.mTotalDy > 0) {
            this.mTotalDy = 0;
            this.mPreScrollDirection = -1;
            this.onNestedVerticalPreScroll(coordinatorLayout, child, target, dx, dy, consumed, this.mPreScrollDirection);
        }
        this.mTotalDy += dy;
    }

    public boolean onNestedFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY, boolean consumed) {
        super.onNestedFling(coordinatorLayout, child, target, velocityX, velocityY, consumed);
        return this.onNestedDirectionFling(coordinatorLayout, child, target, velocityX, velocityY, consumed, velocityY > 0.0f ? 1 : -1);
    }

    public abstract void onNestedVerticalScrollUnconsumed(CoordinatorLayout var1, V var2, int var3, int var4, int var5);

    public abstract void onNestedVerticalScrollConsumed(CoordinatorLayout var1, V var2, int var3, int var4, int var5);

    public abstract void onNestedVerticalPreScroll(CoordinatorLayout var1, V var2, View var3, int var4, int var5, int[] var6, int var7);

    protected abstract boolean onNestedDirectionFling(CoordinatorLayout var1, V var2, View var3, float var4, float var5, boolean var6, int var7);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScrollDirection {
        public static final int SCROLL_DIRECTION_UP = 1;
        public static final int SCROLL_DIRECTION_DOWN = -1;
        public static final int SCROLL_NONE = 0;
    }
}

