/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.sqlitemanager;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ashokvarma.sqlitemanager.R;

@SuppressLint(value={"Instantiatable"})
class ColumnNameView
extends LinearLayout
implements View.OnClickListener {
    private String[] mTableColumnNames;
    public static final byte NO_SORT = 0;
    public static final byte ASCENDING_SORT = 1;
    public static final byte DESCENDING_SORT = 2;
    private ColumnHeaderSortChangeListener mColumnHeaderSortChangeListener;

    public ColumnNameView(Context context) {
        this(context, null);
    }

    public ColumnNameView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ColumnNameView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public ColumnNameView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setOrientation(0);
    }

    private TextView getTextView() {
        return (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.sqlite_manager_column_text_header_item, (ViewGroup)this, false);
    }

    ColumnNameView setData(String[] tableColumnNames) {
        this.removeAllViews();
        this.mTableColumnNames = tableColumnNames;
        int index = 0;
        for (String currentColumnName : this.mTableColumnNames) {
            TextView textView = this.getTextView();
            TableNameHeaderViewTag tableNameHeaderViewTag = new TableNameHeaderViewTag();
            tableNameHeaderViewTag.columnIndex = index;
            tableNameHeaderViewTag.sortOrder = (byte)0;
            textView.setTag((Object)tableNameHeaderViewTag);
            textView.setText((CharSequence)currentColumnName);
            textView.setOnClickListener((View.OnClickListener)this);
            this.addView((View)textView);
            ++index;
        }
        return this;
    }

    public void onClick(View v) {
        boolean isAscendingOrder;
        TableNameHeaderViewTag tableNameHeaderViewTag = (TableNameHeaderViewTag)v.getTag();
        byte nextSortOrder = this.getNextSortOrder(tableNameHeaderViewTag.sortOrder);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View currentChild = this.getChildAt(i);
            if (!(currentChild instanceof TextView)) continue;
            ((TableNameHeaderViewTag)currentChild.getTag()).sortOrder = (byte)0;
            int columnIndex = ((TableNameHeaderViewTag)currentChild.getTag()).columnIndex;
            ((TextView)currentChild).setText((CharSequence)this.mTableColumnNames[columnIndex]);
        }
        boolean bl = isAscendingOrder = nextSortOrder == 1;
        if (this.mColumnHeaderSortChangeListener != null) {
            this.mColumnHeaderSortChangeListener.onHeaderColumnSortChanged(this.mTableColumnNames[tableNameHeaderViewTag.columnIndex], isAscendingOrder);
        }
        tableNameHeaderViewTag.sortOrder = nextSortOrder;
        Drawable ascendingDescendingIcon = isAscendingOrder ? this.getContext().getResources().getDrawable(R.drawable.ic_sort_ascending_white_24dp) : this.getContext().getResources().getDrawable(R.drawable.ic_sort_descending_white_24dp);
        String tableName = this.mTableColumnNames[tableNameHeaderViewTag.columnIndex];
        SpannableString spannableString = new SpannableString((CharSequence)(tableName + "   "));
        ascendingDescendingIcon.setBounds(0, 0, 56, 56);
        ImageSpan image = new ImageSpan(ascendingDescendingIcon, 1);
        spannableString.setSpan((Object)image, tableName.length() + 2, spannableString.length(), 17);
        ((TextView)v).setText((CharSequence)spannableString);
    }

    public void setColumnHeaderSortChangeListener(ColumnHeaderSortChangeListener columnHeaderSortChangeListener) {
        this.mColumnHeaderSortChangeListener = columnHeaderSortChangeListener;
    }

    public String[] getTableColumnNames() {
        return this.mTableColumnNames;
    }

    private byte getNextSortOrder(int currentSortOrder) {
        if (currentSortOrder == 0) {
            return 1;
        }
        if (currentSortOrder == 1) {
            return 2;
        }
        if (currentSortOrder == 2) {
            return 1;
        }
        return 1;
    }

    static interface ColumnHeaderSortChangeListener {
        public void onHeaderColumnSortChanged(String var1, boolean var2);
    }

    private class TableNameHeaderViewTag {
        private byte sortOrder = 0;
        private int columnIndex = 0;

        private TableNameHeaderViewTag() {
        }
    }
}

