/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.sqlitemanager;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ashokvarma.sqlitemanager.R;
import java.util.ArrayList;
import java.util.Arrays;

class RowView
extends FrameLayout {
    private final int mColumnCount;
    private final ArrayList<TextView> mTextViewList;
    private final LinearLayout mRowViewContainer;
    private SparseArray<Object> mColumnIndexToValues;

    RowView(Context context, int columnCount) {
        super(context);
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.sqlite_manager_background_white));
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.sqlite_manager_selectable_horizontal_linear_layout, (ViewGroup)this, true);
        this.mRowViewContainer = (LinearLayout)this.findViewById(R.id.sqlite_manager_row_view_container);
        this.mColumnCount = columnCount;
        this.mTextViewList = new ArrayList(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            TextView textView = this.getTextView();
            this.mTextViewList.add(textView);
            this.mRowViewContainer.addView((View)textView);
        }
    }

    private TextView getTextView() {
        return (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.sqlite_manager_column_text_item, (ViewGroup)this, false);
    }

    void setData(SparseArray<Object> columnIndexToValues) {
        if (columnIndexToValues.size() != this.mColumnCount) {
            throw new IllegalArgumentException("columnIndexValues count doesn't match columnCount");
        }
        this.mColumnIndexToValues = columnIndexToValues;
        for (int i = 0; i < this.mColumnIndexToValues.size(); ++i) {
            Object columnEntry = this.mColumnIndexToValues.get(i);
            if (columnEntry == null) {
                this.mTextViewList.get(i).setText((CharSequence)"(NULL)");
                this.mTextViewList.get(i).setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.sqlite_manager_txt_disabled));
                continue;
            }
            if (columnEntry instanceof String && TextUtils.isEmpty((CharSequence)columnEntry.toString())) {
                this.mTextViewList.get(i).setText((CharSequence)"(EMPTY)");
                this.mTextViewList.get(i).setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.sqlite_manager_txt_disabled));
                continue;
            }
            if (columnEntry instanceof byte[]) {
                this.mTextViewList.get(i).setText((CharSequence)Arrays.toString((byte[])columnEntry));
                this.mTextViewList.get(i).setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.sqlite_manager_txt_secondary));
                continue;
            }
            this.mTextViewList.get(i).setText((CharSequence)columnEntry.toString());
            this.mTextViewList.get(i).setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.sqlite_manager_txt_secondary));
        }
    }
}

