/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.sqlitemanager;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TextInputEditText;
import android.support.design.widget.TextInputLayout;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatSpinner;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.ashokvarma.sqlitemanager.ColumnNameView;
import com.ashokvarma.sqlitemanager.R;
import com.ashokvarma.sqlitemanager.SqliteManager;
import com.ashokvarma.sqlitemanager.SqliteManagerPresenter;
import com.ashokvarma.sqlitemanager.SqliteManagerView;
import com.ashokvarma.sqlitemanager.TableRecyclerAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SqliteManagerActivity
extends AppCompatActivity
implements SqliteManagerView,
AdapterView.OnItemSelectedListener,
ColumnNameView.ColumnHeaderSortChangeListener,
View.OnClickListener,
TableRecyclerAdapter.Listener {
    private SqliteManagerPresenter mSqliteManagerPresenter;
    private TableRecyclerAdapter mTableRecyclerAdapter;
    private View mSqliteManagerParent;
    private Toolbar mToolbar;
    private AppCompatSpinner mTableSelectionSpinner;
    private View mTableSelectionContainer;
    private View mCustomQueryContainer;
    private TextView mCustomQueryText;
    private ImageView mCustomQueryEdit;
    private ImageView mCustomQueryClear;
    private View mErrorLayout;
    private TextView mErrorLayoutText;
    private View mTableLayout;
    private ColumnNameView mColumnNameView;
    private RecyclerView mTableLayoutRecyclerView;
    private FloatingActionButton mSqliteManagerAddFab;
    private View mActionCustomQuery;
    public static final String CSV_FILE_SHARE_AUTHORITY = "csv_file_share_authority";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_sqlite_manager);
        this.mSqliteManagerPresenter = new SqliteManagerPresenter(SqliteManager.mSqliteDataRetriever, this.getIntent().getStringExtra(CSV_FILE_SHARE_AUTHORITY));
        this.mSqliteManagerParent = this.findViewById(R.id.sqlite_manager_parent);
        this.mTableSelectionSpinner = (AppCompatSpinner)this.findViewById(R.id.sqlite_manager_table_selection_spinner);
        this.mErrorLayout = this.findViewById(R.id.sqlite_manager_error_layout);
        this.mTableLayout = this.findViewById(R.id.sqlite_manager_table_layout);
        this.mColumnNameView = (ColumnNameView)this.findViewById(R.id.sqlite_manager_table_layout_header);
        this.mErrorLayoutText = (TextView)this.findViewById(R.id.sqlite_manager_error_layout_text);
        this.mTableLayoutRecyclerView = (RecyclerView)this.findViewById(R.id.sqlite_manager_table_layout_recycler_view);
        this.mActionCustomQuery = this.findViewById(R.id.sqlite_manager_action_custom_query);
        this.mSqliteManagerAddFab = (FloatingActionButton)this.findViewById(R.id.sqlite_manager_add_fab);
        this.mTableSelectionContainer = this.findViewById(R.id.sqlite_manager_table_selection_container);
        this.mCustomQueryContainer = this.findViewById(R.id.sqlite_manager_custom_query_container);
        this.mCustomQueryText = (TextView)this.findViewById(R.id.sqlite_manager_custom_query_text);
        this.mCustomQueryEdit = (ImageView)this.findViewById(R.id.sqlite_manager_custom_query_edit);
        this.mCustomQueryClear = (ImageView)this.findViewById(R.id.sqlite_manager_custom_query_clear);
        this.mToolbar = (Toolbar)this.findViewById(R.id.sqlite_manager_toolbar);
        this.setSupportActionBar(this.mToolbar);
        this.mTableRecyclerAdapter = new TableRecyclerAdapter(null);
        this.mTableRecyclerAdapter.setListener(this);
        this.mTableLayoutRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.mTableLayoutRecyclerView.setAdapter((RecyclerView.Adapter)this.mTableRecyclerAdapter);
        this.mTableSelectionSpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        this.mColumnNameView.setColumnHeaderSortChangeListener(this);
        this.mActionCustomQuery.setOnClickListener((View.OnClickListener)this);
        this.mSqliteManagerAddFab.setOnClickListener((View.OnClickListener)this);
        this.mCustomQueryEdit.setOnClickListener((View.OnClickListener)this);
        this.mCustomQueryClear.setOnClickListener((View.OnClickListener)this);
        this.mSqliteManagerPresenter.bindView(this);
    }

    protected void onDestroy() {
        this.mSqliteManagerPresenter.unBindView(this);
        super.onDestroy();
    }

    @Override
    public void setSubtitle(String subtitle) {
        this.mToolbar.setSubtitle((CharSequence)subtitle);
    }

    @Override
    @NonNull
    public AppCompatActivity getViewContext() {
        return this;
    }

    @Override
    public void finishActivityWithError(@StringRes int errorMessageId) {
        this.finishActivityWithError(this.getString(errorMessageId));
    }

    @Override
    public void finishActivityWithError(String error) {
        Toast.makeText((Context)this, (CharSequence)error, (int)1).show();
        this.finishActivity();
    }

    @Override
    public void finishActivity() {
        SqliteManager.clearReferences();
        this.finish();
    }

    @Override
    public void displayError(@StringRes int errorMessageId) {
        this.displayError(this.getString(errorMessageId));
    }

    @Override
    public void displayError(String error) {
        this.mErrorLayout.setVisibility(0);
        this.mTableLayout.setVisibility(8);
        this.mErrorLayoutText.setText((CharSequence)error);
    }

    @Override
    public void informErrorToUser(@StringRes int errorMessageId) {
        this.informErrorToUser(this.getString(errorMessageId));
    }

    @Override
    public void informErrorToUser(String error) {
        Snackbar.make((View)this.mSqliteManagerParent, (CharSequence)error, (int)0).show();
    }

    @Override
    public void setAddFABVisible(boolean visible) {
        if (visible) {
            this.mSqliteManagerAddFab.show();
        } else {
            this.mSqliteManagerAddFab.hide();
        }
    }

    @Override
    public void showCustomQueryView(String customQuery) {
        this.mTableSelectionContainer.setVisibility(8);
        this.mCustomQueryContainer.setVisibility(0);
        this.mCustomQueryText.setText((CharSequence)customQuery);
    }

    @Override
    public void showTableSelectionView() {
        this.mTableSelectionContainer.setVisibility(0);
        this.mCustomQueryContainer.setVisibility(8);
    }

    @Override
    public void showCustomQueryDialog(String previousCustomQuery) {
        LayoutInflater inflater = this.getLayoutInflater();
        View dialogView = inflater.inflate(R.layout.sqlite_manager_custom_query_dialog, null);
        final TextInputEditText customQueryEditText = (TextInputEditText)dialogView.findViewById(R.id.sqlite_manager_custom_query_edit_text);
        customQueryEditText.setText((CharSequence)previousCustomQuery);
        new AlertDialog.Builder((Context)this).setView(dialogView).setTitle(R.string.sqlite_manager_custom_query).setMessage(R.string.sqlite_manager_custom_query_hint).setPositiveButton(R.string.sqlite_manager_query, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                SqliteManagerActivity.this.mSqliteManagerPresenter.onCustomQuerySubmitted(customQueryEditText.getText().toString());
                dialog.dismiss();
            }
        }).setNegativeButton(R.string.sqlite_manager_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.dismiss();
            }
        }).show();
    }

    @Override
    public void showAddEditRowDialog(final boolean isEdit, final String tableName, final String[] tableColumnNames, final SparseArray<Object> oldColumnValues) {
        LayoutInflater inflater = this.getLayoutInflater();
        final ArrayList<TextInputEditText> editTextViews = new ArrayList<TextInputEditText>(tableColumnNames.length);
        View dialogView = inflater.inflate(R.layout.sqlite_manager_add_edit_dialog_container, null);
        LinearLayout linearLayout = (LinearLayout)dialogView.findViewById(R.id.sqlite_manager_add_edit_dialog_container);
        Button deleteButton = (Button)dialogView.findViewById(R.id.sqlite_manager_add_edit_dialog_delete);
        Button cancelButton = (Button)dialogView.findViewById(R.id.sqlite_manager_add_edit_dialog_cancel);
        Button updateButton = (Button)dialogView.findViewById(R.id.sqlite_manager_add_edit_dialog_update);
        int index = 0;
        for (String currentColumnName : tableColumnNames) {
            View columnView = inflater.inflate(R.layout.sqlite_manager_add_edit_dialog_item, null);
            ((TextInputLayout)columnView.findViewById(R.id.sqlite_manager_add_edit_dialog_text_input_layout)).setHint((CharSequence)currentColumnName);
            TextInputEditText currentInputEditText = (TextInputEditText)columnView.findViewById(R.id.sqlite_manager_add_edit_dialog_edit_text);
            editTextViews.add(currentInputEditText);
            linearLayout.addView(columnView);
            if (oldColumnValues != null && oldColumnValues.get(index) != null) {
                if (oldColumnValues.get(index) instanceof byte[]) {
                    currentInputEditText.setText((CharSequence)Arrays.toString((byte[])oldColumnValues.get(index)));
                } else {
                    currentInputEditText.setText((CharSequence)oldColumnValues.get(index).toString());
                }
            }
            ++index;
        }
        if (!isEdit) {
            deleteButton.setVisibility(8);
            updateButton.setText(R.string.sqlite_manager_add);
        }
        final AlertDialog alertDialog = new AlertDialog.Builder((Context)this).setView(dialogView).setTitle(isEdit ? R.string.sqlite_manager_update_row_dialog_title : R.string.sqlite_manager_add_row_dialog_title).setMessage((CharSequence)this.getString(isEdit ? R.string.sqlite_manager_update_row_dialog_message : R.string.sqlite_manager_add_row_dialog_message, new Object[]{tableName})).create();
        updateButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ArrayList<String> columnValues = new ArrayList<String>(tableColumnNames.length);
                for (TextInputEditText currentEditText : editTextViews) {
                    columnValues.add(currentEditText.getText().toString());
                }
                if (isEdit) {
                    SqliteManagerActivity.this.mSqliteManagerPresenter.updateRow(tableName, tableColumnNames, (SparseArray<Object>)oldColumnValues, columnValues);
                } else {
                    SqliteManagerActivity.this.mSqliteManagerPresenter.addRow(tableName, tableColumnNames, columnValues);
                }
                alertDialog.dismiss();
            }
        });
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertDialog.dismiss();
            }
        });
        deleteButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SqliteManagerActivity.this.mSqliteManagerPresenter.deleteRow(tableName, tableColumnNames, (SparseArray<Object>)oldColumnValues);
                alertDialog.dismiss();
            }
        });
        alertDialog.show();
    }

    @Override
    public void setSpinnerAdapter(ArrayList<String> tableNames) {
        ArrayAdapter adapter = new ArrayAdapter((Context)this, 17367048, tableNames);
        adapter.setDropDownViewResource(0x1090009);
        this.mTableSelectionSpinner.setAdapter((SpinnerAdapter)adapter);
    }

    @Override
    public void showContentView() {
        this.mErrorLayout.setVisibility(8);
        this.mTableLayout.setVisibility(0);
    }

    @Override
    public void updateColumnNames(String[] columnNames) {
        this.mColumnNameView.setData(columnNames);
    }

    @Override
    public void displayRows(List<SparseArray<Object>> columnIndexToValuesArray) {
        this.mTableRecyclerAdapter.setData(columnIndexToValuesArray);
    }

    @Override
    public void onHeaderColumnSortChanged(String columnName, boolean isAscendingOrder) {
        String selectedTableName = this.mTableSelectionSpinner.getSelectedItem().toString();
        this.mSqliteManagerPresenter.onSortChangedOrderChanged(selectedTableName, columnName, isAscendingOrder);
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        String selectedTableName = this.mTableSelectionSpinner.getSelectedItem().toString();
        this.mSqliteManagerPresenter.fetchTableData(selectedTableName);
    }

    public void onNothingSelected(AdapterView<?> parent) {
    }

    public void onClick(View v) {
        if (v.getId() == R.id.sqlite_manager_action_custom_query) {
            this.mSqliteManagerPresenter.onCustomQueryClicked();
        } else if (v.getId() == R.id.sqlite_manager_add_fab) {
            String selectedTableName = this.mTableSelectionSpinner.getSelectedItem().toString();
            this.mSqliteManagerPresenter.onAddFabClicked(selectedTableName, this.mColumnNameView.getTableColumnNames());
        } else if (v.getId() == R.id.sqlite_manager_custom_query_edit) {
            this.mSqliteManagerPresenter.onCustomQueryClicked();
        } else if (v.getId() == R.id.sqlite_manager_custom_query_clear) {
            String selectedTableName = this.mTableSelectionSpinner.getSelectedItem().toString();
            this.mSqliteManagerPresenter.fetchTableData(selectedTableName);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(R.menu.sqlite_manager_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_query_refresh) {
            String selectedTableName = this.mTableSelectionSpinner.getSelectedItem().toString();
            this.mSqliteManagerPresenter.onRefreshClicked(selectedTableName);
            return true;
        }
        if (item.getItemId() == R.id.action_export_result_as_csv) {
            String selectedTableName = this.mTableSelectionSpinner.getSelectedItem().toString();
            this.mSqliteManagerPresenter.onExportResultAsCSVClicked(selectedTableName);
            return true;
        }
        if (item.getItemId() == R.id.action_export_result_as_json) {
            String selectedTableName = this.mTableSelectionSpinner.getSelectedItem().toString();
            this.mSqliteManagerPresenter.onExportResultAsJsonClicked(selectedTableName);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onColumnValueClicked(SparseArray<Object> columnValues) {
        String selectedTableName = this.mTableSelectionSpinner.getSelectedItem().toString();
        this.mSqliteManagerPresenter.onColumnValueClicked(selectedTableName, this.mColumnNameView.getTableColumnNames(), columnValues);
    }
}

