/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.sqlitemanager;

import android.content.pm.ApplicationInfo;
import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.SparseArray;
import com.ashokvarma.sqlitemanager.R;
import com.ashokvarma.sqlitemanager.SqliteDataRetriever;
import com.ashokvarma.sqlitemanager.SqliteManagerUtils;
import com.ashokvarma.sqlitemanager.SqliteManagerView;
import com.ashokvarma.sqlitemanager.SqliteResponse;
import com.ashokvarma.sqlitemanager.SqliteResponseData;
import com.ashokvarma.sqlitemanager.SqliteResponseRetriever;
import java.util.ArrayList;
import java.util.Arrays;

class SqliteManagerPresenter {
    private final SqliteResponseRetriever mSqliteResponseRetriever;
    private final String mFileShareAuthority;
    private final SqliteDataRetriever mSqliteDataRetriever;
    private SqliteManagerView mSqliteManagerView;
    private ArrayList<String> mTableNames = new ArrayList();
    private static final String TABLE_FETCH_QUERY = "SELECT name _id FROM sqlite_master WHERE type ='table'";
    private boolean mIsCustomQuery;
    private SqliteResponseData mCurrentsqliteResponseData;
    private String mPreviousCustomQuery;

    SqliteManagerPresenter(SqliteDataRetriever sqliteDataRetriever, String fileShareAuthority) {
        this.mSqliteDataRetriever = sqliteDataRetriever;
        this.mFileShareAuthority = fileShareAuthority;
        this.mSqliteResponseRetriever = new SqliteResponseRetriever(this.mSqliteDataRetriever);
    }

    public SqliteManagerView getView() {
        return this.mSqliteManagerView;
    }

    void bindView(SqliteManagerView sqliteManagerView) {
        this.mSqliteManagerView = sqliteManagerView;
        this.changeSubTitle();
        this.loadTableNames();
    }

    void unBindView(SqliteManagerView sqliteManagerView) {
        this.mSqliteManagerView = null;
    }

    private void changeSubTitle() {
        String databaseName = this.mSqliteDataRetriever.getDatabaseName();
        String appName = this.getApplicationName(this.getView().getViewContext());
        this.getView().setSubtitle((TextUtils.isEmpty((CharSequence)databaseName) ? "" : databaseName + " ") + appName);
    }

    private void loadTableNames() {
        this.mTableNames.clear();
        SqliteResponse sqliteResponse = this.mSqliteResponseRetriever.getData(TABLE_FETCH_QUERY, null);
        if (sqliteResponse.isQuerySuccess()) {
            Cursor cursor = sqliteResponse.getCursor();
            cursor.moveToFirst();
            do {
                this.mTableNames.add(cursor.getString(0));
            } while (cursor.moveToNext());
            cursor.close();
        } else if (sqliteResponse.getThrowable() != null) {
            this.getView().finishActivityWithError(sqliteResponse.getThrowable().getMessage());
        } else {
            this.getView().finishActivityWithError(R.string.sqlite_manager_error_while_fetching_table_names);
        }
        this.mSqliteDataRetriever.freeResources();
        if (this.mTableNames.isEmpty()) {
            this.getView().displayError(R.string.sqlite_manager_database_has_no_tables);
        } else {
            this.getView().setSpinnerAdapter(this.mTableNames);
        }
    }

    void fetchTableData(@Nullable String selectedTableName) {
        if (selectedTableName == null || TextUtils.isEmpty((CharSequence)selectedTableName)) {
            this.getView().displayError(R.string.sqlite_manager_please_select_a_table);
            return;
        }
        SqliteResponseData sqliteResponseData = this.getSqliteResponseDataForSelectedTable(selectedTableName, null, true);
        this.displayData(sqliteResponseData, false, true);
    }

    void onRefreshClicked(@Nullable String selectedTableName) {
        if (this.mIsCustomQuery) {
            SqliteResponseData sqliteResponseData = this.getSqliteResponseDataForCustomQuery(this.mPreviousCustomQuery, null, true);
            this.displayData(sqliteResponseData, true, true);
        } else {
            if (selectedTableName == null || TextUtils.isEmpty((CharSequence)selectedTableName)) {
                this.getView().informErrorToUser(R.string.sqlite_manager_please_select_a_table);
                return;
            }
            SqliteResponseData sqliteResponseData = this.getSqliteResponseDataForSelectedTable(selectedTableName, null, true);
            this.displayData(sqliteResponseData, false, true);
        }
    }

    void onExportResultAsJsonClicked(String selectedTableName) {
        SqliteManagerUtils.shareSqliteResponseDataAsJsonFile(this.getView().getViewContext(), this.mCurrentsqliteResponseData, selectedTableName, this.mFileShareAuthority);
    }

    void onExportResultAsCSVClicked(String selectedTableName) {
        SqliteManagerUtils.shareSqliteResponseDataAsCsvFile(this.getView().getViewContext(), this.mCurrentsqliteResponseData, selectedTableName, this.mFileShareAuthority);
    }

    void onColumnValueClicked(String tableName, String[] tableColumnNames, SparseArray<Object> columnValues) {
        if (tableName == null || TextUtils.isEmpty((CharSequence)tableName)) {
            this.getView().informErrorToUser(R.string.sqlite_manager_please_select_a_table);
            return;
        }
        this.getView().showAddEditRowDialog(true, tableName, tableColumnNames, columnValues);
    }

    void onAddFabClicked(@Nullable String tableName, String[] tableColumnNames) {
        if (tableName == null || TextUtils.isEmpty((CharSequence)tableName)) {
            this.getView().informErrorToUser(R.string.sqlite_manager_please_select_a_table);
            return;
        }
        this.getView().showAddEditRowDialog(false, tableName, tableColumnNames, null);
    }

    void onSortChangedOrderChanged(@Nullable String selectedTableName, @Nullable String orderBy, boolean isAscendingOrder) {
        if (this.mIsCustomQuery) {
            if (this.mPreviousCustomQuery.toUpperCase().contains("ORDER BY")) {
                this.getView().informErrorToUser(R.string.sqlite_manager_custom_query_contacins_order_by);
                this.onRefreshClicked(selectedTableName);
                return;
            }
            SqliteResponseData sqliteResponseData = this.getSqliteResponseDataForCustomQuery(this.mPreviousCustomQuery, orderBy, isAscendingOrder);
            this.displayData(sqliteResponseData, true, false);
        } else {
            if (selectedTableName == null || TextUtils.isEmpty((CharSequence)selectedTableName)) {
                this.getView().informErrorToUser(R.string.sqlite_manager_please_select_a_table);
                return;
            }
            SqliteResponseData sqliteResponseData = this.getSqliteResponseDataForSelectedTable(selectedTableName, orderBy, isAscendingOrder);
            this.displayData(sqliteResponseData, false, false);
        }
    }

    void onCustomQueryClicked() {
        this.getView().showCustomQueryDialog(this.mPreviousCustomQuery);
    }

    void onCustomQuerySubmitted(String customQuery) {
        if (TextUtils.isEmpty((CharSequence)customQuery)) {
            this.getView().informErrorToUser(R.string.sqlite_manager_empty_custom_query);
            return;
        }
        SqliteResponseData sqliteResponseData = this.getSqliteResponseDataForCustomQuery(customQuery, null, true);
        this.mPreviousCustomQuery = customQuery;
        this.displayData(sqliteResponseData, true, true);
    }

    void addRow(String tableName, String[] tableColumnNames, ArrayList<String> columnValues) {
        if (tableColumnNames.length != columnValues.size()) {
            this.getView().informErrorToUser(R.string.sqlite_manager_table_column_length_error);
            return;
        }
        String columnNameQuery = "(";
        String columnValueQuery = "(";
        int columnIndex = 0;
        for (String currentColumnValue : columnValues) {
            String columnName = tableColumnNames[columnIndex];
            ++columnIndex;
            if (TextUtils.isEmpty((CharSequence)currentColumnValue)) continue;
            columnNameQuery = columnNameQuery.concat(columnName).concat(",");
            columnValueQuery = columnValueQuery.concat("'").concat(currentColumnValue).concat("'").concat(",");
        }
        if (columnNameQuery.endsWith(",")) {
            columnNameQuery = columnNameQuery.substring(0, columnNameQuery.length() - 1).concat(")");
            columnValueQuery = columnValueQuery.substring(0, columnValueQuery.length() - 1).concat(")");
            String query = "INSERT INTO ".concat(tableName).concat(" ").concat(columnNameQuery).concat(" VALUES ").concat(columnValueQuery);
            SqliteResponseData sqliteResponseData = this.getSqliteResponseDataFromQuery(query, null);
            if (sqliteResponseData.isQuerySuccess()) {
                this.getView().informErrorToUser(R.string.sqlite_manager_add_row_success);
                this.onRefreshClicked(tableName);
            } else if (sqliteResponseData.getThrowable() != null) {
                this.getView().informErrorToUser(sqliteResponseData.getThrowable().getMessage());
            } else {
                this.getView().informErrorToUser(R.string.sqlite_manager_add_row_error);
            }
        } else {
            this.getView().informErrorToUser(R.string.sqlite_manager_all_columns_cant_be_empty);
            return;
        }
    }

    void deleteRow(String tableName, String[] tableColumnNames, SparseArray<Object> oldColumnValues) {
        if (tableColumnNames.length != oldColumnValues.size()) {
            this.getView().informErrorToUser(R.string.sqlite_manager_table_column_length_error);
            return;
        }
        String whereCondition = this.getWhereCondition(tableColumnNames, oldColumnValues);
        if (whereCondition != null) {
            String query = "DELETE FROM ".concat(tableName).concat(" WHERE ").concat(whereCondition);
            SqliteResponseData sqliteResponseData = this.getSqliteResponseDataFromQuery(query, null);
            if (sqliteResponseData.isQuerySuccess()) {
                this.getView().informErrorToUser(R.string.sqlite_manager_delete_row_success);
                this.onRefreshClicked(tableName);
            } else if (sqliteResponseData.getThrowable() != null) {
                this.getView().informErrorToUser(sqliteResponseData.getThrowable().getMessage());
            } else {
                this.getView().informErrorToUser(R.string.sqlite_manager_delete_row_error);
            }
        } else {
            this.getView().informErrorToUser(R.string.sqlite_manager_all_columns_cant_be_empty);
            return;
        }
    }

    void updateRow(String tableName, String[] tableColumnNames, SparseArray<Object> oldColumnValues, ArrayList<String> columnValues) {
        if (tableColumnNames.length != oldColumnValues.size() || tableColumnNames.length != columnValues.size()) {
            this.getView().informErrorToUser(R.string.sqlite_manager_table_column_length_error);
            return;
        }
        String whereCondition = this.getWhereCondition(tableColumnNames, oldColumnValues);
        String updateQuery = "";
        int columnIndex = 0;
        for (String currentColumnValue : columnValues) {
            String columnName = tableColumnNames[columnIndex];
            ++columnIndex;
            if (TextUtils.isEmpty((CharSequence)currentColumnValue)) continue;
            Object oldColumnValue = oldColumnValues.get(columnIndex);
            if (oldColumnValue != null && oldColumnValue instanceof byte[]) {
                if (Arrays.toString((byte[])oldColumnValue).equalsIgnoreCase(currentColumnValue)) continue;
                this.getView().informErrorToUser(R.string.sqlite_manager_blob_not_supported);
                return;
            }
            updateQuery = updateQuery.concat(columnName).concat(" = '").concat(currentColumnValue).concat("', ");
        }
        if (!TextUtils.isEmpty((CharSequence)updateQuery) && whereCondition != null) {
            updateQuery = updateQuery.substring(0, updateQuery.length() - 2).concat(" ");
            String query = "UPDATE ".concat(tableName).concat(" SET ").concat(updateQuery).concat(" WHERE ").concat(whereCondition);
            SqliteResponseData sqliteResponseData = this.getSqliteResponseDataFromQuery(query, null);
            if (sqliteResponseData.isQuerySuccess()) {
                this.getView().informErrorToUser(R.string.sqlite_manager_update_row_success);
                this.onRefreshClicked(tableName);
            } else if (sqliteResponseData.getThrowable() != null) {
                this.getView().informErrorToUser(sqliteResponseData.getThrowable().getMessage());
            } else {
                this.getView().informErrorToUser(R.string.sqlite_manager_update_row_error);
            }
        } else {
            this.getView().informErrorToUser(R.string.sqlite_manager_all_columns_cant_be_empty);
            return;
        }
    }

    private String getWhereCondition(String[] tableColumnNames, SparseArray<Object> columnValues) {
        String whereCondition = "";
        int columnIndex = 0;
        for (String currentColumnName : tableColumnNames) {
            Object columnValue = columnValues.get(columnIndex);
            ++columnIndex;
            if (columnValue == null || columnValue instanceof byte[]) continue;
            whereCondition = whereCondition.concat(currentColumnName).concat("='").concat(columnValue.toString()).concat("'").concat(" AND ");
        }
        if (whereCondition.endsWith(" AND ")) {
            return whereCondition.substring(0, whereCondition.length() - 5);
        }
        return null;
    }

    private void displayData(@NonNull SqliteResponseData sqliteResponseData, boolean isCustomQuery, boolean updateColumnNames) {
        this.mCurrentsqliteResponseData = sqliteResponseData;
        if (sqliteResponseData.isQuerySuccess()) {
            this.getView().showContentView();
            this.mIsCustomQuery = isCustomQuery;
            if (updateColumnNames) {
                this.getView().updateColumnNames(sqliteResponseData.getTableColumnNames());
            }
            this.getView().displayRows(sqliteResponseData.getColumnIndexToValuesArray());
        } else if (sqliteResponseData.getThrowable() != null) {
            if (isCustomQuery) {
                this.getView().informErrorToUser(sqliteResponseData.getThrowable().getMessage());
            } else {
                this.getView().displayError(sqliteResponseData.getThrowable().getMessage());
            }
        } else if (isCustomQuery) {
            this.getView().informErrorToUser(R.string.sqlite_manager_error_while_fetching_data);
        } else {
            this.getView().displayError(R.string.sqlite_manager_error_while_fetching_data);
        }
        if (this.mIsCustomQuery) {
            this.getView().showCustomQueryView(this.mPreviousCustomQuery);
            this.getView().setAddFABVisible(false);
        } else {
            this.getView().showTableSelectionView();
            this.getView().setAddFABVisible(true);
        }
    }

    @NonNull
    private SqliteResponseData getSqliteResponseDataForCustomQuery(@NonNull String customQuery, @Nullable String orderBy, boolean isAscendingOrder) {
        String orderByWithIncrement = orderBy == null ? null : orderBy + (isAscendingOrder ? "" : " DESC");
        String customQueryWithIncrement = customQuery + (orderByWithIncrement == null ? "" : " ORDER BY " + orderByWithIncrement);
        return this.getSqliteResponseDataFromQuery(customQueryWithIncrement, null);
    }

    @NonNull
    private SqliteResponseData getSqliteResponseDataForSelectedTable(@NonNull String selectedTableName, @Nullable String orderBy, boolean isAscendingOrder) {
        String orderByWithIncrement = orderBy == null ? null : orderBy + (isAscendingOrder ? "" : " DESC");
        String query = "SELECT * FROM " + selectedTableName + (orderByWithIncrement == null ? "" : " ORDER BY " + orderByWithIncrement);
        return this.getSqliteResponseDataFromQuery(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private SqliteResponseData getSqliteResponseDataFromQuery(String query, String[] selectionArgs) {
        SqliteResponse sqliteResponse = this.mSqliteResponseRetriever.getData(query, selectionArgs);
        if (sqliteResponse.isQuerySuccess()) {
            try {
                Cursor cursor = sqliteResponse.getCursor();
                String[] selectedTableColumnNames = cursor.getColumnNames();
                int[] selectedTableColumnTypes = new int[selectedTableColumnNames.length];
                int columnCount = cursor.getColumnCount();
                ArrayList<SparseArray<Object>> valuesArray = new ArrayList<SparseArray<Object>>(cursor.getCount());
                if (cursor.moveToFirst()) {
                    do {
                        SparseArray columnValuePair = new SparseArray(columnCount);
                        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                            int fieldType;
                            selectedTableColumnTypes[columnIndex] = fieldType = cursor.getType(columnIndex);
                            if (fieldType == 0) {
                                columnValuePair.put(columnIndex, (Object)cursor.getString(columnIndex));
                                continue;
                            }
                            if (fieldType == 1) {
                                columnValuePair.put(columnIndex, (Object)cursor.getInt(columnIndex));
                                continue;
                            }
                            if (fieldType == 2) {
                                columnValuePair.put(columnIndex, (Object)Float.valueOf(cursor.getFloat(columnIndex)));
                                continue;
                            }
                            if (fieldType == 3) {
                                columnValuePair.put(columnIndex, (Object)cursor.getString(columnIndex));
                                continue;
                            }
                            if (fieldType == 4) {
                                columnValuePair.put(columnIndex, (Object)cursor.getBlob(columnIndex));
                                continue;
                            }
                            columnValuePair.put(columnIndex, (Object)cursor.getString(columnIndex));
                        }
                        valuesArray.add((SparseArray<Object>)columnValuePair);
                    } while (cursor.moveToNext());
                }
                SqliteResponseData sqliteResponseData = new SqliteResponseData(columnCount, selectedTableColumnNames, selectedTableColumnTypes, valuesArray);
                return sqliteResponseData;
            }
            catch (Exception exception) {
                SqliteResponseData sqliteResponseData = new SqliteResponseData(exception);
                return sqliteResponseData;
            }
            finally {
                this.mSqliteDataRetriever.freeResources();
            }
        }
        this.mSqliteDataRetriever.freeResources();
        return new SqliteResponseData(sqliteResponse.getThrowable());
    }

    private String getApplicationName(AppCompatActivity appCompatActivity) {
        ApplicationInfo applicationInfo = appCompatActivity.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : appCompatActivity.getString(stringId);
    }
}

