/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.sqlitemanager;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.v4.app.ShareCompat;
import android.support.v4.content.FileProvider;
import android.support.v7.app.AppCompatActivity;
import android.util.SparseArray;
import com.ashokvarma.sqlitemanager.SqliteResponseData;
import com.ashokvarma.sqlitemanager.csv.CsvEscaper;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SqliteManagerUtils {
    SqliteManagerUtils() {
    }

    static void shareSqliteResponseDataAsJsonFile(AppCompatActivity context, SqliteResponseData sqliteResponseData, String selectedTableName, String fileShareAuthority) {
        if (fileShareAuthority == null || fileShareAuthority.trim().length() == 0) {
            return;
        }
        String toBeWrittenString = SqliteManagerUtils.getSqliteResponseDataJsonString(sqliteResponseData);
        String fileName = "json_export" + (selectedTableName == null ? "" : "_" + selectedTableName) + ".txt";
        SqliteManagerUtils.createTempFileAndShare(context, fileShareAuthority, toBeWrittenString, fileName, "text/*");
    }

    private static String getSqliteResponseDataJsonString(SqliteResponseData sqliteResponseData) {
        try {
            return SqliteManagerUtils.getSqliteResponseDataJson(sqliteResponseData).toString(4);
        }
        catch (JSONException e) {
            return "";
        }
    }

    private static JSONArray getSqliteResponseDataJson(SqliteResponseData sqliteResponseData) {
        JSONArray resultSet = new JSONArray();
        if (!sqliteResponseData.isQuerySuccess()) {
            return resultSet;
        }
        for (SparseArray<Object> columnIndexToValues : sqliteResponseData.getColumnIndexToValuesArray()) {
            JSONObject rowObject = new JSONObject();
            for (int i = 0; i < columnIndexToValues.size(); ++i) {
                Object columnEntry = columnIndexToValues.get(i);
                try {
                    if (columnEntry == null) {
                        rowObject.put(sqliteResponseData.getTableColumnNames()[i], (Object)"");
                        continue;
                    }
                    if (columnEntry instanceof byte[]) {
                        rowObject.put(sqliteResponseData.getTableColumnNames()[i], (Object)Arrays.toString((byte[])columnEntry));
                        continue;
                    }
                    rowObject.put(sqliteResponseData.getTableColumnNames()[i], columnEntry);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            resultSet.put((Object)rowObject);
        }
        return resultSet;
    }

    static void shareSqliteResponseDataAsCsvFile(AppCompatActivity context, SqliteResponseData sqliteResponseData, String selectedTableName, String FileShareAuthority) {
        if (!sqliteResponseData.isQuerySuccess() || FileShareAuthority == null || FileShareAuthority.trim().length() == 0) {
            return;
        }
        StringBuilder csvString = new StringBuilder();
        boolean firstElement = true;
        for (String columnName : sqliteResponseData.getTableColumnNames()) {
            if (!firstElement) {
                csvString.append(",");
            }
            firstElement = false;
            csvString.append("\"").append(columnName).append("\"");
        }
        csvString.append("\n");
        for (SparseArray sparseArray : sqliteResponseData.getColumnIndexToValuesArray()) {
            firstElement = true;
            for (int i = 0; i < sparseArray.size(); ++i) {
                if (!firstElement) {
                    csvString.append(",");
                }
                firstElement = false;
                Object columnEntry = sparseArray.get(i);
                if (columnEntry == null) continue;
                if (columnEntry instanceof String) {
                    csvString.append(SqliteManagerUtils.escapeCsv((String)columnEntry));
                    continue;
                }
                if (columnEntry instanceof byte[]) {
                    csvString.append(SqliteManagerUtils.escapeCsv(Arrays.toString((byte[])columnEntry)));
                    continue;
                }
                csvString.append(columnEntry);
            }
            csvString.append("\n");
        }
        String fileName = "sqlite_export" + (selectedTableName == null ? "" : "_" + selectedTableName) + ".csv";
        SqliteManagerUtils.createTempFileAndShare(context, FileShareAuthority, csvString.toString(), fileName, "text/csv");
    }

    private static void createTempFileAndShare(AppCompatActivity context, String fileShareAuthority, String csvString, String csvFileName, String type) {
        try {
            File fileDir = new File(context.getFilesDir(), "sqliteManager");
            fileDir.mkdir();
            File file = new File(fileDir, csvFileName);
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(csvString.getBytes());
            fileOutputStream.close();
            Uri uriToCSVFIle = FileProvider.getUriForFile((Context)context, (String)fileShareAuthority, (File)file);
            Intent shareIntent = ShareCompat.IntentBuilder.from((Activity)context).setStream(uriToCSVFIle).setType(type).getIntent();
            shareIntent.addFlags(1);
            PackageManager pm = context.getPackageManager();
            if (shareIntent.resolveActivity(pm) != null) {
                context.startActivity(shareIntent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String escapeCsv(String input) {
        return CsvEscaper.getInstance().translate(input);
    }
}

