/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.sqlitemanager;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.ashokvarma.sqlitemanager.RowView;
import java.util.List;

class TableRecyclerAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<SparseArray<Object>> mColumnIndexToValuesArray;
    private Listener mListener;

    TableRecyclerAdapter(@Nullable List<SparseArray<Object>> columnIndexToValuesArray) {
        this.mColumnIndexToValuesArray = columnIndexToValuesArray;
    }

    public int getItemViewType(int position) {
        return this.mColumnIndexToValuesArray.get(position).size();
    }

    void setData(List<SparseArray<Object>> mColumnIndexToValuesArray) {
        this.mColumnIndexToValuesArray = mColumnIndexToValuesArray;
        this.notifyDataSetChanged();
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(new RowView(parent.getContext(), viewType));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.mRowView.setData(this.mColumnIndexToValuesArray.get(position));
    }

    public int getItemCount() {
        if (this.mColumnIndexToValuesArray == null) {
            return 0;
        }
        return this.mColumnIndexToValuesArray.size();
    }

    static interface Listener {
        public void onColumnValueClicked(SparseArray<Object> var1);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        final RowView mRowView;

        ViewHolder(RowView itemView) {
            super((View)itemView);
            this.mRowView = itemView;
            this.mRowView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int position = ViewHolder.this.getAdapterPosition();
                    int layoutPosition = ViewHolder.this.getLayoutPosition();
                    if (position != -1 && TableRecyclerAdapter.this.mListener != null) {
                        TableRecyclerAdapter.this.mListener.onColumnValueClicked((SparseArray<Object>)((SparseArray)TableRecyclerAdapter.this.mColumnIndexToValuesArray.get(layoutPosition)));
                    }
                }
            });
        }
    }
}

