/*
 * Decompiled with CFR 0.152.
 */
package com.ashokvarma.sqlitemanager.csv;

import com.ashokvarma.sqlitemanager.csv.CharSequenceTranslator;
import com.ashokvarma.sqlitemanager.csv.StringUtils;
import java.io.IOException;
import java.io.Writer;

public class CsvEscaper
extends CharSequenceTranslator {
    private static CsvEscaper instance;
    private static final char CSV_DELIMITER = ',';
    private static final char CSV_QUOTE = '\"';
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final String CSV_QUOTE_STR;
    private static final char[] CSV_SEARCH_CHARS;

    private CsvEscaper() {
    }

    public static CsvEscaper getInstance() {
        if (instance == null) {
            instance = new CsvEscaper();
        }
        return instance;
    }

    @Override
    public int translate(CharSequence input, int index, Writer out) throws IOException {
        if (index != 0) {
            throw new IllegalStateException("CsvEscaper should never reach the [1] index");
        }
        if (StringUtils.containsNone(input.toString(), CSV_SEARCH_CHARS)) {
            out.write(input.toString());
        } else {
            out.write(34);
            out.write(StringUtils.replace(input.toString(), CSV_QUOTE_STR, CSV_QUOTE_STR + CSV_QUOTE_STR));
            out.write(34);
        }
        return Character.codePointCount(input, 0, input.length());
    }

    static {
        CSV_QUOTE_STR = String.valueOf('\"');
        CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};
    }
}

