/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.ocr.sample;

import com.asprise.ocr.sample.DemoUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;

public class PanelOcrInput
extends JPanel {
    static Preferences prefs = Preferences.userRoot().node(PanelOcrInput.class.getName());
    static String PREF_FILE_IMG = "file-img";
    static String PREF_TEXT_LAYOUT = "text-layout";
    static String PREF_DATA_CAPTURE_BOOLEAN = "data-capture";
    static String PREF_AUTO_ROTATE_BOOLEAN = "auto-rotate";
    static String PREF_WORD_LEVEL = "word-level";
    static String PREF_OUTPUT_FORMAT = "output-format";
    static String PREF_PDF_HIGHLIGHT_TEXT = "pdf-highlight-text";
    static String PREF_LANGUAGE = "lang";
    static String PREF_RECOGNIZE_TYPE = "recognize-type";
    ButtonGroup buttonGroupOutputFormat = new ButtonGroup();
    private JButton buttonBrowseFile;
    private JButton buttonOcr;
    private JCheckBox checkAutoRotatePages;
    private JCheckBox checkDataCapture;
    private JCheckBox checkPdfHighlightText;
    private JCheckBox checkWordLevel;
    private JComboBox comboFileImage;
    private JComboBox comboLanguage;
    private JComboBox comboRecognizeType;
    private JComboBox comboTextLayout;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JRadioButton radioOutputFormatPdf;
    private JRadioButton radioOutputFormatPlainText;
    private JRadioButton radioOutputFormatXml;

    void init() {
        this.comboTextLayout.setModel(new DefaultComboBoxModel<String>(new String[]{"auto", "single_block", "single_column", "single_line", "single_word", "single_char", "scattered"}));
        this.comboRecognizeType.setModel(new DefaultComboBoxModel<String>(new String[]{"Text + Barcodes", "Text only", "Barcodes only"}));
        this.comboLanguage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
        ActionListener actionListenerForOutputFormatRadios = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PanelOcrInput.this.refreshUI();
            }
        };
        this.radioOutputFormatPlainText.addActionListener(actionListenerForOutputFormatRadios);
        this.radioOutputFormatXml.addActionListener(actionListenerForOutputFormatRadios);
        this.radioOutputFormatPdf.addActionListener(actionListenerForOutputFormatRadios);
        this.buttonGroupOutputFormat.add(this.radioOutputFormatPlainText);
        this.buttonGroupOutputFormat.add(this.radioOutputFormatXml);
        this.buttonGroupOutputFormat.add(this.radioOutputFormatPdf);
        this.radioOutputFormatXml.setSelected(true);
        this.comboFileImage.setEditable(true);
        DemoUtils.registerBrowseButtonListener(this.comboFileImage, this.buttonBrowseFile, true, true, DemoUtils.getFileFilterForExtensions(new String[]{"bmp", "gif", "jpg", "jpeg", "pdf", "png", "tif", "tiff"}, true), null);
        DemoUtils.loadPrefs(prefs, PREF_FILE_IMG, this.comboFileImage);
        PanelOcrInput.selectCombo(this.comboTextLayout, prefs.get(PREF_TEXT_LAYOUT, "auto"));
        PanelOcrInput.selectCombo(this.comboRecognizeType, prefs.get(PREF_RECOGNIZE_TYPE, "Text only"));
        this.checkDataCapture.setSelected(prefs.getBoolean(PREF_DATA_CAPTURE_BOOLEAN, true));
        this.checkAutoRotatePages.setSelected(prefs.getBoolean(PREF_AUTO_ROTATE_BOOLEAN, false));
        this.checkWordLevel.setSelected(prefs.getBoolean(PREF_WORD_LEVEL, false));
        this.radioOutputFormatPlainText.setSelected(prefs.get(PREF_OUTPUT_FORMAT, "").toLowerCase().contains("text"));
        this.radioOutputFormatPdf.setSelected(prefs.get(PREF_OUTPUT_FORMAT, "").toLowerCase().contains("pdf"));
        this.checkPdfHighlightText.setSelected(prefs.getBoolean(PREF_PDF_HIGHLIGHT_TEXT, true));
        this.comboLanguage.setPreferredSize(new Dimension(90, this.comboLanguage.getPreferredSize().height));
        this.refreshUI();
    }

    public String getFileImage() {
        return DemoUtils.getText(this.comboFileImage);
    }

    public boolean isImageFileOk() {
        File file = null;
        String files = this.getFileImage();
        if (files.contains(",")) {
            StringTokenizer st = new StringTokenizer(files, ",");
            if (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                file = new File(token);
            }
        } else {
            file = new File(files.trim());
        }
        return file != null && file.exists() && file.isFile();
    }

    public String getTextLayout() {
        return this.comboTextLayout.getSelectedItem().toString();
    }

    public boolean isDataCaptureChecked() {
        return this.checkDataCapture.isSelected();
    }

    public boolean isAutoRotatePagesChecked() {
        return this.checkAutoRotatePages.isSelected();
    }

    public boolean isWordLevelChecked() {
        return this.checkWordLevel.isSelected();
    }

    public String getOutputFormat() {
        return this.radioOutputFormatPlainText.isSelected() ? "text" : (this.radioOutputFormatXml.isSelected() ? "xml" : "pdf");
    }

    public boolean isPdfHighlightTextChecked() {
        return this.checkPdfHighlightText.isSelected();
    }

    public String getRecognizeType() {
        return this.comboRecognizeType.getSelectedItem().toString();
    }

    public String getLanguage() {
        String lang = this.comboLanguage.getSelectedItem() == null ? null : this.comboLanguage.getSelectedItem().toString();
        return lang == null || lang.trim().isEmpty() ? prefs.get(PREF_LANGUAGE, "eng") : lang;
    }

    public JButton getButtonOcr() {
        return this.buttonOcr;
    }

    public void savePrefs() {
        try {
            prefs.put(PREF_TEXT_LAYOUT, this.comboTextLayout.getSelectedItem().toString());
            prefs.put(PREF_RECOGNIZE_TYPE, this.comboRecognizeType.getSelectedItem().toString());
            prefs.putBoolean(PREF_DATA_CAPTURE_BOOLEAN, this.checkDataCapture.isSelected());
            prefs.putBoolean(PREF_AUTO_ROTATE_BOOLEAN, this.checkAutoRotatePages.isSelected());
            prefs.putBoolean(PREF_WORD_LEVEL, this.checkWordLevel.isSelected());
            prefs.put(PREF_OUTPUT_FORMAT, this.radioOutputFormatXml.isSelected() ? "xml" : (this.radioOutputFormatPlainText.isSelected() ? "text" : "pdf"));
            prefs.putBoolean(PREF_PDF_HIGHLIGHT_TEXT, this.checkPdfHighlightText.isSelected());
            prefs.put(PREF_LANGUAGE, this.comboLanguage.getSelectedItem().toString());
            DemoUtils.savePrefs(prefs, PREF_FILE_IMG, this.comboFileImage, this.getFileImage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setOcrLangs(String[] langs) {
        this.comboLanguage.setModel(new DefaultComboBoxModel<String>(langs));
        PanelOcrInput.selectCombo(this.comboLanguage, prefs.get(PREF_LANGUAGE, "eng"));
    }

    static void selectCombo(JComboBox comboBox, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        ComboBoxModel model = comboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!value.equals(model.getElementAt(i).toString())) continue;
            comboBox.setSelectedIndex(i);
            return;
        }
    }

    void refreshUI() {
        this.checkPdfHighlightText.setEnabled(this.radioOutputFormatPdf.isSelected());
    }

    public PanelOcrInput() {
        this.initComponents();
        this.init();
    }

    public static void main(String[] args) {
        DemoUtils.autoAwesomeLookAndFeel(null, null);
        JFrame frame = new JFrame("JFrame Source Demo");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add((Component)new PanelOcrInput(), "Center");
        frame.pack();
        frame.setVisible(true);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.comboFileImage = new JComboBox();
        this.buttonBrowseFile = new JButton();
        this.jLabel2 = new JLabel();
        this.comboTextLayout = new JComboBox();
        this.jLabel3 = new JLabel();
        this.radioOutputFormatPlainText = new JRadioButton();
        this.radioOutputFormatXml = new JRadioButton();
        this.radioOutputFormatPdf = new JRadioButton();
        this.checkPdfHighlightText = new JCheckBox();
        this.checkDataCapture = new JCheckBox();
        this.checkWordLevel = new JCheckBox();
        this.checkAutoRotatePages = new JCheckBox();
        this.buttonOcr = new JButton();
        this.comboLanguage = new JComboBox();
        this.jLabel4 = new JLabel();
        this.comboRecognizeType = new JComboBox();
        this.jLabel1.setText("Image:");
        this.comboFileImage.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.buttonBrowseFile.setText("Browse ...");
        this.jLabel2.setText("Text layout:");
        this.comboTextLayout.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setText("Output format:");
        this.radioOutputFormatPlainText.setText("Plain text");
        this.radioOutputFormatXml.setText("Xml");
        this.radioOutputFormatPdf.setText("PDF");
        this.checkPdfHighlightText.setSelected(true);
        this.checkPdfHighlightText.setText("Highlight text in PDF");
        this.checkDataCapture.setSelected(true);
        this.checkDataCapture.setText("Data capture (invoices and forms)");
        this.checkWordLevel.setText("Word level (instead of line)");
        this.checkAutoRotatePages.setText("Auto rotate pages");
        this.buttonOcr.setBackground(new Color(102, 204, 255));
        this.buttonOcr.setFont(new Font("Tahoma", 1, 14));
        this.buttonOcr.setText("OCR");
        this.comboLanguage.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel4.setText("Language:");
        this.comboRecognizeType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.comboTextLayout, -2, 106, -2).addGap(18, 18, 18).addComponent(this.checkDataCapture).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkAutoRotatePages).addGap(18, 18, 18).addComponent(this.checkWordLevel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.comboFileImage, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonBrowseFile)).addGroup(layout.createSequentialGroup().addComponent(this.radioOutputFormatPlainText).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radioOutputFormatXml).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.radioOutputFormatPdf).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkPdfHighlightText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.comboRecognizeType, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboLanguage, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOcr))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboFileImage, -2, -1, -2).addComponent(this.buttonBrowseFile)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboTextLayout, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.checkDataCapture).addComponent(this.checkAutoRotatePages).addComponent(this.checkWordLevel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.radioOutputFormatPlainText).addComponent(this.radioOutputFormatXml).addComponent(this.radioOutputFormatPdf).addComponent(this.checkPdfHighlightText)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.comboLanguage, -2, -1, -2).addComponent(this.buttonOcr).addComponent(this.comboRecognizeType, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

