/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.lemur.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = LemurSummaryResponse.Builder.class)
public final class LemurSummaryResponse implements ILemurBaseResponse {
    private final String requestId;

    private final String response;

    private final Map<String, Object> additionalProperties;

    private LemurSummaryResponse(String requestId, String response, Map<String, Object> additionalProperties) {
        this.requestId = requestId;
        this.response = response;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The ID of the LeMUR request
     */
    @JsonProperty("request_id")
    @java.lang.Override
    public String getRequestId() {
        return requestId;
    }

    /**
     * @return The response generated by LeMUR
     */
    @JsonProperty("response")
    public String getResponse() {
        return response;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LemurSummaryResponse && equalTo((LemurSummaryResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LemurSummaryResponse other) {
        return requestId.equals(other.requestId) && response.equals(other.response);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.requestId, this.response);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RequestIdStage builder() {
        return new Builder();
    }

    public interface RequestIdStage {
        ResponseStage requestId(String requestId);

        Builder from(LemurSummaryResponse other);
    }

    public interface ResponseStage {
        _FinalStage response(String response);
    }

    public interface _FinalStage {
        LemurSummaryResponse build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements RequestIdStage, ResponseStage, _FinalStage {
        private String requestId;

        private String response;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LemurSummaryResponse other) {
            requestId(other.getRequestId());
            response(other.getResponse());
            return this;
        }

        /**
         * <p>The ID of the LeMUR request</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("request_id")
        public ResponseStage requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        /**
         * <p>The response generated by LeMUR</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("response")
        public _FinalStage response(String response) {
            this.response = response;
            return this;
        }

        @java.lang.Override
        public LemurSummaryResponse build() {
            return new LemurSummaryResponse(requestId, response, additionalProperties);
        }
    }
}
