/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using = SendMessage.Deserializer.class)
public final class SendMessage {
    private final Object value;

    private final int type;

    private SendMessage(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((String) this.value);
        } else if (this.type == 1) {
            return visitor.visit((TerminateSession) this.value);
        } else if (this.type == 2) {
            return visitor.visit((ForceEndUtterance) this.value);
        } else if (this.type == 3) {
            return visitor.visit((ConfigureEndUtteranceSilenceThreshold) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SendMessage && equalTo((SendMessage) other);
    }

    private boolean equalTo(SendMessage other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static SendMessage of(String value) {
        return new SendMessage(value, 0);
    }

    public static SendMessage of(TerminateSession value) {
        return new SendMessage(value, 1);
    }

    public static SendMessage of(ForceEndUtterance value) {
        return new SendMessage(value, 2);
    }

    public static SendMessage of(ConfigureEndUtteranceSilenceThreshold value) {
        return new SendMessage(value, 3);
    }

    public interface Visitor<T> {
        T visit(String value);

        T visit(TerminateSession value);

        T visit(ForceEndUtterance value);

        T visit(ConfigureEndUtteranceSilenceThreshold value);
    }

    static final class Deserializer extends StdDeserializer<SendMessage> {
        Deserializer() {
            super(SendMessage.class);
        }

        @java.lang.Override
        public SendMessage deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, TerminateSession.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, ForceEndUtterance.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, ConfigureEndUtteranceSilenceThreshold.class));
            } catch (IllegalArgumentException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }
}
